/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingFSGroupCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.ReportingGroupCreateOrEdit;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.FilterPanel;
import org.eclipse.aperi.gui.FilterResultsTableModel;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class FilterResultsViewer
extends JDialog
implements GuiRequestor,
ActionListener,
DocumentListener,
TableModelListener {
    private Container cp;
    private JButton viewButton;
    private JButton cancelButton;
    private GridBagPanel tablePanel;
    private GridBagPanel panel;
    private MegaTable resourceTable;
    private boolean exceededMaxLength = false;
    private Object callerPanel;
    private JScrollPane tablePane;
    private Vector resColNames;
    private int selectedFilterIndex;
    private String selectedFilter;
    private short resourceType;
    private int updateEventOffset;
    private short type;
    private FilterResultsTableModel model;
    private NameList[] newRes;
    private JButton selectAllButton;
    private JButton clearAllButton;
    private JTextArea pickTextArea;
    protected JTextField filterField;
    public static short ADD = 1;
    public static short EDIT = (short)2;
    public static short PICK = (short)3;
    public JButton okButton;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public FilterResultsViewer(Frame frame, short s, Object object, int n, Object object2, short s2, String string) {
        super(frame, string, true);
        this.callerPanel = object;
        this.type = s;
        this.resourceType = s2;
        this.selectedFilterIndex = n;
        this.selectedFilter = (String)object2;
        this.cp = this.getContentPane();
        this.configureHelp();
        this.panel = this.getMainPanel();
        this.cp.add(this.panel);
        this.pack();
    }

    public void displayDialog() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.viewButton) {
            this.tablePanel.removeAll();
            this.submitRetrieve();
        } else if (object == this.okButton) {
            boolean bl = false;
            if (this.type == ADD) {
                bl = ((FilterPanel)this.callerPanel).addFilter(this.filterField.getText());
            } else if (this.type == EDIT) {
                bl = ((FilterPanel)this.callerPanel).updateFilter(this.filterField.getText());
            } else if (this.type == PICK) {
                this.newRes = this.model.getData();
                if (this.newRes != null) {
                    bl = true;
                    UpdateSelectedResourcesEvent updateSelectedResourcesEvent = new UpdateSelectedResourcesEvent();
                    EventQueue eventQueue = new EventQueue();
                    eventQueue.postEvent(updateSelectedResourcesEvent);
                }
            }
            if (!bl) {
                this.okButton.setEnabled(false);
                return;
            }
            this.dispose();
        } else if (object == this.selectAllButton) {
            this.model.selectAll(true);
        } else if (object == this.clearAllButton) {
            this.model.selectAll(false);
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    private GridBagPanel getMainPanel() {
        this.panel = new GridBagPanel();
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        this.okButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_OK"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.viewButton = new JButton(Util.getString("LABEL_VIEW"));
        this.viewButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_VIEW"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        this.filterField = new JTextField(30);
        this.tablePanel = new GridBagPanel();
        JTextArea jTextArea = new JTextArea(Util.getString("DESC_FILTER_INSTRUCTIONS"));
        jTextArea.setBackground(this.getBackground());
        jTextArea.setEditable(false);
        this.panel.add((JComponent)jTextArea, 2, 1, 2);
        this.panel.newRow();
        this.panel.add((JComponent)new JLabel(Util.getString("LABEL_FILTER_PATTERN")), 1, 1, 2);
        this.panel.newRow();
        if (this.selectedFilter != null) {
            this.filterField.setText(this.selectedFilter);
        }
        this.panel.add((JComponent)this.filterField, 21, 2);
        this.panel.add((JComponent)this.viewButton, 22, 0);
        if (this.type == ADD || this.type == PICK) {
            this.viewButton.setEnabled(false);
        }
        this.panel.newRow();
        this.panel.add(this.tablePanel, 2, 1, 1, new Insets(4, 0, 4, 0));
        this.panel.newRow();
        this.panel.add((JComponent)this.okButton, 22, 0, new Insets(4, 0, 4, 4));
        this.okButton.setEnabled(false);
        this.panel.add((JComponent)this.cancelButton, 22, 0, new Insets(4, 0, 4, 4));
        this.viewButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.filterField.getDocument().addDocumentListener(this);
        if (this.type == PICK) {
            this.selectAllButton = new JButton(Util.getString("GUI0137L"));
            this.clearAllButton = new JButton(Util.getString("GUI0061L"));
            this.selectAllButton.addActionListener(this);
            this.clearAllButton.addActionListener(this);
            this.pickTextArea = new JTextArea(Util.getString("DESC_FILTER_PICK_INSTRUCTIONS"));
            this.pickTextArea.setBackground(this.getBackground());
            this.pickTextArea.setEditable(false);
        }
        return this.panel;
    }

    private void submitRetrieve() {
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 11;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        request.flags = (byte)4;
        NameList nameList = new NameList();
        nameList.nlName = this.filterField.getText();
        if (this.resourceType == 90) {
            nameList.nlInfo = (short)96;
        } else if (this.resourceType == 89) {
            nameList.nlInfo = (short)95;
        }
        nameList.nlNext = null;
        guiListReq.qualifierObject = nameList;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        NameList nameList = (NameList)response.responseData;
        if (nameList == null) {
            this.tablePanel.add(ReportingDDI.getNoDataMessage(null));
        } else {
            int n;
            Dimension dimension;
            Vector<NameList> vector = new Vector<NameList>();
            NameList[] nameListArray = null;
            NameList nameList2 = null;
            while (nameList != null) {
                nameList2 = (NameList)nameList.clone();
                if (nameList2.nlInfo == 96) {
                    String string = GuiUtil.getComputer((int)nameList2.nlID2).gcTSName;
                    nameList2.nlName = string = String.valueOf(nameList2.nlName) + "(" + string + ")";
                }
                nameList2.nlNext = null;
                vector.add(nameList2);
                nameList = nameList.nlNext;
            }
            vector.trimToSize();
            nameListArray = new NameList[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                nameListArray[n2] = (NameList)vector.get(n2);
                ++n2;
            }
            this.model = new FilterResultsTableModel(nameListArray, this.type, Util.getString("LABEL_FILTER_RESULTS_TABLE", new String[]{this.filterField.getText()}));
            JTable jTable = new JTable(this.model);
            if (this.type == PICK) {
                jTable.getColumnModel().getColumn(0).setPreferredWidth(1);
                jTable.getColumnModel().getColumn(1).setPreferredWidth(400);
                jTable.getColumnModel().setColumnMargin(1);
                this.model.addTableModelListener(this);
                this.okButton.setEnabled(true);
                jTable.setRowSelectionAllowed(true);
                jTable.getSelectionModel().setSelectionMode(0);
            } else {
                jTable.setRowSelectionAllowed(false);
            }
            jTable.setColumnSelectionAllowed(false);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            int n3 = this.panel.getWidth();
            if (jTable.getModel().getRowCount() > 15) {
                dimension = new Dimension(0, 17 * (n3 / 30));
            } else {
                n = jTable.getRowCount();
                int n4 = jTable.getRowHeight();
                dimension = new Dimension(0, (n + 1) * n4 + 2);
            }
            jScrollPane.setPreferredSize(dimension);
            n = 0;
            if (this.type == PICK) {
                this.tablePanel.add(this.pickTextArea, 0, 0, 2, 1, 21, 0, new Insets(4, 11, 4, 4));
                this.tablePanel.add(this.selectAllButton, 1, 0, 1, 1, 21, 0, new Insets(4, 11, 4, 4));
                this.tablePanel.add(this.clearAllButton, 1, 1, 1, 1, 21, 0, new Insets(4, 4, 4, 4));
                n = 2;
            }
            this.tablePanel.add(jScrollPane, n, 0, 2, 1, 21, 1, new Insets(6, 11, 4, 7));
        }
        this.viewButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n = this.filterField.getText().length();
        this.setButtons(n > 0);
        if (n > 128) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI6019T"), "", 0);
            this.exceededMaxLength = true;
            UpdateTextEvent updateTextEvent = new UpdateTextEvent();
            this.updateEventOffset = documentEvent.getOffset();
            EventQueue eventQueue = new EventQueue();
            eventQueue.postEvent(updateTextEvent);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setButtons(this.filterField.getText().length() > 0);
    }

    public void setButtons(boolean bl) {
        this.viewButton.setEnabled(bl);
        if (this.type != PICK) {
            this.okButton.setEnabled(bl);
        }
        this.getRootPane().setDefaultButton(this.viewButton);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            int n = this.model.getRowCount();
            int n2 = 0;
            while (n > 0) {
                if (((Boolean)this.model.getValueAt(n - 1, 0)).booleanValue()) {
                    ++n2;
                }
                --n;
            }
            if (n2 == 0) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    private void configureHelp() {
        String string = "";
        if (this.resourceType == 89 || this.resourceType == 90) {
            if (this.type == ADD || this.type == EDIT) {
                string = "repgrp15";
            } else if (this.type == PICK) {
                string = "repgrp20";
            }
        }
        Help.setHelpID(this.getRootPane(), string);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    private class UpdateTextEvent
    extends AWTEvent
    implements ActiveEvent {
        public UpdateTextEvent() {
            super(new Object(), 2000);
        }

        public void dispatch() {
            try {
                FilterResultsViewer.this.filterField.getDocument().remove(FilterResultsViewer.this.updateEventOffset, 1);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private class UpdateSelectedResourcesEvent
    extends AWTEvent
    implements ActiveEvent {
        public UpdateSelectedResourcesEvent() {
            super(new Object(), 2000);
        }

        public void dispatch() {
            if (FilterResultsViewer.this.callerPanel instanceof ReportingGroupCreateOrEdit) {
                ((ReportingGroupCreateOrEdit)FilterResultsViewer.this.callerPanel).addSelectedResources(FilterResultsViewer.this.newRes);
            } else if (FilterResultsViewer.this.callerPanel instanceof ReportingFSGroupCreateOrEdit) {
                ((ReportingFSGroupCreateOrEdit)FilterResultsViewer.this.callerPanel).addSelectedResources(FilterResultsViewer.this.newRes);
            }
        }
    }
}

