/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintOutputChooser
implements ActionListener {
    private PrintOptions printOptions = null;
    private JDialog editDialog;
    private JRadioButton printButton;
    private JRadioButton pdfButton;
    private JRadioButton htmlButton;
    private JRadioButton psButton;
    private JRadioButton pclButton;
    private JRadioButton screenButton;
    private JRadioButton csvButton;
    private JRadioButton formattedButton;
    private JCheckBox includeHeaders;
    private JCheckBox includeTotals;
    private JButton continueButton;
    private JButton cancelButton;
    static final String SEND_OUTPUT = MessageLog.getMessageNoID("GUI5094L");
    static final String PRINTER = MessageLog.getMessageNoID("GUI5095L");
    static final String PDF_FILE = MessageLog.getMessageNoID("GUI5096L");
    static final String HTML_FILE = MessageLog.getMessageNoID("GUI5087L");
    static final String PS_FILE = MessageLog.getMessageNoID("GUI5088L");
    static final String PCL_FILE = MessageLog.getMessageNoID("GUI5093L");
    static final String SCREEN = MessageLog.getMessageNoID("GUI5089L");
    static final String CSV = MessageLog.getMessageNoID("STG5150L");
    static final String INCLUDE_HEADERS = MessageLog.getMessageNoID("GUI5084L");
    static final String INCLUDE_TOTALS = MessageLog.getMessageNoID("GUI5085L");
    static final String FORMATTED = MessageLog.getMessageNoID("STG5151L");
    static final String PORTRAIT = MessageLog.getMessageNoID("GUI5090L");
    static final String LANDSCAPE = MessageLog.getMessageNoID("GUI5091L");
    static final String CONTINUE = MessageLog.getMessageNoID("GUI5092L");
    static final String CANCEL = MessageLog.getMessageNoID("GUI0114L");
    private boolean allowCSV = true;
    private boolean allowFormatted = true;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public void allowCSV(boolean bl) {
        this.allowCSV = bl;
    }

    public void allowFormatted(boolean bl) {
        this.allowFormatted = bl;
    }

    public PrintOptions getOptions(boolean bl, boolean bl2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        Insets insets = new Insets(1, 0, 2, 9);
        Insets insets2 = new Insets(1, 0, 2, 1);
        Insets insets3 = new Insets(1, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = insets2;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = insets3;
        this.editDialog = new JDialog(this.guiMain.getFrame(), true);
        this.editDialog.setTitle(MessageLog.getMessageNoID("GUI5097L"));
        GuiUtil.setAccessible(this.editDialog, MessageLog.getMessageNoID("GUI5097L"), MessageLog.getMessageNoID("GUI5097L"));
        JPanel jPanel = GuiUtil.getPanel();
        jPanel.add((Component)new BlackLabel(SEND_OUTPUT), gridBagConstraints);
        jPanel.add((Component)new JLabel(" "), gridBagConstraints3);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.printButton = new JRadioButton(PRINTER);
        this.pdfButton = new JRadioButton(PDF_FILE);
        this.htmlButton = new JRadioButton(HTML_FILE);
        this.psButton = new JRadioButton(PS_FILE);
        this.pclButton = new JRadioButton(PCL_FILE);
        this.screenButton = new JRadioButton(SCREEN);
        this.csvButton = new JRadioButton(CSV);
        this.formattedButton = new JRadioButton(FORMATTED);
        buttonGroup.add(this.htmlButton);
        buttonGroup.add(this.csvButton);
        buttonGroup.add(this.formattedButton);
        this.includeHeaders = new JCheckBox(INCLUDE_HEADERS);
        this.includeHeaders.setEnabled(false);
        GuiUtil.setAccessible(this.includeHeaders, INCLUDE_HEADERS, INCLUDE_HEADERS);
        this.includeTotals = new JCheckBox(INCLUDE_TOTALS);
        this.includeTotals.setEnabled(false);
        GuiUtil.setAccessible(this.includeTotals, INCLUDE_TOTALS, INCLUDE_TOTALS);
        if (bl) {
            jPanel.add((Component)this.htmlButton, gridBagConstraints);
            jPanel.add((Component)new JLabel(" "), gridBagConstraints2);
            jPanel.add((Component)new JLabel(" "), gridBagConstraints3);
            if (this.allowCSV) {
                jPanel.add((Component)this.csvButton, gridBagConstraints);
                jPanel.add((Component)this.includeHeaders, gridBagConstraints2);
                jPanel.add((Component)this.includeTotals, gridBagConstraints2);
                jPanel.add((Component)new JLabel(" "), gridBagConstraints3);
            }
            if (this.allowFormatted) {
                jPanel.add((Component)this.formattedButton, gridBagConstraints);
                jPanel.add((Component)new JLabel(" "), gridBagConstraints2);
                jPanel.add((Component)new JLabel(" "), gridBagConstraints3);
            }
        }
        GuiUtil.completePanel(jPanel);
        JPanel jPanel2 = new JPanel();
        this.continueButton = new JButton(CONTINUE);
        this.cancelButton = new JButton(CANCEL);
        GuiUtil.setAccessible(this.continueButton, this.continueButton.getText(), this.continueButton.getText());
        GuiUtil.setAccessible(this.cancelButton, this.cancelButton.getText(), this.cancelButton.getText());
        jPanel2.add(this.continueButton);
        jPanel2.add(this.cancelButton);
        this.printButton.setSelected(true);
        this.printButton.addActionListener(this);
        this.pdfButton.addActionListener(this);
        this.htmlButton.addActionListener(this);
        this.psButton.addActionListener(this);
        this.pclButton.addActionListener(this);
        this.screenButton.addActionListener(this);
        this.csvButton.addActionListener(this);
        this.formattedButton.addActionListener(this);
        this.continueButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Container container = this.editDialog.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.editDialog.getRootPane().setDefaultButton(this.continueButton);
        this.editDialog.pack();
        GuiUtil.centerDialog(this.editDialog);
        this.editDialog.show();
        return this.printOptions;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.printButton) {
            if (object == this.pdfButton || object == this.htmlButton || object == this.psButton || object == this.pclButton || object == this.screenButton || object == this.formattedButton) {
                this.includeHeaders.setEnabled(false);
                this.includeTotals.setEnabled(false);
            } else if (object == this.csvButton) {
                this.includeHeaders.setEnabled(true);
                this.includeTotals.setEnabled(true);
            } else if (object == this.continueButton) {
                this.printOptions = new PrintOptions();
                if (this.htmlButton.isSelected()) {
                    this.printOptions.outputType = (byte)3;
                } else if (this.csvButton.isSelected()) {
                    this.printOptions.outputType = (byte)7;
                    this.printOptions.includeHeaders = this.includeHeaders.isSelected();
                    this.printOptions.includeTotals = this.includeTotals.isSelected();
                } else if (this.formattedButton.isSelected()) {
                    this.printOptions.outputType = (byte)8;
                }
                this.editDialog.dispose();
            } else {
                this.editDialog.dispose();
            }
        }
    }
}

