/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.aperi.TStorm.common.PrintHtmlTable;
import org.eclipse.aperi.TStorm.common.PrintTable;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.WriteReports;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.PrintFileChooser;
import org.eclipse.aperi.gui.PrintManager;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.tables.MegaTable;

public class PrintTableData {
    public static void print(DataDisplayInfo dataDisplayInfo, Container container, String string, String string2, String string3) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof MegaTable) {
                    MegaTable megaTable = (MegaTable)componentArray[n];
                    PrintTableData.printTable(dataDisplayInfo, megaTable, string, string2, string3);
                    break;
                }
                ++n;
            }
        }
    }

    public static void printTable(DataDisplayInfo dataDisplayInfo, MegaTable megaTable, String string, String string2, String string3) {
        PrintOptions printOptions;
        PrintOutputChooser printOutputChooser = new PrintOutputChooser();
        boolean bl = true;
        if (dataDisplayInfo instanceof SavedReportDDI) {
            bl = ((SavedReportDDI)dataDisplayInfo).getPdfAllowed();
        }
        if ((printOptions = printOutputChooser.getOptions(true, bl)) != null) {
            printOptions.creator = string;
            printOptions.title = string2;
            printOptions.fileMask = string3;
            if (printOptions.outputType == 2 || printOptions.outputType == 3 || printOptions.outputType == 4 || printOptions.outputType == 7 || printOptions.outputType == 8 || printOptions.outputType == 5) {
                printOptions.fileName = PrintTableData.getFileName(printOptions);
                if (printOptions.fileName == null) {
                    return;
                }
            }
            if (printOptions.outputType == 3 || printOptions.outputType == 7 || printOptions.outputType == 8) {
                printOptions.outFile = null;
                OutputStreamWriter outputStreamWriter = null;
                PrintWriter printWriter = null;
                try {
                    printOptions.outFile = new FileOutputStream(printOptions.fileName);
                }
                catch (IOException iOException) {
                    GuiUtil.displayErrorMessage(iOException.getMessage());
                    printOptions.outFile = null;
                }
                try {
                    if (printOptions.outFile != null) {
                        outputStreamWriter = printOptions.outputType == 3 || System.getProperty("os.name", " ").regionMatches(true, 0, "win", 0, 3) ? new OutputStreamWriter((OutputStream)printOptions.outFile, "UTF-8") : new OutputStreamWriter(printOptions.outFile);
                    }
                }
                catch (Exception exception) {
                    GuiUtil.displayErrorMessage(exception.getMessage());
                }
                if (printOptions.outFile != null) {
                    printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                }
                if (printWriter != null) {
                    BaseTableModel baseTableModel = (BaseTableModel)megaTable.getDataSource();
                    ReportDataAdjuster reportDataAdjuster = baseTableModel.getAdjuster();
                    int[] nArray = null;
                    nArray = reportDataAdjuster.fixColumnArray(nArray);
                    int[] nArray2 = megaTable.getViewToModelIndices();
                    if (printOptions.outputType == 3) {
                        new PrintHtmlTable().printHtml(reportDataAdjuster, printWriter, nArray, GuiUtil.getUserName(), string2, nArray2);
                    } else if (printOptions.outputType == 7) {
                        new WriteReports().writeCSV(reportDataAdjuster, printWriter, nArray, printOptions.includeHeaders, printOptions.includeTotals, nArray2);
                    } else if (printOptions.outputType == 8) {
                        new WriteReports().writeFormatted(reportDataAdjuster, printWriter, nArray, nArray2);
                    }
                    printWriter.close();
                }
            } else if (printOptions.outputType == 1) {
                new PrintPreviewPanel(dataDisplayInfo, string2, false);
            } else {
                PrintManager.getPrinter(printOptions);
                if (printOptions.printer != null) {
                    BaseTableModel baseTableModel = (BaseTableModel)megaTable.getDataSource();
                    ReportDataAdjuster reportDataAdjuster = baseTableModel.getAdjuster();
                    int[] nArray = null;
                    nArray = reportDataAdjuster.fixColumnArray(nArray);
                    int[] nArray3 = megaTable.getViewToModelIndices();
                    new PrintTable().print(reportDataAdjuster, printOptions, nArray, nArray3);
                    PrintManager.printDocument(printOptions);
                }
            }
        }
    }

    public static String getFileName(PrintOptions printOptions) {
        String string = printOptions.fileMask;
        String string2 = printOptions.outputType == 2 ? ".pdf" : (printOptions.outputType == 3 ? ".html" : (printOptions.outputType == 4 ? ".ps" : (printOptions.outputType == 7 ? ".csv" : (printOptions.outputType == 8 ? ".txt" : ".pcl"))));
        if (string == null) {
            string = "report" + string2;
        } else {
            string = String.valueOf(string) + string2;
            string = WriteReports.adjustFileName(string);
        }
        String string3 = String.valueOf(System.getProperty("user.dir", " ")) + File.separatorChar;
        String string4 = new PrintFileChooser().getName(string3, string);
        return string4;
    }
}

