/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.UilTimeFieldBean;

public class TimeSelector
extends JPanel {
    private Calendar calendar = Calendar.getInstance();
    private UilTimeFieldBean timeField = new UilTimeFieldBean();

    public TimeSelector() {
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public TimeSelector(short s, short s2) {
        this.initFromShorts(s, s2);
        this.buildPanel();
    }

    private void initFromCalendar(Calendar calendar) {
        this.timeField.setTime(calendar.getTime());
    }

    private void initFromShorts(short s, short s2) {
        this.calendar.set(11, s);
        this.calendar.set(12, s2);
    }

    public void setTime(short s, short s2) {
        this.initFromShorts(s, s2);
        this.setTime();
    }

    public void setTime(long l) {
        this.calendar.setTime(new Date(l));
        this.initFromCalendar(this.calendar);
        this.setTime();
    }

    public short[] getTime() {
        this.getSelection();
        short[] sArray = new short[]{(short)this.calendar.get(11), (short)this.calendar.get(12)};
        return sArray;
    }

    public long getLongTime() {
        this.getSelection();
        return this.calendar.getTime().getTime();
    }

    public void setEnabled(boolean bl) {
        this.timeField.setEnabled(bl);
    }

    private void buildPanel() {
        this.timeField.setDateFormat(DateFormat.getTimeInstance(3));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.timeField, gridBagConstraints);
    }

    private void setTime() {
        this.timeField.setTime(this.calendar.getTime());
    }

    private void getSelection() {
        this.calendar.setTime(this.timeField.getTime());
    }
}

