/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.aperi.gui.BaseWizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardListener;
import org.eclipse.aperi.gui.WizardPage;

public class Wizard
extends BaseWizard {
    protected transient ContainerListener containerListener = new CardsListener();
    protected WizardPage currentPage;
    private Hashtable pages = new Hashtable();
    private Stack previous = new Stack();

    public Wizard() {
        this.addContainerListener(this.containerListener);
    }

    public WizardPage add(WizardPage wizardPage) {
        this.add((Component)wizardPage.getContentPane(), wizardPage.getName());
        return wizardPage;
    }

    public void show(String string) {
        this.cardLayout.show(this, string);
    }

    public void first() {
        this.cardLayout.first(this);
    }

    public void last() {
        this.cardLayout.last(this);
    }

    public void finish() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        WizardEvent wizardEvent = new WizardEvent(null, this.currentPage, null, true, true);
        Vector vector = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            WizardListener wizardListener = (WizardListener)vector.elementAt(n);
            wizardListener.canceled(wizardEvent);
            ++n;
        }
    }

    protected Component getCurrentPage() {
        return this.currentPage;
    }

    private boolean next(WizardEvent wizardEvent) {
        WizardPage wizardPage = (WizardPage)wizardEvent.getNewPage();
        this.cardLayout.show(this, wizardPage.getName());
        return true;
    }

    private boolean previous(WizardEvent wizardEvent) {
        WizardPage wizardPage = (WizardPage)wizardEvent.getNewPage();
        this.cardLayout.show(this, wizardPage.getName());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNextWizardEvent(ActionEvent actionEvent) {
        WizardPage wizardPage;
        boolean bl = false;
        if (this.currentPage.next() == null) {
            wizardPage = null;
            bl = true;
        } else {
            bl = false;
            wizardPage = (WizardPage)this.pages.get(this.currentPage.next());
        }
        WizardEvent wizardEvent = new WizardEvent(actionEvent.getSource(), this.currentPage, wizardPage, bl, true);
        Vector vector = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            WizardListener wizardListener = (WizardListener)vector.elementAt(n);
            wizardListener.nextBegin(wizardEvent);
            if (wizardEvent.getAllowChange()) {
                WizardEvent wizardEvent2 = new WizardEvent(actionEvent.getSource(), this.currentPage, wizardEvent.getNewPage(), bl, true);
                this.previous.push(this.currentPage);
                this.currentPage = (WizardPage)wizardEvent2.getNewPage();
                this.next(wizardEvent2);
                wizardListener.nextComplete(wizardEvent2);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePreviousWizardEvent(ActionEvent actionEvent) {
        WizardPage wizardPage = (WizardPage)this.previous.pop();
        WizardEvent wizardEvent = new WizardEvent(actionEvent.getSource(), this.currentPage, wizardPage, false, true);
        Vector vector = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            WizardListener wizardListener = (WizardListener)vector.elementAt(n);
            wizardListener.previousBegin(wizardEvent);
            WizardEvent wizardEvent2 = new WizardEvent(actionEvent.getSource(), this.currentPage, wizardEvent.getNewPage(), false, true);
            this.previous(wizardEvent2);
            wizardListener.previousComplete(wizardEvent2);
            this.currentPage = wizardPage;
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFinishWizardEvent(ActionEvent actionEvent, WizardPage wizardPage) {
        WizardEvent wizardEvent = new WizardEvent(actionEvent.getSource(), wizardPage, null, true, true);
        Vector vector = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            WizardListener wizardListener = (WizardListener)vector.elementAt(n);
            wizardListener.finished(wizardEvent);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHelpWizardEvent(ActionEvent actionEvent, WizardPage wizardPage) {
        WizardEvent wizardEvent = new WizardEvent(actionEvent.getSource(), wizardPage, null, false, true);
        Vector vector = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            WizardListener wizardListener = (WizardListener)vector.elementAt(n);
            wizardListener.help(wizardEvent);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCancelWizardEvent(ActionEvent actionEvent, WizardPage wizardPage) {
        WizardEvent wizardEvent = new WizardEvent(actionEvent.getSource(), wizardPage, null, true, true);
        Vector vector = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            WizardListener wizardListener = (WizardListener)vector.elementAt(n);
            wizardListener.canceled(wizardEvent);
            ++n;
        }
    }

    class CardsListener
    implements ContainerListener {
        CardsListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            WizardPage wizardPage = (WizardPage)containerEvent.getChild();
            if (Wizard.this.pages.isEmpty()) {
                Wizard.this.currentPage = wizardPage;
            }
            Wizard.this.pages.put(wizardPage.getName(), wizardPage);
            wizardPage.getPreviousButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Wizard.this.firePreviousWizardEvent(actionEvent);
                }
            });
            wizardPage.getNextButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Wizard.this.fireNextWizardEvent(actionEvent);
                }
            });
            wizardPage.getFinishButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Wizard.this.fireFinishWizardEvent(actionEvent, ((CardsListener)CardsListener.this).Wizard.this.currentPage);
                }
            });
            wizardPage.getHelpButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Wizard.this.fireHelpWizardEvent(actionEvent, ((CardsListener)CardsListener.this).Wizard.this.currentPage);
                }
            });
            wizardPage.getCancelButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Wizard.this.fireCancelWizardEvent(actionEvent, ((CardsListener)CardsListener.this).Wizard.this.currentPage);
                }
            });
        }

        public void componentRemoved(ContainerEvent containerEvent) {
        }
    }
}

