/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.admin.AgentDDI;
import org.eclipse.aperi.gui.admin.LogConfigDialog;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentTreeNode
extends BaseTreeNode
implements GuiRequestor,
ActionListener {
    protected int computerID;
    protected byte state;
    private String actionCommand;
    private LogConfigDialog lConfigDialog = null;
    public JPopupMenu popup;
    private static final String lLog = "ADG0017L";
    private static final String lTracing = "ADG0304L";
    private static final String lConfig = "ADG0255L";
    private static final String lShutdown = "ADG0006L";
    private static final String lNormal = "ADG0007L";
    private static final String lImmediate = "ADG0009L";
    private static final String lAbort = "ADG0011L";
    private static final String lUninstall = "ADG0262L";
    private static final String lCheck = "ADG0288L";
    private static final String lEnable = "ADG0289L";
    private static final String lDisable = "ADG0290L";

    public AgentTreeNode(Object object, int n, byte by) {
        this.setUserObject(object);
        this.computerID = n;
        this.state = by;
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        switch (this.state) {
            case 2: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateDefectedIcon());
                break;
            }
            case 1: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateUpIcon());
                break;
            }
            case 0: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateDownIcon());
                break;
            }
            case 3: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateUpgradingIcon());
                break;
            }
            case 4: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateUreachableIcon());
                break;
            }
            case 5: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateUpgradeNeededIcon());
            }
        }
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        if (this.ddi == null) {
            AgentDDI agentDDI = new AgentDDI();
            this.ddi = agentDDI;
            this.ddi.treeNode = this;
            this.ddi.setDescription(String.valueOf(MessageLog.getMessageNoID("ADG0201L")) + ":  " + this.getUserObject());
            agentDDI.runNumber = -1;
            agentDDI.agentTab = 0;
        }
        this.ddi.reDisplay();
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.popup;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        UserPreferences userPreferences = guiMain.getUserPrefs();
        boolean bl = true;
        if (mouseEvent == null) {
            bl = false;
        }
        this.popup = this.getPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(MessageLog.getMessageNoID(lLog));
        JMenuItem jMenuItem2 = new JMenuItem(MessageLog.getMessageNoID(lTracing));
        JMenuItem jMenuItem3 = new JMenuItem(MessageLog.getMessageNoID(lConfig));
        JMenu jMenu = new JMenu(MessageLog.getMessageNoID(lShutdown));
        JMenuItem jMenuItem4 = new JMenuItem(MessageLog.getMessageNoID(lNormal));
        JMenuItem jMenuItem5 = new JMenuItem(MessageLog.getMessageNoID(lImmediate));
        JMenuItem jMenuItem6 = new JMenuItem(MessageLog.getMessageNoID(lAbort));
        JMenuItem jMenuItem7 = new JMenuItem(MessageLog.getMessageNoID(lUninstall));
        JMenuItem jMenuItem8 = new JMenuItem(MessageLog.getMessageNoID(lCheck));
        JMenuItem jMenuItem9 = new JMenuItem(MessageLog.getMessageNoID(lEnable));
        JMenuItem jMenuItem10 = new JMenuItem(MessageLog.getMessageNoID(lDisable));
        jMenuItem.setName(MessageLog.getMessageNoID(lLog));
        jMenuItem2.setName(MessageLog.getMessageNoID(lTracing));
        jMenuItem3.setName(MessageLog.getMessageNoID(lConfig));
        jMenu.setName(MessageLog.getMessageNoID(lShutdown));
        jMenuItem4.setName(MessageLog.getMessageNoID(lNormal));
        jMenuItem5.setName(MessageLog.getMessageNoID(lImmediate));
        jMenuItem6.setName(MessageLog.getMessageNoID(lAbort));
        jMenuItem7.setName(MessageLog.getMessageNoID(lUninstall));
        jMenuItem8.setName(MessageLog.getMessageNoID(lCheck));
        jMenuItem9.setName(MessageLog.getMessageNoID(lEnable));
        jMenuItem10.setName(MessageLog.getMessageNoID(lDisable));
        jMenuItem3.setToolTipText(MessageLog.getMessageNoID("ADG0256T"));
        jMenuItem2.setToolTipText(MessageLog.getMessageNoID("ADG0305T"));
        jMenuItem.setToolTipText(MessageLog.getMessageNoID("ADG0260T"));
        jMenu.setToolTipText(MessageLog.getMessageNoID("ADG0016T"));
        jMenuItem4.setToolTipText(MessageLog.getMessageNoID("ADG0008T"));
        jMenuItem5.setToolTipText(MessageLog.getMessageNoID("ADG0010T"));
        jMenuItem6.setToolTipText(MessageLog.getMessageNoID("ADG0012T"));
        jMenuItem7.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        jMenuItem8.setToolTipText(MessageLog.getMessageNoID("ADG0291T"));
        jMenuItem9.setToolTipText(MessageLog.getMessageNoID("ADG0293T"));
        jMenuItem10.setToolTipText(MessageLog.getMessageNoID("ADG0292T"));
        jMenuItem.setActionCommand(lLog);
        jMenuItem2.setActionCommand(lTracing);
        jMenuItem3.setActionCommand(lConfig);
        jMenuItem4.setActionCommand(lNormal);
        jMenuItem5.setActionCommand(lImmediate);
        jMenuItem6.setActionCommand(lAbort);
        jMenuItem7.setActionCommand(lUninstall);
        jMenuItem8.setActionCommand(lCheck);
        jMenuItem9.setActionCommand(lEnable);
        jMenuItem10.setActionCommand(lDisable);
        jMenuItem.addActionListener(this);
        jMenuItem2.addActionListener(this);
        jMenuItem3.addActionListener(this);
        jMenuItem4.addActionListener(this);
        jMenuItem5.addActionListener(this);
        jMenuItem6.addActionListener(this);
        jMenuItem7.addActionListener(this);
        jMenuItem8.addActionListener(this);
        jMenuItem9.addActionListener(this);
        jMenuItem10.addActionListener(this);
        jMenuItem3.setEnabled(userPreferences.administrator);
        jMenuItem2.setEnabled(userPreferences.administrator);
        jMenu.setEnabled(userPreferences.administrator);
        jMenuItem7.setEnabled(userPreferences.administrator);
        jMenuItem9.setEnabled(userPreferences.administrator);
        jMenuItem10.setEnabled(userPreferences.administrator);
        if (this.state == 1 || this.state == 5) {
            this.popup.add(jMenuItem);
            if (this.state == 1) {
                this.popup.add(jMenuItem2);
            }
            this.popup.add(jMenuItem3);
        }
        this.popup.add(jMenuItem8);
        if (this.state == 1 || this.state == 5) {
            this.popup.add(jMenu);
            jMenu.add(jMenuItem4);
            jMenu.add(jMenuItem5);
            jMenu.add(jMenuItem6);
            this.popup.add(jMenuItem10);
        } else if (this.state == 4) {
            this.popup.add(jMenuItem10);
        } else if (this.state == 0) {
            this.popup.add(jMenuItem9);
        }
        this.popup.add(jMenuItem7);
        if (bl) {
            this.showPopupMenu(this.popup, mouseEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionCommand = actionEvent.getActionCommand();
        if (this.actionCommand == lNormal) {
            this.stopAgent((byte)1);
        } else if (this.actionCommand == lImmediate) {
            this.stopAgent((byte)2);
        } else if (this.actionCommand == lAbort) {
            this.stopAgent((byte)3);
        } else if (this.actionCommand == lConfig) {
            this.config();
        } else if (this.actionCommand == lLog) {
            this.log();
        } else if (this.actionCommand == lUninstall) {
            this.uninstallAgent();
        } else if (this.actionCommand == lCheck) {
            this.checkAgent();
        } else if (this.actionCommand == lEnable) {
            this.enableAgent();
        } else if (this.actionCommand == lDisable) {
            this.disableAgent();
        } else if (this.actionCommand == lTracing) {
            this.tracingConfig();
        }
    }

    private void stopAgent(byte by) {
        String string = MessageLog.getMessageNoID("ADG0251T", this.getUserObject());
        String string2 = MessageLog.getMessageNoID("ADG0252T", this.getUserObject());
        String string3 = MessageLog.getMessageNoID("ADG0253L");
        String string4 = MessageLog.getMessageNoID("ADG0254L");
        Object[] objectArray = new String[]{string3, string4};
        int n = JOptionPane.showOptionDialog(guiMain.getFrame(), string2, string, 0, 2, null, objectArray, objectArray[0]);
        if (n == 1) {
            Request request = new Request();
            ServerRequest.agentStop(request, this.computerID, by);
            GuiClient.doRhetoricalRequest(request);
            this.state = 0;
            BaseTree.MyTree.nodeChanged(this);
        }
    }

    private void log() {
        new LogViewer(this.computerID, this);
    }

    private void tracingConfig() {
        Request request = new Request();
        ServerRequest.agentGetTracingConfig(request, this.computerID, "org.eclipse.aperi.agent.svp.AgentSvp");
        GuiClient.doRequest(this, request);
    }

    private void config() {
        Request request = new Request();
        ServerRequest.agentReadConfig(request, this.computerID);
        GuiClient.doRequest(this, request);
    }

    private void uninstallAgent() {
        String string = MessageLog.getMessageNoID("ADG0264T", this.getUserObject());
        String string2 = MessageLog.getMessageNoID("ADG0265T", this.getUserObject());
        String string3 = MessageLog.getMessageNoID("ADG0266L");
        String string4 = MessageLog.getMessageNoID("ADG0267L");
        Object[] objectArray = new String[]{string3, string4};
        int n = JOptionPane.showOptionDialog(guiMain.getFrame(), string2, string, 0, 2, null, objectArray, objectArray[0]);
        if (n == 1) {
            Request request = new Request();
            byte by = 0;
            ServerRequest.uninstallAgent(request, this.computerID, by);
            GuiClient.doRequest(this, request);
            BaseTree.MyTree.removeNodeFromParent(this);
        }
    }

    private void checkAgent() {
        Request request = new Request();
        ServerRequest.agentStatus(request, this.computerID);
        GuiClient.doRequest(this, request);
    }

    private void enableAgent() {
        Request request = new Request();
        ServerRequest.agentState(request, new ComputerID(this.computerID), (byte)1);
        GuiClient.doRequest(this, request);
    }

    private void disableAgent() {
        Request request = new Request();
        ServerRequest.agentState(request, new ComputerID(this.computerID), (byte)0);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (this.actionCommand == lCheck) {
            this.setState(response);
            if (s < 4) {
                String string = MessageLog.getMessageNoID("ADG0294M", this.getUserObject());
                JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
            }
        } else if (this.actionCommand == lEnable || this.actionCommand == lDisable) {
            this.setState(response);
        } else if (this.actionCommand == lTracing) {
            if (s != 0) {
                String string = MessageLog.getMessage("ADG0308E", this.getUserObject());
                JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0307L"), 0);
            } else {
                HashMap hashMap = (HashMap)response.responseData;
                if (this.lConfigDialog == null) {
                    String string = MessageLog.getMessageNoID("ADG0310L", this.getUserObject());
                    this.lConfigDialog = new LogConfigDialog(string, this.computerID, this.getUserObject(), "org.eclipse.aperi.agent.svp.AgentSvp");
                }
                this.lConfigDialog.setLocationRelativeTo(null);
                this.lConfigDialog.show(hashMap, "org.eclipse.aperi.agent.svp.AgentSvp");
            }
        } else if ((this.actionCommand == lImmediate || this.actionCommand == lAbort) && s <= 4) {
            this.actionCommand = null;
            Request request = new Request();
            ServerRequest.agentState(request, new ComputerID(this.computerID), (byte)0);
            GuiClient.doRequest(this, request);
        }
    }

    private void setState(Response response) {
        if (response != null && response.responseData != null && response.responseData instanceof Byte) {
            this.state = (Byte)response.responseData;
            BaseTree.MyTree.nodeChanged(this);
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
            if (dataDisplayInfo != null && dataDisplayInfo instanceof AgentDDI && (AgentTreeNode)dataDisplayInfo.treeNode == this) {
                dataDisplayInfo.remove();
                this.select(null);
            }
        }
    }
}

