/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.OutOfBandAgentDialog;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.AgentListPanel;
import org.eclipse.aperi.gui.admin.agent.OutOfBandFabricAgentTableModel;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class OutOfBandFabricAgentListPanel
extends AgentListPanel {
    private JButton addAgentButton = null;
    private JButton checkButton = null;
    private JButton removeButton = null;

    public OutOfBandFabricAgentListPanel(AgentListDDI agentListDDI) {
        super(agentListDDI);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        this.addAgentButton = this.getButton(GuiUtil.getString("FabricAgent_add"));
        this.checkButton = this.getButton(FabricGuiUtil.getString("FabricOutOfBand_Check"));
        this.removeButton = this.getButton(MessageLog.getMessageNoID("ADG0262L"));
        this.removeButton.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        this.addAgentButton.setEnabled(this.capabilities.isAperiAdmin());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.addAgentButton);
        jPanel2.add(this.checkButton);
        jPanel2.add(this.removeButton);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    void disableAllButtons() {
        this.checkButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    void chooseButtons(Object object) {
        boolean bl;
        boolean bl2 = bl = object instanceof Vector && ((Vector)object).size() > 1;
        if (!bl) {
            this.checkButton.setEnabled(true);
        } else {
            this.checkButton.setEnabled(false);
        }
        this.removeButton.setEnabled(this.capabilities.isAperiAdmin());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        actionEvent.getActionCommand();
        int[] nArray = this.getTable().getSelectedRows();
        NameList[] nameListArray = new NameList[nArray.length];
        int n = 0;
        while (n < nameListArray.length) {
            nameListArray[n] = (NameList)this.getDDI().elementAt(nArray[n]);
            ++n;
        }
        if (object == this.addAgentButton) {
            OutOfBandAgentDialog outOfBandAgentDialog = new OutOfBandAgentDialog(guiMain.getFrame(), true);
            outOfBandAgentDialog.setDDI(this.getDDI());
            outOfBandAgentDialog.show();
        } else if (object == this.removeButton) {
            this.removeAgent(nameListArray);
        } else if (object == this.checkButton) {
            this.checkAgent(nameListArray);
        } else if (object == this.refreshNowButton) {
            this.getDDI().getData();
        }
    }

    private void removeAgent(NameList[] nameListArray) {
        String string = GuiUtil.getString("CONFIRM_DELETE_MULTIPLE");
        String string2 = MessageLog.getMessageNoID("ADG0262L");
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < nameListArray.length) {
            treeSet.add(nameListArray[n].nlName);
            ++n;
        }
        JList<String> jList = new JList<String>(treeSet.toArray(new String[treeSet.size()]));
        int n2 = treeSet.size() < 6 ? treeSet.size() : 6;
        jList.setVisibleRowCount(n2);
        JScrollPane jScrollPane = new JScrollPane(jList);
        int n3 = JOptionPane.showOptionDialog(guiMain.getFrame(), new Object[]{string, jScrollPane}, string2, 2, 2, null, null, null);
        if (n3 == 0) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            request.flags = (byte)4;
            if (nameListArray.length == 1) {
                OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = new OutOfBandFabricAgentInfo();
                outOfBandFabricAgentInfo.hostname = nameListArray[0].nlName;
                outOfBandFabricAgentInfo.ipaddress = nameListArray[0].nlName2;
                outOfBandFabricAgentInfo.request_type = 3;
                request.requestData = outOfBandFabricAgentInfo;
            } else if (nameListArray.length > 1) {
                OutOfBandFabricAgentInfo[] outOfBandFabricAgentInfoArray = new OutOfBandFabricAgentInfo[nameListArray.length];
                int n4 = 0;
                while (n4 < nameListArray.length) {
                    outOfBandFabricAgentInfoArray[n4] = new OutOfBandFabricAgentInfo();
                    outOfBandFabricAgentInfoArray[n4].hostname = nameListArray[n4].nlName;
                    outOfBandFabricAgentInfoArray[n4].ipaddress = nameListArray[n4].nlName2;
                    outOfBandFabricAgentInfoArray[n4].request_type = 3;
                    ++n4;
                }
                request.requestData = outOfBandFabricAgentInfoArray;
            }
            GuiClient.doRequest(new ActionResponseHandler(nameListArray), request);
        }
    }

    private void checkAgent(NameList[] nameListArray) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
        request.userName = GuiUtil.getUserName();
        OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = new OutOfBandFabricAgentInfo();
        request.requestData = outOfBandFabricAgentInfo;
        request.flags = (byte)4;
        outOfBandFabricAgentInfo.request_type = 4;
        outOfBandFabricAgentInfo.hostname = nameListArray[0].nlName;
        outOfBandFabricAgentInfo.ipaddress = nameListArray[0].nlName2;
        GuiClient.doRequest(new ActionResponseHandler(nameListArray), request);
    }

    public OutOfBandFabricAgentTableModel getTableModel() {
        return (OutOfBandFabricAgentTableModel)this.getDDI().getTableModel();
    }

    private class ActionResponseHandler
    implements GuiRequestor {
        private NameList[] agents;

        public ActionResponseHandler(NameList[] nameListArray) {
            this.agents = nameListArray;
        }

        public void handleResponse(short s, Response response) {
            if (s <= 4) {
                OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = response.responseData instanceof OutOfBandFabricAgentInfo ? (OutOfBandFabricAgentInfo)response.responseData : ((OutOfBandFabricAgentInfo[])response.responseData)[0];
                switch (outOfBandFabricAgentInfo.request_type) {
                    case 4: {
                        this.agents[0].nlState = outOfBandFabricAgentInfo.status == 2 ? (byte)1 : (outOfBandFabricAgentInfo.status == 3 ? (byte)0 : (byte)-1);
                        OutOfBandFabricAgentListPanel.this.getTableModel().refreshAgent(this.agents[0]);
                        if (outOfBandFabricAgentInfo.status == 2) {
                            String string = MessageLog.getMessageNoID("ADG0294M", this.agents[0].nlName);
                            JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                            break;
                        }
                        String string = String.valueOf(this.agents[0].nlName) + " " + FabricGuiUtil.getInbandFabricAgentStatusString(outOfBandFabricAgentInfo.status);
                        JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                        break;
                    }
                    case 3: {
                        OutOfBandFabricAgentListPanel.this.getTableModel().removeAgents(this.agents);
                        int n = 0;
                        while (n < this.agents.length) {
                            OutOfBandFabricAgentListPanel.this.getDDI().getTreeNode(this.agents[n], false, true);
                            ++n;
                        }
                        break;
                    }
                }
            }
        }
    }
}

