/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.charting.AperiChartAdapter;

public class AperiChartFactory {
    private static Class currentChartEngineClass;
    private static String currentChartEngineName;
    private static String currentChartEngineChoice;
    private static final String choiceJClassChartEngine = "JClass Chart Engine";
    private static final String choiceEclipseChartEngine = "Eclipse Chart Engine";
    private static final String classJClassChartEngine = "org.eclipse.aperi.gui.charting.AperiJClassChart";
    private static final String classEclipseChartEngine = "org.eclipse.aperi.gui.charting.AperiEclipseChart";
    private static HashMap engineMap;
    private static IGuiMain guiMain;

    static {
        engineMap = new HashMap();
        guiMain = GuiManager.getGuiManager().getGuiMain();
        engineMap.put(choiceEclipseChartEngine, classEclipseChartEngine);
        AperiChartFactory.setEngineChoice(choiceEclipseChartEngine);
    }

    public static JMenuItem getChartEngineMenu() {
        JMenuItem jMenuItem = new JMenuItem("Select Chart Engine");
        jMenuItem.setMnemonic('e');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AperiChartFactory.selectChartEngine();
            }
        });
        return jMenuItem;
    }

    private static void setEngineChoice(String string) {
        AperiChartFactory.setCurrentChartEngineChoice(string);
        AperiChartFactory.setCurrentChartEngineName();
        AperiChartFactory.setCurrentChartEngineClass();
    }

    private static void selectChartEngine() {
        String string = (String)JOptionPane.showInputDialog(guiMain.getFrame(), "Select Chart Engine", "Chart Engine Selector", -1, IconFactory.getPieChartIcon(), engineMap.keySet().toArray(), AperiChartFactory.getCurrentChartEngineChoice());
        if (string != null) {
            AperiChartFactory.setEngineChoice(string);
        }
    }

    public static AperiChartAdapter newChart() {
        try {
            return (AperiChartAdapter)AperiChartFactory.getCurrentChartEngineClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Class getCurrentChartEngineClass() {
        return currentChartEngineClass;
    }

    private static void setCurrentChartEngineClass() {
        try {
            currentChartEngineClass = Class.forName(currentChartEngineName);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String getCurrentChartEngineName() {
        return currentChartEngineName;
    }

    private static void setCurrentChartEngineName() {
        currentChartEngineName = (String)engineMap.get(AperiChartFactory.getCurrentChartEngineChoice());
    }

    private static String getCurrentChartEngineChoice() {
        return currentChartEngineChoice;
    }

    private static void setCurrentChartEngineChoice(String string) {
        currentChartEngineChoice = string;
    }
}

