/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.EditElementManagerConfigDialog;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.GuiConfig;
import org.eclipse.aperi.xmsg.MessageLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementManagerManager {
    private static final String XML_ELM_LAUNCHSTRING = "launchString";
    private static final String XML_ATTR_VALUE = "value";
    private static final String XML_ELM_DISPLAYNAME = "displayName";
    private static final String XML_ELM_MANAGER = "manager";
    private static final String XML_ATTR_GUID = "GUID";
    private static final String XML_ELM_DEVICE = "device";
    private static final String XML_ELM_ELEMENTMANAGERS = "elementManagers";
    private static final String DEFAULT_URLREGEXP = "(^http://.*)|(^https://.*)|(^ftp://.*)";
    private static final String PROPERTY_URLREGEXP = "URLRegexp";
    private static final String DEFAULT_WINDOWSEXECPREAMBLE = "cmd /c start \"\" ";
    private static final String PROPERTY_WINDOWSEXECPREAMBLE = "windowsExecPreamble";
    private static final String DEFAULT_WINDOWSURLPERAMBLE = "cmd /c start \"\" ";
    private static final String PROPERTY_WINDOWSURLPREAMBLE = "windowsURLPreamble";
    private static final String DEFAULT_UNIXEXECPREAMBLE = "/bin/sh -c ";
    private static final String PROPERTY_UNIXEXECPREAMBLE = "unixExecPreamble";
    private static final String DEFAULT_UNINXURLPREAMBLE = "${DEFAULT_BROWSER} ";
    private static final String PROPERTY_UNIXURLPREAMBLE = "unixURLPreamble";
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private HashMap userDefinedElementManagers = null;
    private static String elementDBFile = "element.xml";
    private HashMap internal2external;
    private HashMap external2internal;
    private Properties guiProperties = new Properties();
    private static String guiConfigFile = "GUI.properties";
    private static String WHITESPACE_REGEXP = "^\\s*$";
    private static ElementManagerManager instance = null;

    private ElementManagerManager() {
        this.createPropertyNameMaps();
        this.getElementManagers();
        this.getGUIProperties();
    }

    private void createPropertyNameMaps() {
        this.internal2external = new HashMap();
        this.external2internal = new HashMap();
        this.internal2external.put(PROPERTY_URLREGEXP, Util.getString("ELEMENT_MANAGER_PROPERTY_URLREGEXP"));
        this.internal2external.put(PROPERTY_WINDOWSEXECPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSEXEC"));
        this.internal2external.put(PROPERTY_WINDOWSURLPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSURL"));
        this.internal2external.put(PROPERTY_UNIXEXECPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXEXEC"));
        this.internal2external.put(PROPERTY_UNIXURLPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXURL"));
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_URLREGEXP"), PROPERTY_URLREGEXP);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSEXEC"), PROPERTY_WINDOWSEXECPREAMBLE);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSURL"), PROPERTY_WINDOWSURLPREAMBLE);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXEXEC"), PROPERTY_UNIXEXECPREAMBLE);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXURL"), PROPERTY_UNIXURLPREAMBLE);
    }

    private void getElementManagers() {
        block16: {
            InputStream inputStream;
            block15: {
                this.userDefinedElementManagers = new HashMap();
                inputStream = null;
                try {
                    try {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        inputStream = GuiConfig.getFileInputStream(elementDBFile);
                        if (inputStream != null) {
                            Document document = documentBuilder.parse(inputStream);
                            this.buildData(document);
                        }
                    }
                    catch (Exception exception) {
                        this.userDefinedElementManagers = new HashMap();
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8203E", this.getExceptionMessage(exception)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                break block16;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getExceptionMessage(Exception exception) {
        String string = exception.getLocalizedMessage();
        if (string == null) {
            string = exception.toString();
        }
        return string;
    }

    private void buildData(Document document) {
        Node node = this.getFirstChildNodeMatching(document, (short)1, XML_ELM_ELEMENTMANAGERS);
        if (node != null) {
            Node node2 = this.getFirstChildNodeMatching(node, (short)1, XML_ELM_DEVICE);
            while (node2 != null) {
                this.addDevice(node2);
                node2 = this.getNextSiblingNodeMatching(node2, (short)1, XML_ELM_DEVICE);
            }
        }
    }

    private void addDevice(Node node) {
        try {
            String string = this.getAttribute(node, XML_ATTR_GUID);
            if (string != null) {
                ArrayList<ElementManager> arrayList = new ArrayList<ElementManager>();
                Node node2 = this.getFirstChildNodeMatching(node, (short)1, XML_ELM_MANAGER);
                while (node2 != null) {
                    arrayList.add(new ElementManager(string, this.getAttribute(this.getFirstChildNodeMatching(node2, (short)1, XML_ELM_DISPLAYNAME), XML_ATTR_VALUE), this.getAttribute(this.getFirstChildNodeMatching(node2, (short)1, XML_ELM_LAUNCHSTRING), XML_ATTR_VALUE)));
                    node2 = this.getNextSiblingNodeMatching(node2, (short)1, XML_ELM_MANAGER);
                }
                this.userDefinedElementManagers.put(string, arrayList);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(Util.getString("ELEMENT_MANAGER_ERROR_CORRUPT"));
        }
    }

    private String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            if (this.isMatchingNode(namedNodeMap.item(n), (short)2, string)) {
                return namedNodeMap.item(n).getNodeValue();
            }
            ++n;
        }
        throw new RuntimeException(Util.getString("ELEMENT_MANAGER_ERROR_CORRUPT"));
    }

    private Node getFirstMatchingNode(Node node, short s, String string) {
        Node node2 = node;
        while (node2 != null && !this.isMatchingNode(node2, s, string)) {
            node2 = node2.getNextSibling();
        }
        return node2;
    }

    private Node getNextSiblingNodeMatching(Node node, short s, String string) {
        return this.getFirstMatchingNode(node.getNextSibling(), s, string);
    }

    private Node getFirstChildNodeMatching(Node node, short s, String string) {
        return this.getFirstMatchingNode(node.getFirstChild(), s, string);
    }

    private boolean isMatchingNode(Node node, short s, String string) {
        return node.getNodeType() == s && node.getNodeName().equalsIgnoreCase(string);
    }

    private boolean saveElementManagers() {
        boolean bl;
        block17: {
            OutputStream outputStream;
            block16: {
                bl = true;
                outputStream = null;
                try {
                    try {
                        ArrayList arrayList;
                        String string2;
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                        Element element = document.createElement(XML_ELM_ELEMENTMANAGERS);
                        document.appendChild(element);
                        for (String string2 : this.userDefinedElementManagers.keySet()) {
                            arrayList = (ArrayList)this.userDefinedElementManagers.get(string2);
                            if (arrayList == null) continue;
                            Element element2 = document.createElement(XML_ELM_DEVICE);
                            element2.setAttribute(XML_ATTR_GUID, string2);
                            element.appendChild(element2);
                            int n = 0;
                            while (n < arrayList.size()) {
                                ElementManager elementManager = (ElementManager)arrayList.get(n);
                                Element element3 = document.createElement(XML_ELM_MANAGER);
                                element2.appendChild(element3);
                                Element element4 = document.createElement(XML_ELM_DISPLAYNAME);
                                element4.setAttribute(XML_ATTR_VALUE, elementManager.managerDisplayName);
                                element3.appendChild(element4);
                                Element element5 = document.createElement(XML_ELM_LAUNCHSTRING);
                                element5.setAttribute(XML_ATTR_VALUE, elementManager.managerLaunchString);
                                element3.appendChild(element5);
                                ++n;
                            }
                        }
                        document.normalize();
                        SerializerFactory serializerFactory = SerializerFactory.getSerializerFactory((String)"xml");
                        string2 = new OutputFormat(document);
                        string2.setLineSeparator(System.getProperty("line.separator"));
                        string2.setIndenting(true);
                        outputStream = GuiConfig.getFileOutputStream(elementDBFile);
                        arrayList = serializerFactory.makeSerializer(outputStream, (OutputFormat)string2);
                        arrayList.asDOMSerializer().serialize(document);
                        outputStream.flush();
                    }
                    catch (Exception exception) {
                        bl = false;
                        JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8204E", this.getExceptionMessage(exception)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
                break block17;
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private void getGUIProperties() {
        this.guiProperties.setProperty(PROPERTY_URLREGEXP, DEFAULT_URLREGEXP);
        this.guiProperties.setProperty(PROPERTY_UNIXEXECPREAMBLE, DEFAULT_UNIXEXECPREAMBLE);
        this.guiProperties.setProperty(PROPERTY_UNIXURLPREAMBLE, DEFAULT_UNINXURLPREAMBLE);
        this.guiProperties.setProperty(PROPERTY_WINDOWSEXECPREAMBLE, "cmd /c start \"\" ");
        this.guiProperties.setProperty(PROPERTY_WINDOWSURLPREAMBLE, "cmd /c start \"\" ");
        Properties properties = new Properties();
        try {
            GuiConfig.loadProperties(guiConfigFile, properties);
            this.guiProperties.putAll((Map<?, ?>)properties);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8206E", this.getExceptionMessage(exception)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
    }

    private String getGUIProperty(String string, String string2) {
        String string3 = this.guiProperties.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static synchronized ElementManagerManager getInstance() {
        if (instance == null) {
            instance = new ElementManagerManager();
        }
        return instance;
    }

    public void launchElementManager(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        Object[] objectArray = this.getElementManagers(object, elementManagerHelperInterface);
        if (objectArray == null || objectArray.length == 0) {
            this.displayNoManagerDialog(object, elementManagerHelperInterface);
        } else {
            String string = objectArray.length == 1 ? objectArray[0] : (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8203I", elementManagerHelperInterface.extractDisplayName(object)), Util.getString("ELEMENT_MANAGER_SELECT_TITLE"), 3, null, objectArray, objectArray[0]);
            if (string != null) {
                this.doLaunch(string);
            }
        }
    }

    public boolean hasElementManager(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        return this.getElementManager(object, elementManagerHelperInterface) != null;
    }

    public String getElementManager(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        String string;
        ElementManager elementManager = this.getLocalManager(elementManagerHelperInterface.extractGUID(object));
        if (elementManager == null) {
            string = elementManagerHelperInterface.extractDefaultElementManager(object);
            if (string != null && (string.length() == 0 || string.matches(WHITESPACE_REGEXP))) {
                string = null;
            }
        } else {
            string = elementManager.managerLaunchString;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public String[] getElementManagers(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        ElementManager[] elementManagerArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = elementManagerHelperInterface.extractDefaultElementManager(object);
        if (string != null && string.length() != 0 && !string.matches(WHITESPACE_REGEXP)) {
            arrayList.add(string);
        }
        if ((elementManagerArray = this.getLocalManagers(elementManagerHelperInterface.extractGUID(object))) != null) {
            int n = 0;
            while (n < elementManagerArray.length) {
                arrayList.add(elementManagerArray[n].managerLaunchString);
                ++n;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setElementManager(Object object, String string, ElementManagerHelperInterface elementManagerHelperInterface) {
        this.setLocalManager(elementManagerHelperInterface.extractGUID(object), elementManagerHelperInterface.extractDisplayName(object), string);
    }

    public void setElementManagerDialog(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        Object[] objectArray;
        String string = null;
        String[] stringArray = this.getElementManagers(object, elementManagerHelperInterface);
        JTextField jTextField = new JTextField();
        if (stringArray != null && stringArray.length != 0) {
            jTextField.setText(stringArray[0]);
            objectArray = new Object[]{MessageLog.getMessageNoID("GUI8200I", elementManagerHelperInterface.extractDisplayName(object)), jTextField, new JComboBox<String>(stringArray)};
        } else {
            objectArray = new Object[]{MessageLog.getMessageNoID("GUI8200I", elementManagerHelperInterface.extractDisplayName(object)), jTextField};
        }
        int n = JOptionPane.showOptionDialog(this.guiMain.getFrame(), objectArray, Util.getString("ELEMENT_MANAGER_EDIT_TITLE"), 2, 3, null, null, null);
        if (n != 0) {
            return;
        }
        string = jTextField.getText().trim();
        if (string.length() != 0) {
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (string.equals(stringArray[n2])) {
                        return;
                    }
                    ++n2;
                }
            }
            this.setElementManager(object, string, elementManagerHelperInterface);
        } else {
            this.deleteElementManager(object, elementManagerHelperInterface);
        }
    }

    public void deleteElementManager(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        this.deleteLocalManager(elementManagerHelperInterface.extractGUID(object));
    }

    public void deleteElementManagerDialog(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        Object[] objectArray = this.getLocalManagersElementLaunchString(elementManagerHelperInterface.extractGUID(object));
        if (objectArray != null && objectArray.length > 0) {
            if (objectArray.length == 1) {
                int n = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8202I", objectArray[0], elementManagerHelperInterface.extractDisplayName(object)), Util.getString("ELEMENT_MANAGER_DELETE_TITLE"), 0);
                if (n == 0) {
                    this.deleteElementManager(object, elementManagerHelperInterface);
                }
            } else {
                String string = (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8202I", "", elementManagerHelperInterface.extractDisplayName(object)), Util.getString("ELEMENT_MANAGER_DELETE_TITLE"), 3, null, objectArray, objectArray[0]);
                if (string != null) {
                    this.deleteLocalManager(elementManagerHelperInterface.extractGUID(object), string);
                }
            }
        } else {
            this.displayNoManagerDialog(object, elementManagerHelperInterface);
        }
    }

    private String getWindowsLauncher(String string) {
        String string2 = this.isURL(string) ? this.getWindowsURLPreamble() : this.getWindowsExecPreamble();
        return String.valueOf(string2) + " " + string;
    }

    private String[] getUnixLauncher(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isURL(string)) {
            int n;
            String string2 = this.getUnixURLPreamble();
            if (string2.trim().startsWith("$")) {
                string2 = this.getUnixEnv(string2);
            }
            if (string2.equals("") && (n = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8209E"), Util.getString("ELEMENT_MANAGER_NO_DEFAULT_BROWSER_TITLE"), 2)) == 0) {
                new EditElementManagerConfigDialog(this.guiMain.getFrame());
                string2 = this.getUnixURLPreamble();
                if (string2.trim().startsWith("$")) {
                    string2 = this.getUnixEnv(string2);
                }
            }
            if (!string2.equals("")) {
                arrayList.add(string2);
                arrayList.add(string);
            } else {
                JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8201E"), Util.getString("ELEMENT_MANAGER_NO_DEFAULT_BROWSER_TITLE"), 0);
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getUnixExecPreamble());
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isURL(String string) {
        return string.matches(this.getURLRegexp());
    }

    private void displayNoManagerDialog(Object object, ElementManagerHelperInterface elementManagerHelperInterface) {
        JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8201I", elementManagerHelperInterface.extractDisplayName(object)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
    }

    private void doLaunch(String string) {
        try {
            if (GuiConfig.isWindows()) {
                Runtime.getRuntime().exec(this.getWindowsLauncher(string));
            } else {
                String[] stringArray = this.getUnixLauncher(string);
                if (stringArray.length > 0) {
                    Runtime.getRuntime().exec(stringArray);
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8205E", this.getExceptionMessage(exception)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
    }

    private String getLocalManagerElementLaunchString(String string) {
        ElementManager elementManager = this.getLocalManager(string);
        if (elementManager == null) {
            return null;
        }
        return elementManager.managerLaunchString;
    }

    private String[] getLocalManagersElementLaunchString(String string) {
        ElementManager[] elementManagerArray = this.getLocalManagers(string);
        if (elementManagerArray == null) {
            return null;
        }
        String[] stringArray = new String[elementManagerArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = elementManagerArray[n].managerLaunchString;
            ++n;
        }
        return stringArray;
    }

    private String getLocalManagerDisplayName(String string) {
        ElementManager elementManager = this.getLocalManager(string);
        if (elementManager == null) {
            return null;
        }
        return elementManager.managerDisplayName;
    }

    private ElementManager getLocalManager(String string) {
        ArrayList arrayList = (ArrayList)this.userDefinedElementManagers.get(string);
        if (arrayList != null) {
            return (ElementManager)arrayList.get(0);
        }
        return null;
    }

    private ElementManager[] getLocalManagers(String string) {
        ArrayList arrayList = (ArrayList)this.userDefinedElementManagers.get(string);
        if (arrayList != null) {
            return arrayList.toArray(new ElementManager[arrayList.size()]);
        }
        return null;
    }

    private void setLocalManager(String string, String string2, String string3) {
        ArrayList<ElementManager> arrayList = (ArrayList<ElementManager>)this.userDefinedElementManagers.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<ElementManager>();
        }
        arrayList.add(0, new ElementManager(string, string2, string3));
        this.userDefinedElementManagers.put(string, arrayList);
        this.saveElementManagers();
    }

    private void deleteLocalManager(String string) {
        this.userDefinedElementManagers.remove(string);
        this.saveElementManagers();
    }

    private void deleteLocalManager(String string, String string2) {
        ArrayList arrayList = (ArrayList)this.userDefinedElementManagers.get(string);
        int n = 0;
        while (n < arrayList.size()) {
            ElementManager elementManager = (ElementManager)arrayList.get(n);
            if (elementManager.managerLaunchString.equals(string2)) {
                arrayList.remove(n);
                break;
            }
            ++n;
        }
        this.userDefinedElementManagers.put(string, arrayList);
        this.saveElementManagers();
    }

    private String getURLRegexp() {
        return this.guiProperties.getProperty(PROPERTY_URLREGEXP);
    }

    public String getWindowsExecPreamble() {
        return this.guiProperties.getProperty(PROPERTY_WINDOWSEXECPREAMBLE);
    }

    public String getWindowsURLPreamble() {
        return this.guiProperties.getProperty(PROPERTY_WINDOWSURLPREAMBLE);
    }

    public String getUnixExecPreamble() {
        return this.guiProperties.getProperty(PROPERTY_UNIXEXECPREAMBLE);
    }

    public String getUnixURLPreamble() {
        return this.guiProperties.getProperty(PROPERTY_UNIXURLPREAMBLE);
    }

    public String[][] getAllUserDefinedManagers() {
        String[][] stringArray = new String[this.userDefinedElementManagers.size()][];
        Iterator iterator = this.userDefinedElementManagers.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ElementManager[] elementManagerArray = this.getLocalManagers(string);
            stringArray[n] = new String[elementManagerArray.length + 2];
            stringArray[n][0] = elementManagerArray[0].managerGUID;
            stringArray[n][1] = elementManagerArray[0].managerDisplayName;
            int n2 = 0;
            while (n2 < elementManagerArray.length) {
                stringArray[n][n2 + 2] = elementManagerArray[n2].managerLaunchString;
                ++n2;
            }
            ++n;
        }
        return stringArray;
    }

    public boolean setAllUserDefinedManagers(String[][] stringArray) {
        this.userDefinedElementManagers.clear();
        int n = 0;
        while (n < stringArray.length) {
            ArrayList<ElementManager> arrayList = new ArrayList<ElementManager>();
            int n2 = 2;
            while (n2 < stringArray[n].length) {
                arrayList.add(new ElementManager(stringArray[n][0], stringArray[n][1], stringArray[n][n2]));
                ++n2;
            }
            this.userDefinedElementManagers.put(stringArray[n][0], arrayList);
            ++n;
        }
        return this.saveElementManagers();
    }

    public boolean setModifiedUserDefinedManagers(String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            ArrayList<ElementManager> arrayList = new ArrayList<ElementManager>();
            int n2 = 2;
            while (n2 < stringArray[n].length) {
                arrayList.add(new ElementManager(stringArray[n][0], stringArray[n][1], stringArray[n][n2]));
                ++n2;
            }
            if (arrayList.size() > 0) {
                this.userDefinedElementManagers.put(stringArray[n][0], arrayList);
            } else {
                this.userDefinedElementManagers.remove(stringArray[n][0]);
            }
            ++n;
        }
        return this.saveElementManagers();
    }

    public HashMap getConfig() {
        HashMap hashMap = new HashMap();
        for (Object object : this.guiProperties.keySet()) {
            hashMap.put(this.internal2external.get(object), this.guiProperties.get(object));
        }
        return hashMap;
    }

    public boolean setConfig(HashMap hashMap) {
        boolean bl = true;
        Properties properties = new Properties();
        if (hashMap != null) {
            for (Object k : hashMap.keySet()) {
                properties.setProperty((String)this.external2internal.get(k), (String)hashMap.get(k));
            }
        }
        try {
            GuiConfig.storeProperties(guiConfigFile, properties);
            this.guiProperties.clear();
            this.getGUIProperties();
        }
        catch (Exception exception) {
            bl = false;
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8207E", this.getExceptionMessage(exception)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
        return bl;
    }

    private String getUnixEnv(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo " + string});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            process.waitFor();
        }
        catch (Exception exception) {}
        return stringBuffer.toString().trim();
    }

    private class ElementManager
    implements Serializable {
        String managerGUID;
        String managerDisplayName;
        String managerLaunchString;

        public ElementManager(String string, String string2, String string3) {
            this.managerGUID = string;
            this.managerDisplayName = string2;
            this.managerLaunchString = string3;
        }
    }
}

