/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.StormTreeLabel;
import org.eclipse.aperi.TStorm.gui.TreeLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertingSection
extends ConfigSection
implements ActionListener {
    private JButton link2ComputerAlert = null;
    private ArrayList computerAlertPath = null;
    private JButton link2FSAlert = null;
    private ArrayList fsAlertPath = null;
    private ArrayList dirAlertPath = null;
    private JButton link2ComputerAlertLog = null;
    private ArrayList comAlertLogPath = null;
    private JButton link2FSAlertLog = null;
    private ArrayList fsAlertLogPath = null;
    private ArrayList dirAlertLogPath = null;

    public AlertingSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.add((Component)jPanel, "Last");
        ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_DATA_ALERT_NOTE"), jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.add(new JLabel(GuiUtil.getString("CONFIG_COMMON_ALERT_DEF_LBL")));
        this.link2ComputerAlert = new JButton(GuiUtil.getString("CONFIG_COMPUTER_ALERT"));
        this.link2ComputerAlert.addActionListener(this);
        GuiUtil.setAccessible(this.link2ComputerAlert, this.link2ComputerAlert.getText(), this.link2ComputerAlert.getText());
        jPanel2.add(this.link2ComputerAlert);
        this.link2FSAlert = new JButton(GuiUtil.getString("CONFIG_FILESYSTEM_ALERT"));
        this.link2FSAlert.addActionListener(this);
        GuiUtil.setAccessible(this.link2FSAlert, this.link2FSAlert.getText(), this.link2FSAlert.getText());
        jPanel2.add(this.link2FSAlert);
        this.add((Component)jPanel2, "Before");
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JLabel(GuiUtil.getString("CONFIG_COMMON_ALERT_VIEW_LBL")));
        this.link2ComputerAlertLog = new JButton(MessageLog.getMessageNoID("STG1300L"));
        this.link2ComputerAlertLog.addActionListener(this);
        GuiUtil.setAccessible(this.link2ComputerAlertLog, this.link2ComputerAlertLog.getText(), this.link2ComputerAlertLog.getText());
        jPanel3.add(this.link2ComputerAlertLog);
        this.link2FSAlertLog = new JButton(MessageLog.getMessageNoID("STG1301L"));
        this.link2FSAlertLog.addActionListener(this);
        GuiUtil.setAccessible(this.link2FSAlertLog, this.link2FSAlertLog.getText(), this.link2FSAlertLog.getText());
        jPanel3.add(this.link2FSAlertLog);
        jPanel3.setAlignmentX(0.0f);
        configNote.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        jPanel.add(configNote);
    }

    private void prepareTreeNodes() {
        this.computerAlertPath = new ArrayList();
        this.computerAlertPath.add(StormTreeLabel.class);
        this.computerAlertPath.add(MessageLog.getMessageNoID("STG3142L"));
        this.computerAlertPath.add(MessageLog.getMessageNoID("STG1300L"));
        this.fsAlertPath = new ArrayList();
        this.fsAlertPath.add(StormTreeLabel.class);
        this.fsAlertPath.add(MessageLog.getMessageNoID("STG3142L"));
        this.fsAlertPath.add(MessageLog.getMessageNoID("STG1301L"));
        this.comAlertLogPath = new ArrayList();
        this.comAlertLogPath.add(TreeLabel.class);
        this.comAlertLogPath.add(MessageLog.getMessageNoID("STG3142L"));
        this.comAlertLogPath.add(MessageLog.getMessageNoID("STG1303L"));
        this.comAlertLogPath.add(MessageLog.getMessageNoID("STG5001L"));
        this.fsAlertLogPath = new ArrayList();
        this.fsAlertLogPath.add(TreeLabel.class);
        this.fsAlertLogPath.add(MessageLog.getMessageNoID("STG3142L"));
        this.fsAlertLogPath.add(MessageLog.getMessageNoID("STG1303L"));
        this.fsAlertLogPath.add(MessageLog.getMessageNoID("STG5003L"));
    }

    public String getSectionTitle() {
        return MessageLog.getMessageNoID("STG3142L");
    }

    public void refresh(boolean bl) {
        if (!this.capabilities.isDataAdmin()) {
            this.link2ComputerAlert.setEnabled(false);
            this.link2FSAlert.setEnabled(false);
        } else {
            this.link2ComputerAlert.setEnabled(true);
            this.link2FSAlert.setEnabled(true);
        }
        if (!this.capabilities.isDataOp()) {
            this.link2ComputerAlertLog.setEnabled(false);
            this.link2FSAlertLog.setEnabled(false);
        } else {
            this.link2ComputerAlertLog.setEnabled(true);
            this.link2FSAlertLog.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList arrayList;
        if (actionEvent.getSource() == this.link2ComputerAlert || actionEvent.getSource() == this.link2FSAlert) {
            arrayList = null;
            if (actionEvent.getSource() == this.link2ComputerAlert) {
                arrayList = new ArrayList(this.computerAlertPath);
            } else if (actionEvent.getSource() == this.link2FSAlert) {
                arrayList = new ArrayList(this.fsAlertPath);
            }
            EditableObjectLabel editableObjectLabel = (EditableObjectLabel)new ConfigUtil().getNode(arrayList);
            editableObjectLabel.actionPerformed(new ActionEvent(actionEvent.getSource(), 1001, "N"));
            guiMain.getBaseTree().makeVisible(new TreePath(editableObjectLabel.getPath()));
            guiMain.getBaseTree().getSelectionModel().setSelectionPath(new TreePath(editableObjectLabel.getPath()));
        }
        if (actionEvent.getSource() == this.link2ComputerAlertLog || actionEvent.getSource() == this.link2FSAlertLog) {
            arrayList = null;
            if (actionEvent.getSource() == this.link2ComputerAlertLog) {
                arrayList = new ArrayList(this.comAlertLogPath);
            } else if (actionEvent.getSource() == this.link2FSAlertLog) {
                arrayList = new ArrayList(this.fsAlertLogPath);
            }
            new ConfigUtil().selectNode(arrayList);
        }
    }
}

