/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class FsPercentSummary
extends PanelClasses {
    private DashTotalsRow[] fsArray;
    private JPanel panel;
    private JPanel titlePanel;
    private JPanel fsPanel;
    private GridBagConstraints gbcIndent;
    private GridBagConstraints gbcPlop;
    private GridBagConstraints gbcLast;
    private Insets insetA;
    private Insets insetB;
    private Insets insetC;

    public FsPercentSummary(DashTotalsRow dashTotalsRow) {
        super(dashTotalsRow);
        int n = 0;
        DashTotalsRow dashTotalsRow2 = dashTotalsRow;
        while (dashTotalsRow2 != null) {
            if (dashTotalsRow2.dtrStatisticType == 4) {
                ++n;
            }
            dashTotalsRow2 = dashTotalsRow2.dtrNext;
        }
        if (n > 0) {
            this.fsArray = new DashTotalsRow[n];
            n = 0;
            dashTotalsRow2 = dashTotalsRow;
            while (dashTotalsRow2 != null) {
                if (dashTotalsRow2.dtrStatisticType == 4) {
                    this.fsArray[n] = dashTotalsRow2;
                    ++n;
                }
                dashTotalsRow2 = dashTotalsRow2.dtrNext;
            }
            Arrays.sort(this.fsArray, new FsComparator());
        }
    }

    public Component getComponent(Object object, boolean bl) {
        this.gbcIndent = new GridBagConstraints();
        this.gbcPlop = new GridBagConstraints();
        this.gbcLast = new GridBagConstraints();
        this.insetA = new Insets(1, 0, 2, 5);
        this.insetB = new Insets(1, 0, 2, 2);
        this.insetC = new Insets(1, 0, 2, 0);
        this.gbcIndent.anchor = 17;
        this.gbcIndent.insets = this.insetA;
        this.gbcPlop.anchor = 17;
        this.gbcPlop.insets = this.insetB;
        this.gbcLast.gridwidth = 0;
        this.gbcLast.insets = this.insetC;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.fsPanel = GuiUtil.getPanel();
        this.titlePanel.add(this.getLabel("STG5246L"));
        if (this.fsArray == null) {
            this.fsPanel.add(this.getLabel("STG5247L"));
        } else {
            BoldLabel boldLabel = this.getLabel("STG5248L");
            JLabel jLabel = this.getLabel("STG5249L");
            JLabel jLabel2 = this.getLabel("STG1162L");
            this.addLine(boldLabel, jLabel, jLabel2);
            int n = 0;
            while (n < this.fsArray.length) {
                boldLabel = this.getFs(this.fsArray[n].dtrFilesystemName);
                jLabel = this.getPercent(this.fsArray[n].dtrFreeSpace);
                jLabel2 = this.getSize(this.fsArray[n].dtrFilesystemCapacity);
                this.addLine(boldLabel, jLabel, jLabel2);
                ++n;
            }
        }
        GuiUtil.completePanel(this.fsPanel);
        this.panel.add((Component)this.titlePanel, "North");
        this.panel.add((Component)this.fsPanel, "Center");
        return this.panel;
    }

    private BoldLabel getLabel(String string) {
        return new BoldLabel(MessageLog.getMessageNoID(string));
    }

    private BoldLabel getFs(String string) {
        return new BoldLabel(string);
    }

    private JLabel getPercent(long l) {
        return new JLabel(String.valueOf(Long.toString(l)) + "% ");
    }

    private JLabel getSize(long l) {
        return new JLabel(Util.formatBytes(l * 512L));
    }

    private void addLine(JLabel jLabel, JLabel jLabel2, JLabel jLabel3) {
        this.fsPanel.add((Component)jLabel2, this.gbcIndent);
        this.fsPanel.add((Component)jLabel3, this.gbcPlop);
        this.fsPanel.add((Component)jLabel, this.gbcPlop);
        this.fsPanel.add((Component)new JLabel(" "), this.gbcLast);
    }

    private class FsComparator
    implements Comparator {
        private FsComparator() {
        }

        public int compare(Object object, Object object2) {
            DashTotalsRow dashTotalsRow = (DashTotalsRow)object;
            DashTotalsRow dashTotalsRow2 = (DashTotalsRow)object2;
            if (dashTotalsRow2.dtrFreeSpace < dashTotalsRow.dtrFreeSpace) {
                return 1;
            }
            if (dashTotalsRow2.dtrFreeSpace > dashTotalsRow.dtrFreeSpace) {
                return -1;
            }
            return 0;
        }
    }
}

