/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneControlTabbedPane;
import org.eclipse.aperi.gui.tables.MegaTable;

public class FabricTablePanel
extends JPanel
implements ActionListener {
    private MegaTable fabricTable = new MegaTable();
    protected JButton displayButton = new JButton(FabricGuiUtil.getString("FabricZone_DisplayZones"));
    private FabricTableModel fabricModel;
    private FabricData[] fabricTableData;
    private ZoneControlTabbedPane zcTabPane = null;
    private JPanel tablePanel;
    private static final int FABRIC_COL = 0;
    private static final int FABRIC_WWN_COL = 1;
    private static final int FABRIC_STATE_COL = 2;
    private static final int FABRIC_ACTIVE_COL = 3;
    private static final String[] FABRIC_COL_NAMES = new String[]{FabricGuiUtil.getString("FabricZone_FabricColumn"), FabricGuiUtil.getString("FabricZone_PhysicalFabricColumn2"), FabricGuiUtil.getString("FabricZone_State_Column"), FabricGuiUtil.getString("FabricZone_ActiveColumn")};

    public FabricTablePanel(HashMap[] hashMapArray, ZoneControlTabbedPane zoneControlTabbedPane) {
        this.zcTabPane = zoneControlTabbedPane;
        this.populateFabricData(hashMapArray);
        this.setLayout(new BorderLayout());
        GuiUtil.setAccessible(this.displayButton, FabricGuiUtil.getString("FabricZone_DisplayZones"), FabricGuiUtil.getString("FabricZone_DisplayZones"));
        this.displayButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_DisplayZones_M")));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.displayButton);
        this.add((Component)jPanel, "North");
        this.displayButton.addActionListener(this);
        this.tablePanel = this.createFabricTable();
        this.add((Component)this.tablePanel, "Center");
    }

    private void populateFabricData(HashMap[] hashMapArray) {
        if (hashMapArray != null && hashMapArray.length > 0) {
            this.fabricTableData = new FabricData[hashMapArray.length];
            int n = 0;
            while (n < hashMapArray.length) {
                HashMap hashMap = hashMapArray[n];
                this.fabricTableData[n] = new FabricData((String)hashMap.get("WWN"), (String)hashMap.get("Label"), (Integer)hashMap.get("State"), (Integer)hashMap.get("Active"));
                ++n;
            }
        }
    }

    private JPanel createFabricTable() {
        JPanel jPanel = GuiUtil.getPanel();
        jPanel.setBorder(new TitledBorder(Util.getString("Fabric_TabTitle")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.initializeZoneTable();
        jPanel.add((Component)this.fabricTable, gridBagConstraints);
        return jPanel;
    }

    private void initializeZoneTable() {
        this.fabricTable.setSelectionPolicy(0);
        this.fabricModel = new FabricTableModel();
        this.fabricTable.setCellRenderer(JLabel.class, new LabelIconRenderer());
        this.fabricTable.setBaseTableModel(this.fabricModel);
        this.fabricTable.sortByColumn(0, 1);
    }

    public void refreshTable(HashMap[] hashMapArray) {
        this.populateFabricData(hashMapArray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        boolean bl = this.fabricModel.refreshTableData();
        if (!bl) {
            this.fabricModel.tableDataReset();
            this.tablePanel.removeAll();
            this.tablePanel.add((Component)this.fabricTable, gridBagConstraints);
        } else {
            this.tablePanel.removeAll();
            this.tablePanel.add((Component)ReportingDDI.getNoDataMessage(null), gridBagConstraints);
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.displayButton) {
            FabricData[] fabricDataArray = this.getSelectedFabrics();
            if (fabricDataArray != null && fabricDataArray.length > 0) {
                int n = 0;
                while (n < fabricDataArray.length) {
                    if (fabricDataArray[n] != null) {
                        this.zcTabPane.addZoneConfigTab(fabricDataArray[n].getWWN(), fabricDataArray[n].getLabel());
                    }
                    ++n;
                }
            } else {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZone_SanNotSelected"));
            }
        }
    }

    private FabricData[] getSelectedFabrics() {
        int[] nArray = this.fabricTable.getSelectedRows();
        FabricData[] fabricDataArray = new FabricData[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < this.fabricTableData.length) {
                fabricDataArray[n] = this.fabricTableData[nArray[n]];
            }
            ++n;
        }
        return fabricDataArray;
    }

    private class FabricTableModel
    extends BaseTableModel {
        FabricTableModel() {
            this.populateTable();
            this.tableDataReset();
        }

        public int getNumRows() {
            return this.rowCount;
        }

        public boolean populateTable() {
            boolean bl = false;
            this.columnNames = FABRIC_COL_NAMES;
            if (FabricTablePanel.this.fabricTableData == null || FabricTablePanel.this.fabricTableData.length == 0) {
                bl = true;
                return bl;
            }
            return bl;
        }

        public void tableDataReset() {
            this.rowCount = FabricTablePanel.this.fabricTableData != null ? FabricTablePanel.this.fabricTableData.length : 0;
            this.fireTableDataChanged();
        }

        public boolean refreshTableData() {
            return this.populateTable();
        }

        public Object getTableDataItem(int n, int n2) {
            try {
                switch (n2) {
                    case 0: {
                        return FabricTablePanel.this.fabricTableData[n].getLabel();
                    }
                    case 1: {
                        return FabricTablePanel.this.fabricTableData[n].getWWN();
                    }
                    case 2: {
                        JLabel jLabel = FabricGuiUtil.getDetectableStateLabel(FabricTablePanel.this.fabricTableData[n].getState());
                        return jLabel;
                    }
                    case 3: {
                        return FabricTablePanel.this.fabricTableData[n].getActive();
                    }
                }
                return Util.getString("FabricStatusUnknown");
            }
            catch (Exception exception) {
                return "";
            }
        }

        public void addRow() {
            ++this.rowCount;
            this.fireTableDataChanged();
            FabricTablePanel.this.fabricTable.sortByColumn(0, -1);
        }

        public void deleteRow() {
            --this.rowCount;
            this.fireTableDataChanged();
            FabricTablePanel.this.fabricTable.sortByColumn(0, -1);
        }
    }

    private class FabricData {
        String label = "";
        String wwn = "";
        String active = "";
        int state = 0;

        public FabricData(String string, String string2, Integer n, Integer n2) {
            this.label = string2;
            this.wwn = string;
            this.active = this.getActive(n2);
            this.state = n;
        }

        private String getActive(Integer n) {
            if (n != null) {
                switch (n) {
                    case 0: {
                        return FabricGuiUtil.getString("FabricZoneSetPage_InactiveZoneSet");
                    }
                }
                return FabricGuiUtil.getString("FabricZoneSetPage_ActiveZoneSet");
            }
            return "";
        }

        private JLabel getState(Integer n) {
            if (n != null) {
                return FabricGuiUtil.getDetectableStateLabel(n);
            }
            return new JLabel();
        }

        public String getLabel() {
            return this.label;
        }

        public String getWWN() {
            return this.wwn;
        }

        public String getActive() {
            return this.active;
        }

        public int getState() {
            return this.state;
        }
    }

    private static class LabelIconRenderer
    extends DefaultTableCellRenderer {
        private LabelIconRenderer() {
        }

        public void setValue(Object object) {
            String string = ((JLabel)object).getText();
            this.setText(string);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)object).getIcon();
            this.setIcon(icon);
        }
    }
}

