/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.Component;
import java.util.HashMap;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.FabricTablePanel;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.gui.fabric.zone.ZoneConfigurationPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneControlTabbedPane;
import org.eclipse.aperi.gui.fabric.zone.ZoneDefinitionPanel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class ZoneDDI
extends DataDisplayInfo
implements GuiRequestor {
    protected int zoneTab;
    protected int runNumber;
    ZoneControlTabbedPane mainPanel = new ZoneControlTabbedPane(this);
    private boolean firstTab = true;

    public ZoneDDI() {
        this.panel = this.mainPanel;
    }

    public void displayFirstTab() {
        this.getSANs();
    }

    private void getSANs() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request.userName = GuiUtil.getUserName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.GET_SANS, GuiZoneConstants.GET_SANS);
        request.requestData = hashMap;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    public void reDisplay() {
        if (this.mainPanel == null) {
            this.mainPanel = new ZoneControlTabbedPane(this);
        }
        this.panel = this.mainPanel;
        this.getSANs();
        this.refresh();
    }

    public void refresh() {
        this.show();
    }

    public void closeTab(int n) {
        this.mainPanel.closeTab(n);
    }

    public void panelToBeNulled() {
        if (this.runNumber > 0) {
            this.remove();
        }
    }

    public String getHelpID() {
        Component component = this.mainPanel.getSelectedComponent();
        if (component instanceof ZoneConfigurationPanel) {
            return FabricGuiUtil.FHELP_ZC_ZONING;
        }
        if (component instanceof ZoneDefinitionPanel) {
            return FabricGuiUtil.FHELP_ZC_DEFINITION;
        }
        if (component instanceof FabricTablePanel) {
            return FabricGuiUtil.FHELP_ZC_FABRICS;
        }
        return "welcome_gettingstarted";
    }

    public void handleResponse(short s, Response response) {
        HashMap hashMap;
        if (s <= 4 && (hashMap = (HashMap)response.responseData) != null && hashMap.containsKey(GuiZoneConstants.GET_SANS)) {
            HashMap[] hashMapArray = (HashMap[])hashMap.get(GuiZoneConstants.GET_SANS);
            if (this.firstTab) {
                this.mainPanel.addFirstTab(hashMapArray);
            } else {
                this.mainPanel.refreshSanTab(hashMapArray);
            }
            this.firstTab = false;
            this.refresh();
        }
    }

    public void goingAway() {
        this.mainPanel.closeAllDefinitionTabs();
    }
}

