/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneSetSelectorPanel
implements ActionListener {
    ZoneCNS zoneCNS;
    Zone zone;
    ZoneSet[] origZS;
    DefaultListModel srcModel = new DefaultListModel();
    DefaultListModel selModel = new DefaultListModel();
    JList selList;
    TUpDownListSelector listSelector;

    public ZoneSetSelectorPanel(ZoneCNS zoneCNS, Zone zone, ZoneSet[] zoneSetArray) {
        this.zoneCNS = zoneCNS;
        this.zone = zone;
        this.origZS = zoneSetArray;
    }

    public JPanel createPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selList = this.createCurrentZoneSetList();
        this.listSelector = new TUpDownListSelector(this.createAvailableZoneSetList(), this.selList, FabricGuiUtil.getString("FabricZone_PotentialZoneSets"), FabricGuiUtil.getString("FabricZone_CurrentZonesets"), false);
        this.populateModels();
        jPanel.add((Component)this.listSelector, "Center");
        return jPanel;
    }

    private void populateModels() {
        int n;
        ZoneSet[] zoneSetArray = this.zoneCNS.getZoneSets();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.origZS != null) {
            n = 0;
            while (n < this.origZS.length) {
                this.selModel.addElement(this.origZS[n].getName());
                hashMap.put(this.origZS[n].getName(), this.origZS[n].getName());
                ++n;
            }
        }
        n = 0;
        while (n < zoneSetArray.length) {
            if (!hashMap.containsKey(zoneSetArray[n].getName())) {
                this.srcModel.addElement(zoneSetArray[n].getName());
            }
            ++n;
        }
    }

    public ArrayList getSelectList() {
        return this.listSelector.getSelList();
    }

    private JList createAvailableZoneSetList() {
        return new JList(this.srcModel);
    }

    private JList createCurrentZoneSetList() {
        return new JList(this.selModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

