/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneSetWizard;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneSetTablePanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    protected ZoneCNS zoneCNS = null;
    private MegaTable zsTable = new MegaTable();
    private JPanel tablePanel;
    private ZoneSetTableModel zsModel;
    private ZoneSet[] zsTableData;
    private boolean dblClick = false;
    private JButton addZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSetPanel_add"));
    private JButton delZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSet_Delete"));
    private JButton dupZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSet_Duplicate"));
    private JButton editZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSet_Edit"));
    private JButton actZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSetPage_ActivateButton"));
    private JButton deactZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSetPage_DeactivateButton"));
    private static final ImageIcon ERROR_ICON = GuiUtil.createImageIcon("images/exclam.gif", Util.getString("DESC_ZONE_SETTING_ERROR"));
    private static final int ZONESET_COL = 0;
    private static final int ZONESET_ACTIVE_COL = 1;
    private static final int ZONESET_DESCRIPTION_COL = 2;
    private static final String[] ZONESET_COL_NAMES = new String[]{FabricGuiUtil.getString("FabricZone_ZS_Column"), FabricGuiUtil.getString("FabricZoneSetPage_ActiveZoneSet"), FabricGuiUtil.getString("FabricZone_Description_Column")};
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ZoneSetTablePanel(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        this.setBorder(new TitledBorder(Util.getString("FabricZoneSetPage_PageTitle")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createButtonPanel(), "North");
        this.tablePanel = this.createZSTable();
        jPanel.add((Component)this.tablePanel, "Center");
        this.add((Component)jPanel, gridBagConstraints);
        this.addZSButton.addActionListener(this);
        this.editZSButton.addActionListener(this);
        this.dupZSButton.addActionListener(this);
        this.delZSButton.addActionListener(this);
        this.actZSButton.addActionListener(this);
        this.deactZSButton.addActionListener(this);
        this.refreshTable(this.zoneCNS);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        GuiUtil.setAccessible(this.addZSButton, FabricGuiUtil.getString("FabricZoneSetPanel_add"), FabricGuiUtil.getString("FabricZoneSetPanel_add"));
        this.addZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSetPanel_add_M")));
        jPanel.add(this.addZSButton);
        GuiUtil.setAccessible(this.delZSButton, FabricGuiUtil.getString("FabricZoneSet_Delete"), FabricGuiUtil.getString("FabricZoneSet_Delete"));
        this.delZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSet_Delete_M")));
        jPanel.add(this.delZSButton);
        GuiUtil.setAccessible(this.editZSButton, FabricGuiUtil.getString("FabricZoneSet_Edit"), FabricGuiUtil.getString("FabricZoneSet_Edit"));
        this.editZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSet_Edit_M")));
        jPanel.add(this.editZSButton);
        GuiUtil.setAccessible(this.dupZSButton, FabricGuiUtil.getString("FabricZoneSet_Duplicate"), FabricGuiUtil.getString("FabricZoneSet_Duplicate"));
        this.dupZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSet_Duplicate_M")));
        jPanel.add(this.dupZSButton);
        GuiUtil.setAccessible(this.deactZSButton, FabricGuiUtil.getString("FabricZoneSetPage_DeactivateButton"), FabricGuiUtil.getString("FabricZoneSetPage_DeactivateButton"));
        this.deactZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSetPage_Deactivate_M")));
        jPanel.add(this.deactZSButton);
        GuiUtil.setAccessible(this.actZSButton, FabricGuiUtil.getString("FabricZoneSetPage_ActivateButton"), FabricGuiUtil.getString("FabricZoneSetPage_ActivateButton"));
        this.actZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSetPage_Activate_M")));
        jPanel.add(this.actZSButton);
        return jPanel;
    }

    private JPanel createZSTable() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.initializeZSTable();
        jPanel2.add(this.zsTable);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel2;
    }

    public void refreshTable(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        boolean bl = this.zsModel.refreshTableData();
        this.zsModel.tableDataReset();
        this.tablePanel.removeAll();
        if (!bl) {
            this.tablePanel.add(this.zsTable);
        } else {
            this.tablePanel.add(ReportingDDI.getNoDataMessage(null));
        }
        this.zsTable.sortByColumn(0, -1);
    }

    private void initializeZSTable() {
        this.zsTable.setSelectionPolicy(0);
        this.zsTable.setMouseListener(this);
        this.zsModel = new ZoneSetTableModel();
        this.zsTable.setCellRenderer(String.class, new IconTableCellRenderer());
        this.zsTable.setBaseTableModel(this.zsModel);
        this.zsTable.sortByColumn(0, -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ZoneSet[] zoneSetArray;
        Object object = actionEvent.getSource();
        if (object == this.addZSButton) {
            int n = this.zoneCNS.getZoneCapabilities().getMaxZoneSets();
            int n2 = this.zsTable.getNumRows();
            if (n != -1 && n <= n2) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MaxZoneSets"));
            } else {
                ZoneSetWizard zoneSetWizard = new ZoneSetWizard(this.zoneCNS);
                JDialog jDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneSetConfigTitle"), true);
                jDialog.getContentPane().add(zoneSetWizard);
                jDialog.pack();
                GuiUtil.centerDialog(jDialog);
                jDialog.show();
            }
        } else if (object == this.delZSButton) {
            int n = JOptionPane.showConfirmDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_DeleteZoneSetWarning"), FabricGuiUtil.getString("FabricZoneSetPage_DeleteZoneSetTitle"), 0);
            if (n == 0) {
                ZoneSet[] zoneSetArray2 = this.getSelectedZoneSets();
                this.zoneCNS.deleteZoneSets(zoneSetArray2);
                int n3 = 0;
                while (n3 < zoneSetArray2.length) {
                    Vector vector;
                    this.zoneCNS.removeZoneSetConfigError(zoneSetArray2[n3].getName());
                    if (!this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones() && (vector = this.zoneCNS.checkForOrphanZones()) != null && vector.size() > 0) {
                        int n4 = 0;
                        while (n4 < vector.size()) {
                            this.zoneCNS.addZoneConfigError(((Zone)vector.get(n4)).getName());
                            ++n4;
                        }
                    }
                    ++n3;
                }
                this.zoneCNS.refreshDefinitionPanel();
            }
        } else if (object == this.dupZSButton) {
            if (this.zoneCNS.getZoneCapabilities().getMaxZoneSets() >= this.zsTable.getNumRows()) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MaxZoneSets"));
            } else {
                ZoneSet[] zoneSetArray3 = this.getSelectedZoneSets();
                if (zoneSetArray3 != null && zoneSetArray3.length > 0) {
                    ZoneSet zoneSet = zoneSetArray3[0];
                    ZoneSetWizard zoneSetWizard = new ZoneSetWizard(zoneSet, this.zoneCNS, true, false);
                    JDialog jDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneSetConfigTitle"), true);
                    jDialog.getContentPane().add(zoneSetWizard);
                    jDialog.pack();
                    GuiUtil.centerDialog(jDialog);
                    jDialog.show();
                }
            }
        } else if (object == this.editZSButton && (zoneSetArray = this.getSelectedZoneSets()) != null && zoneSetArray.length > 0) {
            ZoneSet zoneSet = zoneSetArray[0];
            ZoneSetWizard zoneSetWizard = new ZoneSetWizard(zoneSet, this.zoneCNS, false, true);
            JDialog jDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneSetConfigTitle"), true);
            jDialog.getContentPane().add(zoneSetWizard);
            jDialog.pack();
            GuiUtil.centerDialog(jDialog);
            jDialog.show();
        }
        if (object == this.actZSButton) {
            ZoneSet[] zoneSetArray4 = this.getSelectedZoneSets();
            if (zoneSetArray4.length > 1) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MultipleZoneSetsActivated"), FabricGuiUtil.getString("FabricZoneSetPage_ZoneSetActivationErrorTitle"), 0);
                return;
            }
            if (zoneSetArray4 != null && zoneSetArray4.length > 0) {
                this.zoneCNS.activateZoneSet(zoneSetArray4[0]);
                this.zoneCNS.refreshDefinitionPanel();
            }
        } else if (object == this.deactZSButton) {
            ZoneSet[] zoneSetArray5 = this.getSelectedZoneSets();
            if (zoneSetArray5.length > 1) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MultipleZoneSetsDeactivated"), FabricGuiUtil.getString("FabricZoneSetPage_ZoneSetActivationErrorTitle"), 0);
                return;
            }
            if (zoneSetArray5 != null && zoneSetArray5.length > 0) {
                this.zoneCNS.deactivateZoneSet(zoneSetArray5[0]);
                this.zoneCNS.refreshDefinitionPanel();
            }
        }
    }

    private ZoneSet[] getSelectedZoneSets() {
        int[] nArray = this.zsTable.getSelectedRows();
        ZoneSet[] zoneSetArray = new ZoneSet[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            zoneSetArray[n] = this.zsTableData[nArray[n]];
            ++n;
        }
        return zoneSetArray;
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void selectionChanged(boolean bl) {
    }

    public void doubleClick(int n, int n2) {
    }

    public void showDefaultChart(int n) {
    }

    private class ZoneSetTableModel
    extends BaseTableModel {
        ZoneSetTableModel() {
            this.populateTable();
            this.tableDataReset();
        }

        public int getNumRows() {
            return this.rowCount;
        }

        public boolean populateTable() {
            boolean bl = false;
            this.columnNames = ZONESET_COL_NAMES;
            ZoneSetTablePanel.this.zsTableData = ZoneSetTablePanel.this.zoneCNS.getZoneDefinition(false).getZoneSets();
            if (ZoneSetTablePanel.this.zsTableData == null || ZoneSetTablePanel.this.zsTableData.length == 0) {
                bl = true;
                return bl;
            }
            return bl;
        }

        public void tableDataReset() {
            this.rowCount = ZoneSetTablePanel.this.zsTableData.length;
            this.fireTableDataChanged();
        }

        public boolean refreshTableData() {
            return this.populateTable();
        }

        public Object getTableDataItem(int n, int n2) {
            try {
                switch (n2) {
                    case 0: {
                        return ZoneSetTablePanel.this.zsTableData[n].getName();
                    }
                    case 2: {
                        return ZoneSetTablePanel.this.zsTableData[n].getDescription();
                    }
                    case 1: {
                        return this.zsActiveState(ZoneSetTablePanel.this.zsTableData[n]);
                    }
                }
                return FabricGuiUtil.getString("FabricAgent_Unknown");
            }
            catch (Exception exception) {
                return "";
            }
        }

        private String zsActiveState(ZoneSet zoneSet) {
            String string = FabricGuiUtil.getString("FabricZoneSetPage_InactiveZoneSet");
            ZoneSet zoneSet2 = ZoneSetTablePanel.this.zoneCNS.getOriginalActivatedZoneSet();
            if (ZoneSetTablePanel.this.zoneCNS.isZoneSetActive(zoneSet)) {
                string = zoneSet2 == null ? FabricGuiUtil.getString("FabricZoneSetPage_ActivatedPending") : (zoneSet2.getName().equals(zoneSet.getName()) ? FabricGuiUtil.getString("FabricZoneSetPage_ActiveZoneSet") : FabricGuiUtil.getString("FabricZoneSetPage_ActivatedPending"));
            } else if (zoneSet2 != null && zoneSet2.getName().equals(zoneSet.getName())) {
                string = FabricGuiUtil.getString("FabricZoneSetPage_DeactivatePending");
            }
            return string;
        }

        public void addRow() {
            ++this.rowCount;
            this.fireTableDataChanged();
            ZoneSetTablePanel.this.zsTable.sortByColumn(0, -1);
        }

        public void deleteRow() {
            --this.rowCount;
            this.fireTableDataChanged();
            ZoneSetTablePanel.this.zsTable.sortByColumn(0, -1);
        }
    }

    class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            this.setHorizontalAlignment(2);
            this.setVerticalTextPosition(1);
            String string = (String)object;
            if (string != null && this.hasIcon(string)) {
                this.setIcon(ERROR_ICON);
            } else {
                this.setIcon(null);
            }
            this.setText(string);
        }

        protected boolean hasIcon(String string) {
            boolean bl = ZoneSetTablePanel.this.zoneCNS.hasZoneSetError(string);
            return bl;
        }
    }
}

