/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneWizard;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneTablePanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    protected ZoneCNS zoneCNS = null;
    private MegaTable zoneTable = new MegaTable();
    private ZoneTableModel zoneModel;
    private Zone[] zoneTableData;
    private JPanel tablePanel;
    private JLabel zoneLabel = new JLabel(FabricGuiUtil.getString("FabricZonePage_PageTitle"));
    private boolean dblClick = false;
    private JButton addZoneButton = new JButton(FabricGuiUtil.getString("FabricZonePanel_add"));
    private JButton delZoneButton = new JButton(FabricGuiUtil.getString("FabricZone_Delete"));
    private JButton dupZoneButton = new JButton(FabricGuiUtil.getString("FabricZone_Duplicate"));
    private JButton editZoneButton = new JButton(FabricGuiUtil.getString("FabricZone_Edit"));
    private static final ImageIcon ERROR_ICON = GuiUtil.createImageIcon("images/exclam.gif", Util.getString("DESC_ZONE_ERROR"));
    private static final int ZONE_COL = 0;
    private static final int ZONE_DESCRIPTION_COL = 1;
    private static final String[] ZONE_COL_NAMES = new String[]{FabricGuiUtil.getString("FabricZone_Column"), FabricGuiUtil.getString("FabricZone_Description_Column")};
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ZoneTablePanel(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        this.setBorder(new TitledBorder(Util.getString("FabricZonePage_PageTitle")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createButtonPanel(), "North");
        this.tablePanel = this.createZoneTable();
        jPanel.add((Component)this.tablePanel, "Center");
        this.add((Component)jPanel, gridBagConstraints);
        this.addZoneButton.addActionListener(this);
        this.editZoneButton.addActionListener(this);
        this.dupZoneButton.addActionListener(this);
        this.delZoneButton.addActionListener(this);
        this.refreshTable(this.zoneCNS);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        GuiUtil.setAccessible(this.addZoneButton, FabricGuiUtil.getString("FabricZonePanel_add"), FabricGuiUtil.getString("FabricZonePanel_add"));
        this.addZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZonePanel_add_M")));
        jPanel.add(this.addZoneButton);
        GuiUtil.setAccessible(this.delZoneButton, FabricGuiUtil.getString("FabricZone_Delete"), FabricGuiUtil.getString("FabricZone_Delete"));
        this.delZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Delete_M")));
        jPanel.add(this.delZoneButton);
        GuiUtil.setAccessible(this.editZoneButton, FabricGuiUtil.getString("FabricZone_Edit"), FabricGuiUtil.getString("FabricZone_Edit"));
        this.editZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Edit_M")));
        jPanel.add(this.editZoneButton);
        GuiUtil.setAccessible(this.dupZoneButton, FabricGuiUtil.getString("FabricZone_Duplicate"), FabricGuiUtil.getString("FabricZone_Duplicate"));
        this.dupZoneButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Duplicate_M")));
        jPanel.add(this.dupZoneButton);
        return jPanel;
    }

    private JPanel createZoneTable() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.initializeZoneTable();
        jPanel2.add(this.zoneTable);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel2;
    }

    public void refreshTable(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        boolean bl = this.zoneModel.refreshTableData();
        this.zoneModel.tableDataReset();
        this.tablePanel.removeAll();
        if (!bl) {
            this.tablePanel.add(this.zoneTable);
        } else {
            this.tablePanel.add(ReportingDDI.getNoDataMessage(null));
        }
        this.zoneTable.sortByColumn(0, -1);
    }

    private void initializeZoneTable() {
        this.zoneTable.setSelectionPolicy(0);
        this.zoneTable.setMouseListener(this);
        this.zoneModel = new ZoneTableModel();
        this.zoneTable.setCellRenderer(String.class, new IconTableCellRenderer());
        this.zoneTable.setBaseTableModel(this.zoneModel);
        this.zoneTable.sortByColumn(0, -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Zone[] zoneArray;
        Object object = actionEvent.getSource();
        if (object == this.addZoneButton) {
            if (this.zoneCNS.getZoneCapabilities().getMaxZones() == this.zoneTable.getNumRows()) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZonePage_MaxZones"));
            } else {
                ZoneWizard zoneWizard = new ZoneWizard(this.zoneCNS);
                JDialog jDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneConfigTitle"), true);
                jDialog.getContentPane().add(zoneWizard);
                jDialog.pack();
                GuiUtil.centerDialog(jDialog);
                jDialog.show();
            }
        } else if (object == this.delZoneButton) {
            int n = JOptionPane.showConfirmDialog(this, FabricGuiUtil.getString("FabricZonePage_DeleteZoneWarning"), FabricGuiUtil.getString("FabricZonePage_DeleteZoneTitle"), 0);
            if (n == 0) {
                Zone[] zoneArray2 = this.getSelectedZones();
                this.zoneCNS.deleteZones(zoneArray2);
                int n2 = 0;
                while (n2 < zoneArray2.length) {
                    this.zoneCNS.removeZoneConfigError(zoneArray2[n2].getName());
                    ++n2;
                }
                ZoneSet[] zoneSetArray = this.zoneCNS.deleteZones(zoneArray2);
                if (zoneSetArray.length != 0) {
                    int n3 = 0;
                    while (n3 < zoneSetArray.length) {
                        this.zoneCNS.addZoneSet(zoneSetArray[n3]);
                        this.zoneCNS.addZoneSetConfigError(zoneSetArray[n3].getName());
                        ++n3;
                    }
                }
                this.zoneCNS.refreshDefinitionPanel();
            }
        } else if (object == this.dupZoneButton) {
            Zone[] zoneArray3 = this.getSelectedZones();
            if (zoneArray3 != null && zoneArray3.length > 0) {
                Zone zone = zoneArray3[0];
                ZoneWizard zoneWizard = new ZoneWizard(zone, this.zoneCNS, true, false);
                JDialog jDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneConfigTitle"), true);
                jDialog.getContentPane().add(zoneWizard);
                jDialog.pack();
                GuiUtil.centerDialog(jDialog);
                jDialog.show();
            }
        } else if (object == this.editZoneButton && (zoneArray = this.getSelectedZones()) != null && zoneArray.length > 0) {
            Zone zone = zoneArray[0];
            ZoneWizard zoneWizard = new ZoneWizard(zone, this.zoneCNS, false, true);
            JDialog jDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneConfigTitle"), true);
            jDialog.getContentPane().add(zoneWizard);
            jDialog.pack();
            GuiUtil.centerDialog(jDialog);
            jDialog.show();
        }
    }

    private Zone[] getSelectedZones() {
        int[] nArray = this.zoneTable.getSelectedRows();
        Zone[] zoneArray = new Zone[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            zoneArray[n] = this.zoneTableData[nArray[n]];
            ++n;
        }
        return zoneArray;
    }

    private JPanel getPane(JComponent jComponent, JLabel jLabel) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jComponent);
        jScrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void selectionChanged(boolean bl) {
    }

    public void doubleClick(int n, int n2) {
    }

    public void showDefaultChart(int n) {
    }

    private class ZoneTableModel
    extends BaseTableModel {
        ZoneTableModel() {
            this.populateTable();
            this.tableDataReset();
        }

        public int getNumRows() {
            return this.rowCount;
        }

        public boolean populateTable() {
            boolean bl = false;
            this.columnNames = ZONE_COL_NAMES;
            ZoneTablePanel.this.zoneTableData = ZoneTablePanel.this.zoneCNS.getZoneDefinition(false).getZones();
            if (ZoneTablePanel.this.zoneTableData == null || ZoneTablePanel.this.zoneTableData.length == 0) {
                bl = true;
                return bl;
            }
            return bl;
        }

        public void tableDataReset() {
            this.rowCount = ZoneTablePanel.this.zoneTableData.length;
            this.fireTableDataChanged();
        }

        public boolean refreshTableData() {
            return this.populateTable();
        }

        public Object getTableDataItem(int n, int n2) {
            try {
                switch (n2) {
                    case 0: {
                        return ZoneTablePanel.this.zoneTableData[n].getName();
                    }
                    case 1: {
                        return ZoneTablePanel.this.zoneTableData[n].getDescription();
                    }
                }
                return FabricGuiUtil.getString("FabricAgent_Unknown");
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void addRow() {
            ++this.rowCount;
            this.fireTableDataChanged();
            ZoneTablePanel.this.zoneTable.sortByColumn(0, -1);
        }

        public void deleteRow() {
            --this.rowCount;
            this.fireTableDataChanged();
            ZoneTablePanel.this.zoneTable.sortByColumn(0, -1);
        }
    }

    class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            this.setHorizontalAlignment(2);
            this.setVerticalTextPosition(1);
            String string = (String)object;
            if (string != null && this.hasIcon(string)) {
                this.setIcon(ERROR_ICON);
            } else {
                this.setIcon(null);
            }
            this.setText(string);
        }

        protected boolean hasIcon(String string) {
            return ZoneTablePanel.this.zoneCNS.hasZoneError(string);
        }
    }
}

