/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;

public class ZoneUIAccessor {
    private static ZoneUIAccessor zoneAccessor = null;

    public static ZoneUIAccessor getInstance() {
        if (zoneAccessor == null) {
            zoneAccessor = new ZoneUIAccessor();
        }
        return zoneAccessor;
    }

    public static void sendGuiRequest(GuiRequestor guiRequestor, String string, HashMap hashMap) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = string;
        request.requestData = hashMap;
        request.flags = (byte)2;
        GuiClient.doRequest(guiRequestor, request);
    }

    public static void sendJobRequest(GuiRequestor guiRequestor, String string, short s, HashMap hashMap) {
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.SchedulerSvp", string, s);
        deviceRequest.requestData = hashMap;
        GuiClient.doRequest(guiRequestor, deviceRequest);
    }

    public static void sendDeviceRequest(GuiRequestor guiRequestor, String string, short s, HashMap hashMap) {
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", string, s);
        deviceRequest.requestData = hashMap;
        GuiClient.doRequest(guiRequestor, deviceRequest);
    }

    public void getActiveZoneDefinition(GuiRequestor guiRequestor, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, string);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void populateActiveZoneDefinition(GuiRequestor guiRequestor, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, string);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void populateFabricZoneDefinition(GuiRequestor guiRequestor, String string, int n, Token token) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(GuiZoneConstants.POPULATE_FABRICZONEDEF, string);
        hashMap.put(GuiZoneConstants.FLAG, new Integer(n));
        hashMap.put(GuiZoneConstants.RESERVE_BY_USER, GuiMain.getUserName());
        hashMap.put(GuiZoneConstants.TOKEN, token);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void reserveToken(GuiRequestor guiRequestor, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.RESERVE_TOKEN, string);
        hashMap.put(GuiZoneConstants.RESERVE_BY_USER, GuiMain.getUserName());
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void refreshToken(GuiRequestor guiRequestor, Token token) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(GuiZoneConstants.TOKEN, token);
        hashMap.put("refreshtoken", "refreshtoken");
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void unlock(GuiRequestor guiRequestor, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GuiZoneConstants.UNLOCK_FABRIC, string);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void releaseToken(GuiRequestor guiRequestor, String string, Token token) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(GuiZoneConstants.RELEASE_TOKEN, string);
        hashMap.put(GuiZoneConstants.TOKEN, token);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void rollbackToken(GuiRequestor guiRequestor, String string, Token token) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(GuiZoneConstants.ROLLBACK_TOKEN, string);
        hashMap.put(GuiZoneConstants.TOKEN, token);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void saveDescriptions(GuiRequestor guiRequestor, ZoneDefinition zoneDefinition, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS, zoneDefinition);
        hashMap.put(GuiZoneConstants.SAN_WWN, string);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void ping(GuiRequestor guiRequestor, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("pingZoneAgent", string);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }

    public void saveZoneDefinition(GuiRequestor guiRequestor, String string, int n, ZoneDefinition zoneDefinition, Token token) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(GuiZoneConstants.SAVE_ZONEDEF, string);
        hashMap.put(GuiZoneConstants.FLAG, new Integer(n));
        hashMap.put(GuiZoneConstants.ZONE_DEFINITION, zoneDefinition);
        hashMap.put(GuiZoneConstants.TOKEN, token);
        hashMap.put(GuiZoneConstants.RESERVE_BY_USER, GuiMain.getUserName());
        ZoneUIAccessor.sendJobRequest(guiRequestor, "org.eclipse.aperi.server.handler.scheduler.ZoneDeviceHandler", DeviceRequest.DR_FABRIC, hashMap);
    }

    public void originalSaveZoneDefinition(GuiRequestor guiRequestor, String string, int n, ZoneDefinition zoneDefinition) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(GuiZoneConstants.SAVE_ZONEDEF, string);
        hashMap.put(GuiZoneConstants.FLAG, new Integer(n));
        hashMap.put(GuiZoneConstants.ZONE_DEFINITION, zoneDefinition);
        ZoneUIAccessor.sendGuiRequest(guiRequestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", hashMap);
    }
}

