/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;

public class MegaTable
extends JPanel
implements MouseListener {
    public static final Icon DOWN_ARROW = new IconFactory.DownArrowIcon();
    public static final Icon UP_ARROW = new IconFactory.UpArrowIcon();
    public static final Icon NO_ARROW = new IconFactory.BlankArrowIcon();
    private AbstractTableModel baseTableModel = null;
    private TableModelListener tableModelListener = null;
    private int frozenRows = 0;
    private Color frozenRowBackground = Color.YELLOW;
    private int frozenColumns = 0;
    public static final int SORT_DESCENDING = -1;
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    private int selectPolicy = 2;
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    private static SortingDirective EMPTY_DIRECTIVE = new SortingDirective(-1, 0);
    private ArrayList currentSortingDirectives = new ArrayList();
    private ArrayList tableHeaders = new ArrayList(2);
    private HashMap cellRenderers = new HashMap();
    private HashMap hiddenColumns = new HashMap();
    public AskForRowIconInterface iconChanger = new AskForRowIconInterface(){

        public boolean changeIcon(int n) {
            return false;
        }
    };
    public Icon alternateRowIcon;
    private static final TableCellRenderer DUMMY_RENDERER = new DefaultTableCellRenderer.UIResource();
    private Map columnComparators = new HashMap();
    private Row[] viewToModelMap = null;
    private AbstractTableModel upperLeftModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.frozenRows;
        }

        public String getColumnName(int n) {
            return MegaTable.this.getBaseTableModel().getColumnName(n);
        }

        public Object getValueAt(int n, int n2) {
            return MegaTable.this.getBaseTableModel().getValueAt(n, n2);
        }

        public Class getColumnClass(int n) {
            return MegaTable.this.getBaseTableModel().getColumnClass(n);
        }
    };
    private AbstractTableModel upperRightModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.getBaseTableModel().getColumnCount() - MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.frozenRows;
        }

        public String getColumnName(int n) {
            return MegaTable.this.getBaseTableModel().getColumnName(n + MegaTable.this.frozenColumns);
        }

        public Object getValueAt(int n, int n2) {
            return MegaTable.this.getBaseTableModel().getValueAt(n, n2 + MegaTable.this.frozenColumns);
        }

        public Class getColumnClass(int n) {
            return MegaTable.this.getBaseTableModel().getColumnClass(n + MegaTable.this.frozenColumns);
        }
    };
    private AbstractTableModel lowerLeftModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.getBaseTableModel().getRowCount() - MegaTable.this.frozenRows;
        }

        public String getColumnName(int n) {
            return MegaTable.this.getBaseTableModel().getColumnName(n);
        }

        public Object getValueAt(int n, int n2) {
            return MegaTable.this.getBaseTableModel().getValueAt(MegaTable.this.getModelIndex(n + MegaTable.this.frozenRows), n2);
        }

        public Class getColumnClass(int n) {
            return MegaTable.this.getBaseTableModel().getColumnClass(n);
        }
    };
    private AbstractTableModel lowerRightModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.getBaseTableModel().getColumnCount() - MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.getBaseTableModel().getRowCount() - MegaTable.this.frozenRows;
        }

        public String getColumnName(int n) {
            return MegaTable.this.getBaseTableModel().getColumnName(n + MegaTable.this.frozenColumns);
        }

        public Object getValueAt(int n, int n2) {
            return MegaTable.this.getBaseTableModel().getValueAt(MegaTable.this.getModelIndex(n + MegaTable.this.frozenRows), n2 + MegaTable.this.frozenColumns);
        }

        public Class getColumnClass(int n) {
            return MegaTable.this.getBaseTableModel().getColumnClass(n + MegaTable.this.frozenColumns);
        }
    };
    private JScrollPane upperLeftScroll;
    private JScrollPane upperRightScroll;
    private JScrollPane lowerLeftScroll;
    private JScrollPane lowerRightScroll;
    private JTable upperLeftTable;
    private JTable upperRightTable;
    private JTable lowerLeftTable;
    private JTable lowerRightTable;
    private TJCTableMouseInterface mouseListener = new TJCTableMouseAdapter();
    protected Icon chartIcon;
    protected Icon rowIcon = NO_ARROW;
    protected int rowIconType = 0;
    private static final int NO_ROW_ICON = 0;
    private static final int CHART_ICON = 1;
    private static final int DETAIL_ICON = 2;
    private static final int BOTH_ICONS = 3;
    public static final int NO_CHART_ICON = 10;
    public static final int PIE_CHART = 11;
    public static final int BAR_CHART = 12;
    public static final int LINE_CHART = 13;
    private int visibleColumns = Integer.MAX_VALUE;
    private int visibleRows = Integer.MAX_VALUE;
    public int keyboardModifiers;

    public void setColumnComparator(Class clazz, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    protected Comparator getComparator(int n) {
        Class<?> clazz = this.getBaseTableModel().getColumnClass(n);
        Comparator comparator = (Comparator)this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    public MegaTable() {
        this.tableModelListener = new TableModelHandler();
    }

    public MegaTable(AbstractTableModel abstractTableModel, int n, int n2) {
        this.setFrozenRows(n);
        this.setFrozenColumns(n2);
        this.setBaseTableModel(abstractTableModel);
    }

    private void buildTables() {
        this.unBuildTables();
        if (this.getBaseTableModel() != null) {
            this.constructTableViews();
            this.prepareTableHeaders();
            this.layoutTablePanel();
        }
    }

    private void unBuildTables() {
        this.upperLeftScroll = null;
        this.upperRightScroll = null;
        this.lowerLeftScroll = null;
        this.lowerRightScroll = null;
        this.upperLeftTable = null;
        this.upperRightTable = null;
        this.lowerLeftTable = null;
        this.lowerRightTable = null;
        this.removeModelListener(this.upperLeftModel);
        this.removeModelListener(this.upperRightModel);
        this.removeModelListener(this.lowerLeftModel);
        this.removeModelListener(this.lowerRightModel);
        this.viewToModelMap = null;
        this.removeAll();
        this.setLayout(null);
    }

    private void removeModelListener(AbstractTableModel abstractTableModel) {
        if (abstractTableModel == null) {
            return;
        }
        TableModelListener[] tableModelListenerArray = abstractTableModel.getTableModelListeners();
        if (tableModelListenerArray == null || tableModelListenerArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < tableModelListenerArray.length) {
            abstractTableModel.removeTableModelListener(tableModelListenerArray[n]);
            ++n;
        }
    }

    private void initializeTable(JTable jTable) {
        this.applyCellRenderers(jTable);
        jTable.addMouseListener(this);
        jTable.setAutoResizeMode(0);
        jTable.setSelectionMode(this.getSelectPolicy());
        jTable.setColumnSelectionAllowed(false);
        jTable.setRowHeight(21);
    }

    private FrozenTable buildFrozenRowTable(AbstractTableModel abstractTableModel) {
        FrozenTable frozenTable = new FrozenTable(abstractTableModel, true);
        this.initializeTable(frozenTable);
        return frozenTable;
    }

    private JTable buildBasicTable(AbstractTableModel abstractTableModel) {
        FrozenTable frozenTable = new FrozenTable(abstractTableModel, false);
        this.initializeTable(frozenTable);
        return frozenTable;
    }

    private void applyCellRenderers(JTable jTable) {
        for (Object k : this.cellRenderers.keySet()) {
            jTable.setDefaultRenderer((Class)k, (TableCellRenderer)this.cellRenderers.get(k));
        }
    }

    private void constructTableViews() {
        if (this.getFrozenRows() > 0) {
            if (this.getFrozenColumns() > 0) {
                this.buildUpperLeftTable();
            }
            this.buildUpperRightTable();
        }
        if (this.getFrozenColumns() > 0) {
            this.buildLowerLeftTable();
        }
        this.buildLowerRightTable();
        this.linkTableScrolling2LowerRightTable();
        this.hideColumns();
    }

    private void linkTableScrolling2LowerRightTable() {
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2;
        if (this.getFrozenRows() > 0) {
            jScrollBar2 = this.upperRightScroll.getHorizontalScrollBar();
            jScrollBar = this.lowerRightScroll.getHorizontalScrollBar();
            jScrollBar.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    jScrollBar2.setValue(adjustmentEvent.getValue());
                }
            });
        }
        if (this.getFrozenColumns() > 0) {
            jScrollBar2 = this.lowerLeftScroll.getVerticalScrollBar();
            jScrollBar = this.lowerRightScroll.getVerticalScrollBar();
            jScrollBar.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    jScrollBar2.setValue(adjustmentEvent.getValue());
                }
            });
        }
    }

    private void buildLowerRightTable() {
        this.lowerRightTable = this.buildBasicTable(this.lowerRightModel);
        this.lowerRightScroll = this.getFrozenRows() > 0 ? new JScrollPane(this.lowerRightTable){

            public void setColumnHeaderView(Component component) {
            }
        } : new JScrollPane(this.lowerRightTable);
        this.lowerRightTable.setRowSelectionAllowed(true);
        if (this.lowerLeftTable != null) {
            this.lowerRightTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                        MegaTable.this.lowerLeftTable.clearSelection();
                    } else {
                        MegaTable.this.lowerLeftTable.setRowSelectionInterval(((ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex(), ((ListSelectionModel)listSelectionEvent.getSource()).getMaxSelectionIndex());
                    }
                    MegaTable.this.mouseListener.selectionChanged(true);
                }
            });
        } else {
            this.lowerRightTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    MegaTable.this.mouseListener.selectionChanged(true);
                }
            });
        }
    }

    private void buildLowerLeftTable() {
        this.lowerLeftTable = this.buildBasicTable(this.lowerLeftModel);
        this.lowerLeftScroll = this.getFrozenRows() > 0 ? new JScrollPane(this.lowerLeftTable){

            public void setColumnHeaderView(Component component) {
            }
        } : new JScrollPane(this.lowerLeftTable);
        this.lowerLeftScroll.setVerticalScrollBarPolicy(21);
        this.lowerLeftScroll.setHorizontalScrollBarPolicy(32);
        JScrollBar jScrollBar = this.lowerLeftScroll.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = new JScrollBar(){

            public void paint(Graphics graphics) {
            }
        };
        jScrollBar2.setPreferredSize(jScrollBar.getPreferredSize());
        this.lowerLeftScroll.setHorizontalScrollBar(jScrollBar2);
        this.lowerLeftTable.setRowSelectionAllowed(true);
        this.lowerLeftTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                    MegaTable.this.lowerRightTable.clearSelection();
                } else {
                    MegaTable.this.lowerRightTable.setRowSelectionInterval(((ListSelectionModel)listSelectionEvent.getSource()).getMinSelectionIndex(), ((ListSelectionModel)listSelectionEvent.getSource()).getMaxSelectionIndex());
                }
            }
        });
    }

    private void buildUpperRightTable() {
        this.upperRightTable = this.buildFrozenRowTable(this.upperRightModel);
        this.upperRightScroll = new JScrollPane(this.upperRightTable);
        this.upperRightScroll.setHorizontalScrollBarPolicy(31);
        this.upperRightScroll.setVerticalScrollBarPolicy(22);
        JScrollBar jScrollBar = this.upperRightScroll.getVerticalScrollBar();
        JScrollBar jScrollBar2 = new JScrollBar(){

            public void paint(Graphics graphics) {
            }
        };
        jScrollBar2.setPreferredSize(jScrollBar.getPreferredSize());
        this.upperRightScroll.setVerticalScrollBar(jScrollBar2);
        this.upperRightTable.setCellSelectionEnabled(false);
    }

    private void buildUpperLeftTable() {
        this.upperLeftTable = this.buildFrozenRowTable(this.upperLeftModel);
        this.upperLeftScroll = new JScrollPane(this.upperLeftTable);
        this.upperLeftScroll.setHorizontalScrollBarPolicy(31);
        this.upperLeftScroll.setVerticalScrollBarPolicy(21);
        this.upperLeftTable.setCellSelectionEnabled(false);
    }

    private int[] getColumnSizes(JTable jTable) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TableModel tableModel = jTable.getModel();
        Class<?> clazz = null;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        int n4 = jTable.getColumnCount();
        int[] nArray = new int[n4];
        Arrays.fill(nArray, 0);
        int n5 = jTable.getRowCount() > 150 ? 150 : jTable.getRowCount();
        int n6 = 0;
        while (n6 < n4) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n6);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n6);
            n = component.getPreferredSize().width;
            int n7 = jTable.convertColumnIndexToModel(n6);
            n2 = 0;
            clazz = null;
            int n8 = 0;
            while (n8 < n5) {
                Object object = tableModel.getValueAt(n8, n7);
                if (clazz == null) {
                    clazz = jTable.getModel().getColumnClass(n7);
                }
                if (clazz != null && object != null) {
                    component = jTable.getDefaultRenderer(clazz).getTableCellRendererComponent(jTable, object, false, false, n8, n7);
                    n3 = component.getPreferredSize().width;
                    n2 = Math.max(n2, n3);
                }
                ++n8;
            }
            nArray[n6] = Math.max(n, n2) + 5;
            ++n6;
        }
        return nArray;
    }

    private void adjustColumnSizes(JTable jTable, JTable jTable2) {
        if (jTable == null && jTable2 == null) {
            return;
        }
        int[] nArray = jTable == null ? (int[])null : this.getColumnSizes(jTable);
        int[] nArray2 = jTable2 == null ? (int[])null : this.getColumnSizes(jTable2);
        if (nArray == null) {
            nArray = new int[nArray2.length];
            Arrays.fill(nArray, 0);
        } else if (nArray2 == null) {
            nArray2 = new int[nArray.length];
            Arrays.fill(nArray2, 0);
        }
        int n = 0;
        while (n < nArray.length) {
            TableColumn tableColumn;
            if (jTable2 != null && (tableColumn = jTable2.getColumnModel().getColumn(n)) != null) {
                tableColumn.setPreferredWidth(Math.max(nArray[n], nArray2[n]));
                tableColumn.setResizable(false);
            }
            if (jTable != null && (tableColumn = jTable.getColumnModel().getColumn(n)) != null) {
                tableColumn.setPreferredWidth(Math.max(nArray[n], nArray2[n]));
                tableColumn.setResizable(false);
            }
            ++n;
        }
    }

    private int mediumColumnWidth(JTable jTable) {
        if (jTable != null) {
            double d = 0.0;
            int n = jTable.getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                d += (double)jTable.getColumnModel().getColumn(n2).getPreferredWidth();
                ++n2;
            }
            return (int)Math.round(d / (double)n);
        }
        return 0;
    }

    private void adjustColumnSize(JTable jTable) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Class<?> clazz = null;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        int n4 = jTable.getColumnCount();
        int n5 = jTable.getRowCount() > 150 ? 150 : jTable.getRowCount();
        int n6 = 0;
        while (n6 < n4) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n6);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n6);
            n = component.getPreferredSize().width;
            int n7 = jTable.convertColumnIndexToModel(n6);
            n2 = 0;
            clazz = null;
            int n8 = 0;
            while (n8 < n5) {
                Object object = jTable.getModel().getValueAt(n8, n7);
                if (clazz == null) {
                    clazz = jTable.getModel().getColumnClass(n7);
                }
                if (clazz != null && object != null) {
                    component = jTable.getDefaultRenderer(clazz).getTableCellRendererComponent(jTable, object, false, false, n8, n7);
                    n3 = component.getPreferredSize().width;
                    n2 = Math.max(n2, n3);
                }
                ++n8;
            }
            tableColumn.setPreferredWidth(Math.max(n, n2) + 5);
            ++n6;
        }
    }

    private JLabel createBlankLabel(int n) {
        JLabel jLabel = new JLabel(IconFactory.getBlankIcon(n, n));
        jLabel.setBorder(new BevelBorder(0));
        Dimension dimension = new Dimension(n, n);
        jLabel.setMaximumSize(dimension);
        jLabel.setPreferredSize(dimension);
        return jLabel;
    }

    private Component createBlankRowHeader(JTable jTable) {
        if (this.rowIconType == 0) {
            return null;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = 0;
        while (n < jTable.getRowCount()) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(this.createBlankLabel(jTable.getRowHeight(n)));
            if (this.rowIconType == 3) {
                jPanel2.add(this.createBlankLabel(jTable.getRowHeight()));
            }
            jPanel.add(jPanel2);
            ++n;
        }
        return jPanel;
    }

    private JButton createChartButton(int n, int n2) {
        DrillDownButton drillDownButton = new DrillDownButton(this.chartIcon, n);
        drillDownButton.setPreferredSize(new Dimension(n2, n2));
        drillDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrillDownButton drillDownButton = (DrillDownButton)actionEvent.getSource();
                MegaTable.this.setRowSelection(drillDownButton.getViewRow(), drillDownButton.getViewRow());
                MegaTable.this.mouseListener.showDefaultChart(MegaTable.this.getModelIndex(drillDownButton.getViewRow() + MegaTable.this.getFrozenRows()));
            }
        });
        return drillDownButton;
    }

    private JButton createDetailButton(int n, int n2) {
        DrillDownButton drillDownButton = new DrillDownButton(this.rowIcon, n);
        drillDownButton.setPreferredSize(new Dimension(n2, n2));
        drillDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrillDownButton drillDownButton = (DrillDownButton)actionEvent.getSource();
                MegaTable.this.setRowSelection(drillDownButton.getViewRow(), drillDownButton.getViewRow());
                MegaTable.this.mouseListener.doubleClick(MegaTable.this.getModelIndex(drillDownButton.getViewRow() + MegaTable.this.getFrozenRows()), -1);
            }
        });
        return drillDownButton;
    }

    private Component createRowHeader(JTable jTable) {
        if (this.rowIconType == 0) {
            return null;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = 0;
        while (n < jTable.getRowCount()) {
            Icon icon;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            if (this.rowIconType == 1 || this.rowIconType == 3) {
                Icon icon2 = icon = this.iconChanger.changeIcon(this.getDataRow(n + this.frozenRows)) ? this.alternateRowIcon : this.chartIcon;
                if (icon == null || icon instanceof IconFactory.BlankIcon) {
                    jPanel2.add(this.createBlankLabel(jTable.getRowHeight(n)));
                } else {
                    jPanel2.add(this.createChartButton(n, jTable.getRowHeight(n)));
                }
            }
            if (this.rowIconType == 2 || this.rowIconType == 3) {
                if (this.rowIconType == 2) {
                    Icon icon3 = icon = this.iconChanger.changeIcon(this.getDataRow(n + this.frozenRows)) ? this.alternateRowIcon : this.rowIcon;
                    if (icon == null || icon instanceof IconFactory.BlankIcon) {
                        jPanel2.add(this.createBlankLabel(jTable.getRowHeight(n)));
                    } else {
                        jPanel2.add(this.createDetailButton(n, jTable.getRowHeight(n)));
                    }
                } else {
                    jPanel2.add(this.createDetailButton(n, jTable.getRowHeight(n)));
                }
            }
            jPanel.add(jPanel2);
            ++n;
        }
        return jPanel;
    }

    private void layoutTablePanel() {
        int n;
        Dimension dimension;
        this.setLayout(new TableLayout());
        this.adjustColumnSizes(this.upperLeftTable, this.lowerLeftTable);
        this.adjustColumnSizes(this.upperRightTable, this.lowerRightTable);
        int n2 = 0;
        int n3 = 0;
        if (this.lowerRightTable != null) {
            n2 = this.mediumColumnWidth(this.lowerRightTable);
            n3 = this.lowerRightTable.getRowHeight();
        }
        if (this.getFrozenRows() > 0) {
            if (this.getFrozenColumns() > 0) {
                this.upperLeftScroll.setRowHeaderView(this.createBlankRowHeader(this.upperLeftTable));
                dimension = new Dimension(this.upperLeftTable.getPreferredSize());
                dimension.height += this.upperLeftTable.getTableHeader().getPreferredSize().height;
                if (this.upperLeftScroll.getRowHeader() != null) {
                    dimension.width += this.upperLeftScroll.getRowHeader().getPreferredSize().width;
                }
                this.upperLeftScroll.setPreferredSize(dimension);
                this.upperLeftScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.add(this.upperLeftScroll);
            } else {
                this.add(new NullComponent());
            }
            if (this.getFrozenColumns() == 0) {
                this.upperRightScroll.setRowHeaderView(this.createBlankRowHeader(this.upperRightTable));
            }
            if (this.getVisibleColumns() != Integer.MAX_VALUE && this.lowerRightTable != null) {
                n = (int)Math.min((double)(this.getVisibleColumns() * n2), this.upperRightTable.getPreferredSize().getWidth());
                dimension = new Dimension(n, (int)this.upperRightTable.getPreferredSize().getHeight());
            } else {
                dimension = new Dimension(this.upperRightTable.getPreferredSize());
            }
            dimension.height += this.upperRightTable.getTableHeader().getPreferredSize().height;
            dimension.width += this.upperRightScroll.getVerticalScrollBar().getPreferredSize().width;
            if (this.getFrozenColumns() == 0 && this.upperRightScroll.getRowHeader() != null) {
                dimension.width += this.upperRightScroll.getRowHeader().getPreferredSize().width;
            }
            this.upperRightScroll.setPreferredSize(dimension);
            this.upperRightScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(this.upperRightScroll);
        } else {
            this.add(new NullComponent());
            this.add(new NullComponent());
        }
        if (this.getFrozenColumns() > 0) {
            this.lowerLeftScroll.setRowHeaderView(this.createRowHeader(this.lowerLeftTable));
            if (this.getVisibleRows() != Integer.MAX_VALUE && this.lowerRightTable != null) {
                n = (int)Math.min((double)(this.getVisibleRows() * n3), this.lowerLeftTable.getPreferredSize().getHeight());
                dimension = new Dimension((int)this.lowerLeftTable.getPreferredSize().getWidth(), n);
            } else {
                dimension = new Dimension(this.lowerLeftTable.getPreferredSize());
            }
            dimension.height += this.lowerLeftScroll.getHorizontalScrollBar().getPreferredSize().height;
            if (this.getFrozenRows() == 0) {
                dimension.height += this.lowerLeftTable.getTableHeader().getPreferredSize().height;
            }
            if (this.lowerLeftScroll.getRowHeader() != null) {
                dimension.width += this.lowerLeftScroll.getRowHeader().getPreferredSize().width;
            }
            this.lowerLeftScroll.setPreferredSize(dimension);
            this.lowerLeftScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(this.lowerLeftScroll);
        } else {
            this.add(new NullComponent());
        }
        if (this.getFrozenColumns() == 0) {
            this.lowerRightScroll.setRowHeaderView(this.createRowHeader(this.lowerRightTable));
        }
        n = (int)this.lowerRightTable.getPreferredSize().getHeight();
        int n4 = (int)this.lowerRightTable.getPreferredSize().getWidth();
        if (this.getVisibleRows() != Integer.MAX_VALUE && this.lowerRightTable != null) {
            n = Math.min(this.getVisibleRows() * n3, n);
        }
        if (this.getVisibleColumns() != Integer.MAX_VALUE && this.lowerRightTable != null) {
            n4 = Math.min(this.getVisibleColumns() * n2, n4);
        }
        dimension = new Dimension(n4, n);
        dimension.height += this.lowerRightScroll.getHorizontalScrollBar().getPreferredSize().height;
        if (this.getFrozenRows() == 0) {
            dimension.height += this.lowerRightTable.getTableHeader().getPreferredSize().height;
        }
        dimension.width += this.lowerRightScroll.getVerticalScrollBar().getPreferredSize().width;
        if (this.getFrozenColumns() == 0 && this.lowerRightScroll.getRowHeader() != null) {
            dimension.width += this.lowerRightScroll.getRowHeader().getPreferredSize().width;
        }
        this.lowerRightScroll.setPreferredSize(dimension);
        this.lowerRightScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(this.lowerRightScroll);
    }

    private void prepareTableHeader(JTable jTable, int n) {
        this.tableHeaders.add(jTable.getTableHeader());
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().addMouseListener(new HeaderListener(n));
        jTable.getTableHeader().setDefaultRenderer(new SortableHeaderRenderer(jTable.getTableHeader().getDefaultRenderer(), n));
    }

    private void prepareTableHeaders() {
        if (this.getFrozenRows() > 0) {
            if (this.getFrozenColumns() > 0) {
                this.prepareTableHeader(this.upperLeftTable, 0);
                this.prepareTableHeader(this.upperRightTable, this.getFrozenColumns());
            } else {
                this.prepareTableHeader(this.upperRightTable, 0);
            }
        } else if (this.getFrozenColumns() > 0) {
            this.prepareTableHeader(this.lowerLeftTable, 0);
            this.prepareTableHeader(this.lowerRightTable, this.getFrozenColumns());
        } else {
            this.prepareTableHeader(this.lowerRightTable, 0);
        }
    }

    private Row[] getViewToModelMap() {
        if (this.viewToModelMap == null) {
            int n = this.getBaseTableModel().getRowCount();
            this.viewToModelMap = new Row[n];
            int n2 = 0;
            while (n2 < n) {
                this.viewToModelMap[n2] = new Row(n2);
                ++n2;
            }
            if (this.currentSortingDirectives.size() != 0) {
                Arrays.sort(this.viewToModelMap, this.getFrozenRows(), n);
            }
        }
        return this.viewToModelMap;
    }

    private int getModelIndex(int n) {
        return this.getViewToModelMap()[n].modelIndex;
    }

    private void cancelSorting() {
        this.currentSortingDirectives.clear();
        this.sortDirectionChanged();
    }

    private void sortDirectionChanged() {
        this.viewToModelMap = null;
        this.lowerRightModel.fireTableDataChanged();
        if (this.lowerLeftModel != null) {
            this.lowerLeftModel.fireTableDataChanged();
        }
        Iterator iterator = this.tableHeaders.iterator();
        while (iterator.hasNext()) {
            ((JTableHeader)iterator.next()).repaint();
        }
    }

    private int getSortDirection(int n) {
        return this.getDirective(n).direction;
    }

    private void setSortDirection(int n, int n2) {
        SortingDirective sortingDirective = this.getDirective(n);
        if (sortingDirective != EMPTY_DIRECTIVE) {
            this.currentSortingDirectives.remove(sortingDirective);
        }
        if (n2 != 0) {
            this.currentSortingDirectives.add(new SortingDirective(n, n2));
        }
        this.sortDirectionChanged();
    }

    private SortingDirective getDirective(int n) {
        for (SortingDirective sortingDirective : this.currentSortingDirectives) {
            if (sortingDirective.column != n) continue;
            return sortingDirective;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public void setFrozenColumns(int n) {
        this.frozenColumns = n;
        this.buildTables();
    }

    public int getFrozenRows() {
        return this.frozenRows;
    }

    public void setFrozenRows(int n) {
        this.frozenRows = n;
        this.buildTables();
    }

    private AbstractTableModel getBaseTableModel() {
        return this.baseTableModel;
    }

    public void setBaseTableModel(AbstractTableModel abstractTableModel) {
        if (this.baseTableModel != null) {
            this.baseTableModel.removeTableModelListener(this.tableModelListener);
        }
        this.baseTableModel = abstractTableModel;
        this.buildTables();
        if (this.baseTableModel != null) {
            this.baseTableModel.addTableModelListener(this.tableModelListener);
        }
    }

    public int getDataRow(int n) {
        this.assertTableIsBuilt();
        return this.getModelIndex(n);
    }

    public AbstractTableModel getDataSource() {
        return this.getBaseTableModel();
    }

    public int getNumRows() {
        this.assertTableIsBuilt();
        return this.getBaseTableModel().getRowCount();
    }

    public int[] getSelectedRows() {
        try {
            this.assertTableIsBuilt();
        }
        catch (RuntimeException runtimeException) {
            return new int[0];
        }
        int[] nArray = this.lowerRightTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray2[n] = this.getModelIndex(nArray[n] + this.getFrozenRows());
            ++n;
        }
        return nArray2;
    }

    public void setSelectedRows(int n, int n2) {
        int n3 = this.lowerRightTable.getRowCount();
        if (n3 == 0 || n >= n3 || n2 >= n3) {
            return;
        }
        this.assertTableIsBuilt();
        this.lowerRightTable.setRowSelectionInterval(n, n2);
    }

    public void setSelectedDataRows(int[] nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        this.lowerRightTable.clearSelection();
        if (nArray == null) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0) {
                treeSet.add(new Integer(this.getViewRow(nArray[n])));
            }
            ++n;
        }
        if (!treeSet.isEmpty()) {
            Iterator iterator = treeSet.iterator();
            int n2 = 0;
            int n3 = (Integer)iterator.next();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                if (n4 - (n3 + n2) == 1) {
                    ++n2;
                    continue;
                }
                this.lowerRightTable.addRowSelectionInterval(n3, n3 + n2);
                n3 = n4;
                n2 = 0;
            }
            this.lowerRightTable.addRowSelectionInterval(n3, n3 + n2);
        }
    }

    public void clearSelection() {
        this.lowerRightTable.clearSelection();
    }

    public int getViewRow(int n) {
        this.assertTableIsBuilt();
        if (this.viewToModelMap != null) {
            int n2 = 0;
            while (n2 < this.viewToModelMap.length) {
                if (this.viewToModelMap[n2].modelIndex == n) {
                    return n2;
                }
                ++n2;
            }
        }
        return n;
    }

    public int[] getViewToModelIndices() {
        this.assertTableIsBuilt();
        int[] nArray = null;
        if (this.viewToModelMap != null) {
            nArray = new int[this.viewToModelMap.length];
            int n = 0;
            while (n < this.viewToModelMap.length) {
                nArray[n] = this.viewToModelMap[n].modelIndex;
                ++n;
            }
        }
        return nArray;
    }

    public boolean isRowSelected(int n) {
        this.assertTableIsBuilt();
        return this.lowerRightTable.isCellSelected(n, 0);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.lowerRightTable.getSelectedRow();
        int n2 = this.getModelIndex(n + this.getFrozenRows());
        this.keyboardModifiers = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2) {
            this.mouseListener.doubleClick(n2, -1);
            this.mouseListener.selectionChanged(true);
        } else {
            this.mouseListener.select(n, -1);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = this.lowerRightTable.columnAtPoint(point);
            int n2 = this.lowerRightTable.rowAtPoint(point);
            n2 = this.getModelIndex(n2);
            this.mouseListener.showPopup(n2, n += this.getFrozenColumns(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void nullReferences() {
        this.setBaseTableModel(null);
    }

    public boolean rowsSelected() {
        try {
            this.assertTableIsBuilt();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return this.lowerRightTable.getSelectedRowCount() > 0;
    }

    public void setCellRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        this.cellRenderers.put(clazz, tableCellRenderer);
        this.buildTables();
    }

    private void setColunmHidden(JTable jTable, int n) {
        jTable.getColumnModel().removeColumn(jTable.getColumnModel().getColumn(jTable.convertColumnIndexToView(n)));
    }

    private void hideColumns() {
        Iterator iterator = this.hiddenColumns.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (this.getFrozenColumns() > 0 && n < this.getFrozenColumns()) {
                this.setColunmHidden(this.lowerLeftTable, n);
                if (this.getFrozenRows() <= 0) continue;
                this.setColunmHidden(this.upperLeftTable, n);
                continue;
            }
            this.setColunmHidden(this.lowerRightTable, n -= this.getFrozenColumns());
            if (this.getFrozenRows() <= 0) continue;
            this.setColunmHidden(this.upperRightTable, n);
        }
    }

    public void setColumnHidden(int n, boolean bl) {
        if (bl) {
            this.hiddenColumns.put(new Integer(n), null);
        } else {
            this.hiddenColumns.remove(new Integer(n));
        }
        this.buildTables();
    }

    public void setDataSource(AbstractTableModel abstractTableModel) {
        this.setBaseTableModel(abstractTableModel);
    }

    public void setRowIcon(int n, boolean bl) {
        this.rowIconType = bl ? 2 : 0;
        this.rowIcon = bl ? IconFactory.getDetailIcon() : IconFactory.getBlankIcon(38, 16);
        switch (n) {
            case 10: {
                break;
            }
            case 11: {
                this.chartIcon = IconFactory.getPieChartIcon();
                ++this.rowIconType;
                break;
            }
            case 12: {
                this.chartIcon = IconFactory.getBarChartIcon();
                ++this.rowIconType;
                break;
            }
            case 13: {
                this.chartIcon = IconFactory.getLineChartIcon();
                ++this.rowIconType;
            }
        }
        this.buildTables();
    }

    private void setRowSelection(int n, int n2) {
        this.assertTableIsBuilt();
        if (this.lowerRightTable.getRowCount() != 0) {
            this.lowerRightTable.setRowSelectionInterval(n, n2);
        }
    }

    public void sortByColumn(int n, int n2) {
        this.assertTableIsBuilt();
        this.setSortDirection(n, n2);
    }

    public int YtoRow(int n) {
        this.assertTableIsBuilt();
        Point point = new Point(0, n);
        return this.lowerRightTable.rowAtPoint(point);
    }

    public TJCTableMouseInterface getMouseListener() {
        return this.mouseListener;
    }

    public void setMouseListener(TJCTableMouseInterface tJCTableMouseInterface) {
        this.mouseListener = tJCTableMouseInterface;
    }

    private final void assertTableIsBuilt() {
        if (this.getBaseTableModel() == null) {
            throw new RuntimeException("Operation requires table model to be set first");
        }
    }

    public int getSelectPolicy() {
        return this.selectPolicy;
    }

    private void setSelectPolicy(int n) {
        this.selectPolicy = n;
    }

    public void setSelectionPolicy(int n) {
        this.setSelectPolicy(n);
        if (this.lowerRightTable != null) {
            this.lowerRightTable.setSelectionMode(n);
            if (this.lowerLeftTable != null) {
                this.lowerLeftTable.setSelectionMode(n);
            }
        }
    }

    public Color getFrozenRowBackground() {
        return this.frozenRowBackground;
    }

    private Color getDefaultBackground() {
        return Color.WHITE;
    }

    public void setFrozenRowBackground(Color color) {
        this.frozenRowBackground = color;
    }

    public void setAsFirstColumn(int n) {
        int n2 = n - this.frozenColumns;
        if (n2 <= 0) {
            return;
        }
        if (this.upperRightTable != null) {
            this.upperRightTable.moveColumn(this.upperRightTable.convertColumnIndexToView(n2), 0);
        }
        if (this.lowerRightTable != null) {
            this.lowerRightTable.moveColumn(this.lowerRightTable.convertColumnIndexToView(n2), 0);
        }
    }

    public int getVisibleColumns() {
        return this.visibleColumns;
    }

    public void setVisibleColumns(int n) {
        this.visibleColumns = n;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int n) {
        this.visibleRows = n;
    }

    private static class SortingDirective {
        private int column;
        private int direction;

        public SortingDirective(int n, int n2) {
            this.column = n;
            this.direction = n2;
        }
    }

    private class HeaderListener
    extends MouseAdapter {
        private int columnOffset;

        public HeaderListener(int n) {
            this.columnOffset = n;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = tableColumnModel.getColumn(n).getModelIndex();
            if ((n2 += this.columnOffset) != -1) {
                int n3 = MegaTable.this.getSortDirection(n2);
                if (!mouseEvent.isControlDown()) {
                    MegaTable.this.cancelSorting();
                }
                n3 += mouseEvent.isShiftDown() ? -1 : 1;
                n3 = (n3 + 4) % 3 - 1;
                MegaTable.this.setSortDirection(n2, n3);
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;
        private int columnOffset;
        private TableHeaderUI headerUI;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer, int n) {
            this.tableCellRenderer = tableCellRenderer;
            this.columnOffset = n;
        }

        private void checkAndFix(JTable jTable) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (this.headerUI == null || this.headerUI != jTableHeader.getUI()) {
                TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
                jTableHeader.setDefaultRenderer(DUMMY_RENDERER);
                jTableHeader.updateUI();
                this.headerUI = jTableHeader.getUI();
                this.tableCellRenderer = jTableHeader.getDefaultRenderer();
                if (this.tableCellRenderer == null || this.tableCellRenderer == tableCellRenderer || this.tableCellRenderer == DUMMY_RENDERER) {
                    this.tableCellRenderer = new JTableHeader().getDefaultRenderer();
                }
                jTableHeader.setDefaultRenderer(tableCellRenderer);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.checkAndFix(jTable);
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                jLabel.setHorizontalAlignment(2);
                jLabel.setFont(jTable.getFont().deriveFont(1));
                switch (MegaTable.this.getDirective(jTable.convertColumnIndexToModel(n2) + this.columnOffset).direction) {
                    case -1: {
                        jLabel.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_DESCENDING"));
                        jLabel.setIcon(DOWN_ARROW);
                        break;
                    }
                    case 1: {
                        jLabel.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_ASCENDING"));
                        jLabel.setIcon(UP_ARROW);
                        break;
                    }
                    default: {
                        jLabel.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_NONE"));
                        jLabel.setIcon(NO_ARROW);
                    }
                }
            }
            return component;
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            int n = this.modelIndex;
            int n2 = ((Row)object).modelIndex;
            for (SortingDirective sortingDirective : MegaTable.this.currentSortingDirectives) {
                int n3 = sortingDirective.column;
                Object object2 = MegaTable.this.getBaseTableModel().getValueAt(n, n3);
                Object object3 = MegaTable.this.getBaseTableModel().getValueAt(n2, n3);
                int n4 = 0;
                n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : MegaTable.this.getComparator(n3).compare(object2, object3)));
                if (n4 == 0) continue;
                return sortingDirective.direction == -1 ? -n4 : n4;
            }
            return 0;
        }
    }

    private class FrozenTable
    extends JTable {
        private boolean frozen;

        public FrozenTable(AbstractTableModel abstractTableModel, boolean bl) {
            super(abstractTableModel);
            this.frozen = bl;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
            int n3 = this.convertColumnIndexToModel(n2);
            Object object = this.dataModel.getValueAt(n, n3);
            Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, n, n3);
            if (this.frozen) {
                component.setBackground(MegaTable.this.getFrozenRowBackground());
            } else {
                component.setBackground(MegaTable.this.getDefaultBackground());
            }
            return tableCellRenderer;
        }
    }

    private static class NullComponent
    extends JComponent {
        private Dimension zeroDimension = new Dimension(0, 0);

        private NullComponent() {
        }

        public Dimension getMaximumSize() {
            return this.zeroDimension;
        }

        public Dimension getMinimumSize() {
            return this.zeroDimension;
        }

        public Dimension getPreferredSize() {
            return this.zeroDimension;
        }

        public Dimension getSize(Dimension dimension) {
            return this.zeroDimension;
        }

        public void paint(Graphics graphics) {
        }
    }

    private static class TableLayout
    implements LayoutManager {
        private TableLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Component component = container.getComponent(0);
            component.setLocation(0, 0);
            component.setSize(component.getPreferredSize());
            Component component2 = container.getComponent(1);
            component2.setLocation(component.getSize().width, 0);
            component2.setSize(Math.min(dimension.width - component.getSize().width, component2.getPreferredSize().width), Math.max(component2.getPreferredSize().height, component.getSize().height));
            Component component3 = container.getComponent(2);
            component3.setLocation(0, component.getSize().height);
            component3.setSize(Math.max(component.getPreferredSize().width, component3.getPreferredSize().width), Math.min(dimension.height - component.getSize().height, component3.getPreferredSize().height));
            Component component4 = container.getComponent(3);
            component4.setLocation(component3.getSize().width, component2.getSize().height);
            component4.setSize(Math.min(dimension.width - component3.getSize().width, component4.getPreferredSize().width), Math.min(dimension.height - component2.getSize().height, component4.getPreferredSize().height));
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = container.getComponent(0).getMinimumSize();
            Dimension dimension3 = container.getComponent(1).getMinimumSize();
            Dimension dimension4 = container.getComponent(2).getMinimumSize();
            Dimension dimension5 = container.getComponent(3).getMinimumSize();
            dimension.width = Math.max(dimension2.width + dimension3.width, dimension4.width + dimension5.width);
            dimension.height = Math.max(dimension2.height + dimension4.height, dimension3.height + dimension5.height);
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = container.getComponent(0).getPreferredSize();
            Dimension dimension3 = container.getComponent(1).getPreferredSize();
            Dimension dimension4 = container.getComponent(2).getPreferredSize();
            Dimension dimension5 = container.getComponent(3).getPreferredSize();
            dimension.width = Math.max(dimension2.width + dimension3.width, dimension4.width + dimension5.width);
            dimension.height = Math.max(dimension2.height + dimension4.height, dimension3.height + dimension5.height);
            return dimension;
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    private class DrillDownButton
    extends JButton {
        private int row;

        public DrillDownButton(Icon icon, int n) {
            super(icon);
            this.row = n;
            this.setBorder(new BevelBorder(0));
        }

        public int getViewRow() {
            return this.row;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (MegaTable.this.lowerRightTable != null) {
                MegaTable.this.lowerRightTable.clearSelection();
            }
            MegaTable.this.buildTables();
            MegaTable.this.revalidate();
            MegaTable.this.repaint();
        }
    }
}

