/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL0;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL1;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL2;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL0;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL0;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL1;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL2;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.GraphModelStorageL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL2;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL2;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL1;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.ITopoBackend;
import org.eclipse.aperi.gui.topo.widget.ITopoFrontend;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class ControllerApp
implements ITopoFrontend {
    protected ITopoBackend backend;
    protected TopoSetting setting;
    protected JTopoApp topoApp;
    protected PinList pinList;
    protected Hashtable controllerViewsH;

    public ControllerApp() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, constructor");
        }
        TopoResource.init();
        WidgetPool widgetPool = WidgetPool.getInstance();
        this.topoApp = (JTopoApp)widgetPool.getWidget(JTopoApp.class);
        this.pinList = new PinList();
        this.controllerViewsH = new Hashtable();
    }

    public void destruct() {
        Object object;
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, destruct()");
        }
        Enumeration enumeration = this.controllerViewsH.elements();
        while (enumeration.hasMoreElements()) {
            object = (ControllerView)enumeration.nextElement();
            ((ControllerView)object).destruct();
        }
        if (this.topoApp != null) {
            object = WidgetPool.getInstance();
            ((WidgetPool)object).recycleWidget(this.topoApp);
        }
        this.pinList.destruct();
        object = WidgetPool.getInstance();
        ((WidgetPool)object).destruct();
        this.backend = null;
        this.setting = null;
        this.topoApp = null;
        this.pinList = null;
        this.controllerViewsH = null;
    }

    public ITopoBackend getBackend() {
        return this.backend;
    }

    public TopoSetting getTopoSetting() {
        return this.setting;
    }

    public void setSessionModel(ITopoBackend iTopoBackend, TopoSetting topoSetting) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setSessionModel(), backend=" + iTopoBackend + ", setting=" + topoSetting);
        }
        this.backend = iTopoBackend;
        this.setting = topoSetting;
        this.topoApp.setSessionModel(this);
    }

    public JTopoApp getTopoApp() {
        return this.topoApp;
    }

    public PinList getPinList() {
        return this.pinList;
    }

    public ControllerView getFocusedControllerView() {
        return this.topoApp.getFocusedTopoView().getControllerView();
    }

    public Enumeration getControllerViews() {
        return this.controllerViewsH.elements();
    }

    public ControllerView getControllerView(GraphModel.ID iD) {
        return (ControllerView)this.controllerViewsH.get(iD);
    }

    public void addControllerView(GraphModel.ID iD, ControllerView controllerView) {
        this.controllerViewsH.put(iD, controllerView);
    }

    public void removeControllerView(GraphModel.ID iD) {
        this.controllerViewsH.remove(iD);
    }

    public void openView(GraphModel.ID iD) {
        ControllerView controllerView;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, openView(), modelID=" + iD);
        }
        if ((controllerView = this.getControllerView(iD)) == null) {
            if (GraphDebug.isTraceVisible()) {
                GraphDebug.trace("ControllerApp, openView(), a new view is about to be opened");
            }
            controllerView = new ControllerView();
            this.controllerViewsH.put(iD, controllerView);
            controllerView.setSessionModel(this, iD);
        }
        controllerView.focus();
    }

    public void updateView(int n, GraphModel graphModel) {
        if (GraphDebug.isHighlightVisible()) {
            GraphDebug.highlight("ControllerApp, updateView(), data is returned from backend (rtnCode=" + n + ", modelID=" + graphModel.getModelID() + ") ------------");
        }
        if (n == 0) {
            GraphModel.ID iD = graphModel.getModelID();
            if ("PinList".equals(iD.getFocusLevel())) {
                Vector vector = ((GraphModel.MultiEntityID)iD).getChildFocusEntityIDs();
                int n2 = vector.size() - 1;
                while (n2 >= 0) {
                    GraphEntity.ID iD2 = (GraphEntity.ID)vector.elementAt(n2);
                    if (graphModel.get(iD2) == null) {
                        if (GraphDebug.isWarningVisible()) {
                            GraphDebug.warning("ControllerApp, updateView(), the PinList model is inconsistent with its childFocusEntityIDs(), focusEntityID=" + iD2);
                        }
                        vector.remove(n2);
                    }
                    --n2;
                }
                this.pinList.setSessionModel(this, (GraphModelPinList)graphModel);
            } else {
                Object object;
                boolean bl = true;
                if (iD instanceof GraphModel.MultiEntityID) {
                    object = ((GraphModel.MultiEntityID)iD).getChildFocusEntityIDs();
                    int n3 = 0;
                    while (n3 < ((Vector)object).size()) {
                        GraphEntity.ID iD3 = (GraphEntity.ID)((Vector)object).elementAt(n3);
                        if (graphModel.get(iD3) == null) {
                            if (GraphDebug.isWarningVisible()) {
                                GraphDebug.warning("ControllerApp, updateView(), the regular model is inconsistent with its childFocusEntityIDs(), focusEntityID=" + iD3);
                            }
                            bl = false;
                        }
                        ++n3;
                    }
                } else {
                    object = iD.getFocusEntityID();
                    if (object != null && graphModel.get((GraphEntity.ID)object) == null) {
                        if (GraphDebug.isWarningVisible()) {
                            GraphDebug.warning("ControllerApp, updateView(), the regular model is inconsistent with the focusEntityID, focusEntityID=" + object);
                        }
                        bl = false;
                    }
                }
                object = this.getControllerView(iD);
                if (object != null) {
                    SwingUtilities.invokeLater(new UpdateViewThread((ControllerView)object, graphModel, bl));
                } else if (GraphDebug.isErrorVisible()) {
                    GraphDebug.error("ControllerApp, updateView(), controllerView=null, modelID=" + iD);
                }
            }
        } else {
            if (GraphDebug.isWarningVisible()) {
                GraphDebug.warning("ControllerApp, updateView(), backend reported an error, rtnCode=" + n);
            }
            this.showMsg(n, "");
        }
    }

    public Vector getOpenedViews() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, getOpenedViews()");
        }
        Vector<GraphModel.ID> vector = new Vector<GraphModel.ID>(this.controllerViewsH.keySet());
        ControllerView controllerView = this.getFocusedControllerView();
        GraphModel.ID iD = controllerView.getModelID();
        vector.remove(iD);
        vector.add(0, iD);
        vector.add(this.pinList.getModel().getModelID());
        return vector;
    }

    public void showMsg(int n, String string) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, showMsg(), rtnCode=" + n + ", msg=" + string);
        }
        String string2 = String.valueOf(GuiUtil.getString("TOPO_LABEL_DIALOG_SHOWMESSAGE_RTNCODE")) + " " + n + "\r\n" + GuiUtil.getString("TOPO_LABEL_DIALOG_SHOWMESSAGE_MESSAGE") + " " + string;
        JOptionPane.showMessageDialog(this.topoApp.getMainFrame().getContentPane(), string2, GuiUtil.getString("TOPO_LABEL_DIALOG_SHOWMESSAGE_TITLE"), 2);
    }

    public void print() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, print()");
        }
        ControllerView controllerView = this.getFocusedControllerView();
        controllerView.print();
    }

    public void startRefreshView(GraphModel.ID iD) {
        ControllerView controllerView;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, startRefreshView(), modelID=" + iD);
        }
        if ((controllerView = this.getControllerView(iD)) != null) {
            controllerView.startRefreshView();
        } else if (!"PinList".equals(iD.getFocusLevel()) && GraphDebug.isErrorVisible()) {
            GraphDebug.error("ControllerApp, startRefreshView(), invalid modelID=" + iD);
        }
    }

    public void finishRefreshView(GraphModel.ID iD) {
        ControllerView controllerView;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, finishRefreshView, modelID=" + iD);
        }
        if ((controllerView = this.getControllerView(iD)) != null) {
            controllerView.finishRefreshView();
        } else if (!"PinList".equals(iD.getFocusLevel()) && GraphDebug.isErrorVisible()) {
            GraphDebug.error("ControllerApp, finishRefreshView(), invalid modelID=" + iD);
        }
    }

    public void cancelAllRefresh() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, cancelAllRefresh()");
        }
    }

    public void refreshView(GraphModel.ID iD) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, refreshView() (set request to backend), modelID=" + iD);
        }
        this.backend.refreshView(iD);
        this.backend.refreshView(this.pinList.getModel().getModelID());
    }

    public void refreshAllViews() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, refreshAllViews() (set request to backend)");
        }
        this.backend.refreshAllViews();
    }

    public void closeView(GraphModel.ID iD) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, closeView(), modelID=" + iD);
        }
        if ("Overview".equals(iD.getFocusLevel())) {
            return;
        }
        ControllerView controllerView = this.getControllerView(iD);
        if (controllerView != null) {
            this.controllerViewsH.remove(iD);
            controllerView.destruct();
        } else if (GraphDebug.isErrorVisible()) {
            GraphDebug.error("ControllerApp, closeView(), controllerView=null");
        }
    }

    public void closeAllViews() {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, closeAllViews()");
        }
        Vector vector = new Vector(this.controllerViewsH.keySet());
        int n = 0;
        while (n < vector.size()) {
            GraphModel.ID iD = (GraphModel.ID)vector.elementAt(n);
            this.closeView(iD);
            ++n;
        }
    }

    public void launchDetailPanel(GraphEntity.ID iD) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, launchDetailPanel(), nodeID=" + iD);
        }
        this.backend.launchDetailsPanel(iD);
    }

    public void launchElementManager(GraphEntity graphEntity) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, launchElementManager(), node=" + graphEntity);
        }
        this.backend.launchElementManager(graphEntity);
    }

    public void removeMissingEntity(Vector vector) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerApp, removeMissingEntity(), nodeV=" + vector);
        }
        this.backend.removeEntity(vector);
    }

    public void setOverlayHealthEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setOverlayHealthEnabled(), b=" + bl);
        }
        Enumeration enumeration = this.controllerViewsH.elements();
        while (enumeration.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enumeration.nextElement();
            controllerView.setOverlayHealthEnabled(bl);
        }
    }

    public void setOverlayPerfEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setOverlayPerfEnabled(), b=" + bl);
        }
        Enumeration enumeration = this.controllerViewsH.elements();
        while (enumeration.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enumeration.nextElement();
            controllerView.setOverlayPerfEnabled(bl);
        }
    }

    public void setFilteringLevel(int n) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setFilteringLevel(), filteringLevel=" + n);
        }
        Enumeration enumeration = this.controllerViewsH.elements();
        while (enumeration.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enumeration.nextElement();
            controllerView.setFilteringLevel(n);
        }
    }

    public void setShowConnectionEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setShowConnectionEnabled(), b=" + bl);
        }
        Enumeration enumeration = this.controllerViewsH.elements();
        while (enumeration.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enumeration.nextElement();
            controllerView.setShowConnectionEnabled(bl);
        }
    }

    public void setShowZoneEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerApp, setShowZoneEnabled(), b=" + bl);
        }
        Enumeration enumeration = this.controllerViewsH.elements();
        while (enumeration.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enumeration.nextElement();
            controllerView.setShowZoneEnabled(bl);
        }
    }

    public void openView(GraphEntity graphEntity, Vector vector) {
        GraphModel.ID iD = null;
        if (graphEntity instanceof GraphFabricSummary) {
            iD = new GraphModelFabricL0.ID();
        } else if (graphEntity instanceof GraphFabric) {
            iD = new GraphModelFabricL2.ID((GraphFabric)graphEntity);
        } else if (graphEntity instanceof GraphComputerSummary) {
            iD = new GraphModelComputerL0.ID();
        } else if (graphEntity instanceof GraphComputerGroup) {
            iD = new GraphModelComputerL1.ID((GraphComputerGroup)graphEntity, vector);
        } else if (graphEntity instanceof GraphComputer) {
            iD = new GraphModelComputerL2.ID((GraphComputer)graphEntity);
        } else if (graphEntity instanceof GraphSwitchSummary) {
            iD = new GraphModelSwitchL0.ID();
        } else if (graphEntity instanceof GraphSwitchGroup) {
            iD = new GraphModelSwitchL1.ID((GraphSwitchGroup)graphEntity, vector);
        } else if (graphEntity instanceof GraphSwitch) {
            GraphSwitch.ID cfr_ignored_0 = (GraphSwitch.ID)graphEntity.getEntityID();
            iD = new GraphModelSwitchL2.ID((GraphSwitch)graphEntity);
        } else if (graphEntity instanceof GraphStorageSummary) {
            iD = new GraphModelStorageL0.ID();
        } else if (graphEntity instanceof GraphSubsystemGroup) {
            iD = new GraphModelSubsystemL1.ID((GraphSubsystemGroup)graphEntity, vector);
        } else if (graphEntity instanceof GraphSubsystem) {
            GraphSubsystem.ID cfr_ignored_1 = (GraphSubsystem.ID)graphEntity.getEntityID();
            iD = new GraphModelSubsystemL2.ID((GraphSubsystem)graphEntity);
        } else if (graphEntity instanceof GraphTapeLibraryGroup) {
            iD = new GraphModelTapeLibraryL1.ID((GraphTapeLibraryGroup)graphEntity, vector);
        } else if (graphEntity instanceof GraphTapeLibrary) {
            GraphTapeLibrary.ID cfr_ignored_2 = (GraphTapeLibrary.ID)graphEntity.getEntityID();
            iD = new GraphModelTapeLibraryL2.ID((GraphTapeLibrary)graphEntity);
        } else if (graphEntity instanceof GraphOtherSummary) {
            iD = new GraphModelOtherL0.ID();
        } else if (graphEntity instanceof GraphOtherGroup) {
            iD = new GraphModelOtherL1.ID((GraphOtherGroup)graphEntity, vector);
        } else if (graphEntity instanceof GraphOther) {
            GraphOther.ID cfr_ignored_3 = (GraphOther.ID)graphEntity.getEntityID();
            iD = new GraphModelOtherL2.ID((GraphOther)graphEntity);
        }
        if (iD != null) {
            iD.setNeedPerfData(this.setting.isOverlayPerfEnabled());
            iD.setNeedZoneData(this.setting.isShowZoneEnabled);
            this.openView(iD);
        } else {
            System.out.println("ControllerApp, openView(), Invalid jumping, focusEntity=" + graphEntity + ", childFocusEntityIDV=" + vector);
        }
    }

    public void setTopoSetting(TopoSetting topoSetting) {
        this.setting = topoSetting;
    }

    private class UpdateViewThread
    implements Runnable {
        private ControllerView controllerView;
        private GraphModel model;
        private boolean isValid;

        public UpdateViewThread(ControllerView controllerView, GraphModel graphModel, boolean bl) {
            this.controllerView = controllerView;
            this.model = graphModel;
            this.isValid = bl;
        }

        public void run() {
            if (this.isValid) {
                this.controllerView.setDataModel(this.model);
            } else {
                this.controllerView.invalidateView();
            }
        }
    }
}

