/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTabbedPane;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTabular;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JTopoMiniMap;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.JTopoViewGroup;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class ControllerView {
    protected ControllerApp controllerApp;
    protected GraphModel.ID modelID;
    protected GraphModel dataModel;
    protected JTopoView topoView;
    protected HashSet selectionHS;
    protected HashSet highlightHS;
    protected HashSet locateHS;
    protected String locatePattern;

    public ControllerView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, constructor");
        }
        this.selectionHS = new HashSet();
        this.highlightHS = new HashSet();
        this.locateHS = new HashSet();
        WidgetPool widgetPool = WidgetPool.getInstance();
        this.topoView = (JTopoView)widgetPool.getWidget(JTopoView.class);
    }

    public void destruct() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, destruct, modelID=" + this.modelID);
        }
        if (this.topoView != null) {
            Object object;
            if (this.controllerApp != null) {
                object = this.controllerApp.getTopoApp().getTopoViewGroup();
                if (((JTabbedPane)object).getSelectedComponent() == this.topoView) {
                    this.controllerApp.getTopoApp().getMiniMapFrame().getContentPane().removeAll();
                }
                ((JTopoViewGroup)object).removeTopoView(this.topoView);
            }
            object = WidgetPool.getInstance();
            ((WidgetPool)object).recycleWidget(this.topoView);
        }
        this.controllerApp = null;
        this.modelID = null;
        this.topoView = null;
        this.dataModel = null;
        this.selectionHS = null;
        this.highlightHS = null;
        this.locateHS = null;
        this.locatePattern = null;
    }

    public ControllerApp getControllerApp() {
        return this.controllerApp;
    }

    public GraphModel.ID getModelID() {
        return this.modelID;
    }

    public void setSessionModel(ControllerApp controllerApp, GraphModel.ID iD) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setSessionModel(), modelID=" + iD + ", controllerApp=" + controllerApp);
        }
        this.modelID = iD;
        this.controllerApp = controllerApp;
        this.selectionHS.clear();
        this.highlightHS.clear();
        this.locateHS.clear();
        this.locatePattern = null;
        this.topoView.setSessionModel(this);
        JTopoViewGroup jTopoViewGroup = controllerApp.getTopoApp().getTopoViewGroup();
        jTopoViewGroup.addTopoView(this.topoView);
        this.dataModel = new GraphModel(iD);
        this.setDataModel(this.dataModel);
        this.refreshView();
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel graphModel) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setDataModel(), modelID=" + this.modelID);
        }
        this.dataModel = graphModel;
        this.updateView();
    }

    public JTopoView getTopoView() {
        return this.topoView;
    }

    public void focus() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, focus(), modelID=" + this.modelID);
        }
        JTopoViewGroup jTopoViewGroup = this.controllerApp.getTopoApp().getTopoViewGroup();
        jTopoViewGroup.setFocusedTopoView(this.topoView);
    }

    public void updateView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateView(), modelID=" + this.modelID + ", withPerfData=" + this.dataModel.isWithPerfData() + ", withZoneData=" + this.dataModel.isWithZoneData());
        }
        TopoSetting topoSetting = this.controllerApp.getTopoSetting();
        PinList pinList = this.controllerApp.getPinList();
        long l = System.currentTimeMillis();
        this.dataModel.applyCollationKey();
        this.dataModel.applyScope();
        this.dataModel.applyPerfStatus();
        Hashtable hashtable = topoSetting.getSettingPerViewType(this.modelID.getFocusLevel()).getGroupBySet();
        this.dataModel.applyGrouping(hashtable);
        this.dataModel.applyFiltering(topoSetting.getFilteringLevel());
        long l2 = System.currentTimeMillis();
        if (!this.dataModel.isEmpty() && GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerView, updateView(), step 1) all pre-processing steps, cost=" + (l2 - l) + " ms, " + new Date(l2));
        }
        l = System.currentTimeMillis();
        if (GraphDebug.isHighlightVisible()) {
            GraphDebug.highlight("ControllerView, updateView(), --------------- " + this.modelID.getFocusLevel() + " ---------------");
            GraphDebug.highlight(this.dataModel.toString());
        }
        this.topoView.setDataModel(this.dataModel);
        l2 = System.currentTimeMillis();
        if (!this.dataModel.isEmpty() && GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerView, updateView(), step 2) set data model, cost=" + (l2 - l) + " ms, " + new Date(l2));
        }
        l = System.currentTimeMillis();
        this.setShowConnectionEnabled(topoSetting.isShowConnectionEnabled());
        this.setShowZoneEnabled(topoSetting.isShowZoneEnabled());
        this.setPinList(pinList);
        this.setLocate(this.locatePattern);
        l2 = System.currentTimeMillis();
        if (!this.dataModel.isEmpty() && GraphDebug.isInfoVisible()) {
            GraphDebug.info("ControllerView, updateView(), step 3) all post-processing, cost=" + (l2 - l) + " ms, " + new Date(l2));
        }
    }

    public void invalidateView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, invalidateView(), modelID=" + this.modelID);
        }
        this.topoView.setEnabled(false);
    }

    public void print() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, print(), modelID=" + this.modelID);
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.printCanvas();
    }

    public void refreshView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, refreshView(), modelID=" + this.modelID);
        }
        this.controllerApp.refreshView(this.modelID);
    }

    public void startRefreshView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, startRefreshView(), modelID=" + this.modelID);
        }
        this.topoView.setRefreshInProgress(true);
        JTopoViewGroup jTopoViewGroup = this.controllerApp.getTopoApp().getTopoViewGroup();
        jTopoViewGroup.revalidate();
        jTopoViewGroup.repaint();
        try {
            if (GraphDebug.isTraceVisible()) {
                GraphDebug.trace("ControllerView, startRefreshView(), thread sleeps");
            }
            Thread.sleep(250L);
            if (GraphDebug.isTraceVisible()) {
                GraphDebug.trace("ControllerView, startRefreshView(), thread wakes up");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void finishRefreshView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, finishRefreshView(), modelID=" + this.modelID);
        }
        this.topoView.setRefreshInProgress(false);
        JTopoViewGroup jTopoViewGroup = this.controllerApp.getTopoApp().getTopoViewGroup();
        jTopoViewGroup.revalidate();
        jTopoViewGroup.repaint();
    }

    public void cancelAllRefresh() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, cancelAllRefresh(), modelID=" + this.modelID);
        }
    }

    public void setOverlayHealthEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setOverlayHealthEnabled(), b=" + bl + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.setOverlayHealthEnabled(bl);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.setOverlayHealthEnabled(bl);
    }

    public void setOverlayPerfEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setOverlayPerfEnabled(), b=" + bl + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.setOverlayPerfEnabled(bl);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.setOverlayPerfEnabled(bl);
        this.modelID.setNeedPerfData(bl);
        if (bl && !this.dataModel.isWithPerfData()) {
            String string = this.modelID.getFocusLevel();
            boolean bl2 = false;
            if (string.equals("SwitchL2") || string.equals("SubsystemL2")) {
                bl2 = true;
            }
            if (bl2) {
                this.controllerApp.refreshView(this.modelID);
            }
        }
    }

    public void setFilteringLevel(int n) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setFilteringLevel(), filteringLevel=" + n + ", modelID=" + this.modelID);
        }
        this.dataModel.applyFiltering(this.controllerApp.getTopoSetting().getFilteringLevel());
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.setFilteringLevel(n);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.setFilteringLevel(n);
    }

    public void setShowConnectionEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setShowConnectionEnabled(), b=" + bl + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.setShowConnectionEnabled(bl);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.setShowConnectionEnabled(bl);
    }

    public void setShowZoneEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setShowZoneEnabled(), b=" + bl + ", modelID=" + this.modelID);
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.setShowZoneEnabled(bl);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.setShowZoneEnabled(bl);
        this.modelID.setNeedZoneData(bl);
        if (bl && !this.dataModel.isWithZoneData()) {
            String string = this.modelID.getFocusLevel();
            boolean bl2 = true;
            if (string.equals("Overview") || string.equals("FabricL0") || string.equals("ComputerL0") || string.equals("SwitchL0") || string.equals("StorageL0") || string.equals("OtherL0")) {
                bl2 = false;
            }
            if (bl2) {
                this.controllerApp.refreshView(this.modelID);
            }
        }
    }

    public void setPinList(PinList pinList) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setPinList(), modelID=" + this.modelID);
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.setPinList(pinList);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.setPinList(pinList);
    }

    public void setLocate(String string) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, setLocate(), pattern=" + string + ", modelID=" + this.modelID);
        }
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.locate(string);
    }

    protected void canvasLayoutChanged() {
        JTopoMiniMap jTopoMiniMap = this.topoView.getMiniMap();
        jTopoMiniMap.canvasLayoutChanged();
    }

    protected void viewportPositionChanged() {
        JTopoMiniMap jTopoMiniMap = this.topoView.getMiniMap();
        jTopoMiniMap.viewportPositionChanged();
    }

    public HashSet getSelection() {
        return this.selectionHS;
    }

    public void updateSelection(SelectionDelta selectionDelta) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateSelection(), delta=" + selectionDelta + ", modelID=" + this.modelID);
        }
        if (!selectionDelta.isEmpty()) {
            Iterator iterator = selectionDelta.iteratorRemove();
            while (iterator.hasNext()) {
                this.selectionHS.remove(iterator.next());
            }
            iterator = selectionDelta.iteratorAdd();
            while (iterator.hasNext()) {
                this.selectionHS.add(iterator.next());
            }
            AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
            abstractJTopoCanvas.applySelection(selectionDelta);
            AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
            abstractJTopoTabular.applySelection(selectionDelta);
        }
    }

    public HashSet getHighlight() {
        return this.highlightHS;
    }

    public void updateHighlight(HighlightDelta highlightDelta) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateHighlight(), delta=" + highlightDelta + ", modelID=" + this.modelID);
        }
        Iterator iterator = highlightDelta.iteratorRemove();
        while (iterator.hasNext()) {
            this.highlightHS.remove(iterator.next());
        }
        iterator = highlightDelta.iteratorAdd();
        while (iterator.hasNext()) {
            this.highlightHS.add(iterator.next());
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.applyHighlight(highlightDelta);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.applyHighlight(highlightDelta);
    }

    public String getLocatePattern() {
        return this.locatePattern;
    }

    public HashSet getLocate() {
        return this.locateHS;
    }

    public void updateLocate(LocateDelta locateDelta) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("ControllerView, updateLocate(), delta=" + locateDelta + ", modelID=" + this.modelID);
        }
        this.locatePattern = locateDelta.getPattern();
        Iterator iterator = locateDelta.iteratorRemove();
        while (iterator.hasNext()) {
            this.locateHS.remove(iterator.next());
        }
        iterator = locateDelta.iteratorAdd();
        while (iterator.hasNext()) {
            this.locateHS.add(iterator.next());
        }
        AbstractJTopoCanvas abstractJTopoCanvas = this.topoView.getCanvas();
        abstractJTopoCanvas.applyLocate(locateDelta);
        AbstractJTopoTabular abstractJTopoTabular = this.topoView.getTabular();
        abstractJTopoTabular.applyLocate(locateDelta);
    }

    public static class SelectionDelta {
        protected HashSet srcHS = new HashSet();
        protected boolean isAltDown;
        protected boolean isFromCanvas;
        protected GraphEntity.ID clickedEntityID;
        protected Object clickedWidget;
        protected HashSet addHS;
        protected HashSet removeHS;

        public SelectionDelta(HashSet hashSet) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.srcHS.add(iterator.next());
            }
            this.addHS = new HashSet();
            this.removeHS = new HashSet();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SelectionDelta: isAltDown=" + this.isAltDown + ", isFromCanvas=" + this.isFromCanvas + ", clickedEntityID=" + this.clickedEntityID + ", clickedWidget=" + this.clickedWidget);
            stringBuffer.append("\r\n  srcHS=" + this.srcHS);
            stringBuffer.append("\r\n  addHS=" + this.addHS);
            stringBuffer.append("\r\n  removeHS=" + this.removeHS);
            return stringBuffer.toString();
        }

        public boolean isEmpty() {
            return this.addHS.isEmpty() && this.removeHS.isEmpty();
        }

        public boolean isAltDown() {
            return this.isAltDown;
        }

        public void setAltDown(boolean bl) {
            this.isAltDown = bl;
        }

        public boolean isFromCanvas() {
            return this.isFromCanvas;
        }

        public void setFromCanvas(boolean bl) {
            this.isFromCanvas = bl;
        }

        public GraphEntity.ID getClickedEntityID() {
            return this.clickedEntityID;
        }

        public void setClickedEntityID(GraphEntity.ID iD) {
            this.clickedEntityID = iD;
        }

        public Object getClickedWidget() {
            return this.clickedWidget;
        }

        public void setClickedWidget(Object object) {
            this.clickedWidget = object;
        }

        public boolean isInSrc(GraphEntity.ID iD) {
            return this.srcHS.contains(iD);
        }

        public Iterator iteratorSrc() {
            return this.srcHS.iterator();
        }

        public Iterator iteratorAdd() {
            return this.addHS.iterator();
        }

        public Iterator iteratorRemove() {
            return this.removeHS.iterator();
        }

        public void add(GraphEntity.ID iD) {
            if (this.removeHS.contains(iD)) {
                this.removeHS.remove(iD);
            } else if (!this.srcHS.contains(iD)) {
                this.addHS.add(iD);
            }
        }

        public void remove(GraphEntity.ID iD) {
            if (this.addHS.contains(iD)) {
                this.addHS.remove(iD);
            } else if (this.srcHS.contains(iD)) {
                this.removeHS.add(iD);
            }
        }

        public void removeAll() {
            this.addHS.clear();
            Iterator iterator = this.srcHS.iterator();
            while (iterator.hasNext()) {
                this.removeHS.add(iterator.next());
            }
        }
    }

    public static class HighlightDelta {
        protected HashSet srcHS = new HashSet();
        protected GraphEntity.ID clickedEntityID;
        protected HashSet addHS;
        protected HashSet removeHS;

        public HighlightDelta(HashSet hashSet) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.srcHS.add(iterator.next());
            }
            this.addHS = new HashSet();
            this.removeHS = new HashSet();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("HighlightDelta: clickedEntityID=" + this.clickedEntityID);
            stringBuffer.append("\r\n  srcHS=" + this.srcHS);
            stringBuffer.append("\r\n  addHS=" + this.addHS);
            stringBuffer.append("\r\n  removeHS=" + this.removeHS);
            return stringBuffer.toString();
        }

        public GraphEntity.ID getClickedEntityID() {
            return this.clickedEntityID;
        }

        public void setClickedEntityID(GraphEntity.ID iD) {
            this.clickedEntityID = iD;
        }

        public boolean isInSrc(GraphEntity.ID iD) {
            return this.srcHS.contains(iD);
        }

        public Iterator iteratorAdd() {
            return this.addHS.iterator();
        }

        public Iterator iteratorRemove() {
            return this.removeHS.iterator();
        }

        public void add(GraphEntity.ID iD) {
            if (this.removeHS.contains(iD)) {
                this.removeHS.remove(iD);
            } else if (!this.srcHS.contains(iD)) {
                this.addHS.add(iD);
            }
        }

        public void remove(GraphEntity.ID iD) {
            if (this.addHS.contains(iD)) {
                this.addHS.remove(iD);
            } else if (this.srcHS.contains(iD)) {
                this.removeHS.add(iD);
            }
        }

        public void removeAll() {
            Iterator iterator = this.srcHS.iterator();
            while (iterator.hasNext()) {
                this.removeHS.add(iterator.next());
            }
        }
    }

    public static class LocateDelta {
        protected String pattern;
        protected HashSet srcHS;
        protected GraphEntity.ID clickedEntityID;
        protected HashSet addHS;
        protected HashSet removeHS;
        protected HashSet changeHS;
        protected Hashtable cellH;

        public LocateDelta(String string, HashSet hashSet) {
            this.pattern = string;
            this.srcHS = new HashSet();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.srcHS.add(iterator.next());
            }
            this.addHS = new HashSet();
            this.removeHS = new HashSet();
            this.changeHS = new HashSet();
            this.cellH = new Hashtable();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LocateDelta: clickedEntityID=" + this.clickedEntityID);
            stringBuffer.append("\r\n  pattern=" + this.pattern);
            stringBuffer.append("\r\n  srcHS=" + this.srcHS);
            stringBuffer.append("\r\n  addHS=" + this.addHS);
            stringBuffer.append("\r\n  removeHS=" + this.removeHS);
            stringBuffer.append("\r\n  changeHS=" + this.changeHS);
            stringBuffer.append("\r\n  cellH=" + this.cellH);
            return stringBuffer.toString();
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String string) {
            this.pattern = string;
        }

        public GraphEntity.ID getClickedEntityID() {
            return this.clickedEntityID;
        }

        public void setClickedEntityID(GraphEntity.ID iD) {
            this.clickedEntityID = iD;
        }

        public boolean isInSrc(GraphEntity.ID iD) {
            return this.srcHS.contains(iD);
        }

        public Iterator iteratorAdd() {
            return this.addHS.iterator();
        }

        public Iterator iteratorRemove() {
            return this.removeHS.iterator();
        }

        public Iterator iteratorChange() {
            return this.changeHS.iterator();
        }

        public void add(GraphEntity.ID iD) {
            if (this.removeHS.contains(iD)) {
                this.removeHS.remove(iD);
            } else if (!this.srcHS.contains(iD)) {
                this.addHS.add(iD);
            }
        }

        public void remove(GraphEntity.ID iD) {
            if (this.addHS.contains(iD)) {
                this.addHS.remove(iD);
            } else if (this.srcHS.contains(iD)) {
                this.removeHS.add(iD);
            }
        }

        public void removeAll() {
            this.changeHS.clear();
            this.cellH.clear();
            Iterator iterator = this.srcHS.iterator();
            while (iterator.hasNext()) {
                this.removeHS.add(iterator.next());
            }
        }

        public void change(GraphEntity.ID iD) {
            this.changeHS.add(iD);
        }

        public Vector getCells(DefaultTopoTableModel.MemberNode memberNode) {
            return (Vector)this.cellH.get(memberNode);
        }

        public void putCells(DefaultTopoTableModel.MemberNode memberNode, Vector vector) {
            this.cellH.put(memberNode, vector);
        }

        public void removeCells(DefaultTopoTableModel.MemberNode memberNode) {
            this.cellH.remove(memberNode);
        }
    }
}

