/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatFsHistTable;

public class FsHist
extends TStatFsHistTable {
    public static FsHistCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new FsHistCursor(dBConnection, hashtable, vector);
    }

    public FsHist() {
        this.clear();
    }

    public FsHist(int n, String string, Timestamp timestamp, short s, double d, double d2, double d3, int n2, double d4) {
        this.clear();
        this.m_FilesystemId = n;
        this.m_StatisticType = string;
        this.m_StatisticTime = timestamp;
        this.m_AccumCount = s;
        this.m_FileCount = d;
        this.m_Capacity = d2;
        this.m_FreeSpace = d3;
        this.m_ProductId = n2;
        this.m_UsedSpace = d4;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_FilesystemId != Integer.MIN_VALUE) {
            hashtable.put(FsHist.getColumnInfo("FILESYSTEM_ID"), String.valueOf(this.m_FilesystemId));
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(FsHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_StatisticTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(FsHist.getColumnInfo("STATISTIC_TIME"), this.m_StatisticTime);
        }
        if (this.m_AccumCount != Short.MIN_VALUE) {
            hashtable.put(FsHist.getColumnInfo("ACCUM_COUNT"), String.valueOf(this.m_AccumCount));
        }
        if (this.m_FileCount != Double.MIN_VALUE) {
            hashtable.put(FsHist.getColumnInfo("FILE_COUNT"), String.valueOf(this.m_FileCount));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            hashtable.put(FsHist.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            hashtable.put(FsHist.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_ProductId != Integer.MIN_VALUE) {
            hashtable.put(FsHist.getColumnInfo("PRODUCT_ID"), String.valueOf(this.m_ProductId));
        }
        if (this.m_UsedSpace != Double.MIN_VALUE) {
            hashtable.put(FsHist.getColumnInfo("USED_SPACE"), String.valueOf(this.m_UsedSpace));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_FS_HIST", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_FS_HIST", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_FS_HIST", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_FS_HIST", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_FS_HIST", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_FS_HIST", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_FS_HIST", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static FsHist retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        FsHist fsHist = null;
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_FS_HIST", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                fsHist = new FsHist();
                fsHist.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return fsHist;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_FS_HIST", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_FS_HIST", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setFilesystemId(dBResultSet.getInt("FILESYSTEM_ID"));
        this.setStatisticType(dBResultSet.getString("STATISTIC_TYPE"));
        this.setStatisticTime(dBResultSet.getTimestamp("STATISTIC_TIME"));
        this.setAccumCount(dBResultSet.getShort("ACCUM_COUNT"));
        this.setFileCount(dBResultSet.getDouble("FILE_COUNT"));
        this.setCapacity(dBResultSet.getDouble("CAPACITY"));
        this.setFreeSpace(dBResultSet.getDouble("FREE_SPACE"));
        this.setProductId(dBResultSet.getInt("PRODUCT_ID"));
        this.setUsedSpace(dBResultSet.getDouble("USED_SPACE"));
    }

    public static class FsHistCursor
    extends DBCursor {
        private FsHist element = new FsHist();
        private DBConnection con;

        public FsHistCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_STAT_FS_HIST", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public FsHist getObject() throws SQLException {
            FsHist fsHist = null;
            if (this.DBrs != null) {
                fsHist = new FsHist();
                fsHist.setFields(this.con, this.DBrs);
            }
            return fsHist;
        }

        public FsHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

