/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResNamesSubsystemTable;

public class NamesSubsystem
extends TResNamesSubsystemTable {
    public static NamesSubsystemCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new NamesSubsystemCursor(dBConnection, hashtable, vector);
    }

    public NamesSubsystem() {
        this.clear();
    }

    public NamesSubsystem(int n, int n2, String string, short s) {
        this.clear();
        this.m_NamesSubsystemId = n;
        this.m_SubsystemId = n2;
        this.m_Name = string;
        this.m_NameFormat = s;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_NamesSubsystemId != Integer.MIN_VALUE) {
            hashtable.put(NamesSubsystem.getColumnInfo("NAMES_SUBSYSTEM_ID"), String.valueOf(this.m_NamesSubsystemId));
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            hashtable.put(NamesSubsystem.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(NamesSubsystem.getColumnInfo("NAME"), this.m_Name);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_NAMES_SUBSYSTEM", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (hashtable.get(NamesSubsystem.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_NAMES_SUBSYSTEM", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("NAME"), this.m_Name);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_NAMES_SUBSYSTEM", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(NamesSubsystem.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("NAME"), hashtable.get(NamesSubsystem.getColumnInfo("NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_NAMES_SUBSYSTEM", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("NAME"), this.m_Name);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_NAMES_SUBSYSTEM", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(NamesSubsystem.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("NAME"), hashtable.get(NamesSubsystem.getColumnInfo("NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_NAMES_SUBSYSTEM", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(NamesSubsystem.getColumnInfo("NAME"), this.m_Name);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_NAMES_SUBSYSTEM", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static NamesSubsystem retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        NamesSubsystem namesSubsystem = null;
        if (hashtable.get(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(NamesSubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(NamesSubsystem.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        hashtable2.put(NamesSubsystem.getColumnInfo("NAME"), hashtable.get(NamesSubsystem.getColumnInfo("NAME")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_NAMES_SUBSYSTEM", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                namesSubsystem = new NamesSubsystem();
                namesSubsystem.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return namesSubsystem;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_NAMES_SUBSYSTEM", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_NAMES_SUBSYSTEM", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setNamesSubsystemId(dBResultSet.getInt("NAMES_SUBSYSTEM_ID"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setNameFormat(dBResultSet.getShort("NAME_FORMAT"));
    }

    public static class NamesSubsystemCursor
    extends DBCursor {
        private NamesSubsystem element = new NamesSubsystem();
        private DBConnection con;

        public NamesSubsystemCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_NAMES_SUBSYSTEM", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public NamesSubsystem getObject() throws SQLException {
            NamesSubsystem namesSubsystem = null;
            if (this.DBrs != null) {
                namesSubsystem = new NamesSubsystem();
                namesSubsystem.setFields(this.con, this.DBrs);
            }
            return namesSubsystem;
        }

        public NamesSubsystem getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

