/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorTable;

public class Vendor
extends TResVendorTable {
    public static VendorCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new VendorCursor(dBConnection, hashtable, vector);
    }

    public Vendor() {
        this.clear();
    }

    public Vendor(short s, String string, String string2) {
        this.clear();
        this.m_VendorId = s;
        this.m_VendorName = string;
        this.m_VendorDescription = string2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(Vendor.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_VendorDescription != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Vendor.getColumnInfo("VENDOR_DESCRIPTION"), this.m_VendorDescription);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htColsAndValues.put(Vendor.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_VENDOR", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Vendor.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_VENDOR", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(Vendor.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Vendor.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(Vendor.getColumnInfo("VENDOR_NAME"), hashtable.get(Vendor.getColumnInfo("VENDOR_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(Vendor.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Vendor.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(Vendor.getColumnInfo("VENDOR_NAME"), hashtable.get(Vendor.getColumnInfo("VENDOR_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(Vendor.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_VENDOR", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Vendor retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Vendor vendor = null;
        if (hashtable.get(Vendor.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        hashtable2.put(Vendor.getColumnInfo("VENDOR_NAME"), hashtable.get(Vendor.getColumnInfo("VENDOR_NAME")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_VENDOR", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                vendor = new Vendor();
                vendor.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return vendor;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendorName(dBResultSet.getString("VENDOR_NAME"));
        this.setVendorDescription(dBResultSet.getString("VENDOR_DESCRIPTION"));
    }

    public static class VendorCursor
    extends DBCursor {
        private Vendor element = new Vendor();
        private DBConnection con;

        public VendorCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_VENDOR", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Vendor getObject() throws SQLException {
            Vendor vendor = null;
            if (this.DBrs != null) {
                vendor = new Vendor();
                vendor.setFields(this.con, this.DBrs);
            }
            return vendor;
        }

        public Vendor getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

