/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResZoneMemberTable;

public class ZoneMember
extends TResZoneMemberTable {
    public static ZoneMemberCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new ZoneMemberCursor(dBConnection, hashtable, vector);
    }

    public ZoneMember() {
        this.clear();
    }

    public ZoneMember(int n, String string, short s, short s2, String string2) {
        this.clear();
        this.m_ZoneMemberId = n;
        this.m_MemberName = string;
        this.m_Type = s;
        this.m_VendorType = s2;
        this.m_Description = string2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_ZoneMemberId != Integer.MIN_VALUE) {
            hashtable.put(ZoneMember.getColumnInfo("ZONE_MEMBER_ID"), String.valueOf(this.m_ZoneMemberId));
        }
        if (this.m_Type != Short.MIN_VALUE) {
            hashtable.put(ZoneMember.getColumnInfo("TYPE"), String.valueOf(this.m_Type));
        }
        if (this.m_VendorType != Short.MIN_VALUE) {
            hashtable.put(ZoneMember.getColumnInfo("VENDOR_TYPE"), String.valueOf(this.m_VendorType));
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ZoneMember.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htColsAndValues.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_ZONE_MEMBER", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_ZONE_MEMBER", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ZONE_MEMBER", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), hashtable.get(ZoneMember.getColumnInfo("MEMBER_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ZONE_MEMBER", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ZONE_MEMBER", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), hashtable.get(ZoneMember.getColumnInfo("MEMBER_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ZONE_MEMBER", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_MemberName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MEMBER_NAME not found");
        }
        this.htWhereClause.put(ZoneMember.getColumnInfo("MEMBER_NAME"), this.m_MemberName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_ZONE_MEMBER", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static ZoneMember retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        ZoneMember zoneMember = null;
        if (hashtable.get(ZoneMember.getColumnInfo("MEMBER_NAME")) == null) {
            throw new SQLException(" ERROR: key MEMBER_NAME not found");
        }
        hashtable2.put(ZoneMember.getColumnInfo("MEMBER_NAME"), hashtable.get(ZoneMember.getColumnInfo("MEMBER_NAME")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_ZONE_MEMBER", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                zoneMember = new ZoneMember();
                zoneMember.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return zoneMember;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_ZONE_MEMBER", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_ZONE_MEMBER", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setZoneMemberId(dBResultSet.getInt("ZONE_MEMBER_ID"));
        this.setMemberName(dBResultSet.getString("MEMBER_NAME"));
        this.setType(dBResultSet.getShort("TYPE"));
        this.setVendorType(dBResultSet.getShort("VENDOR_TYPE"));
        this.setDescription(dBResultSet.getString("DESCRIPTION"));
    }

    public static class ZoneMemberCursor
    extends DBCursor {
        private ZoneMember element = new ZoneMember();
        private DBConnection con;

        public ZoneMemberCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_ZONE_MEMBER", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public ZoneMember getObject() throws SQLException {
            ZoneMember zoneMember = null;
            if (this.DBrs != null) {
                zoneMember = new ZoneMember();
                zoneMember.setFields(this.con, this.DBrs);
            }
            return zoneMember;
        }

        public ZoneMember getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

