/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Null;
import org.eclipse.aperi.infrastructure.database.objects.Attribute;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Fabric2switch;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Node2computer;
import org.eclipse.aperi.infrastructure.database.objects.Pe2node;
import org.eclipse.aperi.infrastructure.database.objects.PhyPe;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.Port2parent;
import org.eclipse.aperi.infrastructure.database.objects.Port2port2fabric;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.sql.SqlAttribute;
import org.eclipse.aperi.infrastructure.history.detectability.AssociatedEntityElement;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetectionElement;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ChangeDetection {
    private static Hashtable hChangeDetection = null;
    private static Hashtable assocEntity = null;
    private static String thisClassName = ChangeDetection.class.getName();
    private static boolean TRACE = false;
    private static ILogger traceLogger = null;
    private static ColumnInfo groupidCI = StorageSubsystem.getColumnInfo("GROUP_ID");
    private static int tokenGenerator = 0;
    private static int[] systemTypes;
    private static int[] attributeTypes;
    private static int[] groupTypes;
    public int tokenid = -1;
    private ViewReportTablesUpdater vrtu = null;
    private static IEventMonitorService iems;

    static {
        int[] nArray = new int[14];
        nArray[0] = 114;
        nArray[1] = 127;
        nArray[2] = 13;
        nArray[3] = 126;
        nArray[4] = 139;
        nArray[5] = 138;
        nArray[6] = 129;
        nArray[7] = 121;
        nArray[8] = 78;
        nArray[9] = 77;
        nArray[10] = 1;
        nArray[12] = 134;
        nArray[13] = 133;
        systemTypes = nArray;
        attributeTypes = new int[]{114, 121, 138, 129, 81, 82, 26};
        int[] nArray2 = new int[3];
        nArray2[0] = 77;
        nArray2[2] = 133;
        groupTypes = nArray2;
        iems = null;
        iems = (IEventMonitorService)Activator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        hChangeDetection = new Hashtable();
        hChangeDetection.put("T_RES_STORAGE_SUBSYSTEM", new ChangeDetectionElement(StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"), new ColumnInfo[]{StorageSubsystem.getColumnInfo("CACHE"), StorageSubsystem.getColumnInfo("CODE_LEVEL"), StorageSubsystem.getColumnInfo("ALLOCATED_CAPACITY"), StorageSubsystem.getColumnInfo("AVAILABLE_CAPACITY"), StorageSubsystem.getColumnInfo("BACKEND_STORAGE_CAPACITY"), StorageSubsystem.getColumnInfo("OPERATIONAL_STATUS"), StorageSubsystem.getColumnInfo("DETECTABLE")}, 78, 81, "org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem"));
        hChangeDetection.put("T_RES_STORAGE_POOL", new ChangeDetectionElement(StoragePool.getColumnInfo("POOL_ID"), new ColumnInfo[]{StoragePool.getColumnInfo("TOTAL_AVAILABLE_SPACE"), StoragePool.getColumnInfo("CAPACITY"), StoragePool.getColumnInfo("OPERATIONAL_STATUS"), StoragePool.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.StoragePool"));
        hChangeDetection.put("T_RES_PHYSICAL_VOLUME", new ChangeDetectionElement(PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"), new ColumnInfo[]{PhysicalVolume.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume"));
        hChangeDetection.put("T_RES_STORAGE_VOLUME", new ChangeDetectionElement(StorageVolume.getColumnInfo("SVID"), new ColumnInfo[]{StorageVolume.getColumnInfo("CAPACITY"), StorageVolume.getColumnInfo("OPERATIONAL_STATUS"), StorageVolume.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.StorageVolume"));
        hChangeDetection.put("T_RES_BACKEND_CONTROLLER", new ChangeDetectionElement(BackendController.getColumnInfo("BACKEND_CONTROLLER_ID"), new ColumnInfo[]{BackendController.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.BackendController"));
        hChangeDetection.put("T_RES_FABRIC", new ChangeDetectionElement(Fabric.getColumnInfo("FABRIC_WWN"), new ColumnInfo[]{Fabric.getColumnInfo("ACTIVE"), Fabric.getColumnInfo("DETECTABLE"), Fabric.getColumnInfo("OPERATIONAL_STATUS")}, 114, 114, "org.eclipse.aperi.infrastructure.database.objects.Fabric"));
        hChangeDetection.put("T_RES_FABRIC2SWITCH", new ChangeDetectionElement(Fabric2switch.getColumnInfo("FABRIC2SWITCH_ID"), new ColumnInfo[]{Fabric2switch.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Fabric2switch"));
        hChangeDetection.put("T_VIEW_PORT2PORT2FABRIC", new ChangeDetectionElement(Port2port2fabric.getColumnInfo("PORT2PORT_ID"), new ColumnInfo[]{Port2port2fabric.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Port2port2fabric"));
        hChangeDetection.put("T_VIEW_PORT2PARENT", new ChangeDetectionElement(Port2parent.getColumnInfo("PORT_ID"), new ColumnInfo[]{Port2parent.getColumnInfo("OPERATIONAL_STATUS"), Port2parent.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Port2parent"));
        hChangeDetection.put("T_RES_ZONE", new ChangeDetectionElement(Zone.getColumnInfo("ZONE_ID"), new ColumnInfo[]{Zone.getColumnInfo("ACTIVE")}, 127, 114, "org.eclipse.aperi.infrastructure.database.objects.Zone"));
        hChangeDetection.put("T_RES_ZSET", new ChangeDetectionElement(Zset.getColumnInfo("ZSET_ID"), new ColumnInfo[]{Zset.getColumnInfo("ACTIVE")}, 126, 114, "org.eclipse.aperi.infrastructure.database.objects.Zset"));
        hChangeDetection.put("T_RES_SWITCH", new ChangeDetectionElement(Switch.getColumnInfo("SWITCH_WWN"), new ColumnInfo[]{Switch.getColumnInfo("DETECTABLE"), Switch.getColumnInfo("OPERATIONAL_STATUS"), Switch.getColumnInfo("VERSION")}, 121, 121, "org.eclipse.aperi.infrastructure.database.objects.Switch"));
        hChangeDetection.put("T_RES_SWITCH_BLADE", new ChangeDetectionElement(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"), new ColumnInfo[]{SwitchBlade.getColumnInfo("DETECTABLE"), SwitchBlade.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.SwitchBlade"));
        hChangeDetection.put("T_RES_SWITCH2PORT", new ChangeDetectionElement(Switch2port.getColumnInfo("SWITCH2PORT_ID"), new ColumnInfo[]{Switch2port.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Switch2port"));
        hChangeDetection.put("T_RES_PE2NODE", new ChangeDetectionElement(Pe2node.getColumnInfo("PE2NODE_ID"), new ColumnInfo[]{Pe2node.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Pe2node"));
        hChangeDetection.put("T_RES_PHY_PE", new ChangeDetectionElement(PhyPe.getColumnInfo("PHY_PE_ID"), new ColumnInfo[]{PhyPe.getColumnInfo("DETECTABLE"), PhyPe.getColumnInfo("FIRMWARE_REVISION")}, 129, 129, "org.eclipse.aperi.infrastructure.database.objects.PhyPe"));
        hChangeDetection.put("T_RES_NODE", new ChangeDetectionElement(Node.getColumnInfo("NODE_ID"), new ColumnInfo[]{Node.getColumnInfo("DETECTABLE"), Node.getColumnInfo("OPERATIONAL_STATUS")}, 138, 129, "org.eclipse.aperi.infrastructure.database.objects.Node"));
        hChangeDetection.put("T_RES_HOST", new ChangeDetectionElement(Host.getColumnInfo("COMPUTER_ID"), new ColumnInfo[]{Host.getColumnInfo("DETECTABLE"), Host.getColumnInfo("OPERATIONAL_STATUS")}, 1, 26, "org.eclipse.aperi.infrastructure.database.objects.Host"));
        hChangeDetection.put("T_RES_HBA", new ChangeDetectionElement(Hba.getColumnInfo("HBA_ID"), new ColumnInfo[]{Hba.getColumnInfo("DETECTABLE"), Hba.getColumnInfo("FIRMWARE_VERSION"), Hba.getColumnInfo("DRIVER_VERSION"), Hba.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Hba"));
        hChangeDetection.put("T_VIEW_NODE2COMPUTER", new ChangeDetectionElement(Node2computer.getColumnInfo("NODE2HBA_ID"), new ColumnInfo[]{Node2computer.getColumnInfo("DETECTABLE")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.Node2computer"));
        hChangeDetection.put("T_RES_TAPE_LIBRARY", new ChangeDetectionElement(TapeLibrary.getColumnInfo("TAPE_LIBRARY_ID"), new ColumnInfo[]{TapeLibrary.getColumnInfo("DETECTABLE"), TapeLibrary.getColumnInfo("OPERATIONAL_STATUS")}, 134, 81, "org.eclipse.aperi.infrastructure.database.objects.TapeLibrary"));
        hChangeDetection.put("T_RES_TAPE_DRIVE", new ChangeDetectionElement(TapeDrive.getColumnInfo("TAPE_DRIVE_ID"), new ColumnInfo[]{TapeDrive.getColumnInfo("DETECTABLE"), TapeDrive.getColumnInfo("NEEDS_CLEANING"), TapeDrive.getColumnInfo("FIRMWARE_VERSION"), TapeDrive.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.TapeDrive"));
        hChangeDetection.put("T_RES_TAPE_MEDIA_CHANGER", new ChangeDetectionElement(TapeMediaChanger.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), new ColumnInfo[]{TapeMediaChanger.getColumnInfo("DETECTABLE"), TapeMediaChanger.getColumnInfo("FIRMWARE_VERSION"), TapeMediaChanger.getColumnInfo("OPERATIONAL_STATUS")}, -1, -1, "org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger"));
        assocEntity = new Hashtable();
        Vector<AssociatedEntityElement> vector = new Vector<AssociatedEntityElement>();
        vector.add(new AssociatedEntityElement("T_RES_STORAGE_VOLUME", StorageVolume.getColumnInfo("SUBSYSTEM_ID")));
        vector.add(new AssociatedEntityElement("T_RES_STORAGE_POOL", StoragePool.getColumnInfo("SUBSYSTEM_ID")));
        vector.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("SUBSYSTEM_ID")));
        vector.add(new AssociatedEntityElement("T_RES_BACKEND_CONTROLLER", BackendController.getColumnInfo("OWNING_SUBSYSTEM_ID")));
        vector.add(new AssociatedEntityElement("T_RES_PHYSICAL_VOLUME", PhysicalVolume.getColumnInfo("SUBSYSTEM_ID")));
        assocEntity.put("T_RES_STORAGE_SUBSYSTEM", vector);
        Vector<AssociatedEntityElement> vector2 = new Vector<AssociatedEntityElement>();
        vector2.add(new AssociatedEntityElement("T_RES_SWITCH_BLADE", SwitchBlade.getColumnInfo("SWITCH_WWN")));
        vector2.add(new AssociatedEntityElement("T_RES_SWITCH2PORT", Switch2port.getColumnInfo("SWITCH_WWN")));
        vector2.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("SWITCH_WWN")));
        assocEntity.put("T_RES_SWITCH", vector2);
        Vector<AssociatedEntityElement> vector3 = new Vector<AssociatedEntityElement>();
        vector3.add(new AssociatedEntityElement("T_RES_HBA", Hba.getColumnInfo("HOST_ID")));
        vector3.add(new AssociatedEntityElement("T_VIEW_NODE2COMPUTER", Node2computer.getColumnInfo("HOST_ID")));
        vector3.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("HOST_ID")));
        assocEntity.put("T_RES_HOST", vector3);
        Vector<AssociatedEntityElement> vector4 = new Vector<AssociatedEntityElement>();
        vector4.add(new AssociatedEntityElement("T_RES_TAPE_DRIVE", TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        vector4.add(new AssociatedEntityElement("T_RES_TAPE_MEDIA_CHANGER", TapeMediaChanger.getColumnInfo("TAPE_LIBRARY_ID")));
        assocEntity.put("T_RES_TAPE_LIBRARY", vector4);
        Vector<AssociatedEntityElement> vector5 = new Vector<AssociatedEntityElement>();
        vector5.add(new AssociatedEntityElement("T_RES_FABRIC2SWITCH", Fabric2switch.getColumnInfo("FABRIC_WWN")));
        vector5.add(new AssociatedEntityElement("T_VIEW_PORT2PORT2FABRIC", Port2port2fabric.getColumnInfo("FABRIC_WWN")));
        assocEntity.put("T_RES_FABRIC", vector5);
        Vector<AssociatedEntityElement> vector6 = new Vector<AssociatedEntityElement>();
        vector6.add(new AssociatedEntityElement("T_RES_PE2NODE", Pe2node.getColumnInfo("PHY_PE_ID")));
        vector6.add(new AssociatedEntityElement("T_VIEW_PORT2PARENT", Port2parent.getColumnInfo("PHY_PE_ID")));
        assocEntity.put("T_RES_PHY_PE", vector6);
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeDetection(DBConnection dBConnection) {
        Class<ChangeDetection> clazz = ChangeDetection.class;
        synchronized (ChangeDetection.class) {
            this.tokenid = tokenGenerator++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.vrtu = new ViewReportTablesUpdater();
            this.startEntityAttribute(dBConnection);
            return;
        }
    }

    /*
     * Loose catch block
     */
    private Object[] getEntityAttribute(DBConnection dBConnection, ColumnInfo columnInfo, ColumnInfo[] columnInfoArray, String string, String string2) throws SQLException {
        String string3;
        block16: {
            DBCursor dBCursor;
            block15: {
                block13: {
                    Object[] objectArray;
                    block14: {
                        string3 = "getEntityAttribute";
                        if (TRACE) {
                            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string3);
                        }
                        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                        Vector<String> vector = new Vector<String>();
                        hashtable.put(columnInfo, string2);
                        int n = 0;
                        while (n < columnInfoArray.length) {
                            vector.add(columnInfoArray[n].getName());
                            ++n;
                        }
                        dBCursor = null;
                        try {
                            Class<?> clazz = Class.forName(string);
                            Method method = clazz.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                            dBCursor = (DBCursor)method.invoke(clazz, dBConnection, hashtable, vector);
                            if (!dBCursor.next()) break block13;
                            Object[] objectArray2 = dBCursor.getAttribute(vector);
                            if (TRACE) {
                                traceLogger.entry(IRecordType.TYPE_INFO, string3, "attribute returned is " + objectArray2[0]);
                            }
                            if (TRACE) {
                                traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
                            }
                            objectArray = objectArray2;
                            if (dBCursor == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (dBCursor != null) {
                                dBCursor.close();
                            }
                            throw throwable;
                        }
                        dBCursor.close();
                    }
                    return objectArray;
                    {
                        catch (Exception exception) {
                            if (!TRACE) break block15;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                            break block15;
                        }
                    }
                }
                if (dBCursor != null) {
                    dBCursor.close();
                }
                break block16;
            }
            if (dBCursor != null) {
                dBCursor.close();
            }
        }
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_INFO, string3, "attribute returned is null");
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
        }
        return null;
    }

    private Object[] getSnapEntityAttribute(DBConnection dBConnection, ColumnInfo columnInfo, ColumnInfo[] columnInfoArray, int n, int n2, Object[] objectArray, String string, String string2) throws SQLException {
        String string3 = "getSnapEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string3);
        }
        Object[] objectArray2 = null;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        Vector<String> vector = new Vector<String>();
        hashtable.put(columnInfo, string2);
        int n3 = 0;
        while (n3 < columnInfoArray.length) {
            vector.add(columnInfoArray[n3].getName());
            ++n3;
        }
        DBCursor dBCursor = null;
        try {
            try {
                Class<?> clazz = Class.forName(String.valueOf(string) + "AttributeSnapshot");
                Method method = clazz.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                dBCursor = (DBCursor)method.invoke(clazz, dBConnection, hashtable, vector);
                if (dBCursor.next()) {
                    Object[] objectArray3 = dBCursor.getAttribute(vector);
                    objectArray2 = objectArray3;
                }
                dBCursor.close();
            }
            catch (Exception exception) {
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                }
            }
        }
        finally {
            if (dBCursor != null) {
                dBCursor.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
        }
        return objectArray2;
    }

    private static void operateSnapEntityAttribute(DBConnection dBConnection, String string, String string2, ColumnInfo columnInfo, ColumnInfo[] columnInfoArray, String string3, Object[] objectArray) {
        String string4;
        block9: {
            string4 = "operateSnapEntityAttribute";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, String.valueOf(string4) + ":" + string2);
            }
            Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>();
            hashtable.put(columnInfo, string3);
            if (string2.equals("insert") || string2.equals("update")) {
                int n = 0;
                while (n < columnInfoArray.length) {
                    if (objectArray[n] instanceof Integer || objectArray[n] instanceof Long || objectArray[n] instanceof Short || objectArray[n] instanceof Double) {
                        objectArray[n] = objectArray[n].toString();
                    }
                    if (objectArray[n] == null) {
                        objectArray[n] = new Null();
                    }
                    hashtable.put(columnInfoArray[n], objectArray[n]);
                    ++n;
                }
            }
            try {
                Class<?> clazz = Class.forName(String.valueOf(string) + "AttributeSnapshot");
                Method method = clazz.getDeclaredMethod(string2, DBConnection.class, Hashtable.class);
                method.invoke(clazz.newInstance(), dBConnection, hashtable);
                if (string2.equals("insert") || string2.equals("update") || string2.equals("delete")) {
                    dBConnection.commit();
                }
            }
            catch (Exception exception) {
                if (!TRACE) break block9;
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string4, exception);
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, String.valueOf(string4) + ":" + string2);
        }
    }

    private String getTableName(int n) {
        switch (n) {
            case 13: 
            case 77: 
            case 78: {
                return "T_RES_STORAGE_SUBSYSTEM";
            }
            case 114: {
                return "T_RES_FABRIC";
            }
            case 127: {
                return "T_RES_ZONE";
            }
            case 126: {
                return "T_RES_ZSET";
            }
            case 121: {
                return "T_RES_SWITCH";
            }
            case 129: 
            case 139: {
                return "T_RES_PHY_PE";
            }
            case 138: {
                return "T_RES_NODE";
            }
            case 0: 
            case 1: {
                return "T_RES_HOST";
            }
            case 133: 
            case 134: {
                return "T_RES_TAPE_LIBRARY";
            }
        }
        return null;
    }

    private void startAssociatedEntityAttribute(DBConnection dBConnection, String string, String string2) {
        Vector vector;
        String string3 = "startAssociatedEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string3);
        }
        if ((vector = (Vector)assocEntity.get(string)) == null) {
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
            }
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            AssociatedEntityElement associatedEntityElement = (AssociatedEntityElement)vector.elementAt(n);
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            Vector<String> vector2 = new Vector<String>();
            hashtable.put(associatedEntityElement.associatorColumnInfo, string2);
            ChangeDetectionElement changeDetectionElement = (ChangeDetectionElement)hChangeDetection.get(associatedEntityElement.tableName);
            if (changeDetectionElement != null) {
                vector2.add(changeDetectionElement.idColumnInfo.getName());
                DBCursor dBCursor = null;
                try {
                    try {
                        Class<?> clazz = Class.forName(changeDetectionElement.className);
                        Method method = clazz.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                        dBCursor = (DBCursor)method.invoke(clazz, dBConnection, hashtable, vector2);
                        while (dBCursor.next()) {
                            String string4;
                            Object[] objectArray;
                            Object[] objectArray2 = dBCursor.getAttribute(vector2);
                            if (TRACE) {
                                traceLogger.entry(IRecordType.TYPE_INFO, string3, "attribute returned is " + objectArray2[0]);
                            }
                            if ((objectArray = this.getEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, changeDetectionElement.className, string4 = objectArray2[0].toString())) == null) continue;
                            try {
                                ChangeDetection.operateSnapEntityAttribute(dBConnection, changeDetectionElement.className, "insert", changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, string4, objectArray);
                            }
                            catch (Exception exception) {
                                if (!TRACE) continue;
                                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (TRACE) {
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                        }
                    }
                }
                finally {
                    block24: {
                        try {
                            if (dBCursor != null) {
                                dBCursor.close();
                            }
                        }
                        catch (Exception exception) {
                            if (!TRACE) break block24;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                        }
                    }
                }
            }
            ++n;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
        }
    }

    private boolean isGroupType(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < groupTypes.length) {
            if (groupTypes[n2] == n) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private String normalizeType(String string) {
        if (string.equals("T_RES_PORT2PORT")) {
            return "T_VIEW_PORT2PORT2FABRIC";
        }
        if (string.equals("T_RES_NODE2HBA")) {
            return "T_VIEW_NODE2COMPUTER";
        }
        if (string.equals("T_RES_PORT")) {
            return "T_VIEW_PORT2PARENT";
        }
        return string;
    }

    private String deNormalizeType(String string) {
        if (string.equals("T_VIEW_PORT2PORT2FABRIC")) {
            return "T_RES_PORT2PORT";
        }
        if (string.equals("T_VIEW_NODE2COMPUTER")) {
            return "T_RES_NODE2HBA";
        }
        if (string.equals("T_VIEW_PORT2PARENT")) {
            return "T_RES_PORT";
        }
        return string;
    }

    public void startNew(DBConnection dBConnection, Map map) {
        String string;
        block7: {
            string = "startNew";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string);
            }
            this.vrtu.processView(map);
            try {
                for (String string2 : map.keySet()) {
                    List list = (List)map.get(string2);
                    string2 = this.normalizeType(string2);
                    int n = 0;
                    while (n < list.size()) {
                        String string3 = (String)list.get(n);
                        String string4 = this.subWwnForId(dBConnection, string2, string3);
                        if (TRACE) {
                            traceLogger.entry(IRecordType.TYPE_INFO, string, String.valueOf(string2) + ":" + string4);
                        }
                        this.startNewEntityAttribute(dBConnection, string2, string4);
                        this.startNewEntityAttribute2(dBConnection, string2, string4);
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                if (!TRACE) break block7;
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string);
        }
    }

    private void startNewEntityAttribute(DBConnection dBConnection, String string, String string2) {
        String string3;
        block28: {
            string3 = "startNewEntityAttribute";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string3);
            }
            ChangeDetectionElement changeDetectionElement = (ChangeDetectionElement)hChangeDetection.get(string);
            String string4 = string;
            if (changeDetectionElement != null) {
                Object[] objectArray;
                boolean bl = false;
                DBCursor dBCursor = null;
                try {
                    try {
                        objectArray = new Hashtable();
                        objectArray.put(Attribute.getColumnInfo("ATTRIBUTE_TYPE"), new Short((short)changeDetectionElement.attributeType));
                        objectArray.put(Attribute.getColumnInfo("RESOURCE_ID"), new Integer(-1));
                        dBCursor = Attribute.getCursor(dBConnection, (Hashtable)objectArray, null);
                        bl = dBCursor.next();
                    }
                    catch (Exception exception) {
                        if (TRACE) {
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                        }
                    }
                }
                finally {
                    block25: {
                        try {
                            if (dBCursor != null) {
                                dBCursor.close();
                            }
                        }
                        catch (Exception exception) {
                            if (!TRACE) break block25;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                        }
                    }
                }
                if (bl) {
                    block26: {
                        objectArray = null;
                        try {
                            objectArray = this.getEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, changeDetectionElement.className, string2);
                        }
                        catch (Exception exception) {
                            if (!TRACE) break block26;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                        }
                    }
                    if (objectArray != null) {
                        block27: {
                            try {
                                ChangeDetection.operateSnapEntityAttribute(dBConnection, changeDetectionElement.className, "insert", changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, string2, objectArray);
                            }
                            catch (Exception exception) {
                                if (!TRACE) break block27;
                                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                            }
                        }
                        try {
                            this.startAssociatedEntityAttribute(dBConnection, string4, string2);
                        }
                        catch (Exception exception) {
                            if (!TRACE) break block28;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                        }
                    }
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
        }
    }

    private void startNewEntityAttribute2(DBConnection dBConnection, String string, String string2) {
        String string3 = "startNewEntityAttribute2";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string3);
        }
        Enumeration enumeration = assocEntity.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            Vector vector = (Vector)assocEntity.get(string4);
            int n = 0;
            while (n < vector.size()) {
                block9: {
                    ChangeDetectionElement changeDetectionElement;
                    AssociatedEntityElement associatedEntityElement = (AssociatedEntityElement)vector.get(n);
                    if (associatedEntityElement.tableName.equals(this.normalizeType(string)) && (changeDetectionElement = (ChangeDetectionElement)hChangeDetection.get(associatedEntityElement.tableName)) != null) {
                        try {
                            Object[] objectArray = this.getEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, new ColumnInfo[]{associatedEntityElement.associatorColumnInfo}, changeDetectionElement.className, string2);
                            if (objectArray != null) {
                                Object[] objectArray2;
                                String string5 = objectArray[0].toString();
                                ChangeDetectionElement changeDetectionElement2 = (ChangeDetectionElement)hChangeDetection.get(string4);
                                if (changeDetectionElement2 != null && (objectArray2 = this.getSnapEntityAttribute(dBConnection, changeDetectionElement2.idColumnInfo, changeDetectionElement2.attributeColumnInfo, changeDetectionElement2.resourceType, changeDetectionElement2.attributeType, objectArray, changeDetectionElement2.className, string5)) != null) {
                                    Object[] objectArray3 = this.getEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, changeDetectionElement.className, string2);
                                    ChangeDetection.operateSnapEntityAttribute(dBConnection, changeDetectionElement.className, "insert", changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, string2, objectArray3);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!TRACE) break block9;
                            traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                        }
                    }
                }
                ++n;
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
        }
    }

    public void startEntityAttribute(DBConnection dBConnection) {
        String string = "startEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string);
        }
        String string2 = "";
        int n = 0;
        while (n < systemTypes.length) {
            string2 = String.valueOf(string2) + String.valueOf(systemTypes[n]);
            if (n < systemTypes.length - 1) {
                string2 = String.valueOf(string2) + ",";
            }
            ++n;
        }
        String string3 = "";
        int n2 = 0;
        while (n2 < attributeTypes.length) {
            string3 = String.valueOf(string3) + String.valueOf(attributeTypes[n2]);
            if (n2 < attributeTypes.length - 1) {
                string3 = String.valueOf(string3) + ",";
            }
            ++n2;
        }
        String string4 = "(" + string2 + ") AND ATTRIBUTE_TYPE IN (" + string3 + ")";
        DBResultSet dBResultSet = null;
        DBCursor dBCursor = null;
        try {
            try {
                dBResultSet = SqlAttribute.sqlQuery(dBConnection, SqlAttribute.getSnapshotEntitiesQuery, string4, null);
                while (dBResultSet.next()) {
                    Object object;
                    Object[] objectArray;
                    Vector<String> vector;
                    short s;
                    short s2;
                    int n3;
                    block51: {
                        Object[] objectArray2;
                        Object object2;
                        Object[] objectArray3;
                        ChangeDetectionElement changeDetectionElement;
                        String string5;
                        n3 = dBResultSet.getInt(1);
                        s2 = dBResultSet.getShort(2);
                        s = dBResultSet.getShort(3);
                        if (TRACE) {
                            traceLogger.entry(IRecordType.TYPE_INFO, string, "AD:" + n3 + ":" + s2 + ":" + s);
                        }
                        if ((string5 = this.getTableName(s2)) == null || (changeDetectionElement = (ChangeDetectionElement)hChangeDetection.get(string5)) == null) continue;
                        if (this.isGroupType(s2)) {
                            vector = String.valueOf(n3);
                            objectArray = new Vector<String>();
                            objectArray.add(changeDetectionElement.idColumnInfo.getName());
                            object = new Hashtable<ColumnInfo, Vector<String>>();
                            ((Hashtable)object).put(groupidCI, vector);
                            objectArray3 = Class.forName(changeDetectionElement.className.equals("org.eclipse.aperi.infrastructure.database.objects.Host") ? "org.eclipse.aperi.infrastructure.database.objects.StatComputer" : changeDetectionElement.className);
                            object2 = objectArray3.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                            dBCursor = (DBCursor)((Method)object2).invoke((Object)objectArray3, dBConnection, object, objectArray);
                            while (dBCursor.next()) {
                                String string6;
                                block49: {
                                    Object[] objectArray4;
                                    objectArray2 = dBCursor.getAttribute((Vector)objectArray);
                                    if (TRACE) {
                                        traceLogger.entry(IRecordType.TYPE_INFO, string, "attribute returned is " + objectArray2[0]);
                                    }
                                    if ((objectArray4 = this.getEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, changeDetectionElement.className, string6 = objectArray2[0].toString())) == null) continue;
                                    try {
                                        ChangeDetection.operateSnapEntityAttribute(dBConnection, changeDetectionElement.className, "insert", changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, string6, objectArray4);
                                    }
                                    catch (Exception exception) {
                                        if (!TRACE) break block49;
                                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                                    }
                                }
                                try {
                                    this.startAssociatedEntityAttribute(dBConnection, string5, string6);
                                }
                                catch (Exception exception) {
                                    if (!TRACE) continue;
                                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                                }
                            }
                        } else if (n3 != -1) {
                            vector = String.valueOf(n3);
                            objectArray = this.getEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, changeDetectionElement.className, (String)((Object)(vector = this.subWwnForId(dBConnection, string5, (String)((Object)vector)))));
                            if (objectArray != null) {
                                block50: {
                                    try {
                                        ChangeDetection.operateSnapEntityAttribute(dBConnection, changeDetectionElement.className, "insert", changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, vector, objectArray);
                                    }
                                    catch (Exception exception) {
                                        if (!TRACE) break block50;
                                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                                    }
                                }
                                try {
                                    this.startAssociatedEntityAttribute(dBConnection, string5, (String)((Object)vector));
                                }
                                catch (Exception exception) {
                                    if (!TRACE) break block51;
                                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                                }
                            }
                        } else {
                            vector = new Vector();
                            vector.add(changeDetectionElement.idColumnInfo.getName());
                            objectArray = Class.forName(changeDetectionElement.className);
                            object = objectArray.getDeclaredMethod("getCursor", DBConnection.class, Hashtable.class, Vector.class);
                            Object[] objectArray5 = new Object[3];
                            objectArray5[0] = dBConnection;
                            objectArray5[2] = vector;
                            dBCursor = (DBCursor)((Method)object).invoke((Object)objectArray, objectArray5);
                            while (dBCursor.next()) {
                                block52: {
                                    objectArray3 = dBCursor.getAttribute(vector);
                                    if (TRACE) {
                                        traceLogger.entry(IRecordType.TYPE_INFO, string, "attribute returned is " + objectArray3[0]);
                                    }
                                    if ((objectArray2 = this.getEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, changeDetectionElement.className, (String)(object2 = objectArray3[0].toString()))) == null) continue;
                                    try {
                                        ChangeDetection.operateSnapEntityAttribute(dBConnection, changeDetectionElement.className, "insert", changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, (String)object2, objectArray2);
                                    }
                                    catch (Exception exception) {
                                        if (!TRACE) break block52;
                                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                                    }
                                }
                                try {
                                    this.startAssociatedEntityAttribute(dBConnection, string5, (String)object2);
                                }
                                catch (Exception exception) {
                                    if (!TRACE) continue;
                                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                                }
                            }
                        }
                    }
                    vector = new Vector<String>();
                    objectArray = new Vector();
                    vector.add((String)((Object)Attribute.getColumnInfo("RESOURCE_ID")));
                    objectArray.add(String.valueOf(n3));
                    vector.add((String)((Object)Attribute.getColumnInfo("RESOURCE_TYPE")));
                    objectArray.add(String.valueOf(s2));
                    vector.add((String)((Object)Attribute.getColumnInfo("ATTRIBUTE_TYPE")));
                    objectArray.add(String.valueOf(s));
                    object = ComplexQuery.generateHashtable(vector, (Vector)objectArray);
                    SqlAttribute.sqlUpdate(dBConnection, SqlAttribute.updateSnapshotted, (Hashtable)object);
                    dBConnection.commit();
                }
            }
            catch (Exception exception) {
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                }
            }
        }
        finally {
            block55: {
                block54: {
                    try {
                        if (dBResultSet != null) {
                            dBResultSet.getStatement().close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TRACE) break block54;
                        traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                    }
                }
                try {
                    if (dBCursor != null) {
                        dBCursor.close();
                    }
                }
                catch (Exception exception) {
                    if (!TRACE) break block55;
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string, exception);
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string);
        }
    }

    private void stopEntityAttribute(DBConnection dBConnection, ColumnInfo columnInfo, ColumnInfo[] columnInfoArray, int n, int n2, String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "stopEntityAttribute";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string5);
        }
        Object[] objectArray = this.getEntityAttribute(dBConnection, columnInfo, columnInfoArray, string, string2);
        Object[] objectArray2 = this.getSnapEntityAttribute(dBConnection, columnInfo, columnInfoArray, n, n2, objectArray, string, string2);
        boolean bl = false;
        int n3 = 0;
        while (objectArray != null && objectArray2 != null && n3 < objectArray.length) {
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_INFO, string5, "snap_entity_val is " + objectArray2);
            }
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_INFO, string5, "entityValue is " + objectArray);
            }
            if (objectArray2[n3] != null && objectArray[n3] != null && !objectArray2[n3].equals(objectArray[n3])) {
                bl = true;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put(columnInfoArray[n3].getName(), objectArray2[n3]);
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                hashtable2.put(columnInfoArray[n3].getName(), objectArray[n3]);
                if (TRACE) {
                    traceLogger.entry(IRecordType.TYPE_INFO, string5, String.valueOf(string) + ":" + string3 + ":" + columnInfoArray[n3].getName() + ":" + objectArray2[n3] + ":" + objectArray[n3]);
                }
                String string6 = this.deNormalizeType(columnInfoArray[n3].getTableName());
                if (iems != null) {
                    iems.handleDevicePropertyChange(string4, string6, string3, hashtable, hashtable2);
                }
            } else if (objectArray2[n3] == null ^ objectArray[n3] == null) {
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            ChangeDetection.operateSnapEntityAttribute(dBConnection, string, "update", columnInfo, columnInfoArray, string2, objectArray);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string5);
        }
    }

    public void complete(Map map) {
    }

    public void complete(DBConnection dBConnection, Map map, String string) {
        String string2;
        block7: {
            string2 = "detectChangeinAttributes";
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string2);
            }
            this.vrtu.processView(map);
            try {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3;
                    String string4 = string3 = (String)iterator.next();
                    ChangeDetectionElement changeDetectionElement = (ChangeDetectionElement)hChangeDetection.get(string3 = this.normalizeType(string3));
                    if (changeDetectionElement == null) continue;
                    List list = (List)map.get(string4);
                    int n = 0;
                    while (n < list.size()) {
                        String string5 = (String)list.get(n);
                        String string6 = this.subWwnForId(dBConnection, string3, string5);
                        if (TRACE) {
                            traceLogger.entry(IRecordType.TYPE_INFO, string2, String.valueOf(string3) + ":" + string6);
                        }
                        this.stopEntityAttribute(dBConnection, changeDetectionElement.idColumnInfo, changeDetectionElement.attributeColumnInfo, changeDetectionElement.resourceType, changeDetectionElement.attributeType, changeDetectionElement.className, string6, string5, string);
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                if (!TRACE) break block7;
                traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string2, exception);
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string2);
        }
    }

    private String subWwnForId(DBConnection dBConnection, String string, String string2) {
        String string3 = "subWwnForId";
        String string4 = string2;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string3);
        }
        if (string.equals("T_RES_FABRIC") || string.equals("T_RES_SWITCH")) {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            Vector<String> vector = new Vector<String>();
            boolean bl = string.equals("T_RES_FABRIC");
            hashtable.put(bl ? Fabric.getColumnInfo("FABRIC_ID") : Switch.getColumnInfo("SWITCH_ID"), string2);
            vector.add(bl ? "FABRIC_WWN" : "SWITCH_WWN");
            DBCursor dBCursor = null;
            try {
                try {
                    DBCursor dBCursor2 = dBCursor = bl ? Fabric.getCursor(dBConnection, hashtable, vector) : Switch.getCursor(dBConnection, hashtable, vector);
                    if (dBCursor.next()) {
                        string4 = dBCursor.getAttribute(vector)[0].toString();
                    }
                }
                catch (Exception exception) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                }
            }
            finally {
                try {
                    dBCursor.close();
                }
                catch (Exception exception) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, thisClassName, string3, exception);
                }
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string3);
        }
        return string4;
    }

    public void cancel() {
        String string = "cancel";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, thisClassName, string);
        }
        this.tokenid = -1;
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, thisClassName, string);
        }
    }
}

