/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.history.detectability.DetSvcUtils;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.history.detectability.interfaces.DetectabilityConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public final class DetSvcTableInfo
implements DetectabilityConstants {
    private static ILogger traceLogger = null;
    private static String className = DetectabilityService.class.getName();
    private static boolean TRACE = false;
    private static final int DETECTABLE = 0;
    private static final int SUBSYS_CIMOM_UPD = 1;
    private static final int SUBSYS_CIMOM_AUTH = 2;
    private static final int FABRIC_AGENT_UPD = 3;
    private static final int FABRIC_AGENT_AUTH = 4;
    private static final int SWITCH_CIMOM_UPD = 5;
    private static final int SWITCH_CIMOM_AUTH = 6;
    private static final int HAS_PROBE_STATUS = 7;
    private static final int GENERATE_EVENTS = 8;
    private static Hashtable dsTableIndex;
    private static boolean[][] DSTI;
    private static Hashtable tableToFKeyName;
    private static Hashtable tableToAutoIDName;

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
        dsTableIndex = DetSvcTableInfo.populateDSTable();
        boolean[][] blArrayArray = new boolean[46][];
        boolean[] blArray = new boolean[9];
        blArray[3] = true;
        blArray[5] = true;
        blArray[8] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[9];
        blArray2[3] = true;
        blArray2[5] = true;
        blArray2[8] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[9];
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[5] = true;
        blArrayArray[2] = blArray3;
        boolean[] blArray4 = new boolean[9];
        blArray4[1] = true;
        blArray4[5] = true;
        blArrayArray[3] = blArray4;
        boolean[] blArray5 = new boolean[9];
        blArray5[5] = true;
        blArrayArray[4] = blArray5;
        boolean[] blArray6 = new boolean[9];
        blArray6[1] = true;
        blArray6[2] = true;
        blArrayArray[5] = blArray6;
        boolean[] blArray7 = new boolean[9];
        blArray7[1] = true;
        blArray7[2] = true;
        blArray7[5] = true;
        blArray7[6] = true;
        blArrayArray[6] = blArray7;
        boolean[] blArray8 = new boolean[9];
        blArray8[1] = true;
        blArray8[2] = true;
        blArray8[8] = true;
        blArrayArray[7] = blArray8;
        boolean[] blArray9 = new boolean[9];
        blArray9[3] = true;
        blArrayArray[8] = blArray9;
        boolean[] blArray10 = new boolean[9];
        blArray10[1] = true;
        blArray10[2] = true;
        blArray10[8] = true;
        blArrayArray[9] = blArray10;
        boolean[] blArray11 = new boolean[9];
        blArray11[3] = true;
        blArray11[5] = true;
        blArray11[8] = true;
        blArrayArray[10] = blArray11;
        boolean[] blArray12 = new boolean[9];
        blArray12[3] = true;
        blArray12[5] = true;
        blArray12[8] = true;
        blArrayArray[11] = blArray12;
        boolean[] blArray13 = new boolean[9];
        blArray13[3] = true;
        blArray13[4] = true;
        blArray13[8] = true;
        blArrayArray[12] = blArray13;
        boolean[] blArray14 = new boolean[9];
        blArray14[1] = true;
        blArray14[2] = true;
        blArrayArray[13] = blArray14;
        boolean[] blArray15 = new boolean[9];
        blArray15[1] = true;
        blArray15[2] = true;
        blArray15[3] = true;
        blArray15[5] = true;
        blArray15[8] = true;
        blArrayArray[14] = blArray15;
        boolean[] blArray16 = new boolean[9];
        blArray16[3] = true;
        blArray16[8] = true;
        blArrayArray[15] = blArray16;
        boolean[] blArray17 = new boolean[9];
        blArray17[3] = true;
        blArray17[5] = true;
        blArray17[8] = true;
        blArrayArray[16] = blArray17;
        boolean[] blArray18 = new boolean[9];
        blArray18[3] = true;
        blArray18[5] = true;
        blArray18[8] = true;
        blArrayArray[17] = blArray18;
        boolean[] blArray19 = new boolean[9];
        blArray19[1] = true;
        blArray19[2] = true;
        blArrayArray[18] = blArray19;
        boolean[] blArray20 = new boolean[9];
        blArray20[1] = true;
        blArray20[2] = true;
        blArray20[8] = true;
        blArrayArray[19] = blArray20;
        boolean[] blArray21 = new boolean[9];
        blArray21[1] = true;
        blArray21[2] = true;
        blArray21[3] = true;
        blArray21[5] = true;
        blArray21[8] = true;
        blArrayArray[20] = blArray21;
        boolean[] blArray22 = new boolean[9];
        blArray22[3] = true;
        blArray22[5] = true;
        blArray22[8] = true;
        blArrayArray[21] = blArray22;
        boolean[] blArray23 = new boolean[9];
        blArray23[1] = true;
        blArray23[2] = true;
        blArrayArray[22] = blArray23;
        boolean[] blArray24 = new boolean[9];
        blArray24[1] = true;
        blArray24[2] = true;
        blArray24[8] = true;
        blArrayArray[23] = blArray24;
        boolean[] blArray25 = new boolean[9];
        blArray25[1] = true;
        blArray25[2] = true;
        blArray25[8] = true;
        blArrayArray[24] = blArray25;
        boolean[] blArray26 = new boolean[9];
        blArray26[1] = true;
        blArray26[2] = true;
        blArray26[8] = true;
        blArrayArray[25] = blArray26;
        boolean[] blArray27 = new boolean[9];
        blArray27[1] = true;
        blArray27[3] = true;
        blArray27[8] = true;
        blArrayArray[26] = blArray27;
        boolean[] blArray28 = new boolean[9];
        blArray28[1] = true;
        blArray28[2] = true;
        blArray28[8] = true;
        blArrayArray[27] = blArray28;
        boolean[] blArray29 = new boolean[9];
        blArray29[1] = true;
        blArray29[3] = true;
        blArray29[5] = true;
        blArray29[8] = true;
        blArrayArray[28] = blArray29;
        boolean[] blArray30 = new boolean[9];
        blArray30[3] = true;
        blArray30[5] = true;
        blArray30[8] = true;
        blArrayArray[29] = blArray30;
        boolean[] blArray31 = new boolean[9];
        blArray31[3] = true;
        blArray31[5] = true;
        blArray31[8] = true;
        blArrayArray[30] = blArray31;
        boolean[] blArray32 = new boolean[9];
        blArray32[1] = true;
        blArray32[2] = true;
        blArrayArray[31] = blArray32;
        boolean[] blArray33 = new boolean[9];
        blArray33[1] = true;
        blArray33[2] = true;
        blArray33[8] = true;
        blArrayArray[32] = blArray33;
        boolean[] blArray34 = new boolean[9];
        blArray34[1] = true;
        blArray34[2] = true;
        blArrayArray[33] = blArray34;
        boolean[] blArray35 = new boolean[9];
        blArray35[1] = true;
        blArray35[2] = true;
        blArrayArray[34] = blArray35;
        boolean[] blArray36 = new boolean[9];
        blArray36[1] = true;
        blArray36[8] = true;
        blArrayArray[35] = blArray36;
        boolean[] blArray37 = new boolean[9];
        blArray37[1] = true;
        blArray37[2] = true;
        blArray37[8] = true;
        blArrayArray[36] = blArray37;
        boolean[] blArray38 = new boolean[9];
        blArray38[1] = true;
        blArray38[2] = true;
        blArrayArray[37] = blArray38;
        boolean[] blArray39 = new boolean[9];
        blArray39[3] = true;
        blArray39[5] = true;
        blArray39[8] = true;
        blArrayArray[38] = blArray39;
        boolean[] blArray40 = new boolean[9];
        blArray40[3] = true;
        blArray40[5] = true;
        blArray40[8] = true;
        blArrayArray[39] = blArray40;
        boolean[] blArray41 = new boolean[9];
        blArray41[3] = true;
        blArray41[5] = true;
        blArray41[8] = true;
        blArrayArray[40] = blArray41;
        boolean[] blArray42 = new boolean[9];
        blArray42[3] = true;
        blArray42[5] = true;
        blArray42[8] = true;
        blArrayArray[41] = blArray42;
        boolean[] blArray43 = new boolean[9];
        blArray43[3] = true;
        blArray43[5] = true;
        blArray43[8] = true;
        blArrayArray[42] = blArray43;
        boolean[] blArray44 = new boolean[9];
        blArray44[3] = true;
        blArray44[5] = true;
        blArray44[8] = true;
        blArrayArray[43] = blArray44;
        boolean[] blArray45 = new boolean[9];
        blArray45[1] = true;
        blArray45[2] = true;
        blArrayArray[44] = blArray45;
        boolean[] blArray46 = new boolean[9];
        blArray46[1] = true;
        blArray46[2] = true;
        blArrayArray[45] = blArray46;
        DSTI = blArrayArray;
        DetSvcTableInfo.setDetectable();
        DetSvcTableInfo.setProbeStatus();
        tableToFKeyName = DetSvcTableInfo.populateFKeys();
        tableToAutoIDName = DetSvcTableInfo.populateAutoIDs();
    }

    private static Hashtable populateDSTable() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("T_RES_ALIAS", new Integer(0));
        hashtable.put("T_RES_ALIAS2MEMBER", new Integer(1));
        hashtable.put("T_RES_CIMKEY_PORT", new Integer(2));
        hashtable.put("T_RES_CIMKEY_VOLUME", new Integer(5));
        hashtable.put("T_RES_DATA_PATH", new Integer(7));
        hashtable.put("T_RES_DEVICE_AGENT", new Integer(8));
        hashtable.put("T_RES_DISK_GROUP", new Integer(9));
        hashtable.put("T_RES_FABRIC", new Integer(10));
        hashtable.put("T_RES_FABRIC2SWITCH", new Integer(11));
        hashtable.put("T_RES_HBA", new Integer(12));
        hashtable.put("T_RES_LPAR", new Integer(13));
        hashtable.put("T_RES_NODE", new Integer(14));
        hashtable.put("T_RES_NODE2HBA", new Integer(15));
        hashtable.put("T_RES_PE2NODE", new Integer(16));
        hashtable.put("T_RES_PHY_PE", new Integer(17));
        hashtable.put("T_RES_PHYSICAL_PACKAGE", new Integer(18));
        hashtable.put("T_RES_PHYSICAL_VOLUME", new Integer(19));
        hashtable.put("T_RES_PORT", new Integer(20));
        hashtable.put("T_RES_PORT2PORT", new Integer(21));
        hashtable.put("T_RES_REDUNDANCY", new Integer(23));
        hashtable.put("T_RES_STORAGE_EXTENT", new Integer(24));
        hashtable.put("T_RES_STORAGE_POOL", new Integer(25));
        hashtable.put("T_RES_STORAGE_SUBSYSTEM", new Integer(26));
        hashtable.put("T_RES_STORAGE_VOLUME", new Integer(27));
        hashtable.put("T_RES_SWITCH", new Integer(28));
        hashtable.put("T_RES_SWITCH_BLADE", new Integer(29));
        hashtable.put("T_RES_SWITCH2PORT", new Integer(30));
        hashtable.put("T_RES_TAPE_CARTRIDGE", new Integer(31));
        hashtable.put("T_RES_TAPE_DRIVE", new Integer(32));
        hashtable.put("T_RES_TAPE_FRAME", new Integer(33));
        hashtable.put("T_RES_TAPE_IOPORT", new Integer(34));
        hashtable.put("T_RES_TAPE_LIBRARY", new Integer(35));
        hashtable.put("T_RES_TAPE_MEDIA_CHANGER", new Integer(36));
        hashtable.put("T_RES_VOLUME2EXTENT", new Integer(37));
        hashtable.put("T_RES_ZONE", new Integer(38));
        hashtable.put("T_RES_ZONE_MEMBER", new Integer(39));
        hashtable.put("T_RES_ZONE2ALIAS", new Integer(40));
        hashtable.put("T_RES_ZONE2MEMBER", new Integer(41));
        hashtable.put("T_RES_ZSET", new Integer(42));
        hashtable.put("T_RES_ZSET2ZONE", new Integer(43));
        hashtable.put("T_RES_PHYSICALVOLUME2EXTENT", new Integer(44));
        hashtable.put("T_RES_TAPE_MEDIA_LOCATION", new Integer(45));
        return hashtable;
    }

    static void setDetectable() {
        Enumeration enumeration = dsTableIndex.keys();
        String string = null;
        int n = 0;
        Class clazz = null;
        Method method = null;
        ColumnInfo columnInfo = null;
        String string2 = "setDetectable";
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (Integer)dsTableIndex.get(string);
            clazz = DetSvcUtils.getHelperSuper(string);
            try {
                method = clazz.getDeclaredMethod("getColumnInfo", String.class);
                columnInfo = (ColumnInfo)method.invoke((Object)clazz, "DETECTABLE");
                if (columnInfo != null) {
                    DetSvcTableInfo.DSTI[n][0] = true;
                    if (!TRACE) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "Table: " + string + " has detectable set to: true");
                    continue;
                }
                DetSvcTableInfo.DSTI[n][0] = false;
                if (!TRACE) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "Table: " + string + " has detectable set to: false");
            }
            catch (Exception exception) {
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                }
                if (!TRACE) continue;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
        }
    }

    private static void setProbeStatus() {
        int n = 0;
        while (n < DSTI.length) {
            DetSvcTableInfo.DSTI[n][7] = DSTI[n][1] && !DSTI[n][2] || DSTI[n][3] && !DSTI[n][4] || DSTI[n][5] && !DSTI[n][6];
            ++n;
        }
    }

    private static Hashtable populateFKeys() {
        Hashtable hashtable = new Hashtable();
        hashtable.put(dsTableIndex.get("T_RES_REDUNDANCY"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_HBA"), "HOST_ID");
        hashtable.put(dsTableIndex.get("T_RES_STORAGE_VOLUME"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_STORAGE_POOL"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_DISK_GROUP"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_STORAGE_EXTENT"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_DATA_PATH"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_LPAR"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_FRAME"), "TAPE_LIBRARY_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_IOPORT"), "TAPE_LIBRARY_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_MEDIA_CHANGER"), "TAPE_LIBRARY_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_CARTRIDGE"), "TAPE_LIBRARY_ID");
        hashtable.put(dsTableIndex.get("T_RES_PHYSICAL_VOLUME"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_NODE"), "TAPE_LIBRARY_ID");
        hashtable.put(dsTableIndex.get("T_RES_PORT"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_DRIVE"), "TAPE_LIBRARY_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_MEDIA_LOCATION"), "TAPE_LIBRARY_ID");
        return hashtable;
    }

    public static String getFKeyName(String string) {
        Integer n = (Integer)dsTableIndex.get(string);
        return (String)tableToFKeyName.get(n);
    }

    private static Hashtable populateAutoIDs() {
        Hashtable hashtable = new Hashtable();
        hashtable.put(dsTableIndex.get("T_RES_ALIAS"), "ALIAS_ID");
        hashtable.put(dsTableIndex.get("T_RES_ALIAS2MEMBER"), "ALIAS2MEMBER_ID");
        hashtable.put(dsTableIndex.get("T_RES_CIMKEY_PORT"), "CIMKEY_PORT_ID");
        hashtable.put(dsTableIndex.get("T_RES_DEVICE_AGENT"), "DEVICE_AGENT_ID");
        hashtable.put(dsTableIndex.get("T_RES_FABRIC"), "FABRIC_ID");
        hashtable.put(dsTableIndex.get("T_RES_FABRIC2SWITCH"), "FABRIC2SWITCH_ID");
        hashtable.put(dsTableIndex.get("T_RES_NODE"), "NODE_ID");
        hashtable.put(dsTableIndex.get("T_RES_NODE2HBA"), "NODE2HBA_ID");
        hashtable.put(dsTableIndex.get("T_RES_PE2NODE"), "PE2NODE_ID");
        hashtable.put(dsTableIndex.get("T_RES_PHY_PE"), "PHY_PE_ID");
        hashtable.put(dsTableIndex.get("T_RES_PORT"), "PORT_ID");
        hashtable.put(dsTableIndex.get("T_RES_PORT2PORT"), "PORT2PORT_ID");
        hashtable.put(dsTableIndex.get("T_RES_STORAGE_SUBSYSTEM"), "SUBSYSTEM_ID");
        hashtable.put(dsTableIndex.get("T_RES_SWITCH"), "SWITCH_ID");
        hashtable.put(dsTableIndex.get("T_RES_SWITCH_BLADE"), "SWITCH_BLADE_ID");
        hashtable.put(dsTableIndex.get("T_RES_SWITCH2PORT"), "SWITCH2PORT_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_DRIVE"), "TAPE_DRIVE_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_MEDIA_CHANGER"), "TAPE_MEDIA_CHANGER_ID");
        hashtable.put(dsTableIndex.get("T_RES_TAPE_LIBRARY"), "TAPE_LIBRARY_ID");
        hashtable.put(dsTableIndex.get("T_RES_ZONE"), "ZONE_ID");
        hashtable.put(dsTableIndex.get("T_RES_ZONE_MEMBER"), "ZONE_MEMBER_ID");
        hashtable.put(dsTableIndex.get("T_RES_ZONE2ALIAS"), "ZONE2ALIAS_ID");
        hashtable.put(dsTableIndex.get("T_RES_ZONE2MEMBER"), "ZONE2MEMBER_ID");
        hashtable.put(dsTableIndex.get("T_RES_ZSET"), "ZSET_ID");
        hashtable.put(dsTableIndex.get("T_RES_ZSET2ZONE"), "ZSET2ZONE_ID");
        return hashtable;
    }

    public static String getAutoIDName(String string) {
        Integer n = (Integer)dsTableIndex.get(string);
        return (String)tableToAutoIDName.get(n);
    }

    public static boolean isDetSvcTable(String string) {
        return dsTableIndex.containsKey(string);
    }

    public static boolean isProbeStatusUpd(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][7];
        }
        return false;
    }

    public static boolean isDetectableTracked(String string) {
        String string2 = "isDetectableTracked";
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " is returning " + DSTI[n][0]);
            }
            return DSTI[n][0];
        }
        return false;
    }

    public static boolean isSubsysCIMOMScanned(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][1];
        }
        return false;
    }

    public static boolean isSubsysCIMOMAuth(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][2];
        }
        return false;
    }

    public static boolean isFabricAgentScanned(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][3];
        }
        return false;
    }

    public static boolean isFabricAgentAuth(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][4];
        }
        return false;
    }

    public static boolean isSwitchCIMOMScanned(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][5];
        }
        return false;
    }

    public static boolean isSwitchCIMOMAuth(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][6];
        }
        return false;
    }

    public static boolean isHybrid(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string2 = "isHybrid";
        if (!dsTableIndex.containsKey(string)) {
            return false;
        }
        Integer n = (Integer)dsTableIndex.get(string);
        bl = DSTI[n][1];
        bl2 = DSTI[n][3];
        bl3 = DSTI[n][5];
        bl4 = DSTI[n][2];
        bl5 = DSTI[n][4];
        bl6 = DSTI[n][6];
        if (bl && bl4 && (bl2 && !bl5 || bl3 && !bl6)) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " is returning true");
            }
            return true;
        }
        if (bl2 && bl5 && (bl && !bl4 || bl3 && !bl6)) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " is returning true");
            }
            return true;
        }
        if (bl3 && bl6 && (bl2 && !bl5 || bl && !bl4)) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " is returning true");
            }
            return true;
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " is returning false");
        }
        return false;
    }

    public static boolean isEventGen(String string) {
        if (dsTableIndex.containsKey(string)) {
            Integer n = (Integer)dsTableIndex.get(string);
            return DSTI[n][8];
        }
        return false;
    }

    public static int getMetaScannerClass(String string) {
        if (string.equals("StorageSubsystemScanType")) {
            return 100;
        }
        if (string.equals("FabricScanType")) {
            return 101;
        }
        if (string.equals("SwitchScanType")) {
            return 102;
        }
        if (string.equals("TapeScanType")) {
            return 100;
        }
        return -1;
    }

    public static short getElementType(String string) {
        return ((Integer)dsTableIndex.get(string)).shortValue();
    }
}

