/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.mapping.Dedicated;
import org.sblim.wbem.cim.CIMValue;

public class DBTableMapper {
    private static final String DEFAULT_NAMESPACE = "DEFAULT";
    private static Hashtable myDiscoveredMappings = new Hashtable();
    private static Properties myMappings;
    private static Properties myDedicated;

    static {
        myDedicated = new Properties();
        myDedicated.putAll((Map<?, ?>)Dedicated.getMap());
        myMappings = new Properties();
        myMappings.put("Class", "CIMClass");
        myMappings.put("ClassAssociation", "CIMClass");
        myMappings.put("CIM_AllocatedFromStoragePool", "Volume");
        myMappings.put("CIM_AdminDomain", "Fabric");
        myMappings.put("CIM_ContainedDomain", "Fabric");
        myMappings.put("CIM_DeviceSAPImplementation", "Port");
        myMappings.put("CIM_FCPort", "Port");
        myMappings.put("CIM_HostedStoragePool", "Pool");
        myMappings.put("CIM_ProtocolEndPoint", "ProtocolEndpoint");
        myMappings.put("CIM_StorageVolume", "Volume");
        myMappings.put("CIM_StoragePool", "Pool");
        myMappings.put("CIM_SystemDevice", "Port");
        myMappings.put("CIM_ComputerSystem", "***");
        myMappings.put("Brocade_SwitchFCPort", "CIM_FCPort");
        myMappings.put("CIM_ComputerSystem:" + Dedicated.getValue(Dedicated.STORAGE) + ":" + Dedicated.getValue(Dedicated.BLOCK_SERVER), "StorageSubsystem");
        myMappings.put("CIM_ComputerSystem:" + Dedicated.getValue(Dedicated.SWITCH), "Switch");
    }

    private DBTableMapper() {
    }

    public static void addDiscoveredMapping(String string, String string2, String string3) {
        if (string != null && string2 != null && string3 != null) {
            Hashtable<String, String> hashtable = (Hashtable<String, String>)myDiscoveredMappings.get(string3);
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            hashtable.put(string, string2);
            myDiscoveredMappings.put(string3, hashtable);
        }
    }

    public static void addDiscoveredMapping(String string, String string2) {
        DBTableMapper.addDiscoveredMapping(string, string2, DEFAULT_NAMESPACE);
    }

    public static String getLookup(String string, Hashtable hashtable) {
        String string2 = null;
        while (string2 == null && string != null) {
            string2 = (String)myMappings.get(string);
            if (string2 != null && string2.equals("***")) {
                string = DBTableMapper.generateComplexName(string, hashtable);
                string2 = null;
                continue;
            }
            string = (String)myDiscoveredMappings.get(string);
        }
        return string2;
    }

    public static String getLookup(String string, String string2) {
        return DBTableMapper.getLookup(string, string2, DEFAULT_NAMESPACE);
    }

    public static String getLookup(String string, String string2, String string3) {
        Hashtable hashtable = (Hashtable)myDiscoveredMappings.get(string3);
        String string4 = null;
        if (hashtable != null && (string4 = (String)hashtable.get(string)) == null && (string4 = (String)myMappings.get(string)) != null && string4.equals("***")) {
            string = String.valueOf(string) + ":" + string2;
            string4 = (String)myMappings.get(string);
        }
        return string4;
    }

    public static String getObjectParentName(String string) {
        return myMappings.getProperty(string);
    }

    private static String generateComplexName(String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string2 != null) {
            hashtable.put("Dedicated", string2);
            return DBTableMapper.generateComplexName(string, hashtable);
        }
        return null;
    }

    private static String generateComplexName(String string, Hashtable hashtable) {
        String[] stringArray = null;
        String string2 = null;
        Object v = hashtable.get("Dedicated");
        if (v != null) {
            if (v instanceof String) {
                string2 = String.valueOf(string) + ":" + v;
            } else {
                if (v instanceof CIMValue) {
                    CIMValue cIMValue = (CIMValue)v;
                    if (cIMValue.isArrayValue()) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        Vector vector = (Vector)cIMValue.getValue();
                        int n = 0;
                        while (n < cIMValue.getSize()) {
                            arrayList.add(vector.elementAt(n).toString());
                            ++n;
                        }
                        stringArray = arrayList.toArray(new String[0]);
                    } else {
                        stringArray = new String[]{cIMValue.toString()};
                    }
                } else if (v instanceof Vector) {
                    stringArray = ((Vector)v).toArray(new String[0]);
                } else if (v instanceof ArrayList) {
                    stringArray = ((ArrayList)v).toArray(new String[0]);
                } else {
                    try {
                        stringArray = (String[])v;
                    }
                    catch (ClassCastException classCastException) {
                        stringArray = new String[]{};
                    }
                }
                string2 = String.valueOf(string) + ":" + DBTableMapper.normalize(stringArray);
            }
        }
        return string2;
    }

    private static String normalize(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[0]);
        }
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(":");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void printHierarchy() {
        System.out.println("Known Class Hierarchy Mappings: ");
        for (String string : myMappings.keySet()) {
            System.out.println("\t" + string + " -> " + myMappings.get(string));
        }
        System.out.println("Discovered Class Hierarchy Mappings: ");
        for (String string : myDiscoveredMappings.keySet()) {
            System.out.println("\tNamespace: " + string);
            Hashtable hashtable = (Hashtable)myDiscoveredMappings.get(string);
            for (String string2 : hashtable.keySet()) {
                System.out.println("\t\t" + string2 + " -> " + hashtable.get(string2));
            }
        }
    }
}

