/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConstants;

public class MapperResult {
    Hashtable m_insertedRows = new Hashtable();
    Hashtable m_updatedRows = new Hashtable();
    Hashtable m_allNonModifiedRows = new Hashtable();
    Hashtable m_keyReferences = new Hashtable();

    public MapperResult addMapperResult(MapperResult mapperResult) {
        this.m_insertedRows.putAll(mapperResult.m_insertedRows);
        this.m_updatedRows.putAll(mapperResult.m_updatedRows);
        this.m_allNonModifiedRows.putAll(mapperResult.m_allNonModifiedRows);
        this.m_keyReferences.putAll(mapperResult.m_keyReferences);
        return this;
    }

    void addInsertedRow(String string, Hashtable hashtable) {
        this.m_insertedRows.put(string, hashtable);
    }

    void addUpdatedRow(String string, Hashtable hashtable) {
        this.m_updatedRows.put(string, hashtable);
    }

    void addNonModifiedRow(String string, Hashtable hashtable) {
        this.m_allNonModifiedRows.put(string, hashtable);
    }

    void addKeyReference(String string, ColumnInfo columnInfo) {
        try {
            Hashtable hashtable = (Hashtable)this.getAllRows().get(columnInfo.getTableName());
            String string2 = (String)hashtable.get(columnInfo);
            this.m_keyReferences.put(string, string2);
        }
        catch (Exception exception) {
            return;
        }
    }

    void addKeyReference(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.m_keyReferences.put(string, string2);
    }

    public Hashtable getInsertedRows() {
        return this.m_insertedRows;
    }

    public Hashtable getUpdatedRows() {
        return this.m_updatedRows;
    }

    public Hashtable getModifiedRows() {
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(this.m_insertedRows);
        hashtable.putAll(this.m_updatedRows);
        return hashtable;
    }

    public Hashtable getAllRows() {
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(this.m_insertedRows);
        hashtable.putAll(this.m_updatedRows);
        hashtable.putAll(this.m_allNonModifiedRows);
        return hashtable;
    }

    public Hashtable getKeyReferences() {
        return this.m_keyReferences;
    }

    public int getNoOfRowsAffected() {
        return this.getModifiedRows().size();
    }

    public static Map convertRowsToIdentifiers(Map map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Map map2 = (Map)entry.getValue();
            ColumnInfo columnInfo = DBConstants.getAutoIdColumn(string);
            if (columnInfo == null) continue;
            String string2 = (String)map2.get(columnInfo);
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

