/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimom2namespace;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageSubsystem;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlVolume2extent;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_StorageVolumeToDBMapper
extends DBAttributeMapper {
    private static final String sqlUpdateBeginning = "update T_RES_STORAGE_VOLUME set ";
    private static final String sqlInsertBeginning = "insert into T_RES_STORAGE_VOLUME (";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CIM_StorageVolume";
        String string2 = "1.0.2";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string2 = "1.0.3";
        DBAttributeMapper.RegistrationData registrationData2 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        string2 = "1.1.0";
        DBAttributeMapper.RegistrationData registrationData3 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData, registrationData2, registrationData3};
    }

    public SMISCIM_StorageVolumeToDBMapper() {
        ColumnInfo columnInfo = StorageVolume.getColumnInfo("SUBSYSTEM_ID");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = StorageVolume.getColumnInfo("SVID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", mapperInfo);
        ColumnInfo columnInfo3 = StorageVolume.getColumnInfo("NAME");
        columnInfo3.setIsPrimaryKey();
        MapperInfo mapperInfo2 = new MapperInfo(columnInfo3);
        mapperInfo2.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("name", mapperInfo2);
        ColumnInfo columnInfo4 = StorageVolume.getColumnInfo("NAME_FORMAT");
        columnInfo4.setIsPrimaryKey();
        MapperInfo mapperInfo3 = new MapperInfo(columnInfo4);
        mapperInfo3.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("nameformat", mapperInfo3);
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(StorageVolume.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put("blocksize", new MapperInfo(StorageVolume.getColumnInfo("BLOCK_SIZE")));
        this.m_htAttribToMapperInfo.put("numberofblocks", new MapperInfo(StorageVolume.getColumnInfo("NUMBER_OF_BLOCKS")));
        this.m_htAttribToMapperInfo.put("consumableblocks", new MapperInfo(StorageVolume.getColumnInfo("CONSUMABLE_BLOCKS")));
        this.m_htAttribToMapperInfo.put("DISPLAY_NAME".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("elementname", new MapperInfo(StorageVolume.getColumnInfo("ELEMENT_NAME")));
        this.m_dataConverter.addSimpleDataConversion("isbasedonunderlyingredundancy", "Boolean");
        this.m_htAttribToMapperInfo.put("isbasedonunderlyingredundancy", new MapperInfo(StorageVolume.getColumnInfo("UNDERLYING_REDUNDANCY")));
        this.m_htAttribToMapperInfo.put("throttle", new MapperInfo(StorageVolume.getColumnInfo("THROTTLE")));
        this.m_dataConverter.addCalculationDataConversion("CAPACITY".toLowerCase(), "/", "512");
        this.m_htAttribToMapperInfo.put("CAPACITY".toLowerCase(), new MapperInfo(StorageVolume.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put("serialnumber", new MapperInfo(StorageVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("ref_storagepool_id", new MapperInfo(StorageVolume.getColumnInfo("POOL_ID")));
    }

    private Hashtable generateMappings(DBConnection dBConnection, Hashtable hashtable) {
        Hashtable hashtable2 = this.generateValuesHashtable(hashtable);
        try {
            hashtable2.put(StorageVolume.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(dBConnection));
            hashtable2.put(StorageVolume.getColumnInfo("DETECTABLE"), "1");
        }
        catch (Exception exception) {}
        return hashtable2;
    }

    private void updateNameAndNameFormat(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        this.logEntry(this.myClassname, "updateNameAndNameFormat(DBConnection conn, Hashtable htValues)", new Object[]{dBConnection, hashtable});
        Object v = hashtable.get("ref_toplevelsystem_id");
        if (v != null) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string = SqlStorageVolume.getQueryString(1);
                String string2 = (String)hashtable.get("ref_system_names_id");
                if (string2 != null) {
                    string = String.valueOf(string) + " and SYSTEM_NAMES_ID = ?";
                }
                statement = dBConnection.getConnection().prepareStatement(string);
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)statement, CimkeyVolume.getColumnInfo("DEVICE_ID"), 1, hashtable.get("deviceid"));
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)statement, StorageVolume.getColumnInfo("SUBSYSTEM_ID"), 2, v);
                if (string2 != null) {
                    SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)statement, CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), 3, string2);
                }
                if ((resultSet = statement.executeQuery()).next()) {
                    hashtable.put("name", resultSet.getString("NAME"));
                    hashtable.put("nameformat", resultSet.getString("NAME_FORMAT"));
                } else {
                    this.logInfo(this.myClassname, "updateNameAndNameFormat(DBConnection conn, Hashtable htValues)", "Unable to find a name & nameformat value using query: " + string);
                }
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (statement != null) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String queryForSubsystemType(DBConnection dBConnection, String string) throws SQLException {
        this.logEntry(this.myClassname, "queryForSubsystemType(DBConnection conn, String subSystemID)", new Object[]{dBConnection, string});
        String string2 = null;
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = dBConnection.getConnection().prepareStatement(SqlStorageSubsystem.getQueryString(SqlStorageSubsystem.querySubSystemType));
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"), 1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string2 = resultSet.getString("TYPE");
                }
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (preparedStatement != null) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return string2;
    }

    private int attemptInsert(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        this.logEntry(this.myClassname, "attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID)", new Object[]{dBConnection, hashtable, string});
        if (!(hashtable.containsKey(StorageVolume.getColumnInfo("NAME")) && hashtable.containsKey(StorageVolume.getColumnInfo("NAME_FORMAT")) && hashtable.containsKey(StorageVolume.getColumnInfo("SUBSYSTEM_ID")))) {
            throw new SQLException("Values for all three elements of the primary key -- NAME, NAME_FORMAT, and SUBSYSTEM_ID -- are required.");
        }
        StringBuffer stringBuffer = new StringBuffer(sqlInsertBeginning);
        int n = AutoIdentifier.getIdentifier(1, 1);
        hashtable.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(n));
        Iterator iterator = hashtable.keySet().iterator();
        StringBuffer stringBuffer2 = new StringBuffer("values (");
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
        Vector vector2 = new Vector();
        while (iterator.hasNext()) {
            object = (ColumnInfo)iterator.next();
            stringBuffer.append(String.valueOf(((ColumnInfo)object).getName()) + ",");
            stringBuffer2.append("?,");
            vector.add((ColumnInfo)object);
            vector2.add(hashtable.get(object));
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        stringBuffer2.setCharAt(stringBuffer2.length() - 1, ')');
        stringBuffer.append(stringBuffer2);
        object = null;
        int n2 = Integer.MIN_VALUE;
        try {
            object = dBConnection.getConnection().prepareStatement(stringBuffer.toString());
            int n3 = 0;
            while (n3 < vector.size()) {
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, (ColumnInfo)vector.elementAt(n3), n3 + 1, vector2.elementAt(n3));
                ++n3;
            }
            n2 = object.executeUpdate();
            dBConnection.commit();
            try {
                Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
                hashtable2.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(n));
                DetectabilityService.tableUpdated(string, StorageVolume.getTablename(), hashtable2);
            }
            catch (Exception exception) {
                this.logException(this.myClassname, "attemptInsert", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
            }
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception exception) {}
        }
        this.logExit(this.getClass().getName(), "attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID)", new Integer(n2));
        return n2;
    }

    private int attemptUpdate(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        this.logEntry(this.myClassname, "attemptUpdate(DBConnection conn, Hashtable valueMappings)", new Object[]{dBConnection, hashtable});
        StringBuffer stringBuffer = new StringBuffer(sqlUpdateBeginning);
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
        for (ColumnInfo columnInfo : hashtable.keySet()) {
            if (columnInfo.isPrimaryKey()) continue;
            stringBuffer.append(String.valueOf(columnInfo.getName()) + " = ?,");
            vector.add(columnInfo);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(" where NAME = ? and NAME_FORMAT = ? and SUBSYSTEM_ID = ?");
        Object object = null;
        int n = -1;
        try {
            object = dBConnection.getConnection().prepareStatement(stringBuffer.toString());
            int n2 = 1;
            int n3 = 0;
            while (n3 < vector.size()) {
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, (ColumnInfo)vector.get(n3), n2++, hashtable);
                ++n3;
            }
            SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, StorageVolume.getColumnInfo("NAME"), n2++, hashtable);
            SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, StorageVolume.getColumnInfo("NAME_FORMAT"), n2++, hashtable);
            SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, StorageVolume.getColumnInfo("SUBSYSTEM_ID"), n2++, hashtable);
            n = object.executeUpdate();
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception exception) {}
        }
        this.logExit(this.getClass().getName(), "attemptUpdate(DBConnection conn, Hashtable valueMappings)", new Integer(n));
        return n;
    }

    private int getAutoId(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        int n;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block17: {
            this.logEntry(this.myClassname, "getAutoId(DBConnection conn, Hashtable valueMappings, String scanID )", new Object[]{dBConnection, hashtable, string});
            preparedStatement = null;
            resultSet = null;
            n = Integer.MIN_VALUE;
            try {
                preparedStatement = dBConnection.getConnection().prepareStatement(SqlStorageVolume.getQueryString(2));
                int n2 = 1;
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, StorageVolume.getColumnInfo("NAME"), n2++, hashtable);
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, StorageVolume.getColumnInfo("NAME_FORMAT"), n2++, hashtable);
                SMISCIM_StorageVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, StorageVolume.getColumnInfo("SUBSYSTEM_ID"), n2++, hashtable);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                    hashtable.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(n));
                    dBConnection.commit();
                    try {
                        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
                        hashtable2.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(n));
                        DetectabilityService.tableUpdated(string, StorageVolume.getTablename(), hashtable2);
                    }
                    catch (Exception exception) {
                        this.logException(this.myClassname, "getAutoId", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                    }
                    break block17;
                }
                throw new SQLException("No row was found matching NAME = " + hashtable.get("NAME") + "and NAME_FORMAT = " + hashtable.get("NAME_FORMAT") + "and SUBSYSTEM_ID = " + hashtable.get("SUBSYSTEM_ID"));
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        this.logExit(this.getClass().getName(), "getAutoId(DBConnection conn, Hashtable valueMappings, String scanID )", new Integer(n));
        return n;
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        boolean bl;
        Object object2;
        String string2;
        this.logEntry(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", new Object[]{dBConnection, hashtable, string});
        String string3 = (String)hashtable.get("DISPLAY_NAME".toLowerCase());
        if (string3 == null && (string3 = (String)hashtable.get("elementname")) != null && string3.length() > 0) {
            hashtable.put("DISPLAY_NAME".toLowerCase(), string3);
        }
        if ((string2 = (String)hashtable.get("operationalstatus")) != null) {
            object2 = SMISCIM_StorageVolumeToDBMapper.processArrayvalues(string2);
            if ((string2 = DBConstants.convertOperationalstatusArrayToBitValue((Vector)object2)) != null) {
                hashtable.put("operationalstatus", string2);
            } else {
                hashtable.remove("operationalstatus");
            }
            string2 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)object2);
            if (string2 != null) {
                hashtable.put("CONSOLIDATED_STATUS".toLowerCase(), string2);
            }
        }
        object2 = (String)hashtable.get("name");
        String string4 = (String)hashtable.get("nameformat");
        boolean bl2 = bl = object2 != null && string4 != null;
        if (object2 == null || string4 == null) {
            this.updateNameAndNameFormat(dBConnection, hashtable);
            bl = hashtable.get("name") != null && hashtable.get("nameformat") != null;
        } else {
            object = (String)hashtable.get("CAPACITY".toLowerCase());
            if (object == null) {
                try {
                    long l = Long.parseLong((String)hashtable.get("blocksize"));
                    long l2 = Long.parseLong((String)hashtable.get("numberofblocks"));
                    object = Long.toString(l * l2);
                    hashtable.put("CAPACITY".toLowerCase(), object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Wasn't able to calculate Volume Capacity");
                }
                catch (Exception exception) {
                    this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", exception, "Wasn't able to calculate Volume Capacity");
                }
            }
        }
        if (bl) {
            this.m_dataConverter.performDataConversion(hashtable);
            object = this.generateMappings(dBConnection, hashtable);
            MapperResult mapperResult = new MapperResult();
            int n = this.attemptUpdate(dBConnection, (Hashtable)object);
            if (n == 0) {
                this.attemptInsert(dBConnection, (Hashtable)object, string);
                mapperResult.addInsertedRow(StorageVolume.getTablename(), (Hashtable)object);
            } else {
                this.getAutoId(dBConnection, (Hashtable)object, string);
                mapperResult.addUpdatedRow(StorageVolume.getTablename(), (Hashtable)object);
            }
            Hashtable hashtable2 = mapperResult.getAllRows();
            String string5 = (String)((Hashtable)hashtable2.get(StorageVolume.getTablename())).get(StorageVolume.getColumnInfo("SVID"));
            hashtable.put("svid", string5);
            String string6 = (String)((Hashtable)hashtable2.get(StorageVolume.getTablename())).get(StorageVolume.getColumnInfo("SUBSYSTEM_ID"));
            hashtable.put("ssid", string6);
            SMISCimkeyVolumeToDBMapper sMISCimkeyVolumeToDBMapper = new SMISCimkeyVolumeToDBMapper();
            MapperResult mapperResult2 = sMISCimkeyVolumeToDBMapper.persist(dBConnection, hashtable, string);
            MapperResult mapperResult3 = mapperResult.addMapperResult(mapperResult2);
            mapperResult3.addKeyReference("ref_toplevelsystem_id", StorageVolume.getColumnInfo("SUBSYSTEM_ID"));
            mapperResult3.addKeyReference("ref_name", StorageVolume.getColumnInfo("NAME"));
            mapperResult3.addKeyReference("ref_name_format", StorageVolume.getColumnInfo("NAME_FORMAT"));
            mapperResult3.addKeyReference("ref_storagevolume_id", StorageVolume.getColumnInfo("SVID"));
            if (hashtable.get("ref_storageextent_id") != null) {
                Hashtable hashtable3 = mapperResult3.getAllRows();
                String string7 = (String)((Hashtable)hashtable3.get(StorageVolume.getTablename())).get(StorageVolume.getColumnInfo("SVID"));
                hashtable.put("ref_storagevolume_id", string7);
                SMISVolume2ExtentToDBMapper sMISVolume2ExtentToDBMapper = new SMISVolume2ExtentToDBMapper();
                mapperResult3.addMapperResult(sMISVolume2ExtentToDBMapper.persist(dBConnection, hashtable, string));
            }
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult3);
            return mapperResult3;
        }
        this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "No volume for the given parameters could be found");
        return new MapperResult();
    }

    private class SMISVolume2ExtentToDBMapper
    extends DBAttributeMapper {
        private static final String EXTENTCOUNT = "extentcount";
        private static final String sqlUpdateBeginning = "update T_RES_VOLUME2EXTENT set ";

        public SMISVolume2ExtentToDBMapper() {
            ColumnInfo columnInfo = Volume2extent.getColumnInfo("VOLUME_ID");
            columnInfo.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storagevolume_id", new MapperInfo(columnInfo));
            ColumnInfo columnInfo2 = Volume2extent.getColumnInfo("STORAGE_EXTENT_ID");
            columnInfo2.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_storageextent_id", new MapperInfo(columnInfo2));
            this.m_htAttribToMapperInfo.put(EXTENTCOUNT, new MapperInfo(Volume2extent.getColumnInfo("TOTAL_NUM_EXTENTS")));
        }

        private Hashtable generateMappings(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            Hashtable hashtable2 = this.generateValuesHashtable(hashtable);
            try {
                hashtable2.put(CimkeyVolume.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(dBConnection));
            }
            catch (Exception exception) {}
            return hashtable2;
        }

        private int attemptUpdate(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            StringBuffer stringBuffer = new StringBuffer(sqlUpdateBeginning);
            Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
            for (ColumnInfo columnInfo : hashtable.keySet()) {
                if (columnInfo.isPrimaryKey()) continue;
                stringBuffer.append(String.valueOf(columnInfo.getName()) + " = ?,");
                vector.add(columnInfo);
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(" where VOLUME_ID = ? and STORAGE_EXTENT_ID = ? ");
            Object object = null;
            int n = -1;
            try {
                object = dBConnection.getConnection().prepareStatement(stringBuffer.toString());
                int n2 = 1;
                int n3 = 0;
                while (n3 < vector.size()) {
                    SMISVolume2ExtentToDBMapper.setPreparedStatementParameter((PreparedStatement)object, (ColumnInfo)vector.get(n3), n2++, hashtable);
                    ++n3;
                }
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter((PreparedStatement)object, Volume2extent.getColumnInfo("VOLUME_ID"), n2++, hashtable);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter((PreparedStatement)object, Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), n2++, hashtable);
                n = object.executeUpdate();
                dBConnection.commit();
                try {
                    Hashtable hashtable2 = new Hashtable();
                    DetectabilityService.tableUpdated(string, CimkeyVolume.getTablename(), hashtable2);
                }
                catch (Exception exception) {
                    this.logException(this.myClassname, "attemptUpdate", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            catch (Throwable throwable) {
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            return n;
        }

        private int attemptInsert(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            String string2 = SqlVolume2extent.getQueryString(1);
            PreparedStatement preparedStatement = null;
            int n = Integer.MIN_VALUE;
            try {
                preparedStatement = dBConnection.getConnection().prepareStatement(string2);
                int n2 = 1;
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(preparedStatement, Volume2extent.getColumnInfo("VOLUME_ID"), n2++, hashtable);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(preparedStatement, Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), n2++, hashtable);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(preparedStatement, Volume2extent.getColumnInfo("TOTAL_NUM_EXTENTS"), n2++, hashtable);
                SMISVolume2ExtentToDBMapper.setPreparedStatementParameter(preparedStatement, Volume2extent.getColumnInfo("UPDATE_TIMESTAMP"), n2++, hashtable);
                n = preparedStatement.executeUpdate();
                dBConnection.commit();
                try {
                    Hashtable hashtable2 = new Hashtable();
                    DetectabilityService.tableUpdated(string, CimkeyVolume.getTablename(), hashtable2);
                }
                catch (Exception exception) {
                    this.logException(this.myClassname, "attemptInsert", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            return n;
        }

        public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            this.logEntry(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", new Object[]{dBConnection, hashtable, string});
            MapperResult mapperResult = new MapperResult();
            Hashtable hashtable2 = this.generateMappings(dBConnection, hashtable);
            int n = this.attemptUpdate(dBConnection, hashtable2, string);
            if (n == 0) {
                this.attemptInsert(dBConnection, hashtable2, string);
            } else {
                mapperResult.addUpdatedRow(CimkeyVolume.getTablename(), hashtable2);
            }
            this.logExit(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", mapperResult);
            return mapperResult;
        }
    }

    private class SMISCimkeyVolumeToDBMapper
    extends DBAttributeMapper {
        private static final String sqlUpdateBeginning = "update T_RES_CIMKEY_VOLUME set ";
        private final String SVID = "svid";
        private final String CIMNAMESPACEID = "cimnamespaceid";
        private final String SYSTEMNAME = "systemname";
        private final String CREATIONCLASSNAME = "creationclassname";
        private final String SYSTEMCREATIONCLASSNAME = "systemcreationclassname";
        private final String DEVICEID = "deviceid";

        public SMISCimkeyVolumeToDBMapper() {
            ColumnInfo columnInfo = CimkeyVolume.getColumnInfo("VOLUME_ID");
            columnInfo.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("svid", new MapperInfo(columnInfo));
            ColumnInfo columnInfo2 = CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID");
            columnInfo2.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("cimnamespaceid", new MapperInfo(columnInfo2));
            this.m_htAttribToMapperInfo.put("systemname", new MapperInfo(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")));
            this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put("systemcreationclassname", new MapperInfo(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")));
            this.m_htAttribToMapperInfo.put("deviceid", new MapperInfo(CimkeyVolume.getColumnInfo("DEVICE_ID")));
        }

        private int getCIMNamespaceID(DBConnection dBConnection, String string, String string2) throws SQLException {
            this.logEntry(this.myClassname, "getCIMNamespaceID(DBConnection conn, String serviceURL, String namespace)", new Object[]{dBConnection, string, string2});
            int n = Integer.MIN_VALUE;
            if (string == null || string2 == null) {
                return n;
            }
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(RegisteredCimom.getColumnInfo("SERVICE_URL"), string);
                hashtable.put(Cimom2namespace.getColumnInfo("NAMESPACE"), string2);
                statement = dBConnection.getConnection().prepareStatement(SqlCimom2namespace.getQueryString(0));
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)statement, RegisteredCimom.getColumnInfo("SERVICE_URL"), 1, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)statement, Cimom2namespace.getColumnInfo("NAMESPACE"), 2, hashtable);
                resultSet = statement.executeQuery();
                n = resultSet.next() ? resultSet.getInt(1) : Integer.MIN_VALUE;
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (statement != null) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            return n;
        }

        private Hashtable generateMappings(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            String string;
            String string2;
            String string32;
            Hashtable hashtable2 = new Hashtable();
            for (String string32 : hashtable.keySet()) {
                MapperInfo mapperInfo = (MapperInfo)this.m_htAttribToMapperInfo.get(string32.toLowerCase());
                if (mapperInfo == null) continue;
                hashtable2.put(mapperInfo.getTargetColInfo(), hashtable.get(string32));
            }
            try {
                hashtable2.put(CimkeyVolume.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(dBConnection));
            }
            catch (Exception exception) {}
            string32 = (String)hashtable.get("systemname");
            if (string32 != null) {
                short s = Normalizer.SystemNamesGetID(dBConnection, string32);
                hashtable2.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(s));
            }
            if ((string2 = (String)hashtable.get("creationclassname")) != null) {
                short s = Normalizer.CreationClassNameGetID(dBConnection, string2);
                hashtable2.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(s));
            }
            if ((string = (String)hashtable.get("systemcreationclassname")) != null) {
                short s = Normalizer.SystemCreationClassNameGetID(dBConnection, string);
                hashtable2.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(s));
            }
            return hashtable2;
        }

        private int attemptUpdate(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            StringBuffer stringBuffer = new StringBuffer(sqlUpdateBeginning);
            Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
            for (ColumnInfo columnInfo : hashtable.keySet()) {
                if (columnInfo.isPrimaryKey()) continue;
                stringBuffer.append(String.valueOf(columnInfo.getName()) + " = ?,");
                vector.add(columnInfo);
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(" where VOLUME_ID = ? and CIM_NAMESPACE_ID = ?");
            Object object = null;
            int n = -1;
            try {
                object = dBConnection.getConnection().prepareStatement(stringBuffer.toString());
                int n2 = 1;
                int n3 = 0;
                while (n3 < vector.size()) {
                    SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, (ColumnInfo)vector.get(n3), n2++, hashtable);
                    ++n3;
                }
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, CimkeyVolume.getColumnInfo("VOLUME_ID"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter((PreparedStatement)object, CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), n2++, hashtable);
                n = object.executeUpdate();
                dBConnection.commit();
                try {
                    Hashtable hashtable2 = new Hashtable();
                    DetectabilityService.tableUpdated(string, CimkeyVolume.getTablename(), hashtable2);
                }
                catch (Exception exception) {
                    this.logException(this.myClassname, "attemptUpdate", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            catch (Throwable throwable) {
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            return n;
        }

        private int attemptInsert(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            String string2 = SqlCimkeyVolume.getQueryString(0);
            PreparedStatement preparedStatement = null;
            int n = Integer.MIN_VALUE;
            try {
                preparedStatement = dBConnection.getConnection().prepareStatement(string2);
                int n2 = 1;
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("VOLUME_ID"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("DEVICE_ID"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("ACTIVE"), n2++, hashtable);
                SMISCimkeyVolumeToDBMapper.setPreparedStatementParameter(preparedStatement, CimkeyVolume.getColumnInfo("UPDATE_TIMESTAMP"), n2++, hashtable);
                n = preparedStatement.executeUpdate();
                dBConnection.commit();
                try {
                    Hashtable hashtable2 = new Hashtable();
                    DetectabilityService.tableUpdated(string, CimkeyVolume.getTablename(), hashtable2);
                }
                catch (Exception exception) {
                    this.logException(this.myClassname, "attemptInsert", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                }
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            return n;
        }

        public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            this.logEntry(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", new Object[]{dBConnection, hashtable, string});
            int n = this.getCIMNamespaceID(dBConnection, (String)hashtable.get("ref_serviceurl"), (String)hashtable.get("ref_namespace"));
            if (n != Integer.MIN_VALUE) {
                hashtable.put("cimnamespaceid", String.valueOf(n));
            }
            MapperResult mapperResult = new MapperResult();
            Hashtable hashtable2 = this.generateMappings(dBConnection, hashtable);
            int n2 = this.attemptUpdate(dBConnection, hashtable2, string);
            if (n2 == 0) {
                this.attemptInsert(dBConnection, hashtable2, string);
            } else {
                mapperResult.addUpdatedRow(CimkeyVolume.getTablename(), hashtable2);
            }
            this.logExit(this.myClassname, "persist(DBConnection conn, Hashtable htValues, String scanID )", mapperResult);
            return mapperResult;
        }
    }
}

