/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.sql.SqlDataPath;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISDataPathToDBMapper
extends DBAttributeMapper {
    private static final String sqlUpdateBeginning = "update T_RES_DATA_PATH set ";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "DataPath";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMISDataPathToDBMapper() {
        Object object;
        Vector<String> vector = new Vector<String>();
        vector.add("DEVICE_LUN_ID");
        vector.add("HOST_LUN_ID");
        vector.add("UNKNOWN_HOST_NAME");
        int n = 0;
        while (n < vector.size()) {
            object = DataPath.getColumnInfo((String)vector.elementAt(n));
            MapperInfo mapperInfo = new MapperInfo((ColumnInfo)object);
            this.m_htAttribToMapperInfo.put(((String)vector.elementAt(n)).toLowerCase(), mapperInfo);
            ++n;
        }
        ColumnInfo columnInfo = DataPath.getColumnInfo("DATA_PATH_ID");
        columnInfo.setAutoGenerated();
        object = new Vector();
        ((Vector)object).add("INITIATOR_PORT_ID");
        ((Vector)object).add("TARGET_PORT_ID");
        ((Vector)object).add("VOLUME_ID");
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            ColumnInfo columnInfo2 = DataPath.getColumnInfo((String)((Vector)object).elementAt(n2));
            columnInfo2.setIsPrimaryKey();
            MapperInfo mapperInfo = new MapperInfo(columnInfo2);
            mapperInfo.setDerivedColumn(columnInfo);
            this.m_htAttribToMapperInfo.put(((String)((Vector)object).elementAt(n2)).toLowerCase(), mapperInfo);
            ++n2;
        }
        this.m_htAttribToMapperInfo.put("ref_masking_info_id", new MapperInfo(DataPath.getColumnInfo("MASKING_INFO_ID")));
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(DataPath.getColumnInfo("SUBSYSTEM_ID")));
        ColumnInfo columnInfo3 = DataPath.getColumnInfo("VOLUME_ID");
        columnInfo3.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_storagevolume_id", new MapperInfo(columnInfo3));
    }

    private Hashtable generateMappings(DBConnection dBConnection, Hashtable hashtable) {
        Hashtable hashtable2 = this.generateValuesHashtable(hashtable);
        try {
            hashtable2.put(DataPath.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(dBConnection));
        }
        catch (Exception exception) {}
        return hashtable2;
    }

    private int attemptInsert(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        String string2 = SqlDataPath.getQueryString(SqlDataPath.mapperInsert);
        int n = AutoIdentifier.getIdentifier(1, 1);
        hashtable.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(n));
        PreparedStatement preparedStatement = null;
        int n2 = -1;
        try {
            preparedStatement = dBConnection.getConnection().prepareStatement(string2);
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("HOST_LUN_ID"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("DEVICE_LUN_ID"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("INITIATOR_PORT_ID"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("TARGET_PORT_ID"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("VOLUME_ID"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("UNKNOWN_HOST_NAME"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("UPDATE_TIMESTAMP"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("MASKING_INFO_ID"), n3++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("SUBSYSTEM_ID"), n3++, hashtable);
            n2 = preparedStatement.executeUpdate();
            dBConnection.commit();
            try {
                Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
                hashtable2.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(n));
                DetectabilityService.tableUpdated(string, DataPath.getTablename(), hashtable2);
            }
            catch (Exception exception) {
                this.logException(this.myClassname, "attemptInsert", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
            }
        }
        catch (Throwable throwable) {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    private int attemptUpdate(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(sqlUpdateBeginning);
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
        for (ColumnInfo columnInfo : hashtable.keySet()) {
            stringBuffer.append(String.valueOf(columnInfo.getName()) + " = ?,");
            vector.add(columnInfo);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(" where INITIATOR_PORT_ID = ? and TARGET_PORT_ID = ? and VOLUME_ID = ?");
        Object object = null;
        int n = -1;
        try {
            object = dBConnection.getConnection().prepareStatement(stringBuffer.toString());
            int n2 = 1;
            int n3 = 0;
            while (n3 < vector.size()) {
                SMISDataPathToDBMapper.setPreparedStatementParameter((PreparedStatement)object, (ColumnInfo)vector.get(n3), n2++, hashtable);
                ++n3;
            }
            SMISDataPathToDBMapper.setPreparedStatementParameter((PreparedStatement)object, DataPath.getColumnInfo("INITIATOR_PORT_ID"), n2++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter((PreparedStatement)object, DataPath.getColumnInfo("TARGET_PORT_ID"), n2++, hashtable);
            SMISDataPathToDBMapper.setPreparedStatementParameter((PreparedStatement)object, DataPath.getColumnInfo("VOLUME_ID"), n2++, hashtable);
            n = object.executeUpdate();
        }
        catch (Throwable throwable) {
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    private int getAutoId(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        int n;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block17: {
            preparedStatement = null;
            resultSet = null;
            n = -1;
            try {
                preparedStatement = dBConnection.getConnection().prepareStatement(SqlDataPath.getQueryString(SqlDataPath.mapperRetrieveAutoId));
                int n2 = 1;
                SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("INITIATOR_PORT_ID"), n2++, hashtable);
                SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("TARGET_PORT_ID"), n2++, hashtable);
                SMISDataPathToDBMapper.setPreparedStatementParameter(preparedStatement, DataPath.getColumnInfo("VOLUME_ID"), n2++, hashtable);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                    hashtable.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(n));
                    dBConnection.commit();
                    try {
                        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
                        hashtable2.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(n));
                        DetectabilityService.tableUpdated(string, DataPath.getTablename(), hashtable2);
                    }
                    catch (Exception exception) {
                        this.logException(this.myClassname, "getAutoId", exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                    }
                    break block17;
                }
                throw new SQLException("No row was found matching INITIATOR_PORT_ID = " + hashtable.get("INITIATOR_PORT_ID") + "and TARGET_PORT_ID = " + hashtable.get("TARGET_PORT_ID") + "and VOLUME_ID = " + hashtable.get("VOLUME_ID"));
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        Object[] objectArray = new Object[]{dBConnection, hashtable, string};
        this.logEntry(this.myClassname, string2, objectArray);
        Hashtable hashtable2 = this.generateMappings(dBConnection, hashtable);
        if (hashtable2 == null) {
            throw new SQLException("None of the discovered data provided to the mapper mapped to a database column, so nothing was done.");
        }
        MapperResult mapperResult = new MapperResult();
        try {
            this.attemptInsert(dBConnection, hashtable2, string);
            mapperResult.addInsertedRow("T_RES_DATA_PATH", hashtable2);
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("23505")) {
                hashtable2.remove(DataPath.getColumnInfo("DATA_PATH_ID"));
                this.attemptUpdate(dBConnection, hashtable2);
                this.getAutoId(dBConnection, hashtable2, string);
                mapperResult.addUpdatedRow("T_RES_DATA_PATH", hashtable2);
            }
            System.out.println("Got an exception in insert! ");
            sQLException.printStackTrace();
        }
        this.logExit(this.myClassname, string2, mapperResult);
        return mapperResult;
    }
}

