/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_DiskDriveToDBMapper;

public class SMISONTAP_DiskDriveToDBMapper
extends SMISCIM_DiskDriveToDBMapper {
    public static final String CR = "(C) Copyright IBM Corp. 2005.";
    protected final String NETAPP = "NETWORK APPLIANCE";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "ONTAP_DiskDrive";
        String string2 = "1.1.0";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMISONTAP_DiskDriveToDBMapper() {
        this.m_htAttribToMapperInfo.put("serialnumber", new MapperInfo(PhysicalVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("capacity", new MapperInfo(PhysicalVolume.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put("displayname", new MapperInfo(PhysicalVolume.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("subsystemserialno", new MapperInfo(PhysicalVolume.getColumnInfo("SUBSYSTEM_SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("devicetype", new MapperInfo(PhysicalVolume.getColumnInfo("DEVICE_TYPE")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        hashtable.put("model", "NETWORK APPLIANCE");
        hashtable.put("manufacturer", "NETWORK APPLIANCE");
        hashtable.put("devicetype", "0");
        String string2 = (String)hashtable.get("deviceid");
        String string3 = " ";
        int n = string2.lastIndexOf(":") + 1;
        if (n != -1) {
            string3 = string2.substring(n);
        }
        hashtable.put("displayname", string3);
        String string4 = (String)hashtable.get("ref_toplevelsystem_name");
        String string5 = " ";
        hashtable.put("subsystemserialno", string5);
        if (string4 != null) {
            n = string4.lastIndexOf(":") + 1;
            string5 = string4.substring(n);
            if (n != -1) {
                hashtable.put("subsystemserialno", string5);
            }
        }
        this.fixup_deviceId(dBConnection, hashtable);
        String string6 = (String)hashtable.get("deviceid");
        if (string6 != null) {
            hashtable.put("serialnumber", this.prep_serialno(string6, string5));
        } else {
            hashtable.put("serialnumber", "Not in CIM XML");
        }
        this.get_capacity(dBConnection, hashtable);
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
        return mapperResult;
    }

    private void fixup_deviceId(DBConnection dBConnection, Hashtable hashtable) {
        block25: {
            int n;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block22: {
                block23: {
                    this.logEntry(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
                    preparedStatement = null;
                    resultSet = null;
                    string5 = " ";
                    String string6 = "select * from T_RES_PHYSICAL_VOLUME where SERIAL_NUMBER = ?";
                    string4 = "update T_RES_PHYSICAL_VOLUME set DEVICE_ID = ?, SYSTEM_NAMES_ID = ?, SUBSYSTEM_ID = ? where SERIAL_NUMBER = ?";
                    String string7 = (String)hashtable.get("displayname");
                    String string8 = (String)hashtable.get("subsystemserialno");
                    string3 = (String)hashtable.get("deviceid");
                    string2 = (String)hashtable.get("ref_system_names_id");
                    string = (String)hashtable.get("ref_toplevelsystem_id");
                    if (string3 == null) {
                        this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "deviceId from SMIS is not present");
                        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
                        return;
                    }
                    if (string8 == null) {
                        this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "subsystem serial number from SMIS is not present");
                        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
                        return;
                    }
                    if (string7 == null) {
                        this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "device name from SMIS is not present");
                        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
                        return;
                    }
                    if (string2 == null) {
                        this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "system name from SMIS is not present");
                        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
                        return;
                    }
                    if (string == null) {
                        this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "subsystem Id from SMIS is not present");
                        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
                        return;
                    }
                    if (string7 != null && string8 != null) {
                        string5 = String.valueOf(string8) + "/" + string7 + ":" + "NETWORK APPLIANCE";
                    }
                    preparedStatement = dBConnection.getConnection().prepareStatement(string6);
                    n = 1;
                    preparedStatement.setString(n, string5);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next() || !resultSet.next()) break block22;
                    this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "More than 1 disk drive record matched");
                    this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
                    if (preparedStatement == null) break block23;
                    try {
                        resultSet.close();
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                return;
            }
            try {
                try {
                    n = 1;
                    preparedStatement = dBConnection.getConnection().prepareStatement(string4);
                    preparedStatement.setString(n, string3);
                    preparedStatement.setString(++n, string2);
                    preparedStatement.setString(++n, string);
                    preparedStatement.setString(++n, string5);
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    this.logException(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", sQLException, "Error retrieving capacity from storage extent table, continue without saving capacity.");
                }
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    try {
                        resultSet.close();
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (preparedStatement != null) {
                try {
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            break block25;
            if (preparedStatement != null) {
                try {
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{dBConnection, hashtable});
    }

    /*
     * Unable to fully structure code
     */
    private void get_capacity(DBConnection var1_1, Hashtable var2_2) {
        block15: {
            this.logEntry(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
            var3_3 = null;
            var4_4 = null;
            var5_5 = (String)var2_2.get("deviceid");
            var6_6 = "select TOTAL_CAPACITY from T_RES_STORAGE_EXTENT where DEVICE_ID = ? and SUBSYSTEM_ID = ?";
            var3_3 = var1_1.getConnection().prepareStatement(var6_6);
            var7_7 = 1;
            var3_3.setString(var7_7, var5_5.substring(var5_5.lastIndexOf(":") + 1));
            var8_9 = (String)var2_2.get("ref_toplevelsystem_id");
            var3_3.setInt(++var7_7, Integer.parseInt(var8_9));
            var4_4 = var3_3.executeQuery();
            if (!var4_4.next()) ** GOTO lbl34
            var7_7 = 1;
            var9_10 = var4_4.getLong(var7_7);
            if (!var4_4.next()) break block15;
            this.logInfo(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", "More than 1 storage extent record matched");
            this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
lbl19:
            // 3 sources

            while (true) {
                if (var3_3 != null) {
                    try {
                        var4_4.close();
                        var3_3.close();
                    }
                    catch (Exception v0) {}
                }
                return;
            }
        }
        try {
            try {
                var2_2.put("capacity", String.valueOf(var9_10));
                this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                ** GOTO lbl19
lbl34:
                // 1 sources

                this.logInfo(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", "Did not get a matchin storage extent record");
                this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                ** continue;
            }
            catch (SQLException var7_8) {
                this.logException(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", var7_8, "Error retrieving capacity from storage extent table, continue without saving capacity.");
            }
        }
        catch (Throwable var11_11) {
            if (var3_3 != null) {
                try {
                    var4_4.close();
                    var3_3.close();
                }
                catch (Exception v1) {}
            }
            throw var11_11;
        }
        if (var3_3 != null) {
            try {
                var4_4.close();
                var3_3.close();
            }
            catch (Exception v2) {}
        }
        this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
    }

    /*
     * Enabled aggressive block sorting
     */
    private String prep_serialno(String string, String string2) {
        this.logEntry(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(":");
        if (n3 == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
            return "Missing 1st :";
        }
        if ((n = string.indexOf(":", ++n3)) == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
            return "Missing 2nd :";
        }
        n2 = string.indexOf(":", n + 1);
        if (n2 == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
            return "Missing 3rd :";
        }
        String string3 = String.valueOf(string2) + "/" + string.substring(++n2) + ":NETWORK APPLIANCE";
        this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
        return string3;
    }
}

