/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogFileHandler;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

class LogFileReader {
    static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    private static final String className = LogFileHandler.class.getName();
    public static byte FORWARD = 1;
    public static byte BACKWARDS = (byte)-1;
    private static byte DEFAULT_POS = (byte)-1;
    private static String NEW_LINE = System.getProperty("line.separator");
    static final char UNIX_FILE_SEPARATOR = '/';
    static final char WINDOWS_FILE_SEPARATOR = '\\';
    static final int NOT_FOUND = -1;
    private static long startFilePosition = 0L;
    protected static byte status = 1;
    private static long initialFilePosition = 0L;
    private static long filePosition = -1L;
    protected static int foundIndex;
    protected static int foundOffset;
    private static boolean eof;

    static {
        eof = false;
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }

    LogFileReader() {
    }

    protected static String[] readFile(String string) throws FileNotFoundException {
        String string2 = "readFile";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        try {
            try {
                String string3;
                String string4 = LogFileReader.getFileName(string);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));
                while ((string3 = bufferedReader.readLine()) != null) {
                    arrayList.add(String.valueOf(string3) + NEW_LINE);
                }
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, iOException);
                }
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
            }
        }
        return stringArray;
    }

    protected static String[] getDesiredString(String[] stringArray, byte by, LogFilePos logFilePos, int n) {
        String string = "getDesiredString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = logFilePos.offset;
        int n2 = stringArray.length;
        if (l == (long)DEFAULT_POS) {
            if (by == BACKWARDS) {
                int n3 = 0;
                n3 = n < n2 ? n2 - n : 0;
                int n4 = n3;
                while (n4 < n2) {
                    arrayList.add(stringArray[n4]);
                    ++n4;
                }
                logFilePos.offset = n3;
            } else {
                int n5 = n2;
                n5 = n > n2 ? n2 : n;
                int n6 = 0;
                while (n6 < n5) {
                    arrayList.add(stringArray[n6]);
                    ++n6;
                }
                logFilePos.offset = n5;
            }
        } else if (by == BACKWARDS) {
            long l2 = 0L;
            l2 = (long)n > l ? 0L : l - (long)n;
            long l3 = l2;
            while (l3 < l) {
                arrayList.add(stringArray[(int)l3]);
                ++l3;
            }
            logFilePos.offset = l2;
        } else {
            long l4 = (long)n + l;
            if (l4 > (long)n2) {
                l4 = n2;
            }
            long l5 = l;
            while (l5 < l4) {
                arrayList.add(stringArray[(int)l5]);
                ++l5;
            }
            logFilePos.offset = l4;
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return stringArray2;
    }

    protected static String[] getDesiredString(String[] stringArray, byte by, LogFilePos logFilePos, String string, int n) {
        long l;
        String string2 = "getDesiredString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        long l2 = logFilePos.offset;
        int n2 = stringArray.length;
        if (l2 == (long)DEFAULT_POS) {
            if (by == BACKWARDS) {
                l = 0L;
                l2 = LogFileReader.searchBackwards(stringArray, n2 - 1, string);
                l = (long)n > l2 ? 0L : l2 - (long)n + 1L;
                long l3 = l;
                while (l3 <= l2) {
                    arrayList.add(stringArray[(int)l3]);
                    ++l3;
                }
                logFilePos.offset = l;
            } else {
                l2 = LogFileReader.searchForward(stringArray, 0, string);
                l = (long)n + l2;
                long l4 = l2;
                long l5 = 0L;
                while (l4 < l) {
                    arrayList.add(stringArray[(int)l4]);
                    ++l4;
                    ++l5;
                }
                logFilePos.offset = l;
            }
        } else if (by == BACKWARDS) {
            l = 0L;
            l = (long)n > (l2 = (long)LogFileReader.searchBackwards(stringArray, n2 - (int)l2, string)) ? 0L : l2 - (long)n + 1L;
            long l6 = l;
            while (l6 <= l2) {
                arrayList.add(stringArray[(int)l6]);
                ++l6;
            }
            System.out.println("Test - String was found at line " + l2);
            logFilePos.offset = l;
        } else {
            l2 = LogFileReader.searchForward(stringArray, (int)l2, string);
            l = (long)n + l2;
            long l7 = l2;
            long l8 = 0L;
            while (l7 < l) {
                arrayList.add(stringArray[(int)l7]);
                ++l7;
                ++l8;
            }
            logFilePos.offset = l;
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return stringArray2;
    }

    protected static int searchForward(String[] stringArray, int n, String string) {
        String string2 = "searchForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        int n2 = string.length();
        int n3 = n;
        int n4 = 0;
        boolean bl = true;
        while (bl && n3 < stringArray.length) {
            String string3 = stringArray[n3];
            int n5 = string3.length() - n2;
            n4 = 0;
            while (bl && n4 <= n5) {
                if (string3.regionMatches(true, n4, string, 0, n2)) {
                    bl = false;
                    continue;
                }
                ++n4;
            }
            if (!bl) continue;
            ++n3;
        }
        if (bl) {
            n3 = -1;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return n3;
    }

    protected static int searchBackwards(String[] stringArray, int n, String string) {
        String string2 = "searchBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        int n2 = string.length();
        int n3 = n;
        int n4 = 0;
        boolean bl = true;
        while (bl && n3 >= 0) {
            String string3 = stringArray[n3];
            int n5 = string3.length() - n2;
            n4 = 0;
            if (string3.toLowerCase().lastIndexOf(string.toLowerCase()) != -1) {
                bl = false;
            }
            while (bl && n4 >= n5) {
                if (string3.regionMatches(true, n4, string, 0, n2)) {
                    bl = false;
                    continue;
                }
                --n4;
            }
            if (!bl) continue;
            --n3;
        }
        if (bl) {
            n3 = -1;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return n3;
    }

    protected static String getFileName(String string) {
        String string2 = string;
        char c = File.separatorChar;
        boolean bl = true;
        if (string.indexOf(47) != -1 || string.indexOf(92) != -1) {
            string2 = string2.replace('/', c);
            string2 = string2.replace('\\', c);
            bl = false;
        }
        if (bl) {
            String string3 = Variables.getBaseDirectory();
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(c);
            stringBuffer.append("log");
            stringBuffer.append(c);
            stringBuffer.append(string2);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    protected static String[] readForward(String string, LogFilePos logFilePos, String string2, int n) throws FileNotFoundException {
        String string3 = "readForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
        }
        filePosition = logFilePos.offset;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        long l = 0L;
        int n2 = n;
        try {
            try {
                String string4;
                int n3;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                if (logFilePos.offset != (long)DEFAULT_POS) {
                    l = bufferedReader.skip(logFilePos.offset);
                }
                startFilePosition = l;
                if (string2 != null) {
                    n3 = -1;
                    while ((string4 = bufferedReader.readLine()) != null) {
                        n3 = string4.toLowerCase().indexOf(string2.toLowerCase());
                        if (n3 != -1) {
                            status = 0;
                            string4 = string4.substring(n3);
                            arrayList.add(String.valueOf(string4) + NEW_LINE);
                            --n2;
                            filePosition += (long)(string4.length() + NEW_LINE.length());
                            break;
                        }
                        filePosition += (long)(string4.length() + NEW_LINE.length());
                    }
                }
                n3 = 0;
                while (n3 < n2) {
                    string4 = bufferedReader.readLine();
                    if (string4 == null) break;
                    arrayList.add(String.valueOf(string4) + NEW_LINE);
                    filePosition += (long)(string4.length() + NEW_LINE.length());
                    ++n3;
                }
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, iOException);
                }
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        return stringArray;
    }

    protected static String[] readBackwards(String string, LogFilePos logFilePos, String string2, int n) throws FileNotFoundException {
        String string3 = "readBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
        }
        filePosition = logFilePos.offset;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        long l = 0L;
        try {
            try {
                int n2;
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                while ((string4 = bufferedReader.readLine()) != null) {
                    string4 = String.valueOf(string4) + NEW_LINE;
                    if (arrayList.size() > n && string2 == null) {
                        arrayList.remove(0);
                    }
                    if (logFilePos.offset != (long)DEFAULT_POS && l + (long)string4.length() >= logFilePos.offset) {
                        string4 = string4.substring(0, (int)(logFilePos.offset - l));
                        arrayList.add(string4);
                        l += (long)string4.length();
                        break;
                    }
                    l += (long)string4.length();
                    arrayList.add(string4);
                }
                if (arrayList.size() > n && string2 == null) {
                    arrayList.remove(0);
                }
                if (string2 != null) {
                    n2 = -1;
                    String string5 = null;
                    int n3 = 0;
                    n3 = arrayList.size() - 1;
                    while (n3 >= 0) {
                        string5 = (String)arrayList.get(n3);
                        n2 = string5.toLowerCase().lastIndexOf(string2.toLowerCase());
                        if (n2 != -1) {
                            status = 0;
                            l -= (long)string5.length();
                            string5 = string5.substring(0, n2 + string2.length());
                            l += (long)string5.length();
                            arrayList.set(n3, string5);
                            break;
                        }
                        l -= (long)string5.length();
                        arrayList.remove(n3);
                        --n3;
                    }
                    n3 -= n;
                    while (n3-- >= 0) {
                        arrayList.remove(0);
                    }
                }
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                n2 = 0;
                while (n2 < stringArray.length) {
                    l -= (long)stringArray[n2].length();
                    ++n2;
                }
                filePosition = l;
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string3, iOException);
                }
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        return stringArray;
    }

    private static String[] readForward(String string, LogFilePos logFilePos, int n) throws FileNotFoundException {
        String string2 = "readForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        filePosition = logFilePos.offset;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        long l = 0L;
        int n2 = n;
        try {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                if (logFilePos.offset != (long)DEFAULT_POS) {
                    l = bufferedReader.skip(logFilePos.offset);
                } else {
                    filePosition = 0L;
                }
                initialFilePosition = l;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = bufferedReader.readLine();
                    if (string3 == null) {
                        eof = true;
                        break;
                    }
                    arrayList.add(String.valueOf(string3) + NEW_LINE);
                    filePosition += (long)(string3.length() + NEW_LINE.length());
                    ++n3;
                }
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                status = 0;
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            System.out.println("out of readFile");
        }
        return stringArray;
    }

    private static String[] searchForward(String string, LogFilePos logFilePos, String string2, int n) throws FileNotFoundException {
        String string3 = "searchForward";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
        }
        int n2 = -1;
        String[] stringArray = null;
        eof = false;
        while (!eof) {
            stringArray = LogFileReader.readForward(string, logFilePos, n);
            int n3 = 0;
            while (n3 < stringArray.length) {
                n2 = stringArray[n3].toLowerCase().indexOf(string2.toLowerCase());
                if (n2 != -1) {
                    foundOffset = n2;
                    foundIndex = n3;
                    break;
                }
                ++n3;
            }
            if (n2 != -1) break;
            logFilePos.offset = filePosition;
        }
        if (n2 == -1) {
            status = 1;
        }
        return stringArray;
    }

    private static String[] readBackwards(String string, LogFilePos logFilePos, int n) throws FileNotFoundException {
        String string2 = "readBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        filePosition = logFilePos.offset;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        long l = 0L;
        try {
            try {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                while ((string3 = bufferedReader.readLine()) != null) {
                    string3 = String.valueOf(string3) + NEW_LINE;
                    if (arrayList.size() > n) {
                        initialFilePosition = l - (long)((String)arrayList.get(0)).length();
                        arrayList.remove(0);
                    }
                    if (logFilePos.offset != (long)DEFAULT_POS && l + (long)string3.length() >= logFilePos.offset) {
                        string3 = string3.substring(0, (int)(logFilePos.offset - l));
                        arrayList.add(string3);
                        l += (long)string3.length();
                        break;
                    }
                    l += (long)string3.length();
                    arrayList.add(string3);
                }
                if (string3 == null) {
                    eof = true;
                }
                if (arrayList.size() > n) {
                    initialFilePosition = l - (long)((String)arrayList.get(0)).length();
                    arrayList.remove(0);
                }
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                filePosition = l;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    l -= (long)stringArray[n2].length();
                    ++n2;
                }
                initialFilePosition = l;
                status = 0;
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string2, iOException);
                }
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
            }
        }
        return stringArray;
    }

    private static String[] searchBackwards(String string, LogFilePos logFilePos, String string2, int n) throws FileNotFoundException {
        String string3 = "searchBackwards";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
        }
        int n2 = -1;
        String[] stringArray = null;
        eof = false;
        try {
            while (!eof) {
                stringArray = LogFileReader.readBackwards(string, logFilePos, n);
                int n3 = stringArray.length - 1;
                while (n3 >= 0) {
                    n2 = stringArray[n3].toLowerCase().lastIndexOf(string2.toLowerCase());
                    if (n2 != -1) {
                        foundOffset = n2;
                        foundIndex = n3;
                        break;
                    }
                    --n3;
                }
                if (n2 != -1) break;
                logFilePos.offset = filePosition;
            }
            if (n2 == -1) {
                status = 1;
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        return stringArray;
    }

    protected static String[] read(String string, byte by, LogFilePos logFilePos, String string2, int n) throws FileNotFoundException {
        String string3 = "read";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
        }
        String[] stringArray = new String[n];
        try {
            String string4 = LogFileReader.getFileName(string);
            if (string2 == null) {
                if (by == FORWARD) {
                    stringArray = LogFileReader.readForward(string4, logFilePos, n);
                } else if (by == BACKWARDS) {
                    stringArray = LogFileReader.readBackwards(string4, logFilePos, n);
                }
            } else if (by == FORWARD) {
                stringArray = LogFileReader.searchForward(string4, logFilePos, string2, n);
            } else if (by == BACKWARDS) {
                stringArray = LogFileReader.searchBackwards(string4, logFilePos, string2, n);
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string3);
            }
        }
        return stringArray;
    }

    protected static long getFilePosition() {
        return filePosition;
    }

    protected static long getInitialFilePosition() {
        return initialFilePosition;
    }
}

