/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.util;

public class InterpResolver {
    private static final long serialVersionUID = 20001130L;
    public static final String sunos = "SunOS";
    public static final String solaris = "Solaris";
    public static final String linux = "Linux";
    public static final String aix = "AIX";
    public static final String winnt = "Windows NT";
    public static final String win2k = "Windows 2000";
    public static final String winxp = "Windows XP";
    public static final String ppc = "ppc";
    public static final String intel = "i386";
    public static final String wintel = "x86";
    public static final String unknown = "unknown";
    public static final String sunos4 = "sunos4";
    public static final String solaris2 = "solaris2";
    public static final String aix3 = "aix3-r2";
    public static final String aix4 = "aix4-r1";
    public static final String aix5 = "aix";
    public static final String linuxix86 = "linux-ix86";
    public static final String w32ix86 = "w32-ix86";

    public static String getInterp() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        String string3 = System.getProperty("os.arch");
        return InterpResolver.getInterp(string, string2, string3);
    }

    public static String getInterp(String string, String string2, String string3) {
        if (string.equals(sunos) || string.equals(solaris)) {
            return solaris2;
        }
        if (string.equals(aix)) {
            return aix5;
        }
        if (InterpResolver.isLinux(string)) {
            return linuxix86;
        }
        if (InterpResolver.isWindows(string)) {
            return w32ix86;
        }
        return unknown;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return InterpResolver.isWindows(string);
    }

    public static boolean isWindows(String string) {
        boolean bl = false;
        if (string.indexOf("windows") != -1 || string.indexOf("Windows") != -1 || string.indexOf("WINDOWS") != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isLinux(String string) {
        boolean bl = false;
        if (string.equals(linux)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAIX(String string) {
        boolean bl = false;
        if (string.equals(aix5)) {
            bl = true;
        }
        return bl;
    }
}

