/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.server.guireq.AlertEmail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertDefinition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 7547461129608221481L;
    public int aldAlertID;
    public String aldCreator;
    private String aldName;
    public String aldDescription;
    public String aldNotifyOnLogin;
    public AlertEmail aldEmailDef;
    public boolean aldEnabled;
    public short aldProductID;
    public short aldType;
    public short aldCondition;
    public byte aldThresholdType;
    public int aldThresholdValue;
    public int aldThresholdValue2;
    public int aldThresholdValue3;
    public int aldThresholdValue4;
    public boolean aldSnmpTrap;
    public boolean aldTecEvent;
    public boolean aldOsLog;
    public byte aldOsLogSeverity;
    public byte aldSyslogFacility;
    public boolean aldEmail;
    public boolean aldSALog = true;
    public int aldScriptComputerID;
    public String aldScriptName;
    public byte aldDbmsType;
    public static final String USER_STRING = "user";
    public static final String GROUP_STRING = "group";
    public static final String FILESYSTEM_STRING = "filesystem";
    public static final String DIRECTORY_STRING = "directory";

    public String getLogMsgID() {
        return AlertConditionManager.getLogMessageId(this.aldCondition);
    }

    public String getEmailMsgID() {
        return AlertConditionManager.getEmailMessageId(this.aldCondition);
    }

    public String getEmailSubjectID() {
        return AlertConditionManager.getEmailSubjectId(this.aldCondition);
    }

    public Map<Integer, String> getEmailParmMsgIdMap() {
        return AlertConditionManager.getEmailParameterIdMap(this.aldCondition);
    }

    public boolean accumulateAlertLog() {
        return AlertConditionManager.isAccumulate(this.aldCondition);
    }

    public int hashCode() {
        return Integer.valueOf(this.aldAlertID).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AlertDefinition) {
            return this.aldAlertID == ((AlertDefinition)object).aldAlertID;
        }
        return false;
    }

    public boolean isEqualTo(AlertDefinition alertDefinition) {
        return this.aldProductID == alertDefinition.aldProductID && this.aldType == alertDefinition.aldType && this.aldDbmsType == alertDefinition.aldDbmsType && this.aldCondition == alertDefinition.aldCondition && this.aldThresholdType == alertDefinition.aldThresholdType && this.aldThresholdValue == alertDefinition.aldThresholdValue && this.aldSnmpTrap == alertDefinition.aldSnmpTrap && this.aldTecEvent == alertDefinition.aldTecEvent && this.aldOsLog == alertDefinition.aldOsLog && this.aldOsLogSeverity == alertDefinition.aldOsLogSeverity && this.aldSyslogFacility == alertDefinition.aldSyslogFacility && this.aldEmail == alertDefinition.aldEmail && Util.stringsEqual(this.aldNotifyOnLogin, alertDefinition.aldNotifyOnLogin) && (this.aldEmailDef == null && alertDefinition.aldEmailDef == null || this.aldEmailDef != null && alertDefinition.aldEmailDef != null && this.aldEmailDef.equals(alertDefinition.aldEmailDef)) && this.aldScriptComputerID == alertDefinition.aldScriptComputerID && (this.aldScriptComputerID < 0 || Util.stringsEqual(this.aldScriptName, alertDefinition.aldScriptName));
    }

    public static boolean alertDefsEqual(AlertDefinition alertDefinition, AlertDefinition alertDefinition2) {
        if (alertDefinition == null) {
            return alertDefinition2 == null;
        }
        return alertDefinition2 != null && alertDefinition.isEqualTo(alertDefinition2);
    }

    public Object clone() {
        AlertDefinition alertDefinition = null;
        try {
            alertDefinition = (AlertDefinition)super.clone();
            if (this.aldEmailDef != null) {
                alertDefinition.aldEmailDef = (AlertEmail)this.aldEmailDef.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException();
        }
        return alertDefinition;
    }

    public String getAldName() {
        return Util.getTranslatedName(this.aldName);
    }

    public void setAldName(String string) {
        this.aldName = string;
    }
}

