/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerOtherL0
extends ViewerSanL1 {
    public static boolean debug = false;
    public static final String SELECT_OTHER = "SELECT \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on \tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tOTHER.VENDOR_ID = VENDOR.VENDOR_ID ";
    public static final String SELECT_SANS_FROM_OTHER = "SELECT \t OTHER2FABRIC.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC";

    public void getOther(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerOtherL0.class.getName(), "getOther", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("other...");
        }
        GraphOther graphOther = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_OTHER);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = (Integer)resultSet.getObject("OTHER_ID");
                String string = (String)resultSet.getObject("PREFIX_ID");
                String string2 = String.valueOf(string) + n;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphOther = new GraphOther(string2);
                    this.populator.populateOther(resultSet, graphOther);
                    graphModel.put(graphOther);
                    hashMap.put(string2, graphOther);
                    if (graphModel != null) {
                        graphModel.put(graphOther);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getOther", "Duplicated Other entry:" + string2);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getOther", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getOther", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("other totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerOtherL0.class.getName(), "getOther", "");
        }
    }

    public void getSansFromUnknown(Connection connection, GraphModel graphModel, HashMap hashMap) throws SQLException {
        this.getSansFromUnknown(connection, graphModel, hashMap, (Object[])null, SELECT_SANS_FROM_OTHER);
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerOtherL0.class.getName(), "getView", "");
        }
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            GraphModelOtherL0 graphModelOtherL0 = new GraphModelOtherL0((GraphModelOtherL0.ID)viewerRequest.getModelID());
            this.getOther(connection, graphModelOtherL0, hashMap);
            graphModelOtherL0.setWithZoneData(true);
            this.commit(connection);
            viewerResponse.addResponse(0, graphModelOtherL0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerOtherL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

