/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL0;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2VirtualFabric;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerRoot;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerSanL0 {
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static boolean debug = false;
    public static String SELECT_SAN = "SELECT distinct \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 , \tPARENT.FABRIC_ID PARENT_FABRIC_ID from     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN ORDER by PARENT.FABRIC_ID DESC";
    public static String DO_OTHER_COUNTS = "SELECT DISTINCT   A.FABRIC_ID FABRIC_ID,   B.TOTAL_OTHER TOTAL_OTHER,   B.TOTAL_ABNORMAL_OTHER TOTAL_ABNORMAL_OTHER FROM   T_RES_FABRIC A          left outer join   (SELECT     OTHER2FABRIC.FABRIC_ID FABRIC_ID,     COUNT(OTHER2FABRIC.PREFIX_ID) TOTAL_OTHER,     COUNT(CASE WHEN OTHER.PROPAGATED_STATUS > 0 and OTHER.PROPAGATED_STATUS != 4 THEN OTHER2FABRIC.PREFIX_ID       else NULL END) TOTAL_ABNORMAL_OTHER   FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC, T_VIEW_VOTHER OTHER   WHERE     OTHER2FABRIC.PREFIX_ID = OTHER.PREFIX_ID and     OTHER2FABRIC.OTHER_ID = OTHER.OTHER_ID   GROUP BY OTHER2FABRIC.FABRIC_ID) B          on A.FABRIC_ID = B.FABRIC_ID";
    public static String DO_SWITCH_COUNTS = "SELECT DISTINCT   A.FABRIC_ID FABRIC_ID,   B.TOTAL_SWITCH TOTAL_SWITCH,   B.TOTAL_ABNORMAL_SWITCH TOTAL_ABNORMAL_SWITCH FROM   T_RES_FABRIC A          left outer join   (SELECT distinct     SWITCH2FABRIC.FABRIC_ID FABRIC_ID,     COUNT(distinct SWITCH.SWITCH_WWN) TOTAL_SWITCH,     COUNT(CASE WHEN SWITCH.PROPAGATED_STATUS > 0 and SWITCH.PROPAGATED_STATUS != 4 THEN SWITCH.SWITCH_WWN \t   WHEN SWITCH.DETECTABLE = 0 THEN SWITCH.SWITCH_WWN       else NULL END) TOTAL_ABNORMAL_SWITCH   FROM T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH SWITCH   WHERE     SWITCH2FABRIC.SWITCH_ID = SWITCH.SWITCH_ID and     SWITCH2FABRIC.PREFIX_ID = SWITCH.PREFIX_ID   GROUP BY SWITCH2FABRIC.FABRIC_ID) B          on A.FABRIC_ID = B.FABRIC_ID";
    public static String DO_SUBSYSTEM_COUNTS = "SELECT DISTINCT   A.FABRIC_ID FABRIC_ID,   B.TOTAL_SUBSYSTEM TOTAL_SUBSYSTEM,   B.TOTAL_ABNORMAL_SUBSYSTEM TOTAL_ABNORMAL_SUBSYSTEM FROM   T_RES_FABRIC A          left outer join   (SELECT     SUBSYSTEM2FABRIC.FABRIC_ID FABRIC_ID,     COUNT(SUBSYSTEM2FABRIC.SUBSYSTEM_ID) TOTAL_SUBSYSTEM,     COUNT(CASE WHEN SUBSYSTEM.PROPAGATED_STATUS > 0 AND SUBSYSTEM.PROPAGATED_STATUS != 4       THEN SUBSYSTEM.SUBSYSTEM_ID       WHEN SUBSYSTEM.DETECTABLE = 0 THEN SUBSYSTEM.SUBSYSTEM_ID       ELSE cast(NULL AS INTEGER) END) TOTAL_ABNORMAL_SUBSYSTEM   FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC, T_VIEW_VSTORAGE_SUBSYSTEM SUBSYSTEM   WHERE     SUBSYSTEM2FABRIC.PREFIX_ID = SUBSYSTEM.PREFIX_ID and     SUBSYSTEM2FABRIC.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID   GROUP BY SUBSYSTEM2FABRIC.FABRIC_ID) B          on A.FABRIC_ID = B.FABRIC_ID";
    public static String DO_TAPE_COUNTS = "SELECT DISTINCT   A.FABRIC_ID FABRIC_ID,   B.TOTAL_TAPE TOTAL_TAPE,   B.TOTAL_ABNORMAL_TAPE TOTAL_ABNORMAL_TAPE FROM   T_RES_FABRIC A          left outer join   (SELECT     TAPE2FABRIC.FABRIC_ID FABRIC_ID,     COUNT(TAPE2FABRIC.TAPE_LIBRARY_ID) TOTAL_TAPE,     COUNT(CASE WHEN TAPE.PROPAGATED_STATUS > 0 AND TAPE.PROPAGATED_STATUS != 4       THEN TAPE.TAPE_LIBRARY_ID       WHEN TAPE.DETECTABLE = 0 THEN TAPE.TAPE_LIBRARY_ID       ELSE cast(NULL AS INTEGER) END) TOTAL_ABNORMAL_TAPE   FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC, T_VIEW_VTAPE_LIBRARY TAPE   WHERE     TAPE2FABRIC.PREFIX_ID = TAPE.PREFIX_ID and     TAPE2FABRIC.TAPE_LIBRARY_ID = TAPE.TAPE_LIBRARY_ID   GROUP BY TAPE2FABRIC.FABRIC_ID) B          on A.FABRIC_ID = B.FABRIC_ID";
    public static String DO_HOST_COUNTS = "SELECT DISTINCT   A.FABRIC_ID FABRIC_ID,   B.TOTAL_HOST TOTAL_HOST,   B.TOTAL_ABNORMAL_HOST TOTAL_ABNORMAL_HOST FROM   T_RES_FABRIC A          left outer join   (SELECT     HOST2FABRIC.FABRIC_ID FABRIC_ID,     COUNT(HOST2FABRIC.HOST_ID) TOTAL_HOST,     COUNT(CASE WHEN HOST.PROPAGATED_STATUS > 0 and HOST.PROPAGATED_STATUS != 4        THEN HOST.COMPUTER_ID       WHEN HOST.DETECTABLE = 0 THEN HOST.COMPUTER_ID       else CAST(NULL AS INTEGER) END) TOTAL_ABNORMAL_HOST   FROM T_VIEW_VHOST2FABRIC HOST2FABRIC, T_VIEW_VHOST HOST   WHERE     HOST2FABRIC.PREFIX_ID = HOST.PREFIX_ID and     HOST2FABRIC.HOST_ID = HOST.COMPUTER_ID   GROUP BY HOST2FABRIC.FABRIC_ID) B          on A.FABRIC_ID = B.FABRIC_ID";
    public static String COUNT_OTHER_FROM_SAN = "select \tcount (OTHER2FABRIC.PREFIX_ID) TOTAL from T_VIEW_VOTHER2FABRIC OTHER2FABRIC where \tOTHER2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_ABNORMAL_OTHER_FROM_SAN = "select    COUNT(CASE WHEN OTHER.PROPAGATED_STATUS > 0 and OTHER.PROPAGATED_STATUS != 4 THEN OTHER2FABRIC.PREFIX_ID             else NULL END) TOTAL from \tT_VIEW_VOTHER2FABRIC OTHER2FABRIC, T_VIEW_VOTHER OTHER where \tOTHER2FABRIC.FABRIC_ID = ? and    OTHER2FABRIC.PREFIX_ID = OTHER.PREFIX_ID and    OTHER2FABRIC.OTHER_ID = OTHER.OTHER_ID";
    public static String COUNT_ARRAY_FROM_SAN = "select \tCOUNT(SUBSYSTEM2FABRIC.SUBSYSTEM_ID) TOTAL FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC WHERE \tSUBSYSTEM2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_ABNORMAL_ARRAY_FROM_SAN = "select \tCOUNT(CASE WHEN SUBSYSTEM.PROPAGATED_STATUS > 0 AND SUBSYSTEM.PROPAGATED_STATUS != 4\t\t  THEN SUBSYSTEM.SUBSYSTEM_ID\t\t  WHEN SUBSYSTEM.DETECTABLE = 0 THEN SUBSYSTEM.SUBSYSTEM_ID\t\t  ELSE cast (NULL as integer) END) TOTAL FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC, T_VIEW_VSTORAGE_SUBSYSTEM SUBSYSTEM WHERE \tSUBSYSTEM2FABRIC.FABRIC_ID = ? and    SUBSYSTEM2FABRIC.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID and    SUBSYSTEM2FABRIC.PREFIX_ID = SUBSYSTEM.PREFIX_ID";
    public static String COUNT_TAPE_FROM_SAN = "SELECT \tCOUNT(TAPE2FABRIC.TAPE_LIBRARY_ID) TOTAL FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE     TAPE2FABRIC.FABRIC_ID = ?";
    public static String COUNT_ABNORMAL_TAPE_FROM_SAN = "SELECT    COUNT(CASE WHEN TAPE.PROPAGATED_STATUS > 0 and TAPE.PROPAGATED_STATUS != 4 THEN TAPE.TAPE_LIBRARY_ID    \t  \tWHEN TAPE.DETECTABLE = 0 THEN TAPE.TAPE_LIBRARY_ID            else cast (null as integer) END) TOTAL FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC, T_VIEW_VTAPE_LIBRARY TAPE WHERE     TAPE2FABRIC.FABRIC_ID = ? and     TAPE2FABRIC.TAPE_LIBRARY_ID = TAPE.TAPE_LIBRARY_ID and  \t TAPE2FABRIC.PREFIX_ID = TAPE.PREFIX_ID ";
    public static String COUNT_HOST_FROM_SAN = "SELECT \t\tcount(HOST2FABRIC.HOST_ID) TOTAL FROM T_VIEW_VHOST2FABRIC HOST2FABRIC WHERE    HOST2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_ABNORMAL_HOST_FROM_SAN = "SELECT    COUNT(CASE WHEN HOST.PROPAGATED_STATUS > 0 and HOST.PROPAGATED_STATUS != 4 THEN HOST.COMPUTER_ID    \t  \tWHEN HOST.DETECTABLE = 0 THEN HOST.COMPUTER_ID            else cast (null as integer) END) TOTAL FROM T_VIEW_VHOST2FABRIC HOST2FABRIC,\t\tT_VIEW_VHOST HOST WHERE    HOST2FABRIC.FABRIC_ID = ? and   HOST2FABRIC.PREFIX_ID = HOST.PREFIX_ID and \t  HOST2FABRIC.HOST_ID = HOST.COMPUTER_ID  ";
    public static String COUNT_SWITCH_FROM_SAN = "SELECT  \tCOUNT(distinct SWITCH.SWITCH_WWN) TOTAL from T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH SWITCH WHERE \tSWITCH2FABRIC.FABRIC_ID = ? and   SWITCH2FABRIC.SWITCH_ID = SWITCH.SWITCH_ID and    SWITCH2FABRIC.PREFIX_ID = SWITCH.PREFIX_ID ";
    public static String COUNT_ABNORMAL_SWITCH_FROM_SAN = "SELECT     COUNT(CASE WHEN SWITCH.PROPAGATED_STATUS > 0 and SWITCH.PROPAGATED_STATUS != 4 THEN SWITCH.SWITCH_WWN    \t  \tWHEN SWITCH.DETECTABLE = 0 THEN SWITCH.SWITCH_WWN            else null END) TOTAL FROM T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH SWITCH where \tSWITCH2FABRIC.FABRIC_ID = ? and    SWITCH2FABRIC.SWITCH_ID = SWITCH.SWITCH_ID and    SWITCH2FABRIC.PREFIX_ID = SWITCH.PREFIX_ID ";

    public static int getTotalSingle(Connection connection, String string, Integer n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL0.class.getName(), "getView", "");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = resultSet.getInt("TOTAL");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ViewerSanL0.class.getName(), "getTotal", "result=" + n2);
                }
                int n3 = n2;
                return n3;
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerSanL0.class.getName(), "getTotal", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerSanL0.class.getName(), "getTotal", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL0.class.getName(), "getTotal", "result=0");
        }
        return 0;
    }

    public static int getTotal(Connection connection, String string, Integer n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL0.class.getName(), "getView", "");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    int n2 = resultSet.getInt("TOTAL");
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit(ViewerSanL0.class.getName(), "getTotal", "result=" + n2);
                    }
                    int n3 = n2;
                    return n3;
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSanL0.class.getName(), "getTotal", exception);
                }
            }
        }
        finally {
            block26: {
                block25: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block25;
                        TraceLogger.exception(ViewerSanL0.class.getName(), "getTotal", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block26;
                    TraceLogger.exception(ViewerSanL0.class.getName(), "getTotal", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL0.class.getName(), "getTotal", "result=0");
        }
        return 0;
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL0.class.getName(), "getView", "");
        }
        GraphModelFabricL0 graphModelFabricL0 = new GraphModelFabricL0((GraphModelFabricL0.ID)viewerRequest.getModelID());
        HashMap<String, Comparable<Integer>> hashMap = new HashMap<String, Comparable<Integer>>();
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            Comparable<Integer> comparable;
            String string;
            Integer n;
            try {
                preparedStatement = connection.prepareStatement(SELECT_SAN);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = (Integer)resultSet.getObject("FABRIC_ID");
                    if (n == null) continue;
                    string = "fabric:" + n;
                    if (hashMap.get(string) == null) {
                        comparable = (Integer)resultSet.getObject("PARENT_FABRIC_ID");
                        GraphFabric graphFabric = new GraphFabric(string);
                        this.populator.populateSan(resultSet, graphFabric);
                        graphFabric.setNumOfComputers(new Integer(0));
                        graphFabric.setNumOfSubsystems(new Integer(0));
                        graphFabric.setNumOfSwitches(new Integer(0));
                        graphFabric.setNumOfTapeLibraries(new Integer(0));
                        graphFabric.setNumOfOthers(new Integer(0));
                        graphFabric.setNumOfAbnormalComputers(new Integer(0));
                        graphFabric.setNumOfAbnormalSubsystems(new Integer(0));
                        graphFabric.setNumOfAbnormalSwitches(new Integer(0));
                        graphFabric.setNumOfAbnormalTapeLibraries(new Integer(0));
                        graphFabric.setNumOfAbnormalOthers(new Integer(0));
                        if (comparable != null) {
                            GraphFabric graphFabric2 = (GraphFabric)hashMap.get("fabric:" + comparable);
                            if (graphFabric2 != null) {
                                String string2 = "fabric2vfabric:" + comparable + ',' + n;
                                GraphFabric2VirtualFabric graphFabric2VirtualFabric = new GraphFabric2VirtualFabric(string2);
                                graphFabric2VirtualFabric.setFabricID((GraphFabric.ID)graphFabric2.getEntityID());
                                graphFabric2VirtualFabric.setVirtualFabricID((GraphFabric.ID)graphFabric.getEntityID());
                                hashMap.put(string2, graphFabric2VirtualFabric);
                                graphModelFabricL0.put(graphFabric2VirtualFabric);
                            } else if (TraceLogger.enableTrace) {
                                TraceLogger.traceMessage(1, ViewerSanL0.class.getName(), "getView", "Parent SAN not found: fabric:" + comparable);
                            }
                        }
                        hashMap.put(string, graphFabric);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSanL0.class.getName(), "getView", "San already exists:" + string);
                }
            }
            finally {
                block95: {
                    block94: {
                        this.commit(connection);
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block94;
                            TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block95;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(DO_HOST_COUNTS);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = (Integer)resultSet.getObject("FABRIC_ID");
                    if (n == null || (comparable = (GraphFabric)hashMap.get(string = "fabric:" + n)) == null) continue;
                    int n2 = resultSet.getInt("TOTAL_HOST");
                    int n3 = resultSet.getInt("TOTAL_ABNORMAL_HOST");
                    ((GraphFabric)comparable).setNumOfComputers(new Integer(n2));
                    ((GraphFabric)comparable).setNumOfAbnormalComputers(new Integer(n3));
                    hashMap.put(string, comparable);
                }
            }
            finally {
                block98: {
                    block97: {
                        this.commit(connection);
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block97;
                            TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block98;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(DO_SWITCH_COUNTS);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = (Integer)resultSet.getObject("FABRIC_ID");
                    if (n == null || (comparable = (GraphFabric)hashMap.get(string = "fabric:" + n)) == null) continue;
                    int n4 = resultSet.getInt("TOTAL_SWITCH");
                    int n5 = resultSet.getInt("TOTAL_ABNORMAL_SWITCH");
                    ((GraphFabric)comparable).setNumOfSwitches(new Integer(n4));
                    ((GraphFabric)comparable).setNumOfAbnormalSwitches(new Integer(n5));
                    hashMap.put(string, comparable);
                }
            }
            finally {
                block101: {
                    block100: {
                        this.commit(connection);
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block100;
                            TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block101;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(DO_SUBSYSTEM_COUNTS);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = (Integer)resultSet.getObject("FABRIC_ID");
                    if (n == null || (comparable = (GraphFabric)hashMap.get(string = "fabric:" + n)) == null) continue;
                    int n6 = resultSet.getInt("TOTAL_SUBSYSTEM");
                    int n7 = resultSet.getInt("TOTAL_ABNORMAL_SUBSYSTEM");
                    ((GraphFabric)comparable).setNumOfSubsystems(new Integer(n6));
                    ((GraphFabric)comparable).setNumOfAbnormalSubsystems(new Integer(n7));
                    hashMap.put(string, comparable);
                }
            }
            finally {
                block104: {
                    block103: {
                        this.commit(connection);
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block103;
                            TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block104;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(DO_TAPE_COUNTS);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = (Integer)resultSet.getObject("FABRIC_ID");
                    if (n == null || (comparable = (GraphFabric)hashMap.get(string = "fabric:" + n)) == null) continue;
                    int n8 = resultSet.getInt("TOTAL_TAPE");
                    int n9 = resultSet.getInt("TOTAL_ABNORMAL_TAPE");
                    ((GraphFabric)comparable).setNumOfTapeLibraries(new Integer(n8));
                    ((GraphFabric)comparable).setNumOfAbnormalTapeLibraries(new Integer(n9));
                    hashMap.put(string, comparable);
                }
            }
            finally {
                block107: {
                    block106: {
                        this.commit(connection);
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block106;
                            TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block107;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(DO_OTHER_COUNTS);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n = (Integer)resultSet.getObject("FABRIC_ID");
                    if (n == null || (comparable = (GraphFabric)hashMap.get(string = "fabric:" + n)) == null) continue;
                    int n10 = resultSet.getInt("TOTAL_OTHER");
                    int n11 = resultSet.getInt("TOTAL_ABNORMAL_OTHER");
                    ((GraphFabric)comparable).setNumOfOthers(new Integer(n10));
                    ((GraphFabric)comparable).setNumOfAbnormalOthers(new Integer(n11));
                    hashMap.put(string, comparable);
                    graphModelFabricL0.put((GraphEntity)comparable);
                }
            }
            finally {
                block110: {
                    block109: {
                        this.commit(connection);
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block109;
                            TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block110;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getView", sQLException);
                    }
                }
            }
            graphModelFabricL0.setWithZoneData(true);
            viewerResponse.addResponse(0, graphModelFabricL0);
        } else {
            viewerResponse.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL0.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

