/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.queue;

import java.util.LinkedList;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.util.queue.IJobFilter;

public class Queue {
    private LinkedList order = new LinkedList();
    private Object lock = new Object();
    private IJobFilter filter = null;

    public Queue(IJobFilter iJobFilter) {
        this.filter = iJobFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobInfo jobInfo) {
        Object object = this.lock;
        synchronized (object) {
            int n = this.filter.disposition(jobInfo, this);
            if (n == 0) {
                this.order.addLast(jobInfo);
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getNextJob() {
        JobInfo jobInfo = null;
        while (!Thread.interrupted() && jobInfo == null) {
            Object object = this.lock;
            synchronized (object) {
                while (this.order.size() > 0) {
                    jobInfo = (JobInfo)this.order.get(0);
                    while (jobInfo.getStatus() == 4) {
                        this.order.remove(jobInfo);
                        jobInfo = jobInfo.getReplacementJob();
                    }
                    if (!this.filter.okToRun(jobInfo) || jobInfo == null) continue;
                    this.order.remove(jobInfo);
                    this.jobStarted(jobInfo);
                    break;
                }
            }
            if (jobInfo != null) continue;
            try {
                object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return jobInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobStarted(JobInfo jobInfo) {
        Object object = this.lock;
        synchronized (object) {
            this.filter.jobStarted(jobInfo);
            jobInfo.setStartTime(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobCompleted(JobInfo jobInfo) {
        this.filter.jobCompleted(jobInfo);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

