/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.aperi.common.ListElement;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class CurtailedWriter
extends PrintWriter
implements FilenameFilter {
    public static NumberFormat extension = new DecimalFormat("000000'.log'");
    private String prefix;
    private int dirPart;
    private PrintWriter real;
    private int messageCount;
    private SortedMap<OneDotTwoInteger, OneDotTwoInteger> sorter;
    private Range workingRange;
    private Range rangeHead;
    private int filesOnDisk;
    private boolean redirectErrOut;
    private String currentFileName;
    public int maxMessages;
    public int maxFiles;

    public CurtailedWriter(OutputStream outputStream) {
        super(outputStream);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    public CurtailedWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out, autoFlush");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    public CurtailedWriter(Writer writer) {
        super(writer);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    public CurtailedWriter(Writer writer, boolean bl) {
        super(writer, bl);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "CurtailedWriter", "out, autoFlush");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "CurtailedWriter");
        }
    }

    private String nextFilename() {
        int n;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "nextFilename", "");
        }
        this.workingRange.last = n = this.workingRange.last + 1;
        ++this.filesOnDisk;
        String string = String.valueOf(this.prefix) + extension.format(n);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "nextFilename", string);
        }
        return string;
    }

    private void purge() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "purge", "");
        }
        if (this.maxFiles <= 0) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "purge");
            }
            return;
        }
        int n = this.filesOnDisk - this.maxFiles;
        while (n > 0) {
            String string = String.valueOf(this.prefix) + extension.format(this.rangeHead.first);
            File file = new File(string);
            if (!file.delete()) {
                Object[] objectArray = new Object[]{string};
                this.real.println(MessageLog.getMessage("GEN0038W", objectArray));
            }
            ++this.rangeHead.first;
            if (this.rangeHead.first > this.rangeHead.last) {
                this.rangeHead = (Range)this.rangeHead.nextElement;
            }
            --n;
        }
        this.filesOnDisk = this.maxFiles;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "purge");
        }
    }

    public boolean accept(File file, String string) {
        int n;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "accept", "dir, name");
        }
        if (!string.endsWith(".log")) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", bl);
            }
            return bl;
        }
        int n2 = string.length() - 4;
        int n3 = this.prefix.length() - this.dirPart;
        if (!string.regionMatches(0, this.prefix, this.dirPart, n3)) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", bl);
            }
            return bl;
        }
        try {
            n = Integer.parseInt(string.substring(n3, n2));
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CurtailedWriter.class.getName(), "accept", numberFormatException);
            }
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", bl);
            }
            return bl;
        }
        if (n <= 0) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CurtailedWriter.class.getName(), "accept", bl);
            }
            return bl;
        }
        ++this.filesOnDisk;
        OneDotTwoInteger oneDotTwoInteger = new OneDotTwoInteger(-n);
        this.sorter.put(oneDotTwoInteger, oneDotTwoInteger);
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "accept", bl);
        }
        return bl;
    }

    private void setMaxMessages(int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "setMaxMessages", "maxMessagesPerFile");
        }
        this.maxMessages = n > 5 || n <= 0 ? n : 5;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "setMaxMessages");
        }
    }

    private void setMaxFiles(int n) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CurtailedWriter.class.getName(), "setMaxFiles", "pMaxFiles");
        }
        this.maxFiles = n != 1 ? n : 2;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CurtailedWriter.class.getName(), "setMaxFiles");
        }
    }

    public CurtailedWriter(String string, int n, int n2, boolean bl) throws IOException {
        super(System.err);
        Object[] objectArray;
        Object object;
        OneDotTwoInteger oneDotTwoInteger;
        int n3;
        FileOutputStream fileOutputStream;
        this.setMaxFiles(n);
        this.maxMessages = 0;
        this.prefix = String.valueOf(string) + "_";
        this.redirectErrOut = bl;
        String string2 = String.valueOf(string) + ".log";
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (IOException iOException) {
            MessageLog.logException("GEN0036E", iOException);
            throw iOException;
        }
        this.currentFileName = string2;
        if (this.redirectErrOut) {
            MessageLog.redirectErrOut(fileOutputStream);
        }
        this.real = new PrintWriter(fileOutputStream, true);
        this.dirPart = this.prefix.lastIndexOf(File.separatorChar) + 1;
        File file = this.dirPart > 0 ? new File(this.prefix.substring(0, this.dirPart)) : new File(".");
        this.filesOnDisk = 0;
        this.sorter = new TreeMap<OneDotTwoInteger, OneDotTwoInteger>();
        if (file.list(this) == null) {
            Object[] objectArray2 = new Object[]{file.getPath()};
            this.println(MessageLog.getMessage("GEN0052E", objectArray2));
            return;
        }
        this.rangeHead = this.workingRange = new Range();
        Iterator<OneDotTwoInteger> iterator = this.sorter.values().iterator();
        if (!iterator.hasNext()) {
            n3 = 0;
        } else {
            oneDotTwoInteger = iterator.next();
            n3 = -oneDotTwoInteger.intValue();
        }
        this.workingRange.last = n3;
        int n4 = n3;
        while (iterator.hasNext()) {
            oneDotTwoInteger = iterator.next();
            n3 = -oneDotTwoInteger.intValue();
            if (n3 != n4 - 1) {
                this.rangeHead.first = n4;
                object = new Range();
                ((Range)object).last = n3;
                ((Range)object).nextElement = this.rangeHead;
                this.rangeHead = object;
            }
            n4 = n3;
        }
        this.rangeHead.first = n4;
        this.sorter = null;
        object = this.nextFilename();
        boolean bl2 = false;
        this.real.close();
        if (!this.real.checkError()) {
            objectArray = new File(string2);
            File file2 = new File((String)object);
            bl2 = objectArray.renameTo(file2);
            if (!bl2) {
                object = string2;
            }
            try {
                fileOutputStream = new FileOutputStream((String)object);
            }
            catch (IOException iOException) {
                MessageLog.logException("GEN0036E", iOException);
                throw iOException;
            }
            if (this.redirectErrOut) {
                MessageLog.redirectErrOut(fileOutputStream);
            }
            this.real = new PrintWriter(fileOutputStream, true);
        }
        if (!bl2) {
            objectArray = new Object[]{string2, object};
            this.println(MessageLog.getMessage("GEN0023E", objectArray));
            return;
        }
        this.currentFileName = object;
        if (n3 > 0) {
            this.purge();
        } else {
            this.workingRange.first = 1;
        }
        this.setMaxMessages(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParms(int n, int n2) {
        Range range = this.workingRange;
        synchronized (range) {
            this.setMaxFiles(n);
            this.setMaxMessages(n2);
            this.purge();
        }
    }

    public void flush() {
        this.real.flush();
    }

    public void close() {
        this.real.close();
    }

    public boolean checkError() {
        return this.real.checkError();
    }

    public void print(boolean bl) {
        this.real.print(bl);
    }

    public void print(char c) {
        this.real.print(c);
    }

    public void print(char[] cArray) {
        this.real.print(cArray);
    }

    public void print(int n) {
        this.real.print(n);
    }

    public void print(long l) {
        this.real.print(l);
    }

    public void print(float f) {
        this.real.print(f);
    }

    public void print(double d) {
        this.real.print(d);
    }

    public void print(String string) {
        this.real.print(string);
    }

    public void print(Object object) {
        this.real.print(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        int n;
        this.real.println(string);
        if (this.maxMessages <= 0) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.messageCount = n = this.messageCount + 1;
        }
        if (n % this.maxMessages != 0) {
            return;
        }
        object = this.workingRange;
        synchronized (object) {
            FileOutputStream fileOutputStream;
            String string2 = this.nextFilename();
            try {
                fileOutputStream = new FileOutputStream(string2);
            }
            catch (IOException iOException) {
                this.real.println(MessageLog.getMessageWithException("GEN0036E", iOException));
                --this.workingRange.last;
                --this.filesOnDisk;
                return;
            }
            this.currentFileName = string2;
            if (this.redirectErrOut) {
                MessageLog.redirectErrOut(fileOutputStream);
            }
            PrintWriter printWriter = this.real;
            this.real = new PrintWriter(fileOutputStream, true);
            printWriter.close();
            this.purge();
        }
    }

    public void println() {
        this.println("");
    }

    public void println(boolean bl) {
        this.println(String.valueOf(bl));
    }

    public void println(char c) {
        this.println(String.valueOf(c));
    }

    public void println(char[] cArray) {
        this.println(String.valueOf(cArray));
    }

    public void println(int n) {
        this.println(String.valueOf(n));
    }

    public void println(long l) {
        this.println(String.valueOf(l));
    }

    public void println(float f) {
        this.println(String.valueOf(f));
    }

    public void println(double d) {
        this.println(String.valueOf(d));
    }

    public void println(Object object) {
        this.println(String.valueOf(object));
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    private static class Range
    extends ListElement {
        static final long serialVersionUID = 3043739478394309129L;
        public int first;
        public int last;

        private Range() {
        }
    }

    private static class OneDotTwoInteger
    implements Comparable {
        private int value;

        public OneDotTwoInteger(int n) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(OneDotTwoInteger.class.getName(), "OneDotTwoInteger", "pValue");
            }
            this.value = n;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(OneDotTwoInteger.class.getName(), "OneDotTwoInteger");
            }
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(OneDotTwoInteger.class.getName(), "compareTo", "obj");
            }
            OneDotTwoInteger oneDotTwoInteger = (OneDotTwoInteger)object;
            int n = this.value - oneDotTwoInteger.value;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(OneDotTwoInteger.class.getName(), "compareTo", n);
            }
            return n;
        }

        public int intValue() {
            return this.value;
        }
    }
}

