/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogComponent;
import com.ibm.log.util.LogUtil;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public abstract class LogNode
implements Cloneable,
LogComponent {
    private String description = "";
    private String descriptionFile = "";
    private String descriptionKey = "";
    private String name = "";

    public LogNode() {
    }

    public LogNode(String string) {
        this.setName(string);
    }

    public synchronized Object clone() {
        try {
            LogNode logNode = (LogNode)super.clone();
            return logNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Properties getConfig() {
        Properties properties = new Properties();
        if (!this.getName().equals("")) {
            properties.put("name", this.getName());
        }
        if (!this.getDescription().equals("")) {
            properties.put("description", this.getDescription());
        }
        if (!this.getDescriptionFile().equals("")) {
            properties.put("descriptionFile", this.getDescriptionFile());
        }
        if (!this.getDescriptionKey().equals("")) {
            properties.put("descriptionKey", this.getDescriptionKey());
        }
        properties.put("className", this.getClass().getName());
        return properties;
    }

    public void setConfig(Properties properties) {
        String string = properties.getProperty("name");
        if (string != null) {
            this.setName(string);
        }
        if ((string = properties.getProperty("description")) != null) {
            this.setDescription(string);
        }
        if ((string = properties.getProperty("descriptionFile")) != null) {
            this.setDescriptionFile(string);
        }
        if ((string = properties.getProperty("descriptionKey")) != null) {
            this.setDescriptionKey(string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null) {
            this.name = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setName");
            LogUtil.errorMsg(string2);
        }
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        String string = this.description;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.getDescriptionFile() != null && this.getDescriptionKey() != null) {
            try {
                String string2 = this.getDescriptionFile();
                ClassLoader classLoader = LogUtil.getClassLoaderForResource(string2);
                ResourceBundle resourceBundle = classLoader == null ? ResourceBundle.getBundle(string2, locale) : ResourceBundle.getBundle(string2, locale, classLoader);
                string = resourceBundle.getString(this.getDescriptionKey());
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string;
    }

    public void setDescription(String string) {
        if (string != null) {
            this.description = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDescription");
            LogUtil.errorMsg(string2);
        }
    }

    public void setDescription(String string, String string2) {
        if (string != null && string2 != null) {
            this.setDescriptionKey(string);
            this.setDescriptionFile(string2);
        } else {
            String string3 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".set");
            LogUtil.errorMsg(string3);
        }
    }

    public String getDescriptionFile() {
        return this.descriptionFile;
    }

    public void setDescriptionFile(String string) {
        if (string != null) {
            this.descriptionFile = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDescriptionFile");
            LogUtil.errorMsg(string2);
        }
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescriptionKey(String string) {
        if (string != null) {
            this.descriptionKey = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDescriptionKey");
            LogUtil.errorMsg(string2);
        }
    }

    public String toString() {
        String string = this.getName();
        if (string.equals("")) {
            string = "(none)";
        }
        return "name=" + string + ", class=" + this.getClass().getName();
    }
}

