/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;

public class CircularEventQueue {
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    protected int queueCount = 0;
    protected int capacity;
    private int head = 0;
    private int tail = 0;
    private LogEvent[] queue = null;

    public CircularEventQueue() {
        this(10000);
    }

    public CircularEventQueue(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException(LogUtil.getLogMsg("ERR_QUEUE_SIZE", new Integer(n)));
        }
        this.setCapacity(n);
        this.queue = new LogEvent[n];
    }

    public synchronized int getQueueCount() {
        return this.queueCount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int n) {
        if (n >= 1) {
            this.capacity = n;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setCapacity");
            LogUtil.errorMsg(string);
        }
    }

    public synchronized void enqueue(LogEvent logEvent) {
        if (logEvent != null) {
            this.queue[this.tail] = logEvent;
            if (this.queueCount < this.capacity) {
                ++this.queueCount;
            }
            if (this.tail == this.head && this.queueCount == this.capacity) {
                this.head = (this.head + 1) % this.capacity;
            }
            this.tail = (this.tail + 1) % this.capacity;
        }
    }

    public synchronized LogEvent dequeue() {
        LogEvent logEvent = this.first();
        if (logEvent != null) {
            this.queue[this.head] = null;
            this.head = (this.head + 1) % this.capacity;
            --this.queueCount;
        }
        return logEvent;
    }

    public synchronized LogEvent first() {
        LogEvent logEvent = null;
        if (this.queueCount != 0) {
            logEvent = this.queue[this.head];
        }
        return logEvent;
    }
}

