/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.util.MessageCatalog;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogUtil {
    public static final String LOG_MSG_CAT = "com.ibm.log.util.Msgs";
    private static final String MISSING_MSG_CAT = "The Logging Toolkit message file, com.ibm.log.util.Msgs, was not found.  No toolkit messages can be displayed.";
    private static MessageCatalog msgs;
    private static Hashtable localeToCodePage;
    private static PrintWriter defaultErrWriter;
    private static PrintWriter currentErrWriter;
    private static ClassLoader defaultResourceLoader;
    private static HashMap resourceLoaders;
    private static Object resourceLoaderMapLock;

    static {
        Object object;
        msgs = null;
        try {
            ResourceBundle.getBundle(LOG_MSG_CAT);
            msgs = new MessageCatalog(LOG_MSG_CAT);
        }
        catch (MissingResourceException missingResourceException) {
            object = System.getProperty("line.separator");
            LogUtil.errorMsg(String.valueOf(object) + MISSING_MSG_CAT + (String)object);
        }
        localeToCodePage = new Hashtable();
        defaultErrWriter = null;
        currentErrWriter = null;
        localeToCodePage.put("cs", "Cp852");
        localeToCodePage.put("da", "Cp850");
        localeToCodePage.put("en", "Cp850");
        localeToCodePage.put("de", "Cp850");
        localeToCodePage.put("es", "Cp850");
        localeToCodePage.put("fi", "Cp850");
        localeToCodePage.put("fr", "Cp850");
        localeToCodePage.put("hu", "Cp852");
        localeToCodePage.put("it", "Cp850");
        localeToCodePage.put("nl", "Cp949");
        localeToCodePage.put("no", "Cp850");
        localeToCodePage.put("pl", "Cp852");
        localeToCodePage.put("pt", "Cp850");
        localeToCodePage.put("ru", "Cp866");
        localeToCodePage.put("sl", "Cp852");
        localeToCodePage.put("sv", "Cp850");
        localeToCodePage.put("tr", "Cp857");
        try {
            String string = LogUtil.getConsoleCodePage();
            object = string != null ? new OutputStreamWriter((OutputStream)System.err, string) : new OutputStreamWriter(System.err);
            currentErrWriter = defaultErrWriter = new PrintWriter((Writer)object, true);
        }
        catch (Exception exception) {}
        defaultResourceLoader = null;
        resourceLoaders = null;
        resourceLoaderMapLock = new Object();
    }

    public static Object[] checkNullObjects(Object[] objectArray) {
        String string = null;
        Object[] objectArray2 = null;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null) {
                    if (string == null) {
                        string = LogUtil.getLogMsg("NULL_OBJECT");
                    }
                    if (objectArray2 == null) {
                        objectArray2 = new Object[objectArray.length];
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            objectArray2[n2] = objectArray[n2];
                            ++n2;
                        }
                    }
                    objectArray2[n] = string;
                }
                ++n;
            }
        }
        if (objectArray2 == null) {
            return objectArray;
        }
        return objectArray2;
    }

    public static Object createObject(String string) {
        Class<?> clazz = null;
        Object var2_2 = null;
        if (string != null) {
            ClassLoader classLoader = LogUtil.getClassLoaderForResource(string);
            if (classLoader == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("com.ibm.log.util.LogUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classLoader = clazz2.getClassLoader();
            }
            try {
                clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                var2_2 = clazz.newInstance();
            }
            catch (Exception exception) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_OBJ_CREATE", string));
                exception.printStackTrace();
            }
        }
        return var2_2;
    }

    public static void errorMsg(String string) {
        if (currentErrWriter == null) {
            System.err.println(string);
        } else {
            currentErrWriter.println(string);
        }
    }

    public static void errorStack(Throwable throwable) {
        if (currentErrWriter == null) {
            throwable.printStackTrace(System.err);
        } else {
            throwable.printStackTrace(currentErrWriter);
        }
    }

    public static String getConsoleCodePage() {
        String string = null;
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.startsWith("Windows")) {
            Locale locale = Locale.getDefault();
            String string3 = locale.getLanguage();
            String string4 = locale.getCountry();
            string = (String)localeToCodePage.get(String.valueOf(string3) + "_" + string4);
            if (string == null) {
                string = (String)localeToCodePage.get(string3);
            }
        }
        return string;
    }

    public static String getLogMsg(String string) {
        return LogUtil.getLogMsg(string, null);
    }

    public static String getLogMsg(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return LogUtil.getLogMsg(string, objectArray);
    }

    public static String getLogMsg(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return LogUtil.getLogMsg(string, objectArray);
    }

    public static String getLogMsg(String string, Object[] objectArray) {
        String string2 = "";
        if (msgs != null) {
            string2 = msgs.getMessage(string, objectArray);
        }
        return string2;
    }

    public static String left(String string, int n) {
        return LogUtil.left(string, n, " ");
    }

    public static String left(String string, int n, String string2) {
        String string3 = string;
        if (string != null) {
            if (string.length() < n) {
                while (string3.length() < n) {
                    string3 = String.valueOf(string3) + string2;
                }
            } else if (string.length() > n) {
                string3 = string.substring(0, n);
            }
        }
        return string3;
    }

    public static Vector arrayToVector(Object[] objectArray) {
        Vector<String> vector = null;
        if (objectArray != null) {
            vector = new Vector<String>();
            int n = 0;
            while (n < objectArray.length) {
                vector.addElement(objectArray[n].toString());
                ++n;
            }
        }
        return vector;
    }

    public static Vector stringToVector(String string) {
        Vector<String> vector = null;
        if (string != null) {
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken().trim());
            }
        }
        return vector;
    }

    public static String vectorToString(Vector vector) {
        String string = null;
        StringBuffer stringBuffer = null;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement());
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString().trim();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassLoaderForResource(ClassLoader classLoader, String string) {
        if (classLoader == null || string == null) {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.setClassLoaderForResource");
            LogUtil.errorMsg(string2);
            return;
        }
        Object object = resourceLoaderMapLock;
        synchronized (object) {
            if (resourceLoaders == null) {
                resourceLoaders = new HashMap();
            }
            resourceLoaders.put(string, classLoader);
        }
    }

    public static ClassLoader getClassLoaderForResource(String string) {
        if (string == null) {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.getClassLoaderForResource");
            LogUtil.errorMsg(string2);
            return null;
        }
        ClassLoader classLoader = null;
        if (resourceLoaders != null) {
            classLoader = (ClassLoader)resourceLoaders.get(string);
        }
        if (classLoader == null) {
            classLoader = defaultResourceLoader;
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClassLoaderForResource(String string) {
        if (string == null) {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.removeClassLoaderForResource");
            LogUtil.errorMsg(string2);
            return;
        }
        Object object = resourceLoaderMapLock;
        synchronized (object) {
            if (resourceLoaders != null) {
                resourceLoaders.remove(string);
            }
        }
    }

    public static ClassLoader getDefaultResourceClassLoader() {
        return defaultResourceLoader;
    }

    public static void setDefaultResourceClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.setDefaultResourceClassLoader");
            LogUtil.errorMsg(string);
        } else {
            defaultResourceLoader = classLoader;
        }
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        String string4 = String.valueOf(string.substring(0, n)) + string3;
        String string5 = string.substring(n + string2.length(), string.length());
        return String.valueOf(string4) + LogUtil.replace(string5, string2, string3);
    }

    public static void setErrWriter(PrintWriter printWriter) {
        currentErrWriter = printWriter != null ? printWriter : defaultErrWriter;
    }

    public static void setErrLocale(Locale locale) {
        if (locale != null) {
            msgs.setLocale(locale);
        }
    }
}

