/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.disk.discovery.TopLevelDiscoveryProcess;
import org.eclipse.aperi.disk.discovery.TopLevelProcess;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.tape.api.ITapeCollectionService;
import org.eclipse.aperi.tape.collection.ProbeGenericTapeLibraryProcess;
import org.eclipse.aperi.tape.collection.ProbeTapeLibraryProcess;
import org.eclipse.aperi.tape.collection.TapeProbeDispatcher;
import org.eclipse.aperi.util.osgi.ServiceHelper;

public class TapeCollectionService
implements ITapeCollectionService {
    ServiceHelper cServiceHelper;
    protected static String className;
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.tape.TapeCollectionService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }

    public TapeCollectionService(ServiceHelper serviceHelper) {
        Class<?> clazz;
        this.cServiceHelper = serviceHelper;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IDiscoverRouterService iDiscoverRouterService = (IDiscoverRouterService)this.cServiceHelper.bindLocal(clazz);
        iDiscoverRouterService.addProcess("collectStorageSubsystemsFromCIMOM", (IDiscoverProcess)new TopLevelDiscoveryProcess("collectStorageSubsystemsFromCIMOM", false));
        iDiscoverRouterService.addProcess("dispatchDiscoveryProcess", (IDiscoverProcess)new TopLevelProcess("dispatchDiscoveryProcess", true));
        iDiscoverRouterService.addProcess("collectDataFromTapeLibrary", (IDiscoverProcess)new TapeProbeDispatcher("collectDataFromTapeLibrary", false));
        iDiscoverRouterService.addProcess("collectDataFromSingleTapeLibrary", (IDiscoverProcess)new ProbeTapeLibraryProcess("collectDataFromSingleTapeLibrary", true));
        iDiscoverRouterService.addProcess("probeTapeLibraryProcess", (IDiscoverProcess)new ProbeTapeLibraryProcess("probe/collect generic Tape Library", true));
        ProbeGenericTapeLibraryProcess.addLegacyDiscoverProcess(iDiscoverRouterService);
    }

    public AsyncResult discoverTapeLibraries(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        String string = "discoverTapeLibraries";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (stringArray != null && stringArray.length == 0) {
            throw new MissingParameterException(1, new SRMMessage("HWNTM0002E", new String[]{"pCimomIDs"}));
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        AsyncResult asyncResult = new AsyncResult(0, -1);
        hashtable.put("CIMOMID_PARAM", stringArray);
        hashtable.put("Type", "ToplevelLibrary");
        String string2 = this.getDiscoverProxy().discover("dispatchDiscoveryProcess", hashtable);
        asyncResult = this.getDiscoverProxy().getJobStatus(string2);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return asyncResult;
    }

    public AsyncResult probeTapeLibraries(String[] stringArray, Integer n) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.probeTapeLibraries(stringArray, (int)n);
    }

    public AsyncResult probeTapeLibraries(String[] stringArray, int n) throws ServerException, InvalidParameterException, MissingParameterException {
        String string = "probeTapeLibraries";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string, (Object)new Integer(n));
        }
        if (stringArray != null && stringArray.length == 0) {
            throw new MissingParameterException(1, new SRMMessage("HWNTM0002E", new String[]{"pTapeLibIDs"}));
        }
        if (n != 2 && n != 3) {
            throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid collection type: " + new Integer(n)}));
        }
        AsyncResult asyncResult = new AsyncResult(0, -1);
        Properties properties = new Properties();
        properties.put("TAPELIBRARY", stringArray);
        properties.put("COLLTYPE", new Integer(n));
        String string2 = this.getDiscoverProxy().discover("collectDataFromTapeLibrary", (Hashtable)properties);
        asyncResult = this.getDiscoverProxy().getJobStatus(string2);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return asyncResult;
    }

    protected IDiscover getDiscoverProxy() {
        return (IDiscover)this.cServiceHelper.bindLocal("DiscoverService");
    }
}

