/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.data.Entity;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.MissingUniqueIdException;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.Response;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.snmp.SnmpSocketException;

public class SensorEventScanner
extends SNMPScanner {
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    private String SCANNERNAME = "SensorEvent";
    private String SCANNERTYPE = "outband";
    private int WWNSIZE = 32;
    private String OUTBAND_SENSOREVENT_SCANNER = "OutbandSensorEventScanner:";
    private String version = "5.0.0";
    public static final String Unknown_text = "Unknown";
    public static final String Unused_text = "Unused";
    public static final String OK_text = "OK";
    public static final String Warning_text = "Warning";
    public static final String Failed_text = "Failed";
    public static final String Online_text = "Online";
    public static final String Offline_text = "Offline";
    public static final String Other_text = "Other";
    public static final String Battery_text = "Battery";
    public static final String Fan_text = "Fan";
    public static final String PowerSupply_text = "Power-Supply";
    public static final String Transmitter_text = "Transmitter";
    public static final String Enclosure_text = "Enclosure";
    public static final String Board_text = "Board";
    public static final String Receiver_text = "Receiver";
    public static final String Temperature_text = "Temperature";
    public static final String Pressure_text = "Pressure";
    public static final String Emf_text = "Emf";
    public static final String CurrentValue_text = "Currentvalue";
    public static final String Airflow_text = "Airflow";
    public static final String Frequency_text = "Frequency";
    public static final String Door_text = "Door";
    public static final String Status_text = "Status";
    public static final String Configuration_text = "Configuration";
    public static final String Topology_text = "Topology";
    public static final String Chassis_text = "Chassis";
    public static final String Backplane_text = "Backplane";
    public static final String Container_text = "Container";
    public static final String Sensor_text = "Sensor";
    public static final String Module_text = "Module";
    public static final String Port_text = "Port";
    public static final String Power_text = "Power";
    String result = new String();
    Header header = null;
    Vector connUnitList = new Vector();
    Vector sensorList = new Vector();
    Vector eventList = new Vector();
    Vector sensorEntityList = new Vector();
    Vector sensorPwrList = new Vector();
    Vector sensorFanList = new Vector();

    static {
        Class<?> clazz;
        msgLogger = SNMPScanner.msgLogger;
        traceLogger = SNMPScanner.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.SensorEventScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    private void setConnUnitValues(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals(Status_text)) {
                    String string = parameter.getActualValue();
                    if (string.equals("1")) {
                        parameter.setValue(Unknown_text);
                    } else if (string.equals("2")) {
                        parameter.setValue(Unused_text);
                    } else if (string.equals("3")) {
                        parameter.setValue(OK_text);
                    } else if (string.equals("4")) {
                        parameter.setValue(Warning_text);
                    } else if (string.equals("5")) {
                        parameter.setValue(Failed_text);
                    }
                }
                if (parameter.getName().equals("State")) {
                    if (parameter.getActualValue().equals("1")) {
                        parameter.setValue(Unknown_text);
                    } else if (parameter.getActualValue().equals("2")) {
                        parameter.setValue(Online_text);
                    } else if (parameter.getActualValue().equals("3")) {
                        parameter.setValue(Offline_text);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void setSensorValues(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                String string;
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals(Status_text)) {
                    string = parameter.getActualValue();
                    if (string.equals("1")) {
                        parameter.setValue(Unknown_text);
                    } else if (string.equals("2")) {
                        parameter.setValue(Other_text);
                    } else if (string.equals("3")) {
                        parameter.setValue(OK_text);
                    } else if (string.equals("4")) {
                        parameter.setValue(Warning_text);
                    } else if (string.equals("5")) {
                        parameter.setValue(Failed_text);
                    }
                }
                if (parameter.getName().equals("Type")) {
                    string = parameter.getActualValue();
                    if (string.equals("1")) {
                        parameter.setValue(Unknown_text);
                    } else if (string.equals("2")) {
                        parameter.setValue(Other_text);
                    } else if (string.equals("3")) {
                        parameter.setValue(Battery_text);
                    } else if (string.equals("4")) {
                        parameter.setValue(Fan_text);
                    } else if (string.equals("5")) {
                        parameter.setValue(PowerSupply_text);
                    } else if (string.equals("6")) {
                        parameter.setValue(Transmitter_text);
                    } else if (string.equals("7")) {
                        parameter.setValue(Enclosure_text);
                    } else if (string.equals("8")) {
                        parameter.setValue(Board_text);
                    } else if (string.equals("9")) {
                        parameter.setValue(Receiver_text);
                    }
                }
                if (parameter.getName().equals("Characteristic")) {
                    string = parameter.getActualValue();
                    if (string.equals("1")) {
                        parameter.setValue(Unknown_text);
                    } else if (string.equals("2")) {
                        parameter.setValue(Other_text);
                    } else if (string.equals("3")) {
                        parameter.setValue(Temperature_text);
                    } else if (string.equals("4")) {
                        parameter.setValue(Pressure_text);
                    } else if (string.equals("5")) {
                        parameter.setValue(Emf_text);
                    } else if (string.equals("6")) {
                        parameter.setValue(CurrentValue_text);
                    } else if (string.equals("7")) {
                        parameter.setValue(Airflow_text);
                    } else if (string.equals("8")) {
                        parameter.setValue(Frequency_text);
                    } else if (string.equals("9")) {
                        parameter.setValue(Power_text);
                    } else if (string.equals("10")) {
                        parameter.setValue(Door_text);
                    }
                }
                if (parameter.getName().equals("Message")) {
                    string = SensorEventScanner.convertHexStringToAscii(parameter.getActualValue());
                    parameter.setValue(string);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void setEventValues(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                String string;
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Type")) {
                    string = parameter.getActualValue();
                    if (string.equals("1")) {
                        parameter.setValue(Unknown_text);
                    } else if (string.equals("2")) {
                        parameter.setValue(Other_text);
                    } else if (string.equals("3")) {
                        parameter.setValue(Status_text);
                    } else if (string.equals("4")) {
                        parameter.setValue(Configuration_text);
                    } else if (string.equals("5")) {
                        parameter.setValue(Topology_text);
                    }
                }
                if (parameter.getName().equals("Description")) {
                    string = SensorEventScanner.convertHexStringToAscii(parameter.getActualValue());
                    parameter.setValue(string);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void setCiscoSensorValues(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                String string;
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals(Status_text)) {
                    string = parameter.getActualValue();
                    if (string.equals("1")) {
                        parameter.setValue(Unknown_text);
                    } else if (string.equals("2")) {
                        parameter.setValue(Online_text);
                    } else if (string.equals("3")) {
                        parameter.setValue(Offline_text);
                    }
                }
                if (parameter.getName().equals("Type")) {
                    string = parameter.getActualValue();
                    if (string.equals("1")) {
                        parameter.setValue(Other_text);
                    } else if (string.equals("2")) {
                        parameter.setValue(Unknown_text);
                    } else if (string.equals("3")) {
                        parameter.setValue(Chassis_text);
                    } else if (string.equals("4")) {
                        parameter.setValue(Backplane_text);
                    } else if (string.equals("5")) {
                        parameter.setValue(Container_text);
                    } else if (string.equals("6")) {
                        parameter.setValue(PowerSupply_text);
                    } else if (string.equals("7")) {
                        parameter.setValue(Fan_text);
                    } else if (string.equals("8")) {
                        parameter.setValue(Sensor_text);
                    } else if (string.equals("9")) {
                        parameter.setValue(Module_text);
                    } else if (string.equals("10")) {
                        parameter.setValue(Port_text);
                    }
                }
                if (parameter.getName().equals("Message")) {
                    string = SensorEventScanner.convertHexStringToAscii(parameter.getActualValue());
                    parameter.setValue(string);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void fixConnUnitAndIndexValues(Vector vector, Vector vector2) {
        int n;
        String string = null;
        int n2 = 0;
        while (n2 < vector2.size()) {
            Entity entity = (Entity)vector2.elementAt(n2);
            n = 0;
            while (n < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n);
                if (parameter.getName().equals("Index")) {
                    string = parameter.getActualValue();
                    if (!string.equals("")) break;
                    string = Integer.toString(n2 + 1);
                    parameter.setValue(string);
                    break;
                }
                ++n;
            }
            ++n2;
        }
        n2 = vector.size();
        int n3 = 0;
        n = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < vector2.size()) {
            Object object;
            boolean bl = false;
            Entity entity = (Entity)vector2.elementAt(n5);
            int n6 = 0;
            while (n6 < entity.getParameterList().size()) {
                String string2;
                object = (Parameter)entity.getParameterList().elementAt(n6);
                if (((Parameter)object).getName().equals("Index")) {
                    string = ((Parameter)object).getActualValue();
                    n4 = Integer.valueOf(string);
                }
                if (((Parameter)object).getName().equals("ConnUnitWWN") && (string2 = ((Parameter)object).getActualValue()).equals("")) {
                    bl = true;
                }
                ++n6;
            }
            if (bl) {
                if (n4 < n && ++n3 > n2 - 1) {
                    n3 = n2 - 1;
                }
                Entity entity2 = (Entity)vector.elementAt(n3);
                object = entity2.getUniqueId();
                int n7 = 0;
                while (n7 < entity.getParameterList().size()) {
                    Parameter parameter = (Parameter)entity.getParameterList().elementAt(n7);
                    if (parameter.getName().equals("ConnUnitWWN")) {
                        String string3 = parameter.getActualValue();
                        if (!string3.equals("")) break;
                        parameter.setValue((String)object);
                        break;
                    }
                    ++n7;
                }
            }
            n = n4;
            ++n5;
        }
    }

    private void setSensorEventUniqueIds(Vector vector) {
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            int n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                Parameter parameter = (Parameter)entity.getParameterList().elementAt(n2);
                if (parameter.getName().equals("Index")) {
                    string = parameter.getActualValue();
                }
                if (parameter.getName().equals("ConnUnitWWN")) {
                    string2 = parameter.getActualValue();
                }
                ++n2;
            }
            entity.setUniqueId(String.valueOf(string2) + ":" + string);
            ++n;
        }
    }

    private String getSubstring(String string) {
        String string2 = "getSubString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter= " + string));
        }
        if (string.length() >= this.WWNSIZE && this.isZeroSubstring(string)) {
            String string3 = string.substring(0, 16);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return string3;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string;
    }

    private boolean isZeroSubstring(String string) {
        String string2 = string.substring(16, string.length());
        boolean bl = true;
        int n = 0;
        while (n < string2.length()) {
            if (string2.charAt(n) != '0') {
                bl = false;
                break;
            }
            bl = true;
            ++n;
        }
        return bl;
    }

    private void resetUniqueId(Vector vector) {
        String string = "resetUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Entity's Unique ID Value = " + entity.getUniqueId());
            }
            String string2 = this.getSubstring(entity.getUniqueId());
            entity.setUniqueId(string2);
            Vector vector2 = entity.getParameterList();
            int n2 = 0;
            while (n2 < vector2.size()) {
                Parameter parameter = (Parameter)vector2.elementAt(n2);
                String string3 = parameter.getActualValue();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Parameter Value = " + string3);
                }
                String string4 = this.getSubstring(string3);
                parameter.setValue(string4);
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void hardcodeValue(Vector vector, String string, String string2) {
        int n = 0;
        while (n < vector.size()) {
            ((Entity)vector.elementAt(n)).addParameter(string, string2);
            ++n;
        }
    }

    public String getScannerHeader(String string, String string2) {
        String string3 = null;
        String string4 = null;
        if (this.header == null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
                string4 = inetAddress.getHostAddress();
            }
            catch (Exception exception) {}
            this.header = new Header(string2, string, this.SCANNERTYPE, String.valueOf(this.OUTBAND_SENSOREVENT_SCANNER) + string4, "5.0.0");
        }
        string3 = this.header.toString();
        return string3;
    }

    public org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response invoke(String string, String[] stringArray) throws SnmpSocketException, UnknownHostException, Exception, MissingUniqueIdException {
        HashMap hashMap;
        boolean bl = false;
        String string2 = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        this.switchIpAddress = stringArray[0];
        String[] stringArray2 = new String[]{this.CONNUNITGLOBALID, this.CONNUNITSTATE, this.CONNUNITSTATUS};
        String[] stringArray3 = new String[]{this.CONNUNITGLOBALID_OLD, this.CONNUNITSTATE_OLD, this.CONNUNITSTATUS_OLD};
        String[] stringArray4 = new String[]{this.CONNUNITSENSORNAME, this.CONNUNITSENSORSTATUS, this.CONNUNITSENSORINFO, this.CONNUNITSENSORMESSAGE, this.CONNUNITSENSORTYPE, this.CONNUNITSENSORCHARACTERISTIC};
        String[] stringArray5 = new String[]{this.CONNUNITSENSORUNITID_OLD, this.CONNUNITSENSORINDEX_OLD, this.CONNUNITSENSORNAME_OLD, this.CONNUNITSENSORSTATUS_OLD, this.CONNUNITSENSORINFO_OLD, this.CONNUNITSENSORMESSAGE_OLD, this.CONNUNITSENSORTYPE_OLD, this.CONNUNITSENSORCHARACTERISTIC_OLD};
        String[] stringArray6 = new String[]{this.CONNUNITEVENTINDEX, this.CONNUNITREVENTTIME, this.CONNUNITSEVENTTIME, this.CONNUNITEVENTSEVERITY, this.CONNUNITEVENTTYPE, this.CONNUNITEVENTOBJECT, this.CONNUNITEVENTDESCR};
        String[] stringArray7 = new String[]{this.CONNUNITEVENTUNITID_OLD, this.CONNUNITEVENTINDEX_OLD, this.CONNUNITREVENTTIME_OLD, this.CONNUNITSEVENTTIME_OLD, this.CONNUNITEVENTSEVERITY_OLD, this.CONNUNITEVENTTYPE_OLD, this.CONNUNITEVENTOBJECT_OLD, this.CONNUNITEVENTDESCR_OLD};
        String[] stringArray8 = new String[]{this.CISCOFCFEELEMENTNAME};
        String[] stringArray9 = new String[]{this.ENTPHYSICALNAME, this.ENTPHYSICALCLASS, this.ENTPHYSICALDESCR};
        String[] stringArray10 = new String[]{this.CEFCFRUPOWEROPERSTATUS};
        String[] stringArray11 = new String[]{this.CEFCFANTRAYOPERSTATUS};
        InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
        String string3 = inetAddress.getHostAddress();
        this.header = new Header(stringArray[0], string, this.SCANNERTYPE, String.valueOf(this.OUTBAND_SENSOREVENT_SCANNER) + string3, "5.0.0");
        this.result = this.header.toString();
        if (this.isCiscoMdsSwitch(stringArray[0]) == 1) {
            bl = true;
        }
        this.setScanType(2);
        if (bl) {
            this.connUnitList = this.runProcess(stringArray[0], stringArray8);
            if (this.connUnitList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Failed to get Fabric Element WWN for target device " + stringArray[0]);
                }
                throw new MissingUniqueIdException();
            }
            this.setScanType(4);
            this.sensorEntityList = this.runProcess(stringArray[0], stringArray9);
            if (this.sensorEntityList.isEmpty() && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Failed to get Entity data for target device " + stringArray[0]);
            }
            this.sensorPwrList = this.runProcess(stringArray[0], stringArray10);
            if (this.sensorPwrList.isEmpty() && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Failed to get Power options for target device " + stringArray[0]);
            }
            this.sensorFanList = this.runProcess(stringArray[0], stringArray11);
            if (this.sensorFanList.isEmpty() && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Failed to get Fan data for target device " + stringArray[0]);
            }
            hashMap = this.createEntityHashMap(this.sensorEntityList);
            this.sensorList = this.compileSensorData(hashMap, this.sensorPwrList, this.sensorFanList);
        } else {
            this.connUnitList = this.runProcess(stringArray[0], stringArray2);
            if (this.connUnitList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "The target device " + stringArray[0] + " supports old FC MGMT MIB");
                }
                this.connUnitList = this.runProcess(stringArray[0], stringArray3);
            }
            if (this.connUnitList.isEmpty()) {
                throw new MissingUniqueIdException();
            }
            this.setScanType(4);
            this.sensorList = this.runProcess(stringArray[0], stringArray4);
            if (this.sensorList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "The target device " + stringArray[0] + " supports old FC MGMT MIB");
                }
                this.sensorList = this.runProcess(stringArray[0], stringArray5);
            }
            this.setScanType(5);
            this.eventList = this.runProcess(stringArray[0], stringArray6);
            if (this.eventList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "The target device " + stringArray[0] + " supports old FC MGMT MIB");
                }
                this.eventList = this.runProcess(stringArray[0], stringArray7);
            }
        }
        this.resetUniqueId(this.connUnitList);
        this.resetUniqueId(this.sensorList);
        this.resetUniqueId(this.eventList);
        this.fixConnUnitAndIndexValues(this.connUnitList, this.sensorList);
        this.fixConnUnitAndIndexValues(this.connUnitList, this.eventList);
        this.setSensorEventUniqueIds(this.sensorList);
        this.setSensorEventUniqueIds(this.eventList);
        this.setConnUnitValues(this.connUnitList);
        if (bl) {
            this.setCiscoSensorValues(this.sensorList);
        } else {
            this.setSensorValues(this.sensorList);
        }
        this.setEventValues(this.eventList);
        this.result = this.result.concat(this.sensorEventOutputGenerator());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, this.result);
        }
        hashMap = new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(Response.RETURN_CODE_OK, this.result);
        this.eventList = null;
        this.connUnitList = null;
        this.sensorList = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return hashMap;
    }

    private HashMap createEntityHashMap(Vector vector) {
        HashMap<String, Entity> hashMap = new HashMap<String, Entity>();
        String string = "createEntityHashMap";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            Entity entity = (Entity)vector.elementAt(n);
            String string2 = entity.getName();
            String string3 = string2.substring(string2.lastIndexOf(".") + 1);
            hashMap.put(string3, entity);
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return hashMap;
    }

    private Vector compileSensorData(HashMap hashMap, Vector vector, Vector vector2) throws Exception {
        Vector vector3 = new Vector();
        String string = "compileSensorData";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        vector3.addAll(vector);
        vector3.addAll(vector2);
        this.getIndex(hashMap, vector3);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector3;
    }

    private void getIndex(HashMap hashMap, Vector vector) throws Exception {
        String string = "getIndex";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < vector.size()) {
            int n2;
            Entity entity = (Entity)vector.elementAt(n);
            String string2 = entity.getName();
            String string3 = string2.substring(string2.lastIndexOf(".") + 1);
            Entity entity2 = (Entity)hashMap.get(string3);
            if (entity2 != null) {
                n2 = 0;
                while (n2 < entity2.getParameterList().size()) {
                    String string4 = entity2.getParamNameAt(n2);
                    if (string4 != null && (string4.equals("Name") || string4.equals("Info") || string4.equals("Type"))) {
                        entity.addParameter(string4, entity2.getParamValueAt(n2));
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < entity.getParameterList().size()) {
                if (entity.getParamNameAt(n2).equals("Index")) {
                    entity.setParamValueAt(n2, string3);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public String sensorEventOutputGenerator() {
        Entity entity;
        String string = "sensorEventOutputGenerator";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        String string2 = new String();
        int n = 0;
        while (n < this.connUnitList.size()) {
            entity = (Entity)this.connUnitList.elementAt(n);
            string2 = string2.concat(entity.toString());
            ++n;
        }
        n = 0;
        while (n < this.sensorList.size()) {
            entity = (Entity)this.sensorList.elementAt(n);
            string2 = string2.concat(entity.toString());
            ++n;
        }
        n = 0;
        while (n < this.eventList.size()) {
            entity = (Entity)this.eventList.elementAt(n);
            string2 = string2.concat(entity.toString());
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string2;
    }

    private Vector runProcess(String string, String[] stringArray) throws SnmpSocketException, UnknownHostException, Exception {
        String string2 = "runProcess";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        Vector vector = new Vector();
        boolean bl = false;
        int n = this.queryRetryCount + 1;
        int n2 = 0;
        while (n2 < n) {
            vector = this.runSnmpQuery(string, stringArray);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "--------> Statistics:: runProcess: " + string + " counter =" + n2);
            }
            if (!this.ERROR_FLAG) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new Exception("Unable to contact the host " + string + " after " + n + " attempts!");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            SensorEventScanner sensorEventScanner = new SensorEventScanner();
            org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response response = sensorEventScanner.invoke("SensorEvent", stringArray);
            System.out.println(response);
            System.out.println("==================");
        }
        catch (Exception exception) {
            System.out.println("Main: " + exception);
        }
    }
}

