/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.data.NoSnmpDestinationException;
import org.eclipse.aperi.sanmgmt.event.data.SnmpAddress;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class DestinationFactory {
    private ILogger msgLogger = null;
    private ILogger traceLogger = null;
    private IConfigService dbParms = null;
    private static final String TEC_SERVER_LOCATION_KEY = "TECServerLocation";
    private static final String TEC_SERVER_PORT_KEY = "TECServerPort";
    private static final String TEC_DEBUG_MODE_KEY = "TECDebugMode";
    public static final int DEFAULT_TEC_PORTNUM = 0;
    private ArrayList snmpAddrList = null;
    private String tecServerLocation = null;
    private int tecServerPort = 0;
    private String tecDebugMode = "NO";
    private String callBackURL = null;
    private static final String className;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.DestinationFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    DestinationFactory(ILogger iLogger, ILogger iLogger2, IConfigService iConfigService) {
        this.msgLogger = iLogger;
        this.traceLogger = iLogger2;
        if (iLogger2.isLogging()) {
            iLogger2.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "DestinationFactory");
        }
        this.dbParms = iConfigService;
        if (iLogger2.isLogging()) {
            iLogger2.exit(IRecordType.TYPE_EXIT, (Object)className, "DestinationFactory");
        }
    }

    synchronized boolean init() {
        boolean bl;
        block4: {
            bl = false;
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "init");
            }
            try {
                this.snmpAddrList = this.retrieveAllSnmpAddr();
                this.tecServerLocation = this.retrieveTECServerLocation();
                this.tecServerPort = this.retrieveTECServerPort();
                this.tecDebugMode = this.retrieveTECDebugMode();
                String string = this.dbParms.getProperty("manager.loc", "setup");
                String string2 = this.dbParms.getProperty("manager.port", "setup");
                this.callBackURL = String.valueOf(string) + ":" + string2;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "init", "callBackURL=" + this.callBackURL);
                this.dbParms.register(TEC_SERVER_LOCATION_KEY, "user", this.callBackURL, "SANEvent");
                this.dbParms.register(TEC_SERVER_PORT_KEY, "user", this.callBackURL, "SANEvent");
                bl = true;
            }
            catch (Exception exception) {
                this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "init", "SANEventMessage_ErrorReadingSnmpTECAddresses", (Object)"user");
                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "init", (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "init", (Throwable)exception);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "init");
        }
        return bl;
    }

    synchronized void close() {
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "close");
        }
        this.dbParms.deRegister(TEC_SERVER_LOCATION_KEY, "user", this.callBackURL, "SANEvent");
        this.dbParms.deRegister(TEC_SERVER_PORT_KEY, "user", this.callBackURL, "SANEvent");
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "close");
        }
    }

    public synchronized void propCallback(String string, String string2, String string3) {
        block8: {
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "propCallback", (Object)("name=" + string + ", group=" + string2 + ", value=" + string3));
            }
            if (string2.equals("user")) {
                if (string.equals(TEC_SERVER_LOCATION_KEY)) {
                    this.tecServerLocation = string3;
                } else if (string.equals(TEC_SERVER_PORT_KEY)) {
                    try {
                        this.tecServerPort = string3 == null || string3.equals("") ? 0 : Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block8;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "propCallback", (Throwable)numberFormatException);
                    }
                }
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "propCallback", (Object)("tecServerLocation = " + this.tecServerLocation + ", tecServerPort = " + this.tecServerPort));
        }
    }

    synchronized ArrayList getAllSnmpAddr() {
        return this.snmpAddrList;
    }

    synchronized String getTECServerLocation() {
        return this.tecServerLocation;
    }

    synchronized int getTECServerPort() {
        return this.tecServerPort;
    }

    synchronized String getTECDebugMode() {
        return this.tecDebugMode;
    }

    ArrayList retrieveAllSnmpAddr() {
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "retrieveAllSnmpAddr");
        }
        ArrayList<SnmpAddress> arrayList = new ArrayList<SnmpAddress>();
        ArrayList arrayList2 = this.dbParms.getKeys("user");
        if (!arrayList2.isEmpty()) {
            String string = null;
            int n = 0;
            while (n < arrayList2.size()) {
                SnmpAddress snmpAddress;
                string = (String)arrayList2.get(n);
                if (this.dbParms.getProperty(string, "user").equals("SnmpAddress") && (snmpAddress = this.stringToSnmpAddr(string)) != null) {
                    arrayList.add(snmpAddress);
                    if (this.traceLogger.isLogging()) {
                        try {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "retrieveAllSnmpAddr", "Snmp Destination = " + snmpAddress.getSnmpDestination() + ", port = " + snmpAddress.getSnmpPort() + ", community = " + snmpAddress.getCommunityName());
                        }
                        catch (NoSnmpDestinationException noSnmpDestinationException) {}
                    }
                }
                ++n;
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "retrieveAllSnmpAddr");
        }
        return arrayList;
    }

    String retrieveTECServerLocation() {
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "retrieveTECServerLocation");
        }
        String string = null;
        string = this.dbParms.getProperty(TEC_SERVER_LOCATION_KEY, "user");
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "retrieveTECServerLocation", (Object)("TEC Server location = " + string));
        }
        return string;
    }

    int retrieveTECServerPort() {
        int n;
        block6: {
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "getTECServerPort");
            }
            n = 0;
            String string = null;
            try {
                string = this.dbParms.getProperty(TEC_SERVER_PORT_KEY, "user");
                if (string != null && !string.equals("")) {
                    n = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getTECServerPort", (Throwable)exception);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getTECServerPort", (Throwable)exception);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "getTECServerPort", (Object)("TEC Server port = " + n));
        }
        return n;
    }

    String retrieveTECDebugMode() {
        String string;
        block6: {
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "retrieveTECDebugMode");
            }
            string = null;
            try {
                string = this.dbParms.getProperty(TEC_DEBUG_MODE_KEY, "user");
                if (string == null || string.equals("")) {
                    string = "NO";
                }
            }
            catch (Exception exception) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "retrieveTECDebugMode", (Throwable)exception);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "retrieveTECDebugMode", (Throwable)exception);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "retrieveTECDebugMode", (Object)("TEC Debug Mode = " + string));
        }
        return string;
    }

    public synchronized boolean setSnmpAddr(SnmpAddress snmpAddress) {
        boolean bl;
        block11: {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "setSnmpAddr");
            }
            bl = false;
            String string = this.snmpAddrToString(snmpAddress);
            if (string != null) {
                try {
                    int n = this.dbParms.setProperty(string, "user", "SnmpAddress");
                    if (n != 0) {
                        if (this.msgLogger != null) {
                            this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "setSnmpAddr", "SANEventMessage_snmpAddrNotSaved", (Object)"user.properties");
                        }
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, "setSnmpAddr", "Unable to save SnmpAddr entry to USER Properties table.");
                        }
                    } else {
                        int n2 = this.snmpAddrList.indexOf(snmpAddress);
                        if (n2 == -1) {
                            this.snmpAddrList.add(snmpAddress);
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setSnmpAddr", (Throwable)exception);
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setSnmpAddr", (Throwable)exception);
                }
            }
        }
        bl = true;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "setSnmpAddr");
        }
        return bl;
    }

    public synchronized boolean deleteSnmpAddr(SnmpAddress snmpAddress) {
        boolean bl;
        block11: {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "deleteSnmpAddr");
            }
            bl = false;
            String string = this.snmpAddrToString(snmpAddress);
            if (string != null) {
                try {
                    int n = this.dbParms.remove(string, "user");
                    if (n != 0) {
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, "deleteSnmpAddr", "Unable to delete SnmpAddr entry from the USER Properties table.");
                        }
                        if (this.msgLogger != null) {
                            this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "deleteSnmpAddr", "SANEventMessage_snmpAddrNotRemoved", (Object)"user.properties");
                        }
                    } else {
                        int n2 = this.snmpAddrList.indexOf(snmpAddress);
                        if (n2 != -1) {
                            this.snmpAddrList.remove(n2);
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "deleteSnmpAddr", (Throwable)exception);
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "deleteSnmpAddr", (Throwable)exception);
                }
            }
        }
        bl = true;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "deleteSnmpAddr");
        }
        return bl;
    }

    private String snmpAddrToString(SnmpAddress snmpAddress) {
        String string;
        String string2;
        String string3;
        block10: {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "snmpAddrToString");
            }
            string3 = null;
            string2 = null;
            string = null;
            try {
                string3 = snmpAddress.getSnmpDestination();
            }
            catch (NoSnmpDestinationException noSnmpDestinationException) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "snmpAddrToString", "SANEventMessage_NoSnmpDestinationException");
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block10;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "snmpAddrToString", (Throwable)noSnmpDestinationException);
            }
        }
        if (string3 == null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "snmpAddrToString");
            }
            return null;
        }
        try {
            string2 = Integer.toString(snmpAddress.getSnmpPort());
        }
        catch (Exception exception) {
            string2 = "-1";
        }
        string = snmpAddress.getCommunityName();
        if (string == null) {
            string = "";
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "snmpAddrToString");
        }
        return String.valueOf(string3) + "?" + string2 + "?" + string;
    }

    private SnmpAddress stringToSnmpAddr(String string) {
        SnmpAddress snmpAddress;
        block7: {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "stringToSnmpAddr");
            }
            String string2 = null;
            int n = -1;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "?");
            if (!stringTokenizer.hasMoreTokens()) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "stringToSnmpAddr");
                }
                return null;
            }
            string2 = stringTokenizer.nextToken();
            n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : -1;
            string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            snmpAddress = null;
            try {
                snmpAddress = new SnmpAddress(string2, n, string3);
            }
            catch (NoSnmpDestinationException noSnmpDestinationException) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "stringToSnmpAddr", "SANEventMessage_NoSnmpDestinationException");
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block7;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "stringToSnmpAddr", (Throwable)noSnmpDestinationException);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "stringToSnmpAddr");
        }
        return snmpAddress;
    }
}

