/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmpagent.manager;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.TopologyScanner;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.OutbandScannerProperty;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmpagent.manager.DiscoverAgents;
import org.eclipse.aperi.snmpagent.manager.data.IPCapability;
import org.eclipse.aperi.snmpagent.manager.interfaces.ISNMPAgentManager;
import org.eclipse.aperi.snmpagent.manager.util.SqlUtil;
import org.eclipse.aperi.util.SRMCrypto;

public class SNMPAgentManager
implements ISNMPAgentManager,
IService,
ICliDispatcher,
Runnable {
    public static String className;
    public static final String MESSAGE_NAME = "aperi.logger.message.SnmpAgentManager";
    public static final String TRACE_NAME = "aperi.logger.trace.SnmpAgentManager";
    public static String MSG_FILE;
    public Status status = new Status(5, 6);
    public static String DEFAULT_SNMP_COMMUNITY;
    public static String DEFAULT_SNMP_RW_COMMUNITY;
    private Thread iWorkerThread;
    private boolean doingRefresh = false;
    private int pollingInterval;
    private static SNMPAgentManager snmpAgentManager;
    private static final HashMap capabilityMapping;
    private static final HashMap capabilityTypeName;
    private static boolean trace;
    private static boolean message;
    private OutbandScannerProperty outbandProp = null;
    private Hashtable activeCapabilityScans = new Hashtable();
    private static Object acsLock;
    protected static Object lock;
    private static final String ADD = "-add";
    private static final String UID = "-uid";
    private static final String PWD = "-pwd";
    private static final String TIMEOUT = "-timeout";
    private static final String SWITCHFILTER = "-switchfilter";
    public static final int SUCCESS = 0;
    public static final int INVALID_BROCADE_ID_PW = 2;
    public static final int NOT_BROCADE_SWITCH = 3;
    public static final int CANNOT_LOAD_SCANNER = -25;
    public static final int CANNOT_VALIDATE_LINUX_ID_PW = -42;
    public static IEventMonitorService monitorServiceProxy;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    public SNMPAgentManager thisSnmpMgr = null;
    protected boolean isShuttingDown = false;
    private String[] SCANNERS = new String[]{"PO2", "PO3", "PO4"};

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.snmpagent.manager.SNMPAgentManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
        DEFAULT_SNMP_COMMUNITY = "public";
        DEFAULT_SNMP_RW_COMMUNITY = "private";
        snmpAgentManager = null;
        capabilityMapping = new HashMap();
        capabilityTypeName = new HashMap();
        trace = true;
        message = true;
        acsLock = new Object();
        lock = new Object();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public void initialize() {
        String string = "initialize";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        acsLock = new Object();
        capabilityMapping.put("PO2", new Integer(1));
        capabilityMapping.put("PO3", new Integer(4));
        capabilityMapping.put("PO4", new Integer(32));
        capabilityTypeName.put(new Integer(1), "Topology");
        capabilityTypeName.put(new Integer(4), "Brocade");
        capabilityTypeName.put(new Integer(2), "Statistics");
        capabilityTypeName.put(new Integer(32), "CiscoMDS");
        monitorServiceProxy = SNMPAgentManager.getMonitorServiceProxy();
        this.iWorkerThread = new Thread((Runnable)this, "IpTarget Monitor");
        this.iWorkerThread.start();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public static IEventMonitorService getMonitorServiceProxy() {
        if (monitorServiceProxy == null) {
            monitorServiceProxy = (IEventMonitorService)FabricActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return monitorServiceProxy;
    }

    private int getMonitorInterval() {
        String string = "getMonitorInterval";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = Integer.valueOf("60000");
        if (this.outbandProp == null) {
            this.outbandProp = new OutbandScannerProperty();
        }
        if (this.outbandProp != null) {
            n = this.outbandProp.getOutbandAgentMonitorInterval();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Outband IpTarget monitor interval is " + n + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public String getDescription() {
        return "Service that monitors SNMP Agents";
    }

    public String getName() {
        return "SNMPAgentManager";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("SNMPAgentManager_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("SNMPAgentManager_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean startup() {
        String string;
        block7: {
            string = "startup";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            this.status.setRunStatus(9);
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                SnmpV1API.initialize((String)"", (int)-1, (boolean)true, null, (String)"org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig", (ClassLoader)clazz.getClassLoader());
            }
            catch (Exception exception) {
                if (message) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block7;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        this.initialize();
        this.status.setRunStatus(8);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dispatch(String string, String[] stringArray) {
        String string2 = "dispatch";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equalsIgnoreCase("help")) {
            stringBuffer.append("\nThe SNMPAgentManager CLI supports the following commands:\n");
            stringBuffer.append("\n");
            stringBuffer.append("    addTargets    targetIp1 targetIp2 ... targetIpn\n");
            stringBuffer.append("    removeTargets targetIp1 targetIp2 ... targetIpn\n");
            stringBuffer.append("    setUserIdPassword  targetIp userId password\n");
            stringBuffer.append("    updateCapabilities targetIp capability1 capability2 capability3\n");
            stringBuffer.append("\n");
            stringBuffer.append("    ping targetIp\n");
            stringBuffer.append("\n");
            stringBuffer.append("    discoverAgents startingIp [-add -t <timeoutInMillis> -switchFilter <ON|OFF> -uid <userid> -pwd <password> ]\n");
            stringBuffer.append("\n");
        } else if (string.equalsIgnoreCase("addTargets")) {
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
            this.addTargets(stringArray2);
            stringBuffer.append("Added " + stringArray.length + " Outband agents");
        } else if (string.equalsIgnoreCase("removeTargets")) {
            String[] stringArray3 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray3[n] = stringArray[n];
                ++n;
            }
            this.removeTargets(stringArray3);
            stringBuffer.append("Removed " + stringArray.length + " Outband agents");
        } else if (string.equalsIgnoreCase("setUserIdPassword")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Invalid number of parameters");
            } else {
                String string3 = stringArray[0];
                String string4 = null;
                String string5 = null;
                if (stringArray.length > 1) {
                    string4 = stringArray[1];
                    if (stringArray.length > 2) {
                        string5 = stringArray[2];
                    }
                }
                if (string5 != null) {
                    try {
                        string5 = SRMCrypto.encrypt(string5);
                    }
                    catch (Exception exception) {
                        stringBuffer.append("Could not encrypt the password.  The userId and password were not set for " + string3);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string2);
                        }
                        return stringBuffer.toString();
                    }
                }
                this.setUserIdPassword(string3, string4, string5);
                stringBuffer.append("The userId and password were set for " + string3);
            }
        } else if (string.equalsIgnoreCase("updateCapabilities")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Invalid number of parameters");
            } else {
                String string6 = this.getIpAddress(stringArray[0]);
                String[] stringArray4 = new String[stringArray.length - 1];
                int n = 1;
                while (n < stringArray.length) {
                    stringArray4[n - 1] = stringArray[n];
                    ++n;
                }
                n = 0;
                Object object = lock;
                synchronized (object) {
                    n = SqlUtil.updateCapability((String)string6, (String[])stringArray4) ? 1 : 0;
                }
                stringBuffer.append("The capabilities for " + string6 + " were ");
                if (n == 0) {
                    stringBuffer.append("not ");
                }
                stringBuffer.append("changed.");
            }
        } else if (string.equalsIgnoreCase("ping")) {
            if (stringArray.length != 1) {
                stringBuffer.append("Invalid number of parameters");
            } else {
                String string7 = stringArray[0];
                boolean bl = this.ping(string7);
                stringBuffer.append("The ping of " + string7 + " was ");
                if (!bl) {
                    stringBuffer.append("not ");
                }
                stringBuffer.append("successful.");
            }
        } else if (string.equalsIgnoreCase("discoverAgents")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Invalid number of parameters");
            } else {
                String string8 = stringArray[0].trim();
                Object[] objectArray = new String[4];
                Vector<String> vector = new Vector<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string8.trim(), ".");
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                    if (vector.size() == 3) break;
                }
                if (vector.size() < 3) {
                    stringBuffer.append("\n Invalid Ip address entered.");
                } else {
                    int n = 500;
                    boolean bl = false;
                    boolean bl2 = false;
                    String string9 = null;
                    String string10 = null;
                    boolean bl3 = true;
                    int n2 = 1;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].equalsIgnoreCase(ADD)) {
                            bl = true;
                        } else if (stringArray[n2].equalsIgnoreCase(SWITCHFILTER)) {
                            if (!(n2 + 1 >= stringArray.length || stringArray[n2 + 1].equalsIgnoreCase(ADD) || stringArray[n2 + 1].equalsIgnoreCase(UID) || stringArray[n2 + 1].equalsIgnoreCase(PWD) || stringArray[n2 + 1].equalsIgnoreCase(SWITCHFILTER) || stringArray[n2 + 1].equalsIgnoreCase(TIMEOUT))) {
                                bl3 = stringArray[++n2].equalsIgnoreCase("ON");
                            }
                        } else if (stringArray[n2].equalsIgnoreCase(TIMEOUT)) {
                            if (!(n2 + 1 >= stringArray.length || stringArray[n2 + 1].equalsIgnoreCase(ADD) || stringArray[n2 + 1].equalsIgnoreCase(UID) || stringArray[n2 + 1].equalsIgnoreCase(SWITCHFILTER) || stringArray[n2 + 1].equalsIgnoreCase(PWD) || stringArray[n2 + 1].equalsIgnoreCase(TIMEOUT))) {
                                n = Integer.valueOf(stringArray[++n2]);
                            }
                        } else if (stringArray[n2].equalsIgnoreCase(UID)) {
                            bl2 = true;
                            if (!(n2 + 1 >= stringArray.length || stringArray[n2 + 1].equalsIgnoreCase(ADD) || stringArray[n2 + 1].equalsIgnoreCase(UID) || stringArray[n2 + 1].equalsIgnoreCase(SWITCHFILTER) || stringArray[n2 + 1].equalsIgnoreCase(PWD) || stringArray[n2 + 1].equalsIgnoreCase(TIMEOUT))) {
                                string9 = stringArray[++n2];
                            }
                        } else if (stringArray[n2].equalsIgnoreCase(PWD)) {
                            bl2 = true;
                            if (n2 + 1 < stringArray.length) {
                                if (!(stringArray[n2 + 1].equalsIgnoreCase(ADD) || stringArray[n2 + 1].equalsIgnoreCase(UID) || stringArray[n2 + 1].equalsIgnoreCase(SWITCHFILTER) || stringArray[n2 + 1].equalsIgnoreCase(PWD) || stringArray[n2 + 1].equalsIgnoreCase(TIMEOUT))) {
                                    string10 = stringArray[++n2];
                                }
                                if (string10 != null) {
                                    try {
                                        string10 = SRMCrypto.encrypt(string10);
                                    }
                                    catch (Exception exception) {
                                        stringBuffer.append("Could not encrypt the password.");
                                        return stringBuffer.toString();
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                    vector.copyInto(objectArray);
                    String[] stringArray5 = DiscoverAgents.scan((String[])objectArray, n, bl3);
                    if (stringArray5.length > 0) {
                        int n3;
                        if (bl) {
                            if (bl2) {
                                n3 = 0;
                                while (n3 < stringArray5.length) {
                                    this.setUserIdPassword(stringArray5[n3], string9, string10);
                                    ++n3;
                                }
                            } else {
                                this.addTargets(stringArray5);
                            }
                        }
                        stringBuffer.append("\n  Outband agents found:");
                        n3 = 0;
                        while (n3 < stringArray5.length) {
                            String string11 = stringArray5[n3];
                            String string12 = "";
                            try {
                                InetAddress inetAddress = InetAddress.getByName(string11);
                                string12 = inetAddress.getHostName();
                            }
                            catch (Exception exception) {}
                            stringBuffer.append("\n    " + string11 + "   " + string12);
                            ++n3;
                        }
                    } else {
                        stringBuffer = stringBuffer.append("\n  No outband agents found.");
                    }
                }
            }
        } else {
            stringBuffer.append("Invalid command, Valid values are set, get, addTargets, removeTargets, setUserIdPassword, updateCapabilities, getActiveOutbandScanners, ping, discover, registerScan, and registerAllScans.");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string2);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string2);
        }
        return stringBuffer.toString();
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("SNMPAgentManager", new Integer(RoleChecker.FABRIC_ADMIN));
        return hashtable;
    }

    public String getIpAddress(String string) {
        String string2;
        String string3;
        block8: {
            string3 = "getIpAddress";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3);
            }
            string2 = string;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                string2 = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                if (message) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string3, "QueryEngine_invalidIPAddress", (Object)string);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string3, (Throwable)unknownHostException);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)unknownHostException);
                }
            }
            catch (Exception exception) {
                if (message) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string3, "QueryEngine_invalidIPAddress", (Object)string);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string3, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPCapability[] getTargets() {
        var1_1 = "getTargets";
        if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
            SNMPAgentManager.traceLogger.entry(IRecordType.TYPE_API, (Object)SNMPAgentManager.className, var1_1);
        }
        var2_2 = new Vector<IPCapability>();
        var3_3 = SNMPAgentManager.lock;
        synchronized (SNMPAgentManager.lock) {
            block33: {
                var4_4 = ServiceUtils.getConnection();
                try {
                    block32: {
                        try {
                            var5_5 = SqlUtil.getTargets((DBConnection)var4_4);
                            var6_7 = var5_5.iterator();
                            while (var6_7.hasNext()) {
                                block31: {
                                    var7_8 = (IpTarget)var6_7.next();
                                    var8_9 = var7_8.getIpAddress();
                                    var9_10 = var7_8.getUserId();
                                    var10_11 = var7_8.getPassword();
                                    var11_12 = (SNMPConfig)SnmpV1API.getConfig();
                                    var11_12.setSnmpCommunityName(var8_9, var7_8.getReadCommunityName());
                                    var11_12.setSnmpWriteCommunityName(var8_9, var7_8.getRwCommunityName());
                                    var12_13 = new IPCapability(var8_9, var9_10, var10_11);
                                    var13_14 = 0;
                                    var14_15 = null;
                                    try {
                                        block30: {
                                            try {
                                                var14_15 = SqlUtil.getCapability((DBConnection)var4_4, (String)var8_9, (String[])this.SCANNERS);
                                                while (var14_15.next()) {
                                                    var15_16 = var14_15.getString("SCANNER").trim();
                                                    var16_18 = var14_15.getInt("ENABLED");
                                                    if (var16_18 == 0) continue;
                                                    var13_14 |= ((Integer)SNMPAgentManager.capabilityMapping.get(var15_16)).intValue();
                                                }
                                            }
                                            catch (Exception var15_17) {
                                                if (SNMPAgentManager.message) {
                                                    SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var1_1, "IpTarget_getCapabilitiesError", (Object)var8_9);
                                                    SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var1_1, (Throwable)var15_17);
                                                }
                                                if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block30;
                                                SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var1_1, (Throwable)var15_17);
                                            }
                                        }
                                        var17_19 = null;
                                    }
                                    catch (Throwable var18_21) {
                                        var17_19 = null;
                                        try {
                                            if (var14_15 == null) throw var18_21;
                                            var14_15.closeAll();
                                            throw var18_21;
                                        }
                                        catch (Exception var19_20) {
                                            if (SNMPAgentManager.message) {
                                                SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var1_1, "IpTarget_getCapabilitiesError", (Object)var8_9);
                                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var1_1, (Throwable)var19_20);
                                            }
                                            if (SNMPAgentManager.traceLogger == null) throw var18_21;
                                            if (SNMPAgentManager.traceLogger.isLogging() == false) throw var18_21;
                                            SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var1_1, (Throwable)var19_20);
                                        }
                                        throw var18_21;
                                    }
                                    ** try [egrp 5[TRYBLOCK] [3 : 320->333)] { 
lbl60:
                                    // 1 sources

                                    if (var14_15 != null) {
                                        var14_15.closeAll();
                                    }
                                    break block31;
lbl63:
                                    // 1 sources

                                    catch (Exception var19_20) {
                                        if (SNMPAgentManager.message) {
                                            SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var1_1, "IpTarget_getCapabilitiesError", (Object)var8_9);
                                            SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var1_1, (Throwable)var19_20);
                                        }
                                        if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block31;
                                        SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var1_1, (Throwable)var19_20);
                                    }
                                }
                                var12_13.setInitialCapabilities(var13_14);
                                var2_2.addElement(var12_13);
                            }
                        }
                        catch (Exception var5_6) {
                            if (SNMPAgentManager.message) {
                                SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var1_1, "IpTarget_getTargetsError");
                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var1_1, (Throwable)var5_6);
                            }
                            if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block32;
                            SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var1_1, (Throwable)var5_6);
                        }
                    }
                    var20_24 = null;
                    if (var4_4 == null) break block33;
                }
                catch (Throwable var21_22) {
                    var20_23 = null;
                    if (var4_4 == null) throw var21_22;
                    try {
                        var4_4.commit();
                    }
                    catch (SQLException v0) {}
                    try {
                        var4_4.close();
                        throw var21_22;
                    }
                    catch (SQLException v1) {}
                    throw var21_22;
                }
                try {}
                catch (SQLException v2) {}
                var4_4.commit();
                try {}
                catch (SQLException v3) {}
                var4_4.close();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            var3_3 = new IPCapability[var2_2.size()];
            var2_2.toArray(var3_3);
            if (SNMPAgentManager.traceLogger == null) return var3_3;
            if (SNMPAgentManager.traceLogger.isLogging() == false) return var3_3;
            SNMPAgentManager.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SNMPAgentManager.className, var1_1);
            return var3_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPCapability getTarget(String var1_1) {
        var2_2 = "getTarget";
        if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
            SNMPAgentManager.traceLogger.entry(IRecordType.TYPE_API, (Object)SNMPAgentManager.className, var2_2);
        }
        var3_3 = var1_1;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = SNMPAgentManager.lock;
        synchronized (var8_8) {
            block32: {
                var9_9 = ServiceUtils.getConnection();
                try {
                    block29: {
                        try {
                            block31: {
                                var10_10 = SqlUtil.getTarget((String)var3_3);
                                if (var10_10 == null) break block29;
                                var3_3 = var10_10.getIpAddress();
                                var4_4 = var10_10.getUserId();
                                var5_5 = var10_10.getPassword();
                                var11_12 = (SNMPConfig)SnmpV1API.getConfig();
                                var11_12.setSnmpCommunityName(var3_3, var10_10.getReadCommunityName());
                                var11_12.setSnmpWriteCommunityName(var3_3, var10_10.getRwCommunityName());
                                var6_6 = new IPCapability(var3_3, var4_4, var5_5);
                                var12_13 = 0;
                                try {
                                    block30: {
                                        try {
                                            var7_7 = SqlUtil.getCapability((DBConnection)var9_9, (String)var3_3, (String[])this.SCANNERS);
                                            while (var7_7.next()) {
                                                var13_14 = var7_7.getString("SCANNER").trim();
                                                var14_16 = var7_7.getInt("ENABLED");
                                                if (var14_16 == 0) continue;
                                                var12_13 |= ((Integer)SNMPAgentManager.capabilityMapping.get(var13_14)).intValue();
                                            }
                                        }
                                        catch (Exception var13_15) {
                                            if (SNMPAgentManager.msgLogger != null) {
                                                SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var2_2, "IpTarget_getCapabilitiesError", (Object)var1_1);
                                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var2_2, (Throwable)var13_15);
                                            }
                                            if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block30;
                                            SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var13_15);
                                        }
                                    }
                                    var15_19 = null;
                                }
                                catch (Throwable var16_17) {
                                    var15_18 = null;
                                    try {
                                        if (var7_7 == null) throw var16_17;
                                        var7_7.closeAll();
                                        throw var16_17;
                                    }
                                    catch (Exception var17_20) {
                                        if (SNMPAgentManager.msgLogger != null) {
                                            SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var2_2, "IpTarget_getCapabilitiesError", (Object)var1_1);
                                            SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var2_2, (Throwable)var17_20);
                                        }
                                        if (SNMPAgentManager.traceLogger == null) throw var16_17;
                                        if (SNMPAgentManager.traceLogger.isLogging() == false) throw var16_17;
                                        SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var17_20);
                                    }
                                    throw var16_17;
                                }
                                ** try [egrp 5[TRYBLOCK] [3 : 300->313)] { 
lbl61:
                                // 1 sources

                                if (var7_7 != null) {
                                    var7_7.closeAll();
                                }
                                break block31;
lbl64:
                                // 1 sources

                                catch (Exception var17_21) {
                                    if (SNMPAgentManager.msgLogger != null) {
                                        SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var2_2, "IpTarget_getCapabilitiesError", (Object)var1_1);
                                        SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var2_2, (Throwable)var17_21);
                                    }
                                    if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block31;
                                    SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var17_21);
                                }
                            }
                            var6_6.setInitialCapabilities(var12_13);
                        }
                        catch (Exception var10_11) {
                            if (SNMPAgentManager.message) {
                                SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)this, var2_2, "IpTarget_getTargetError", (Object)var1_1);
                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var2_2, (Throwable)var10_11);
                            }
                            if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block29;
                            SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var10_11);
                        }
                    }
                    var18_24 = null;
                    if (var9_9 == null) break block32;
                }
                catch (Throwable var19_22) {
                    var18_23 = null;
                    if (var9_9 == null) throw var19_22;
                    try {
                        var9_9.commit();
                    }
                    catch (SQLException v0) {}
                    try {
                        var9_9.close();
                        throw var19_22;
                    }
                    catch (SQLException v1) {}
                    throw var19_22;
                }
                try {}
                catch (SQLException v2) {}
                var9_9.commit();
                try {}
                catch (SQLException v3) {}
                var9_9.close();
            }
        }
        if (SNMPAgentManager.traceLogger == null) return var6_6;
        if (SNMPAgentManager.traceLogger.isLogging() == false) return var6_6;
        SNMPAgentManager.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SNMPAgentManager.className, var2_2);
        return var6_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargets(String[] stringArray) {
        String string = "addTargets";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            InetAddress inetAddress;
            String string3;
            String string4;
            boolean bl;
            block13: {
                bl = false;
                string4 = stringArray[n];
                string3 = null;
                try {
                    inetAddress = InetAddress.getByName(string4);
                    string2 = inetAddress.getHostAddress();
                    inetAddress = InetAddress.getByName(string2);
                    string4 = string2;
                    string3 = inetAddress.getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    if (message) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "QueryEngine_invalidIPAddress", (Object)string4);
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)unknownHostException);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)unknownHostException);
                    }
                }
                catch (Exception exception) {
                    if (message) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "QueryEngine_invalidIPAddress", (Object)string4);
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) break block13;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
            inetAddress = null;
            string2 = null;
            Object object = lock;
            synchronized (object) {
                bl = SqlUtil.addTarget((String)string3, (String)string4, (String)((Object)inetAddress), (String)string2);
            }
            if (bl) {
                this.refreshCapabilities(string4);
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargets(String[] stringArray) {
        String string = "removeTargets";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = this.getIpAddress(stringArray[n]);
            IPCapability iPCapability = this.getTarget(string2);
            boolean bl = false;
            if (iPCapability != null) {
                Object object = lock;
                synchronized (object) {
                    bl = SqlUtil.removeTarget((String)string2);
                    this.ipTargetEventGenerator(string2, iPCapability.getInitialCapabilities(), 0, bl);
                    SNMPScanner.removeSnmpTimeout(string2);
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserIdPassword(String string, String string2, String string3) {
        String string4 = "setUserIdPassword";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string4);
        }
        boolean bl = false;
        String string5 = this.getIpAddress(string);
        String[] stringArray = new String[]{string5};
        this.addTargets(stringArray);
        Object object = lock;
        synchronized (object) {
            bl = SqlUtil.setUseridPassword((String)string5, (String)string2, (String)string3);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performIpTargetCapabiltyScan(IPCapability iPCapability) {
        String string = "performIpTargetCapabiltyScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.refreshIpTargetCapabilities(iPCapability, true);
        Object object = acsLock;
        synchronized (object) {
            this.activeCapabilityScans.remove(iPCapability.getIpAddress());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllIpTargetCapabilities() {
        String string = "refreshAllIpTargetCapabilities";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        IPCapability[] iPCapabilityArray = this.getTargets();
        int n = 0;
        while (n < iPCapabilityArray.length) {
            Object object = acsLock;
            synchronized (object) {
                if (!this.activeCapabilityScans.containsKey(iPCapabilityArray[n].getIpAddress())) {
                    IpTargetCapabilityScan ipTargetCapabilityScan = new IpTargetCapabilityScan(this, iPCapabilityArray[n]);
                    this.activeCapabilityScans.put(iPCapabilityArray[n].getIpAddress(), ipTargetCapabilityScan);
                    ipTargetCapabilityScan.start();
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCapabilities(String string) {
        IPCapability iPCapability;
        String string2 = "refreshCapabilities(address)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        new Vector();
        if (string != null && (iPCapability = this.getTarget(string)) != null) {
            if (this.checkShutdown()) {
                return;
            }
            Object object = acsLock;
            synchronized (object) {
                if (!this.activeCapabilityScans.containsKey(string)) {
                    IpTargetCapabilityScan ipTargetCapabilityScan = new IpTargetCapabilityScan(this, iPCapability);
                    this.activeCapabilityScans.put(string, ipTargetCapabilityScan);
                    ipTargetCapabilityScan.start();
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public boolean refreshIpTargetCapabilities(IPCapability iPCapability, boolean bl) {
        String string = "refreshIpTargetCapabilities";
        boolean bl2 = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (iPCapability != null) {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            Vector vector = new Vector();
            this.setInitialCaps(iPCapability.getInitialCapabilities(), vector);
            int n = this.CiscoCapabilityScan(iPCapability);
            if (this.checkShutdown()) {
                return bl2;
            }
            bl2 = bl5 = n == 1;
            int n2 = this.setCapability(iPCapability, "PO4", vector, bl5);
            if (n2 == 1) {
                bl3 = this.updateCapability(iPCapability, vector);
                this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
            } else if (n2 == 2) {
                bl3 = this.updateCapability(iPCapability, vector);
                this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
            }
            if (bl5) {
                int n3;
                int n4 = this.setCapability(iPCapability, "PO2", vector, false);
                if (n4 == 2) {
                    bl3 = this.updateCapability(iPCapability, vector);
                    this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
                }
                if ((n3 = this.setCapability(iPCapability, "PO3", vector, false)) == 2) {
                    bl3 = this.updateCapability(iPCapability, vector);
                    this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
                }
            } else {
                int n5;
                if (n == 2) {
                    n5 = this.setCapability(iPCapability, "PO2", vector, false);
                    if (n5 == 2) {
                        bl3 = this.updateCapability(iPCapability, vector);
                        this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
                    }
                } else {
                    if (this.checkShutdown()) {
                        return bl2;
                    }
                    bl2 = bl4 = this.topologyCapabilityScan(iPCapability) == 1;
                    n5 = this.setCapability(iPCapability, "PO2", vector, bl4);
                    if (n5 == 1) {
                        bl3 = this.updateCapability(iPCapability, vector);
                        if (bl3) {
                            this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
                        }
                    } else if (n5 == 2) {
                        bl3 = this.updateCapability(iPCapability, vector);
                        this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
                    }
                }
                if (this.checkShutdown()) {
                    return bl2;
                }
                n5 = this.setCapability(iPCapability, "PO3", vector, this.BrocadeApiCapabilityScan(iPCapability));
                if (n5 == 1) {
                    bl3 = this.updateCapability(iPCapability, vector);
                    this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
                } else if (n5 == 2) {
                    bl3 = this.updateCapability(iPCapability, vector);
                    this.ipTargetEventGenerator(iPCapability.getIpAddress(), iPCapability.getInitialCapabilities(), iPCapability.getCapabilities(), bl);
                }
                return bl2;
            }
            if (this.checkShutdown()) {
                return bl2;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl2;
    }

    private int setCapability(IPCapability iPCapability, String string, Vector vector, boolean bl) {
        String string2 = "setCapability";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n = (Integer)capabilityMapping.get(string);
        int n2 = 3;
        if (this.checkShutdown()) {
            return n2;
        }
        if (bl) {
            n2 = iPCapability.addCapability(n);
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
        } else {
            n2 = iPCapability.removeCapability(n);
            if (vector.contains(string)) {
                vector.removeElement(string);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            if (n2 == 1) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Added capability " + capabilityTypeName.get(new Integer(n)) + " to IpTarget " + iPCapability.getIpAddress());
            } else if (n2 == 2) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Removed capability " + capabilityTypeName.get(new Integer(n)) + " from IpTarget " + iPCapability.getIpAddress());
            } else {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "No capability change of " + capabilityTypeName.get(new Integer(n)) + " to IpTarget " + iPCapability.getIpAddress());
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n2;
    }

    private void ipTargetEventGenerator(String string, int n, int n2, boolean bl) {
        String string2 = "ipTargetEventGenerator";
        if (!bl) {
            return;
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if (this.checkShutdown()) {
            return;
        }
        SNMPAgentManager.getMonitorServiceProxy();
        if (monitorServiceProxy == null) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Monitor Service is down. Unable to generate capability change event for  IpTarget " + string);
        } else {
            monitorServiceProxy.handleDeviceStateChange("DummyProcessId", IpTarget.getTablename(), string, n, n2);
        }
    }

    private void setInitialCaps(int n, Vector vector) {
        int n2;
        String string = "setInitialCaps";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if ((n & (n2 = ((Integer)capabilityMapping.get("PO2")).intValue())) == n2) {
            vector.addElement("PO2");
        }
        if ((n & (n2 = ((Integer)capabilityMapping.get("PO3")).intValue())) == n2) {
            vector.addElement("PO3");
        }
        if ((n & (n2 = ((Integer)capabilityMapping.get("PO4")).intValue())) == n2) {
            vector.addElement("PO4");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private boolean updateCapability(IPCapability iPCapability, Vector vector) {
        String string = "updateCapability";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return SqlUtil.updateCapability((String)iPCapability.getIpAddress(), (String[])stringArray);
    }

    public boolean ping(String string) {
        String string2 = "ping";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        boolean bl = false;
        String string3 = this.getIpAddress(string);
        IPCapability iPCapability = new IPCapability(string3, null, null);
        boolean bl2 = bl = this.CiscoCapabilityScan(iPCapability) == 1;
        if (!bl) {
            boolean bl3 = bl = this.topologyCapabilityScan(iPCapability) == 1;
        }
        if (!bl && message) {
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "Scanner_noResponseFromFCMGMTorCiscoMIB", (Object)string3);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return bl;
    }

    public boolean pingAndUpdateRepository(String string) {
        String string2 = "pingAndUpdateRepository";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        boolean bl = false;
        String string3 = this.getIpAddress(string);
        IPCapability iPCapability = this.getTarget(string);
        bl = this.refreshIpTargetCapabilities(iPCapability, true);
        if (!bl && message) {
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "Scanner_noResponseFromFCMGMTorCiscoMIB", (Object)string3);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return bl;
    }

    public int topologyCapabilityScan(IPCapability iPCapability) {
        String string = "topologyCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        try {
            TopologyScanner topologyScanner = new TopologyScanner();
            n = topologyScanner.isTopology(iPCapability.getIpAddress());
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return 0;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public int BrocadeCapabilityScan(IPCapability iPCapability) {
        String string = "BrocadeCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        try {
            TopologyScanner topologyScanner = new TopologyScanner();
            n = topologyScanner.isBrocadeSwitch(iPCapability.getIpAddress());
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return 0;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public boolean BrocadeApiCapabilityScan(IPCapability iPCapability) {
        boolean bl;
        String string = "BrocadeApiCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl2 = bl = this.BrocadeUserIdPasswordCapabilityScan(iPCapability) && this.BrocadeCapabilityScan(iPCapability) == 1;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public boolean BrocadeUserIdPasswordCapabilityScan(IPCapability iPCapability) {
        String string = "BrocadeUserIdPasswordCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl = false;
        if (iPCapability != null) {
            bl = iPCapability.isUserIdPasswordSet();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public int CiscoCapabilityScan(IPCapability iPCapability) {
        String string = "CiscoCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = 0;
        try {
            TopologyScanner topologyScanner = new TopologyScanner();
            n = topologyScanner.isCiscoMdsSwitch(iPCapability.getIpAddress());
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return 0;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public boolean SharkCapabilityScan(IPCapability iPCapability) {
        String string = "SharkCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public boolean SharkCliCapabilityScan(IPCapability iPCapability) {
        boolean bl;
        String string = "SharkCliCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl2 = bl = this.SharkUserIdPasswordCapabilityScan(iPCapability) && this.SharkCapabilityScan(iPCapability);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public boolean SharkUserIdPasswordCapabilityScan(IPCapability iPCapability) {
        String string = "SharkUserIdPasswordCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl = false;
        if (iPCapability != null) {
            bl = iPCapability.isUserIdPasswordSet();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public boolean NASCapabilityScan(IPCapability iPCapability) {
        String string = "NASCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    private boolean checkShutdown() {
        String string = "checkShutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.isShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        block14: {
            String string = "shutdown";
            this.isShuttingDown = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string, "Stopping all active SNMP capability scans");
            }
            object = acsLock;
            synchronized (object) {
                Enumeration enumeration = this.activeCapabilityScans.elements();
                while (enumeration.hasMoreElements()) {
                    IpTargetCapabilityScan ipTargetCapabilityScan = (IpTargetCapabilityScan)enumeration.nextElement();
                    ipTargetCapabilityScan.shutdown();
                }
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string, "All active IpTarget capability scans stopped.");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            try {
                SnmpV1API.terminate();
            }
            catch (Exception exception) {
                if (message) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block14;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = "run";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.doingRefresh = true;
        while (this.iWorkerThread == Thread.currentThread()) {
            if (this.checkShutdown()) break;
            this.refreshAllIpTargetCapabilities();
            if (this.checkShutdown()) break;
            SNMPAgentManager sNMPAgentManager = this;
            synchronized (sNMPAgentManager) {
                this.doingRefresh = false;
                this.pollingInterval = this.getMonitorInterval();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Waiting " + this.pollingInterval + " milliseconds to do refreshCapabilities");
                }
                try {
                    this.wait(this.pollingInterval);
                }
                catch (Exception exception) {}
                this.doingRefresh = true;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Waking up to do refreshCapabilities");
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private String wrap(String string) {
        String string2 = "wrap";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string == null ? "null" : "'" + string + "'";
    }

    public String[] discoverAgents(String[] stringArray, String string, String string2, String string3) {
        String string4 = "discoverAgents";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4, (Object)stringArray.toString());
        }
        string2 = null;
        string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = null;
            Object[] objectArray = new String[4];
            String string5 = stringArray[n];
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string5.trim(), ".");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
                if (vector.size() == 3) break;
            }
            if (vector.size() < 3) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string4, "The address " + vector.toString() + "is not valid");
                }
            } else {
                int n2 = 500;
                boolean bl = true;
                String string6 = string2;
                String string7 = string3;
                boolean bl2 = true;
                if (string == null) {
                    string = DEFAULT_SNMP_COMMUNITY;
                }
                vector.copyInto(objectArray);
                stringArray2 = DiscoverAgents.scan((String[])objectArray, n2, bl2);
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    arrayList.add(stringArray2[n3]);
                    ++n3;
                }
                if (stringArray2.length > 0 && bl) {
                    ArrayList<InetAddress> arrayList2 = new ArrayList<InetAddress>();
                    int n4 = 0;
                    while (n4 < stringArray2.length) {
                        InetAddress inetAddress;
                        String string8 = stringArray2[n4];
                        String string9 = "";
                        try {
                            inetAddress = InetAddress.getByName(string8);
                            string9 = inetAddress.getHostName();
                        }
                        catch (Exception exception) {}
                        inetAddress = new SNMPAgent(stringArray2[n4], string9, string, string6, string7);
                        arrayList2.add(inetAddress);
                        ++n4;
                    }
                    this.addSNMPAgents(arrayList2);
                }
            }
            ++n;
        }
        if (traceLogger.isLogging() && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4, (Object)arrayList.toArray().toString());
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] discoverAgents(String[] stringArray, int n, boolean bl, String string, String string2) {
        return this.discoverAgents(stringArray, "public", string, string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] addSNMPAgents(ArrayList var1_1) {
        block31: {
            block28: {
                block29: {
                    var2_2 = "addSNMPAgents";
                    var3_3 = ServiceUtils.getConnection();
                    var4_4 = new IpTarget();
                    var5_5 = new Scanner();
                    var6_6 = new Vector<String>();
                    try {
                        try {
                            var7_7 = 0;
                            while (true) {
                                block32: {
                                    block30: {
                                        block33: {
                                            if (var7_7 >= var1_1.size()) {
                                                var3_3.commit();
                                                this.updateNewAgentCapabilities(var1_1, false);
                                                break block28;
                                            }
                                            var8_10 = SqlUtil.getTarget((String)((SNMPAgent)var1_1.get(var7_7)).getIpAddress(), (DBConnection)var3_3);
                                            if (var8_10 != null) break block32;
                                            var4_4.clear();
                                            var4_4.setHostName(((SNMPAgent)var1_1.get(var7_7)).getDnsName());
                                            var9_11 = ((SNMPAgent)var1_1.get(var7_7)).getIpAddress();
                                            var4_4.setIpAddress(var9_11);
                                            if (var4_4.getIpAddress() == null && var4_4.getHostName() == null) {
                                                if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
                                                    SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, var2_2, "Host name and IP Address of the SNMP Agent to be added are null");
                                                }
lbl24:
                                                // 5 sources

                                                while (true) {
                                                    var14_18 = null;
                                                    break block29;
                                                    break;
                                                }
                                            }
                                            if (var4_4.getIpAddress() != null) break block33;
                                            try {
                                                var10_12 = InetAddress.getByName(var4_4.getHostName());
                                                var4_4.setIpAddress(var10_12.getHostAddress());
                                            }
                                            catch (UnknownHostException var10_13) {
                                                if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) ** GOTO lbl24
                                                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)this, var2_2, var10_13.getStackTrace().toString());
                                                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, var2_2, "Unable to retrieve IP Address from the hostname passed for SNMPAgent");
                                                ** continue;
                                            }
                                        }
                                        if ((var10_12 = ((SNMPAgent)var1_1.get(var7_7)).getUserName()) != null && !var10_12.trim().equals("")) {
                                            var4_4.setUserId((String)var10_12);
                                        }
                                        var11_14 = ((SNMPAgent)var1_1.get(var7_7)).getPassword();
                                        var12_15 = null;
                                        if (var11_14 != null && !var11_14.trim().equals("")) {
                                            try {
                                                var12_15 = SRMCrypto.encrypt((String)var11_14);
                                                var4_4.setPassword(var12_15);
                                            }
                                            catch (Exception var13_17) {
                                                SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)SNMPAgentManager.className, var2_2, "Scanner_errorEncryptingPassword", (Object)var4_4);
                                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var13_17);
                                                if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block30;
                                                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_WARN, (Object)this, var2_2, "Could not encrypt Password ");
                                            }
                                        }
                                    }
                                    if (((SNMPAgent)var1_1.get(var7_7)).getCommunityName() == null || ((SNMPAgent)var1_1.get(var7_7)).getCommunityName().trim().length() == 0) {
                                        ((SNMPAgent)var1_1.get(var7_7)).setCommunityName(SNMPAgentManager.DEFAULT_SNMP_COMMUNITY);
                                    }
                                    if (((SNMPAgent)var1_1.get(var7_7)).getRWCommunityName() == null || ((SNMPAgent)var1_1.get(var7_7)).getRWCommunityName().trim().length() == 0) {
                                        ((SNMPAgent)var1_1.get(var7_7)).setRWCommunityName(SNMPAgentManager.DEFAULT_SNMP_RW_COMMUNITY);
                                    }
                                    var4_4.setReadCommunityName(((SNMPAgent)var1_1.get(var7_7)).getCommunityName());
                                    var4_4.setRwCommunityName(((SNMPAgent)var1_1.get(var7_7)).getRWCommunityName());
                                    this.insertTarget(var4_4, var3_3);
                                    var13_16 = (SNMPConfig)SnmpV1API.getConfig();
                                    var13_16.setSnmpCommunityName(var9_11, var4_4.getReadCommunityName());
                                    var13_16.setSnmpWriteCommunityName(var9_11, var4_4.getRwCommunityName());
                                    var5_5.clear();
                                    var5_5.setAgentName(((SNMPAgent)var1_1.get(var7_7)).getIpAddress());
                                    var5_5.setScannerId("PO2:" + ((SNMPAgent)var1_1.get(var7_7)).getIpAddress());
                                    var5_5.setType("PO2");
                                    this.insertScanner(var5_5, var3_3);
                                    var5_5.setScannerId("PO4:" + ((SNMPAgent)var1_1.get(var7_7)).getIpAddress());
                                    var5_5.setType("PO4");
                                    this.insertScanner(var5_5, var3_3);
                                    var6_6.add(var4_4.getIpAddress());
                                }
                                ++var7_7;
                            }
                        }
                        catch (Exception var7_8) {
                            if (SNMPAgentManager.msgLogger != null) {
                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var7_8);
                            }
                            if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
                                SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, var2_2, (Throwable)var7_8);
                                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, var2_2, "Exception while commiting the added agents to database");
                            }
                            break block28;
                        }
                    }
                    catch (Throwable var15_24) {
                        var14_19 = null;
                        try {
                            if (var3_3 == null) throw var15_24;
                            var3_3.close();
                            throw var15_24;
                        }
                        catch (Exception var16_22) {
                            if (SNMPAgentManager.msgLogger != null) {
                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var16_22);
                            }
                            if (SNMPAgentManager.traceLogger == null) throw var15_24;
                            if (SNMPAgentManager.traceLogger.isLogging() == false) throw var15_24;
                            SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, var2_2, (Throwable)var16_22);
                            SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, var2_2, "Exception while commiting closing database connection");
                        }
                        throw var15_24;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [7 : 836->847)] { 
lbl100:
                // 1 sources

                if (var3_3 == null) return null;
                var3_3.close();
                return null;
lbl103:
                // 1 sources

                catch (Exception var16_21) {
                    if (SNMPAgentManager.msgLogger != null) {
                        SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var16_21);
                    }
                    if (SNMPAgentManager.traceLogger == null) return null;
                    if (SNMPAgentManager.traceLogger.isLogging() == false) return null;
                    SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, var2_2, (Throwable)var16_21);
                    SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, var2_2, "Exception while commiting closing database connection");
                }
                return null;
            }
            var14_20 = null;
            ** try [egrp 4[TRYBLOCK] [7 : 836->847)] { 
lbl114:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block31;
lbl117:
            // 1 sources

            catch (Exception var16_23) {
                if (SNMPAgentManager.msgLogger != null) {
                    SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, var2_2, (Throwable)var16_23);
                }
                if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block31;
                SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, var2_2, (Throwable)var16_23);
                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, var2_2, "Exception while commiting closing database connection");
            }
        }
        var7_9 = new String[var6_6.size()];
        var6_6.toArray(var7_9);
        if (SNMPAgentManager.traceLogger == null) return var7_9;
        if (SNMPAgentManager.traceLogger.isLogging() == false) return var7_9;
        SNMPAgentManager.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SNMPAgentManager.className, var2_2, (Object)var7_9.toString());
        return var7_9;
    }

    private void updateNewAgentCapabilities(ArrayList arrayList, boolean bl) {
        int n = 0;
        while (n < arrayList.size()) {
            String string = ((SNMPAgent)arrayList.get(n)).getIpAddress();
            IPCapability iPCapability = this.getTarget(string);
            this.refreshIpTargetCapabilities(iPCapability, bl);
            ++n;
        }
    }

    public void insertScanner(Scanner scanner, DBConnection dBConnection) {
        block7: {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "insertScanner", (Object)scanner.getScannerId());
            }
            try {
                scanner.insert(dBConnection);
            }
            catch (SQLException sQLException) {
                try {
                    scanner.update(dBConnection);
                }
                catch (SQLException sQLException2) {
                    sQLException2.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block7;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "insertScanner", (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "insertScanner", (Object)scanner.toString());
        }
    }

    public void insertTarget(IpTarget ipTarget, DBConnection dBConnection) {
        block7: {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "insertTarget", (Object)ipTarget.getIpAddress());
            }
            try {
                ipTarget.insert(dBConnection);
            }
            catch (SQLException sQLException) {
                try {
                    ipTarget.update(dBConnection);
                }
                catch (SQLException sQLException2) {
                    sQLException2.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block7;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "insertTarget", (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "insertTarget", (Object)ipTarget.toString());
        }
    }

    class IpTargetCapabilityScan
    extends Thread {
        private ILogger msgLogger = msgLogger;
        private ILogger traceLogger = traceLogger;
        private final String className;
        SNMPAgentManager ic;
        IPCapability ipt;

        public IpTargetCapabilityScan(SNMPAgentManager sNMPAgentManager2, IPCapability iPCapability) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.snmpagent.manager.SNMPAgentManager$IpTargetCapabilityScan");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.className = clazz.getName();
            this.ic = null;
            this.ipt = null;
            this.ic = sNMPAgentManager2;
            this.ipt = iPCapability;
            this.setName("IpTargetCapabilityScan address=" + this.ipt.getIpAddress());
        }

        public void run() {
            String string = "run";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, string);
            }
            this.ic.performIpTargetCapabiltyScan(this.ipt);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, string);
            }
        }

        public void shutdown() {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, "shutdown");
                this.traceLogger.text(IRecordType.TYPE_WARN, (Object)this, "shutdown", "Ending IpTargetCapabilityScan address=" + this.ipt.getIpAddress() + " before scan has completed.");
            }
            Thread thread = new Thread(this);
            thread.interrupt();
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, "shutdown");
            }
        }
    }
}

