/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.LogEventListener;
import com.ibm.log.LogEventProducer;
import com.ibm.log.LogNode;
import com.ibm.log.util.LogUtil;
import java.util.Properties;
import java.util.Vector;

public abstract class LogEventProducerImpl
extends LogNode
implements LogEventProducer {
    private transient boolean listenerWarningSent = false;
    private boolean logging = true;
    protected int listenerCount = 0;
    protected transient long loggedEventCount = 0L;
    private Object listenerSync = new Object();
    private String listenerNames = "";
    private Vector listeners = new Vector();
    private LogEventListener[] cachedListeners = new LogEventListener[0];

    public LogEventProducerImpl() {
    }

    public LogEventProducerImpl(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object clone() {
        LogEventProducerImpl logEventProducerImpl = (LogEventProducerImpl)super.clone();
        Object object = this.listenerSync;
        synchronized (object) {
            logEventProducerImpl.listeners = (Vector)this.listeners.clone();
            logEventProducerImpl.cachedListeners = this.listeners.toArray(new LogEventListener[0]);
        }
        return logEventProducerImpl;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("logging", new Boolean(this.logging).toString());
        if (!this.listenerNames.equals("")) {
            properties.put("listenerNames", this.listenerNames);
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("logging");
        if (string != null) {
            this.setLogging(new Boolean(string));
        }
        if ((string = properties.getProperty("listenerNames")) != null) {
            this.listenerNames = string;
        }
    }

    public final boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEventListener(LogEventListener logEventListener) {
        if (logEventListener != null) {
            Object object = this.listenerSync;
            synchronized (object) {
                if (!this.listeners.contains(logEventListener)) {
                    this.listeners.add(logEventListener);
                    ++this.listenerCount;
                    this.cachedListeners = this.listeners.toArray(new LogEventListener[0]);
                }
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".addLogEventListener");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeLogEventListener(LogEventListener logEventListener) {
        if (logEventListener != null) {
            Object object = this.listenerSync;
            synchronized (object) {
                if (this.listeners.contains(logEventListener)) {
                    this.listeners.remove(logEventListener);
                    --this.listenerCount;
                    this.cachedListeners = this.listeners.toArray(new LogEventListener[0]);
                }
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".removeLogEventListener");
            LogUtil.errorMsg(string);
        }
    }

    public LogEventListener[] getLogEventListeners() {
        return this.cachedListeners;
    }

    public void log(LogEvent logEvent) {
        if (logEvent != null && this.listenerCount > 0) {
            ++this.loggedEventCount;
            LogEventListener[] logEventListenerArray = this.getLogEventListeners();
            if (logEventListenerArray != null) {
                int n = 0;
                while (n < logEventListenerArray.length) {
                    LogEventListener logEventListener = logEventListenerArray[n];
                    logEventListener.process(logEvent);
                    ++n;
                }
            }
        }
    }

    protected void logAndWarn(LogEvent logEvent) {
        if (logEvent != null) {
            if (this.listenerCount > 0) {
                ++this.loggedEventCount;
                this.listenerWarningSent = false;
                LogEventListener[] logEventListenerArray = this.getLogEventListeners();
                if (logEventListenerArray != null) {
                    int n = 0;
                    while (n < logEventListenerArray.length) {
                        LogEventListener logEventListener = logEventListenerArray[n];
                        logEventListener.process(logEvent);
                        ++n;
                    }
                }
            } else if (!this.listenerWarningSent) {
                this.listenerWarningSent = true;
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_NO_LISTENERS", this.getName()));
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", isLogging=" + this.isLogging() + ", loggedEvents=" + this.loggedEventCount;
    }
}

