/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.CircularEventQueue;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class MemoryHandler
extends Handler {
    static final long serialVersionUID = 8568566190684608305L;
    protected transient CircularEventQueue queue = new CircularEventQueue();
    protected boolean convertExceptions = false;

    public MemoryHandler() {
        this.open = true;
    }

    public MemoryHandler(String string) {
        super(string);
        this.open = true;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("queueCapacity", new Integer(this.queue.getCapacity()).toString());
        properties.put("convertExceptions", new Boolean(this.convertExceptions));
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("queueCapacity");
        if (string != null) {
            this.queue.setCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("dumpEvents")) != null) {
            this.setDumpEvents(new Boolean(string));
        }
        if ((string = properties.getProperty("convertExceptions")) != null) {
            this.convertExceptions = new Boolean(string);
        }
    }

    public int getQueueCount() {
        return this.queue.getQueueCount();
    }

    public int getQueueCapacity() {
        return this.queue.getCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueCapacity(int n) {
        if (n >= 1) {
            Object object = this.deviceLock;
            synchronized (object) {
                this.close();
                this.queue.setCapacity(n);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(n), String.valueOf(this.getClass().getName()) + ".setQueueCapacity");
            LogUtil.errorMsg(string);
        }
    }

    public void setDumpEvents(boolean bl) {
        if (bl) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            while (this.queue.getQueueCount() > 0) {
                this.log(this.queue.dequeue());
            }
        }
    }

    public synchronized void process(LogEvent logEvent) {
        if (logEvent != null) {
            if (this.convertExceptions) {
                logEvent.convertException();
            }
            this.queue.enqueue(logEvent);
        }
    }

    public void write(LogEvent logEvent) throws Exception {
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", capacity=" + this.getQueueCapacity();
    }
}

