/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.DataStoreSupport;
import com.ibm.log.util.LogException;
import com.ibm.log.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyDataStore
extends DataStoreSupport {
    protected Properties props;
    protected String propFileName;
    protected BufferedInputStream is;

    public PropertyDataStore(String string) throws IOException, LogException, AccessControlException {
        this.propFileName = string;
        this.props = this.loadProperties(string);
        this.restoreConfig();
    }

    public PropertyDataStore(InputStream inputStream) throws IOException, LogException {
        this.propFileName = "[java.io.InputStream]";
        this.props = this.loadPropertiesFromStream(inputStream);
        this.restoreConfig();
    }

    protected Properties loadProperties(String string) throws IOException, AccessControlException {
        InputStream inputStream;
        ClassLoader classLoader = LogUtil.getClassLoaderForResource(string);
        if (classLoader == null) {
            inputStream = this.getClass().getResourceAsStream(string);
        } else {
            if (string != null && string.startsWith("/")) {
                try {
                    string = string.substring(1);
                }
                catch (Exception exception) {}
            }
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            String string2 = LogUtil.getLogMsg("ERR_FILE_NOT_FOUND", this.propFileName);
            LogUtil.errorMsg(string2);
        }
        return this.loadPropertiesFromStream(inputStream);
    }

    protected Properties loadPropertiesFromStream(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        this.is = new BufferedInputStream(inputStream);
        properties.load(this.is);
        this.is.close();
        return properties;
    }

    public void restoreConfig() throws LogException {
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = ((String)enumeration.nextElement()).trim();
            if (string.startsWith("#") || string.startsWith("!")) continue;
            String string2 = this.props.getProperty(string);
            this.restoreProp(string, string2);
        }
        this.initialized = true;
    }

    protected void restoreProp(String string, String string2) throws LogException {
        String string3;
        boolean bl = false;
        String string4 = "";
        int n = string.lastIndexOf(46);
        if (n == -1) {
            bl = true;
            string4 = String.valueOf(string4) + System.getProperty("line.separator") + string + "=" + string2;
        } else {
            string3 = string.substring(0, n);
            String string5 = string.substring(n + 1);
            if (string3.equals("") || string5.equals("")) {
                bl = true;
                string4 = String.valueOf(string4) + System.getProperty("line.separator") + string + "=" + string2;
            } else {
                DataStoreConfig dataStoreConfig = this.getConfig(string3);
                dataStoreConfig.setProperty(string5, string2);
                dataStoreConfig.setLoadedFromDataStore(true);
            }
        }
        if (bl) {
            string3 = String.valueOf(LogUtil.getLogMsg("ERR_DATA_STORE", this.propFileName)) + string4;
            throw new LogException(string3);
        }
    }

    public void saveConfig(boolean bl) throws Exception {
        String string = LogUtil.getLogMsg("WARN_CANNOT_SAVE_CFG");
        LogUtil.errorMsg(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void substitute(String string, String string2) throws LogException {
        if (string == null || string2 == null) {
            String string3 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".substitute");
            LogUtil.errorMsg(string3);
            return;
        }
        String string4 = "$(" + string + ")";
        Properties properties = this.props;
        synchronized (properties) {
            Enumeration<Object> enumeration = this.props.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                String string6 = this.props.getProperty(string5);
                if (string6.indexOf(string4) == -1) continue;
                String string7 = LogUtil.replace(string6, string4, string2);
                this.props.setProperty(string5, string7);
                this.restoreProp(string5, string7);
            }
        }
    }
}

