/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.server;

import com.ibm.log.FileHandler;
import com.ibm.log.LogEventListener;
import com.ibm.log.Logger;
import com.ibm.log.server.SocketLogger;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class SocketServer
extends Logger
implements Runnable {
    static final long serialVersionUID = -1264105798077827156L;
    public static final int DEFAULT_PORT = 9991;
    public static final String DEFAULT_LOG_FILE = "server.log";
    private transient boolean finished = false;
    private transient boolean stopRequested = false;
    private int port = 9991;
    private LogEventListener eventListener;

    public static void main(String[] stringArray) {
        int n = 9991;
        String string = DEFAULT_LOG_FILE;
        switch (stringArray.length) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    n = Integer.valueOf(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("SS_USAGE"));
                    System.exit(1);
                }
                break;
            }
            case 2: {
                try {
                    n = Integer.valueOf(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("SS_USAGE"));
                    System.exit(1);
                }
                string = stringArray[1];
                break;
            }
            default: {
                LogUtil.errorMsg(LogUtil.getLogMsg("SS_USAGE"));
                System.exit(1);
            }
        }
        FileHandler fileHandler = new FileHandler();
        fileHandler.setFileName(string);
        SocketServer socketServer = new SocketServer(n);
        socketServer.addLogEventListener(fileHandler);
        Thread thread = new Thread(socketServer);
        thread.start();
        System.out.println(LogUtil.getLogMsg("START_SERVER", new Integer(n).toString()));
        System.out.println(LogUtil.getLogMsg("OUTPUT_TO_FILE", string));
    }

    public SocketServer() {
    }

    public SocketServer(int n) {
        this.port = n;
    }

    public void run() throws SecurityException, AccessControlException {
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (!this.stopRequested) {
                try {
                    Socket socket;
                    final ServerSocket serverSocket2 = serverSocket;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager == null) {
                        socket = serverSocket2.accept();
                    } else {
                        try {
                            socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return serverSocket2.accept();
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw (IOException)privilegedActionException.getException();
                        }
                    }
                    if (this.stopRequested) continue;
                    SocketLogger socketLogger = new SocketLogger(socket);
                    LogEventListener[] logEventListenerArray = this.getLogEventListeners();
                    int n = 0;
                    while (n < logEventListenerArray.length) {
                        socketLogger.addLogEventListener(logEventListenerArray[n]);
                        ++n;
                    }
                    Thread thread = new Thread(socketLogger);
                    thread.start();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void stop() throws SecurityException {
        this.stopRequested = true;
        try {
            new Socket("localhost", this.port).close();
        }
        catch (IOException iOException) {}
    }
}

