/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms;

import java.net.InetAddress;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.interfaces.IMessagingService;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.JMSImplLogInfo;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicSession;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicSubscriber;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class MSTopicConnection
implements TopicConnection {
    private boolean started = false;
    private Vector subscribers = new Vector();
    private String hostName = null;
    private int port = 0;
    private ILogger traceLogger = JMSImplLogInfo.traceLogger;
    private ILogger msgLogger = JMSImplLogInfo.msgLogger;
    private static String className = null;

    public MSTopicConnection(String string, int n) {
        className = this.getClass().getName();
        String string2 = "MSTopicConnection(String serverName, int serverPort)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        this.hostName = string;
        this.port = n;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public String getHostName() {
        String string = "getHostName()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.hostName;
    }

    public void setPort(int n) {
        String string = "setPort(int port)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.port = n;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int getPort() {
        String string = "getPort()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.port;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("createConnectionConsumer not implemented");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("createDurableConnectionConsumer not implemented");
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        String string = "createTopicSession(boolean transacted, int acknowledgeMode)";
        MSTopicSession mSTopicSession = null;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (bl || n != 0) {
            throw new JMSException("createTopicSession not implemented for transacted=true or acknowledgeMode!=0.");
        }
        mSTopicSession = new MSTopicSession(this);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return mSTopicSession;
    }

    public void close() throws JMSException {
        String string = "close()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public String getClientID() throws JMSException {
        throw new JMSException("getClientID() not implemented");
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        throw new JMSException("getExceptionListener() not implemented");
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        throw new JMSException("getMetaData() not implemented");
    }

    public void setClientID(String string) throws JMSException {
        throw new JMSException("setClientID() not implemented");
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        throw new JMSException("setExceptionListener(ExceptionListener arg0) not implemented");
    }

    public void start() throws JMSException {
        String string = "start()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (!this.started) {
            int n = 0;
            while (n < this.subscribers.size()) {
                this.subscribe((MSTopicSubscriber)this.subscribers.get(n));
                ++n;
            }
            this.started = true;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void stop() throws JMSException {
        String string = "stop()";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (this.started) {
            int n = 0;
            while (n < this.subscribers.size()) {
                this.unsubscribe((MSTopicSubscriber)this.subscribers.get(n));
                ++n;
            }
            this.started = false;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    protected void addSubscriber(MSTopicSubscriber mSTopicSubscriber) throws JMSException {
        String string = "addSubscriber(MSTopicSubscriber topicSubscriber)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.subscribers.add(mSTopicSubscriber);
        if (this.started) {
            this.subscribe(mSTopicSubscriber);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void subscribe(MSTopicSubscriber mSTopicSubscriber) throws JMSException {
        String string = "subscribe(MSTopicSubscriber topicSubscriber)";
        IMessagingService iMessagingService = null;
        String string2 = null;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        String string3 = ((IService)mSTopicSubscriber.getMessageListener()).getName();
        String string4 = mSTopicSubscriber.getTopic().getTopicName();
        try {
            if (this.hostName.equals("localhost")) {
                iMessagingService = (IMessagingService)Activator._serviceHelper.bindLocal("MessagingService");
            } else {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.MessagingService.interfaces.IMessagingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                iMessagingService = (IMessagingService)ConnectorClient.getService((String)this.hostName, (int)this.port, clazz, (String)"MessagingService");
                String string5 = InetAddress.getLocalHost().getHostAddress();
                IConfigService iConfigService = null;
                iConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
                String string6 = iConfigService.getProperty("agent.port", "setup");
                int n = Integer.parseInt(string6);
                string2 = String.valueOf(string5) + ":" + n;
            }
            if (!iMessagingService.isAlive()) {
                if (this.msgLogger != null && this.msgLogger.isLogging()) {
                    this.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "MessagingService_Down");
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Messaging Service is not running. Cannot subscribe to events.");
                }
                throw new JMSException("Messaging Service is not running. Cannot subscribe to events.");
            }
            iMessagingService.subscribe(string4, string2, string3);
        }
        catch (Exception exception) {
            if (this.msgLogger != null && this.msgLogger.isLogging()) {
                this.msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, string, "subscribe_failed", (Object)string3, (Object)string4);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
            throw new JMSException("Service cannot subscribe to topic. Exception: " + exception.toString());
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void unsubscribe(MSTopicSubscriber mSTopicSubscriber) {
        String string = "unsubscribe(MSTopicSubscriber topicSubscriber)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return null;
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        return null;
    }
}

